

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetSharedList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetSharedList.sp,v $ $Id: LMGetSharedList.sp,v 1.4.2.7 2018/03/27 08:46:30 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetSharedList <<<'

IF EXISTS (select * from sysobjects where name='LMGetSharedList')
	drop procedure LMGetSharedList
IF EXISTS (select * from GxQscripts where name='LMGetSharedList')
	delete from GxQscripts where name = 'LMGetSharedList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSharedList')
	delete from GXDBVersions where aliasname = 'LMGetSharedList'
GO
print '... Creating Procedure: LMGetSharedList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetSharedList
  @userid INTEGER,
  @inputxml_req xml,
  @o_xmlMsg xml		OUTPUT
AS
	Set transaction isolation level read uncommitted
	declare @sharetype int = (select ref.value('@sharetype','INT') from @inputxml_req.nodes('LogMonitoring_GetSharedListReq') as R(ref))
	declare @includeMySharedSearchesOnly integer
	declare @startId int = 0
	declare @countOfentities int = 0
	declare @totalcount int = 0
	DECLARE @appType INT = 0
	set @startId =  ISNULL((select ref.value('@start','INT') from @inputxml_req.nodes('LogMonitoring_GetSharedListReq/pageinfo') as R(ref) ) , 0)
	set @countOfentities =  ISNULL((select ref.value('@count','INT') from @inputxml_req.nodes('LogMonitoring_GetSharedListReq/pageinfo') as R(ref) ) , 0)
	set @includeMySharedSearchesOnly = isnull ( (select ref.value('@includeMySearchesOnly','INT') from @inputxml_req.nodes('LogMonitoring_GetSharedListReq') as R(ref)),1)
	SET @appType = ISNULL ( (SELECT ref.value('@appType','INT') from @inputxml_req.nodes('LogMonitoring_GetSharedListReq') as R(ref)),1)
	declare @userHasViewRightOnCS int
	set @userHasViewRightOnCS = 0
	-- Check for security only when all results are needed.
	if @includeMySharedSearchesOnly=0
	begin
		IF object_id('tempdb.dbo.#searchListTmp') is not null
			DROP TABLE #searchListTmp
create table  #searchListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		exec dbo.sec_getuserObjects @userID, 2018, 2, '#searchListTmp'
if exists(select 1 from #searchListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) )
		begin
			set @userHasViewRightOnCS = 1
		end
	end
	declare @visibleSharedentities table
	(
		sharedEntityId int,
		rowPos int
	)
	-- Instead of umusercredential table we call following sp
	IF object_id('tempdb.dbo.#userCreds') is not null DROP TABLE #userCreds
		create table #userCreds (entityId int)
	exec sec_getNonIdaObjectsForThisUser @userid, 9674, 0, '#userCreds'
	--select * from #userCreds
	-- #userCreds will be having all shareIds for given userId
	--Now ignore shareIds of other shareType and appType
	--Now delete other shareTypes
	DELETE shareTbl
	FROM #userCreds shareTbl
	LEFT JOIN App_SharedEntityInfo appShareTbl
	ON shareTbl.entityId = appShareTbl.SharedEntityId
	WHERE appShareTbl.SharedEntityId IS NULL OR appShareTbl.SharedEntityType <> @shareType
	--Now delete other appType shareIds.
	IF @shareType = 137 --dashboard
	BEGIN
		DELETE shareTbl
		FROM #userCreds shareTbl
		LEFT JOIN App_SharedEntityInfo appShareTbl ON shareTbl.entityId = appShareTbl.SharedEntityId
		LEFT JOIN LMDashBoard dashTbl ON appShareTbl.OriginalEntityId = dashTbl.dashBoardId
		WHERE appShareTbl.SharedEntityId IS NULL OR dashTbl.dashBoardId IS NULL OR dashTbl.monitoringAppType <> @appType OR dashTbl.creatorUserId = @userid
	END
	ELSE IF @shareType = 134 --SEARCH
	BEGIN
		DELETE shareTbl
		FROM #userCreds shareTbl
		LEFT JOIN App_SharedEntityInfo appShared ON shareTbl.entityId = appShared.SharedEntityId
		LEFT JOIN LMUserSearch searchTbl ON appShared.OriginalEntityId = searchTbl.searchId
		WHERE appShared.SharedEntityId IS NULL OR searchTbl.searchId IS NULL OR searchTbl.monitoringAppType <> @appType OR searchTbl.creatorUserId = @userid
	END
	Insert into @visibleSharedentities
	select shareIdTbl.entityId,ROW_NUMBER() over (order by shareIdTbl.entityId) as rownum
	from
	(
		select distinct um.entityId
		from #userCreds um
		-- checks are already done above
		--inner join App_SharedEntityInfo app
		--on um.entityId = app.SharedEntityId
		--where um.entityId <> 0 AND app.SharedEntityType = @sharetype -- This check will filter sharedEntityId based on shareType whether it is (search or dashboard)
	) shareIdTbl
	select @totalcount = count(sharedEntityId) from @visibleSharedentities
	set @totalcount = isnull(@totalcount , 0)
	-- Now total Count is computed we remove entries not in range.
	IF @countOfentities != 0  -- If @countOfentities = 0 , fetch all list , So no pagination logic to be done.
	BEGIN
		delete T
		from @visibleSharedentities T
		where t.rowPos < @startId Or t.rowPos >= @startId +@countOfentities
	END
	IF @totalcount > 0
	BEGIN
		IF @sharetype = 134 -- SEARCH
		BEGIN
			SET @o_xmlMsg=(	select shared.sharedEntitytype as '@sharetype',shared.originalEntityId as '@originalEntityId', u.login as '@sharedUser', lm.searchname as '@originalEntityName', ( lm.searchinfo).value(' (/LogMonitoring_SearchURLInfo/@browserURL) [1]','nvarchar(512)') as '@browserUrl', lm.creatoruserid as '@creatorId',shared.sharedEntityId as 'sharedEntityId/@sharedEntityId'
			from App_SharedEntityInfo shared inner join @visibleSharedentities as visibleSharedentities
			on shared.SharedEntityId = visibleSharedentities.sharedEntityId
			inner join LMUserSearch lm
			on shared.OriginalEntityId = lm.searchId
			inner join UMUsers u
			on u.id = lm.creatorUserId
			--appType is checked above
			--WHERE lm.monitoringAppType = @appType
			order by shared.sharedEntityId desc
			for xml path('sharedInfoList') , root('LogMonitoring_SharedListResp')
			)
		END
		ELSE IF @sharetype = 137 -- DASHBOARD
		BEGIN
			SET @o_xmlMsg=( select shared.sharedEntitytype as '@sharetype',shared.originalEntityId as '@originalEntityId', u.login as '@sharedUser', lm.dashBoardName as '@originalEntityName',  lm.creatoruserid as '@creatorId',CONVERT(NVARCHAR(MAX),lm.dashBoardProp) as '@dashBoardProp',shared.sharedEntityId as 'sharedEntityId/@sharedEntityId'
			from App_SharedEntityInfo shared inner join @visibleSharedentities as visibleSharedentities
			on shared.SharedEntityId = visibleSharedentities.sharedEntityId
			inner join LMDashBoard lm
			on shared.OriginalEntityId = lm.dashBoardId
			inner join UMUsers u
			on u.id = lm.creatorUserId
			----appType is checked above
			--WHERE lm.monitoringAppType = @appType
			order by shared.sharedEntityId desc
			for xml path('sharedInfoList') , root('LogMonitoring_SharedListResp')
			)
		END
		IF @o_xmlMsg IS NOT NULL
		BEGIN
		set @o_xmlMsg.modify('insert attribute totalSearch {sql:variable("@totalcount")} into (/LogMonitoring_SharedListResp)[1]')
		END
	END
	set @o_xmlMsg = isnull(@o_xmlMsg,'<LogMonitoring_SharedListResp totalSearch="0"> </LogMonitoring_SharedListResp>' )
	select @o_xmlMsg
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetSharedList')
	delete from GxQscripts where name = 'LMGetSharedList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSharedList')
	delete from GXDBVersions where aliasname = 'LMGetSharedList'
GO

insert into GXDBVersions values(2, 'LMGetSharedList',  '00010004000200070000', 'LMGetSharedList', '00010004000200070000')
GO

