

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetSearchList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetSearchList.sp,v $ $Id: LMGetSearchList.sp,v 1.17.2.17 2018/03/22 01:50:25 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetSearchList <<<'

IF EXISTS (select * from sysobjects where name='LMGetSearchList')
	drop procedure LMGetSearchList
IF EXISTS (select * from GxQscripts where name='LMGetSearchList')
	delete from GxQscripts where name = 'LMGetSearchList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSearchList')
	delete from GXDBVersions where aliasname = 'LMGetSearchList'
GO
print '... Creating Procedure: LMGetSearchList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetSearchList
  @userId INTEGER,
  @inputxml_req xml,
  @o_xmlMsg xml		OUTPUT
AS
  DECLARE @outPutXML XML
Set transaction isolation level read uncommitted
DECLARE @infoLevel INTEGER = 0
DECLARE @searchIds TABLE (searchId INTEGER,rowPos int);
DECLARE @groupIds  TABLE (groupId INTEGER);
DECLARE @DashSearch TABLE (searchId INTEGER, dashBoards XML)
DECLARE @input XML = @inputxml_req
DECLARE @startId INTEGER
DECLARE @count	INTEGER
DECLARE @dashId INTEGER
DECLARE @status INTEGER
DECLARE @searchId INTEGER
DECLARE @searchName nvarchar(512)
DECLARE @ntotalSearchsCnt int
declare @includeMySearchesOnly integer
declare @getSharedSearchesOnly integer
declare @includeImplicitSearches integer
declare @appType integer
SET @infoLevel = ISNULL((SELECT ref.value('@infoLevel','INTEGER') AS data
					FROM @input.nodes('LogMonitoring_GetSearchListReq') R ( ref )),0)
SET @startId = ISNULL((SELECT ref.value('@start','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetSearchListReq/pageInfo') R ( ref )),0)
SET @count = ISNULL((SELECT ref.value('@count','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetSearchListReq/pageInfo') R ( ref )),0)
SET @dashId = ISNULL((SELECT ref.value('@dashBoardId','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetSearchListReq/dashBoard') R ( ref )),0)
SET @status = ISNULL((SELECT ref.value('@status','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetSearchListReq') R ( ref )),0)
SET @searchId = ISNULL((SELECT ref.value('@searchId','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetSearchListReq/searchInfo') R ( ref )),0)
SET @searchName = ISNULL((SELECT ref.value('@searchName','nvarchar(512)') AS data
				FROM @input.nodes('LogMonitoring_GetSearchListReq/searchInfo') R ( ref )),'')
SET @includeMySearchesOnly = ISNULL((SELECT ref.value('@includeMySearchesOnly','INTEGER') AS data
					FROM @input.nodes('LogMonitoring_GetSearchListReq') R ( ref )),0)
SET @includeImplicitSearches = ISNULL((SELECT ref.value('@includeImplicitSearches','INTEGER') AS data
					FROM @input.nodes('LogMonitoring_GetSearchListReq') R ( ref )),1)
SET @getSharedSearchesOnly =  ISNULL((SELECT ref.value('@getSharedSearchesOnly','INTEGER') AS data
					FROM @input.nodes('LogMonitoring_GetSearchListReq') R ( ref )),0)
SET @appType = ISNULL((SELECT ref.value('@appType','INTEGER') AS data
					FROM @input.nodes('LogMonitoring_GetSearchListReq') R ( ref )),0)
set @ntotalSearchsCnt = 0
declare @userHasViewRightOnCS int
declare @validAlerts TABLE(alertId INT,alertProp XML ,rowPos int)
/*if @appType = 0
begin
	set @appType = 1
end
*/
set @userHasViewRightOnCS = 0
-- Check for security only when all results are needed.
if @includeMySearchesOnly=0
begin
	IF object_id('tempdb.dbo.#searchListTmp') is not null
		 DROP TABLE #searchListTmp
create table  #searchListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	exec dbo.sec_getuserObjects @userID, 2018, 2, '#searchListTmp'
if exists(select 1 from #searchListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) )
	begin
		set @userHasViewRightOnCS = 1
	end
end
IF @infoLevel = 2 or @infoLevel = 3
BEGIN
	if(@searchId = 0 and not(@searchName is null or LEN(@searchName) = 0))
	BEGIN
		SET @searchId = (SELECT searchId from LMUserSearch WITH(NOLOCK) where searchName = @searchName)
	END
	INSERT INTO @searchIds(searchId,rowPos)
    SELECT @searchId,0
END
ELSE
BEGIN
	IF  (@dashId != 0 AND (@status & 4) <> 0) OR (@infoLevel = 4) -- @infoLevel = 4 -> fetch searches for dashBoardId(sharedDashboard)
	BEGIN
		INSERT INTO @searchIds(searchId,rowPos) -- No security check for dashboard saved searches since only users can see only their dashboards
        SELECT  DISTINCT searchAssocTbl.searchId,0
		FROM LMDashSearchAssoc searchAssocTbl WITH(NOLOCK)
		INNER JOIN LMUserSearch searchTbl WITH(NOLOCK) ON searchTbl.searchId = searchAssocTbl.searchId
		WHERE dashBoardId = @dashId AND (@appType = 0 OR searchTbl.monitoringAppType = @appType)
		ORDER BY searchAssocTbl.searchId DESC
	END
	ELSE if (@status & 8) <> 0
	begin
		INSERT INTO @validAlerts(alertId , rowPos)
		SELECT alertTbl.alertId , 0
		FROM APP_LMAlertInfo alertTbl WITH(NOLOCK)
		INNER JOIN NTnotificationRule ntTbl WITH(NOLOCK)
		ON alertTbl.AlertId = ntTbl.id AND (ntTbl.status&2)=0
		INNER JOIN LMUserSearch searchTbl WITH(NOLOCK)
		on alertTbl.SearchId = searchTbl.searchId and ( (searchTbl.creatorUserId=@userId or @userHasViewRightOnCS=1) and searchTbl.isPrivate=1) and (@appType = 0 OR searchTbl.monitoringAppType = @appType)
		order by alertTbl.AlertId desc
	end
	else
	BEGIN
		-- We are not filtering includeImplicitSearches for dashboards and alerts now even if GUI asks to filter since there is no use case. We will always returns all results for those cases.
		INSERT INTO @searchIds(searchId,rowPos)
        SELECT  DISTINCT searchId,0
		FROM LMUserSearch WITH(NOLOCK) WHERE ((creatorUserId = @userId Or @userHasViewRightOnCS=1) AND isPrivate = 1 AND (status & @status) <> 0
		and (@includeImplicitSearches=1 OR IsNull(convert(xml,searchInfo).value('(/LogMonitoring_SearchURLInfo/@isImplicitSearch)[1]','int'),0)=0) AND (@appType = 0 OR monitoringAppType = @appType))
		OR (searchId IN (select searchId from LMDashSearchAssoc where dashBoardId IN (SELECT dashBoardId FROM LMDashBoard WHERE status = 8 AND (@appType = 0 OR monitoringAppType = @appType))))
		ORDER BY searchId DESC
	END
END
-- If @infoLevel = 4 -> fetch searches for dashBoardId(sharedDashboard)
-- All search has same dashboard Information . So its enough to send dashboard information for the first search.
IF @infoLevel = 4
BEGIN
	INSERT INTO @DashSearch(searchId)
	SELECT TOP 1 searchId FROM @searchIds ORDER BY searchId DESC -- used order by because in @outputXMl ,xml is formed with searchId in decending order.
END
ELSE
BEGIN
	INSERT INTO @DashSearch(searchId)
	SELECT searchId FROM @searchIds
END
If @getSharedSearchesOnly = 1 -- @getSharedSearchesOnly will be 1 when sharedByMeTab is clicked in logmointoring webconsole;
begin
	delete from @searchIds
	where searchId not in (
								select appShare.OriginalEntityId
									from App_SharedEntityInfo appShare
										inner join LMUserSearch lmSearch
											on appShare.OriginalEntityId = lmSearch.searchId
												where (lmSearch.creatorUserId = @userId OR @userHasViewRightOnCS = 1) AND appShare.SharedEntityType = 134 AND (@appType = 0 OR lmSearch.monitoringAppType = @appType)
							)
end
IF (@status & 8) <> 0
BEGIN
	UPDATE validAlert
    SET rowPos = t.rowNo
    FROM @validAlerts validAlert,
            (
                    SELECT alertId,ROW_NUMBER() over (ORDER BY alertId desc) AS rowNo
                    FROM @validAlerts
            ) t
    where t.alertId=validAlert.alertId
	SET @ntotalSearchsCnt = ISNULL((SELECT COUNT(DISTINCT alertId) FROM @validAlerts),0)
	DELETE FROM @validAlerts
    WHERE rowPos < @startId Or rowPos>@startId+@count-1
	INSERT INTO @searchIds
	SELECT DISTINCT lmUserSearch.searchId,0
	FROM LMUserSearch lmUserSearch WITH(NOLOCK)
	INNER JOIN APP_LMAlertInfo alertTbl WITH(NOLOCK)
	ON lmUserSearch.searchId = alertTbl.SearchId
	INNER JOIN @validAlerts validAlert
	ON alertTbl.AlertId = validAlert.alertId
END
ELSE
IF @infoLevel != 2 AND @infoLevel != 3 and @count!=0
begin
       -- Now delete from searches which are not needed.
       Update SearchIds
       set rowPos = t.rowNo
       from @searchIds SearchIds,
              (
                     select searchId,ROW_NUMBER() over (order by searchId desc) as rowNo
                     from @searchIds
              ) t
       where t.searchId=SearchIds.searchId
	   -- this we do before pagination restricts the results.
	   -- Compute @ntotalSearchsCnt based on no of searches returned to webconsole.
	--	set @ntotalSearchsCnt = IsNull((select count(distinct searchId) from @searchIds),0)
	set @ntotalSearchsCnt = IsNull((select count(distinct searches.searchId) from @searchIds searches inner join LMUserSearch lms on searches.searchId = lms.searchId where (@appType = 0 OR lms.monitoringAppType = @appType)),0)
       delete from @searchIds
       where rowPos < @startId Or rowPos>@startId+@count-1
end
else
begin
	-- Compute @ntotalSearchsCnt based on no of searches returned to webconsole.
	set @ntotalSearchsCnt = IsNull((select count(distinct searchId) from @searchIds),0)
end
UPDATE tempds
SET dashBoards = (SELECT dsb.dashBoardId  as '@dashBoardId',
							dsb.dashBoardName as '@dashBoardName',
							dsb.status as '@status',
							CONVERT(NVARCHAR(MAX),dsb.dashBoardProp) as '@dashBoardProp',
							dsb.creatorUserId as 'creator/@userId'
						FROM @DashSearch ds INNER JOIN LMDashSearchAssoc dsa WITH(NOLOCK)
								ON ds.searchId = dsa.searchId
									INNER JOIN LMDashBoard dsb WITH(NOLOCK)
										ON dsb.dashBoardId = dsa.dashBoardId
										WHERE ds.searchId = tempds.searchId FOR XML PATH('dashInfo'))
FROM @DashSearch tempds
declare @userAndGroupInfo table(userId int , groupId int , providerId int , objectId int)
-- @infoLevel = 0 is when, searches under sharedByMe is clicked
if (@infoLevel = 0)
begin
	-- get sharedUserList
	declare @xml xml
	declare @shareId int
	declare cur_searchIds cursor
	static for
	SELECT DISTINCT appShared.SharedEntityId
	FROM App_SharedEntityInfo appShared
		INNER JOIN @searchIds searchIds ON searchIds.searchId = appShared.OriginalEntityId
			INNER JOIN LMUserSearch lmSearch ON lmSearch.searchId = searchIds.searchId
	WHERE appShared.SharedEntityType = 134 AND (@appType = 0 OR lmSearch.monitoringAppType = @appType)
	open cur_searchIds
		if @@CURSOR_ROWS > 0
		begin
			fetch next from cur_searchIds into @shareId
			while @@FETCH_STATUS = 0
			begin
				--exec sec_getSecurityForEntity @userId, @xml output, 9674, @shareId  -- LM_SHARED_ENTITY_INFO = 9674
				--calling userId with admin because user has no permission on othere users can be viewed by admin only.
				exec sec_getSecurityForEntity 1, @xml output, 9674, @shareId  -- LM_SHARED_ENTITY_INFO = 9674
				insert into @userAndGroupInfo(userId , groupId , providerId , objectId)
				SELECT isnull(ref.value('@userId','INTEGER'),0) ,
case when ref.value('@_type_','INTEGER') = 15 then isnull(ref.value('@userGroupId', 'INT'), 0)
when ref.value('@_type_', 'INTEGER') = 62 then isnull(ref.value('@groupId', 'INT'), 0)				--will remove it once isExternalLocalGroupSingleList key is enabled by default
							else 0
					   end,
					   0,
					   @shareId
				FROM @xml.nodes('associations/userOrGroup') R ( ref )
				fetch next from cur_searchIds into @shareId
			end
		end
	close cur_searchIds
	deallocate cur_searchIds
end
DECLARE @alertProp TABLE(searchId INT , alertXml XML)
DECLARE @searchUrlTble TABLE(searchId INT,searchUrl XML)
IF NOT EXISTS(SELECT 1 FROM @validAlerts)
BEGIN
	INSERT INTO @validAlerts(alertId)
	SELECT DISTINCT alertTbl.AlertId
	FROM APP_LMAlertInfo alertTbl WITH(NOLOCK)
	INNER JOIN @searchIds searchIds
	on alertTbl.SearchId = searchIds.searchId
	INNER JOIN NTnotificationRule ntTbl WITH(NOLOCK)
	ON alertTbl.AlertId = ntTbl.id AND (ntTbl.status&2)=0
END
UPDATE alertResp
SET alertProp = lmAlert.AlertProp
FROM @validAlerts alertResp
INNER JOIN APP_LMAlertInfo lmAlert
on alertResp.alertId = lmAlert.AlertId
--Getting status of alert(Enabled or Disabled) from NTNotificationRule Table
UPDATE alertResp
SET alertProp.modify('replace value of (alertInfoLst/@status) [1] with ("1") ')
FROM @validAlerts alertResp
INNER JOIN NTNotificationRule ntNotificationTbl
ON alertResp.alertId = ntNotificationTbl.id
WHERE (ntNotificationTbl.status &1) = 0  AND (ntNotificationTbl.status&2)=0 --> Enabled & non deleted alerts.
UPDATE alertResp
SET alertProp.modify('replace value of (alertInfoLst/@status) [1] with ("0") ')
FROM @validAlerts alertResp
INNER JOIN NTNotificationRule ntNotificationTbl
ON alertResp.alertId = ntNotificationTbl.id
WHERE (ntNotificationTbl.status &1) <> 0  AND (ntNotificationTbl.status&2)=0 --> Disabled
INSERT INTO @alertProp(searchId , alertXml)
SELECT lmSearchTbl.searchId ,
		(
			SELECT alertResp.AlertProp.query('.')
				FROM @validAlerts alertResp
				INNER JOIN APP_LMAlertInfo  alertTbl WITH(NOLOCK)
				ON alertResp.alertId = alertTbl.AlertId
				WHERE alertTbl.SearchId = lmSearchTbl.searchId
				FOR XML PATH(''),type
		) as alertProp
FROM LMUserSearch as lmSearchTbl WITH(NOLOCK)
INNER JOIN @searchIds searchIds
ON lmSearchTbl.searchId = searchIds.searchId
INSERT INTO @searchUrlTble
SELECT searchTbl.searchId,searchTbl.searchInfo
FROM LMUserSearch searchTbl WITH(NOLOCK)
INNER JOIN @searchIds searchIds
ON searchTbl.searchId = searchIds.searchId
UPDATE searchUrlTbl
SET searchUrl.modify('insert ( sql:column("alertTbl.alertXml") ) as first into (/LogMonitoring_SearchURLInfo[1])')
FROM @searchUrlTble searchUrlTbl
INNER JOIN @alertProp alertTbl
ON searchUrlTbl.searchId = alertTbl.searchId
SET @o_xmlMsg = ISNULL((SELECT lms.searchId as '@searchId',
		searchName as '@searchName',
		lms.isPrivate as '@isPrivate',
		lms.status as '@status',
		lms.monitoringAppType as '@appType',
		CONVERT(nvarchar(max),searchUrlTbl.searchUrl) as '@urlInfo',
		lms.creatorUserId as 'creator/@userId',
		UMUsers.login as 'creator/@userName',
		lmd.dashBoards as 'node()',
		App_SharedEntityInfo.SharedEntityType as 'sharedEntityInfo/@sharetype',
		App_SharedEntityInfo.originalEntityId as 'sharedEntityInfo/@originalEntityId',
		case when @infoLevel = 0 then Lms.searchName  end as 'sharedEntityInfo/@originalEntityName',
		-- case when @getSharedSearchesOnly = 1 then Lms.searchName  end  as 'sharedEntityInfo/@originalEntityName',
		-- add creatorId here later... browserurl not needed in this context..
		App_SharedEntityInfo.SharedEntityId as 'sharedEntityInfo/sharedEntityId/@sharedEntityId',
		--App_SharedEntityInfo.SharedEntityName as 'sharedEntityInfo/sharedEntityId/@SharedEntityName',
		(
			select case when userId <> 0 then 1 -- userid
                   when groupId <> 0 and UMGroups.umdsProviderId = 0 then 3 -- commcellgroup
                   when groupId <> 0 and UMGroups.umdsProviderId > 0 then 4 -- External group
                   end as '@userType',
				case when userId <> 0 then UMUsers.name + '('+ UMUsers.login + ')' end as 'user/@userName',
				case when groupId <> 0 and UMGroups.umdsProviderID = 0 then UMGroups.name + '('+ UMGroups.name + ')' end as 'group/@userGroupName',
				case when groupId <> 0 and UMGroups.umdsProviderID > 0 then UMgroups.name + '(' + UMDSProviders.domainName + '\'+ UMgroups.name+ ')' end as 'externalGroup/@externalGroupName'
            from @userAndGroupInfo association
			left join UMUsers on association.userId=umusers.id
			left join UMGroups on association.groupId = UMGroups.id
			left join UMDSProviders on UMGroups.umdsProviderId = UMDSProviders.id
            where App_SharedEntityInfo.SharedEntityId = association.objectId
			for xml path('sharedTo'),type
		) as 'sharedEntityInfo'
		FROM LMUserSearch lms with(nolock) INNER JOIN @searchIds ids
			ON lms.searchId = ids.searchId
			INNER JOIN @searchUrlTble searchUrlTbl
				ON searchUrlTbl.searchId = lms.searchId
				LEFT JOIN @DashSearch lmd
					ON lmd.searchId = ids.searchId
				Left join UMUsers
					on lms.creatorUserId = UMUsers.id
					left join App_SharedEntityInfo on
				App_SharedEntityInfo.SharedEntityType=134 and App_SharedEntityInfo.OriginalEntityId=lms.searchId and @infoLevel = 0
			where (@appType = 0 OR lms.monitoringAppType = @appType)
		ORDER BY lms.searchId DESC
		FOR XML PATH('searchInfoList'),ROOT('LogMonitoring_SearchListResp')),'<LogMonitoring_SearchListResp/>')
set @o_xmlMsg.modify('insert attribute totalSearchs {sql:variable("@ntotalSearchsCnt")} into (/LogMonitoring_SearchListResp)[1]')
-- @infoLevel = 3 is when searches under sharedToMe is clicked
	if @infoLevel = 3 OR @infoLevel = 4 -- sharing
	begin
		--SECURITY CHECK, Checking whether search is shared to the user
			declare @userHasCapabilityToViewShare int = 0
			declare @isSearchUnshared int = 0
			DECLARE @shareType INT = 134 -- SHARED_SEARCH
			DECLARE @originalEntityId INT = @searchId
			DECLARE @isAllowed INTEGER = 0
			DECLARE @shareEntityId INT
			IF (@dashId <> NULL OR @dashId <> 0) AND (@infoLevel = 4)
			BEGIN
				-- dashboard link is clicked
				SET @shareType = 137 -- SHARED_DASHBOARD
				SET @originalEntityId = @dashId
SET @shareEntityId = ISNULL(( SELECT top 1 SharedEntityId FROM App_SharedEntityInfo WHERE SharedEntityType = 137 and OriginalEntityId = @originalEntityId ),0)
				IF(@shareEntityId <> 0)
				BEGIN
EXEC sec_checkPermissionOnEntity @userId , 216 , @isAllowed OUTPUT , 9674 , @shareEntityId
					IF @isAllowed = 1
					BEGIN
						SET @userHasCapabilityToViewShare = 1
					END
				END
			END
			ELSE IF @infoLevel = 3
			BEGIN
SET @shareEntityId = ISNULL((SELECT TOP 1 SharedEntityId FROM App_SharedEntityInfo WHERE SharedEntityType =  134 AND OriginalEntityId = @originalEntityId),0)
				IF (@shareEntityId <> 0)
				BEGIN
EXEC sec_checkPermissionOnEntity @userId , 216 , @isAllowed OUTPUT , 9674 , @shareEntityId
					IF @isAllowed = 1
					BEGIN
						SET @userHasCapabilityToViewShare = 1
					END
				END
				IF @userHasCapabilityToViewShare = 0
				BEGIN
					SET @shareEntityId = ISNULL((SELECT TOP 1 shareTbl.SharedEntityId
													FROM App_SharedEntityInfo shareTbl
WHERE shareTbl.SharedEntityType = 137 AND shareTbl.OriginalEntityId = (SELECT TOP 1 dashBoardId FROM LMDashSearchAssoc WHERE searchId = @originalEntityId)
											 ),0)
					IF @shareEntityId <> 0
					BEGIN
EXEC sec_checkPermissionOnEntity @userId , 216 , @isAllowed OUTPUT , 9674 , @shareEntityId
						IF @isAllowed = 1
						BEGIN
							set @userHasCapabilityToViewShare = 1
							-- which means , user clicked on search through dashboard.So change orignialEntityId and shareType.
							SET @originalEntityId = (SELECT TOP 1 dashBoardId FROM LMDashSearchAssoc WHERE searchId = @originalEntityId)
SET @shareType = 137
						END
					END
				END
			END
			-- check whether that search is unshared or not
			IF NOT EXISTS (SELECT 1 FROM App_SharedEntityInfo where SharedEntityId = @shareEntityId)
			BEGIN
				SET @isSearchUnshared = 1 ;
			END
			if ( (/*@userHasViewRightOnCS = 1 or */@userHasCapabilityToViewShare = 1) AND @isSearchUnshared = 0)
			begin
				declare @creatoruserid int
				declare @monitorinPolicy_xml xml
				declare @monitoringPolicyFromApp_shared_Xml xml
				declare @monitoringPolicyList_xml xml
				declare @mpTblFromXml table(mointoringPolicyId int,monitoringTypesXml xml)
				declare @mpTblFromApp_shared table(monitoringPolicyId int)
				declare @intersectingMpTable table(monitoringPolicyId int)
				IF @shareType = 134 -- SHARED_SEARCH
				BEGIN
					SET @creatoruserid = (select creatoruserid from lmusersearch where searchid= @originalEntityId )
				END
				ELSE IF @shareType = 137 -- SHARED_DASHBOARD
				BEGIN
					SET @creatoruserid = (SELECT creatoruserid FROM LMDashBoard WHERE dashBoardId = @originalEntityId )
				END
				exec LMGetMonitoringPolicy @creatoruserid,'' , @o_xmlMsg = @monitorinPolicy_xml output
				insert into @mpTblFromXml(mointoringPolicyId , monitoringTypesXml)
				select ref.value('@monitoringPolicyid','INT') , ref.query('monitoringTypes')
				from  @monitorinPolicy_xml.nodes('LogMonitoring_GetMonitoringPoliciesListResp/monitoringPolicies') R(ref)
				set @monitoringPolicyFromApp_shared_Xml  = (select monitoringpolices from App_SharedEntityInfo where OriginalEntityId = @originalEntityId and SharedEntityType = @shareType)
				insert into @mpTblFromApp_shared
				select ref.value('@monitoringPolicyId','int')
				from @monitoringPolicyFromApp_shared_Xml.nodes('monitoringPolicy/sharedPolicies') R(ref)
				--intersecting;
				insert into @intersectingMpTable (monitoringPolicyId)
				select ref.mointoringPolicyId
				from (
						select mointoringPolicyId from @mpTblFromXml
						intersect
						select monitoringPolicyId from @mpTblFromApp_shared
					 ) as ref
				set @monitoringPolicyList_xml =  (select mpTbl.mointoringPolicyId as '@monitoringPolicyId' , mpTbl.monitoringTypesXml as '*'
														from @mpTblFromXml mpTbl
														inner join @intersectingMpTable intersectingTbl
														on intersectingTbl.monitoringPolicyId = mpTbl.mointoringPolicyId
														for xml path('sharedPolicies'))
				IF @monitoringPolicyList_xml IS NOT NULL
					set @o_xmlMsg.modify( ' insert sql:variable("@monitoringPolicyList_xml") into (/LogMonitoring_SearchListResp/searchInfoList)[1]  ')
				-- For shared search/dashboard, we need to provide creators client association also.Because client filter is done in webconsole.
				DECLARE @permission INTEGER = 0
DECLARE @entity INTEGER = 3
				DECLARE @userHasRightOnAllClients INTEGER
				EXEC sec_checkPermissionOnEntity @userId, @permission, @userHasRightOnAllClients OUTPUT, @entity, 0 -- This is entityId..
				IF(@userHasRightOnAllClients <> 1)
				BEGIN
					DECLARE @clientXml XML
					IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
					CREATE TABLE #clientList
					(
					clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
					)
					EXEC sec_getIdaObjectsForUser @creatoruserid,@entity,0,1,'#clientList'
					SET @clientXml = (
						SELECT clientId as '@clientId'
						FROM #clientList
						FOR XML PATH('shareClientList'))
					IF @clientXml IS NOT NULL
						set @o_xmlMsg.modify( ' insert sql:variable("@clientXml") into (/LogMonitoring_SearchListResp/searchInfoList)[1]  ')
					DROP TABLE #clientList
				END
			end --if part
			else
			begin
				SET @o_xmlMsg = (SELECT 1 AS '@errorCode', 'User does not have permission to view share' AS '@errorString'
								 FOR XML PATH('error'),ROOT('LogMonitoring_SearchListResp'))
			end
	end --infolevel=3
SET @outPutXML = @o_xmlMsg
SELECT @outPutXML
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetSearchList')
	delete from GxQscripts where name = 'LMGetSearchList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSearchList')
	delete from GXDBVersions where aliasname = 'LMGetSearchList'
GO

insert into GXDBVersions values(2, 'LMGetSearchList',  '00010017000200170000', 'LMGetSearchList', '00010017000200170000')
GO

