

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetSearchAlertAndInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetSearchAlertAndInfo.sp,v $ $Id: LMGetSearchAlertAndInfo.sp,v 1.3.48.6 2018/02/28 19:32:48 logeshg Exp $"
--
--  +========================================================================+
--  | Stored Precedure: LMGetSearchAlertAndInfo()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Mrityunjay upadhyay LMGetSearchAlertAndInfo to fetch clouds associated to monitoring policies.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetSearchAlertAndInfo <<<'

IF EXISTS (select * from sysobjects where name='LMGetSearchAlertAndInfo')
	drop procedure LMGetSearchAlertAndInfo
IF EXISTS (select * from GxQscripts where name='LMGetSearchAlertAndInfo')
	delete from GxQscripts where name = 'LMGetSearchAlertAndInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSearchAlertAndInfo')
	delete from GXDBVersions where aliasname = 'LMGetSearchAlertAndInfo'
GO
print '... Creating Procedure: LMGetSearchAlertAndInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetSearchAlertAndInfo
  @clientId int
AS
--LM Search Alerts: Requires search url, external alert info and CI engine list for shard query
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @searchListResponse XML
DECLARE @GetCloudClientInfoListResp  XML
DECLARE @nv_searchListResponse NVARCHAR(MAX)
DECLARE @nv_GetCloudClientInfoListResp NVARCHAR(MAX)
DECLARE @nv_@searchListResponse NVARCHAR(MAX)
DECLARE @o_xml XML
-- IF clientID is not first MA, JUst return empty result
-- If the client's Licence was released , appClient.status & 2 <> 2 code in below statement will ignore that client.
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
exec DM2GetIndexServers 'Log Monitoring'
DECLARE @curLM INT
SET @curLM = ISNULL((SELECT TOP 1 dm2Tbl.clientId FROM #getIndexServers dm2Tbl
					INNER JOIN APP_Client appClient WITH(NOLOCK) ON dm2Tbl.clientId = appClient.id WHERE appClient.status & 2 <> 2 ORDER BY dm2Tbl.clientId),0)
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
IF( @clientId <> @curLM)
BEGIN
	SET @o_xml = '<LogMonitoring_LMSearchAlertResp> </LogMonitoring_LMSearchAlertResp>'
	GOTO ENDPROC
END
DECLARE @searchinfoTbl table
( searchinfo nvarchar(MAX))
SET @searchListResponse = (Select searchInfoList.searchId as "@searchId",searchName as "@searchName",searchInfoList.status as "@status", CAST(searchInfo AS NVARCHAR(MAX)) as "@urlInfo"
FROM LMUserSearch AS searchInfoList
INNER JOIN APP_LMAlertInfo alertTbl WITH(NOLOCK)
ON searchInfoList.searchId = alertTbl.SearchId
INNER JOIN NTnotificationRule ntTbl WITH(NOLOCK)
ON ntTbl.id = alertTbl.AlertId
WHERE ntTbl.status &1=0 AND (ntTbl.status&2)=0-->enabled and non deleted alerts.
For XML PATH('searchInfoList'), ROOT('LogMonitoring_SearchListResp'))
	IF ( CURSOR_STATUS(N'global', N'MPListForAlert') >= 0  /* cursor is open */
		OR CURSOR_STATUS(N'local', 'MPListForAlert') >= 0 )
			CLOSE MPListForAlert
	IF ( CURSOR_STATUS('global','MPListForAlert') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','MPListForAlert') = -1 )
			DEALLOCATE MPListForAlert
DECLARE @searchid int
DECLARE @searchName nvarchar(512)
DECLARE @status int
DECLARE @searchInfo nvarchar(MAX)
DECLARE @creatoeUserId int
DECLARE @capability bigint = POWER(CONVERT(bigint,2),33-1)
DECLARE @alertProp table(alertId int , alertXml xml)
DECLARE @lastRunTimeTbl TABLE(alertId INT , lastRunTime BIGINT)
DECLARE @alertPropXml XML
DECLARE @currentTime BIGINT = DBO.GetUnixTime(GETUTCDATE())
DECLARE @newAlerts TABLE(alertId INT)
DECLARE MPListForAlert CURSOR
FOR
	Select DISTINCT searchInfoList.searchId,searchInfoList.searchName,searchInfoList.status, CAST(searchInfoList.searchInfo AS NVARCHAR(MAX)), searchInfoList.creatorUserId
	FROM LMUserSearch AS searchInfoList
	INNER JOIN APP_LMAlertInfo alertTbl WITH(NOLOCK)
	ON searchInfoList.searchId = alertTbl.SearchId
	INNER JOIN NTnotificationRule ntTbl WITH(NOLOCK)
	ON ntTbl.id = alertTbl.AlertId
	WHERE ntTbl.status &1=0 AND (ntTbl.status&2)=0-->enabled and non deleted alerts.
	OPEN MPListForAlert
			FETCH NEXT FROM MPListForAlert
			INTO  @searchid,
			 @searchName,
			 @status,
			 @searchInfo,
			 @creatoeUserId
			 WHILE @@FETCH_STATUS = 0
			 BEGIN
			declare @x XML
			exec LMGetMonitoringPolicy @creatoeUserId,'',@x output
			DECLARE @searchUrlInfo XML = CONVERT(XML , @searchInfo)
			DELETE FROM @alertProp
			DELETE FROM @lastRunTimeTbl
			INSERT @alertProp
			SELECT alertId,AlertProp
			FROM APP_LMAlertInfo alertTbl WITH(NOLOCK)
			INNER JOIN NTnotificationRule ntTbl WITH(NOLOCK)
			ON ntTbl.id = alertTbl.AlertId
			WHERE SearchId = @searchid AND ntTbl.status &1=0 AND (ntTbl.status&2)=0-->enabled and non deleted alerts.
			INSERT INTO @lastRunTimeTbl
			SELECT lmAlert.alertId ,
					CASE
						WHEN (DATEDIFF(YEAR ,'1970-01-01 00:00:00',ntNotif.lastRunTime) >= 1) then DBO.GetUnixTime(ntNotif.lastRunTime)
						ELSE @currentTime
					END
			FROM @alertProp lmAlert
			INNER JOIN NTNotificationQueryMapping ntNotif WITH(NOLOCK)
			ON lmAlert.AlertId = ntNotif.NtNotificationId
			INSERT INTO @newAlerts
			SELECT lastRunTbl.alertId
			FROM @lastRunTimeTbl lastRunTbl
			WHERE lastRunTbl.lastRunTime = @currentTime
			UPDATE lmAlert
			set alertXml.modify('insert attribute lastRunTime { sql:column("lastRun.lastRunTime") } as first into (/alertInfoLst) [1] ')
			FROM @alertProp lmAlert
			INNER JOIN @lastRunTimeTbl lastRun
			ON lmAlert.AlertId = lastRun.alertId
			SET @alertPropXml = (
					SELECT alertXml.query('.')
					FROM @alertProp
					FOR XML PATH(''),type
				)
			SET @searchUrlInfo.modify('insert ( sql:variable("@alertPropXml")) as first into (/LogMonitoring_SearchURLInfo[1])  ')
			SET @searchInfo = CONVERT(NVARCHAR(MAX),@searchUrlInfo)
			SET @searchListResponse = (Select @searchid as "@searchId",@searchName as "@searchName",@status as "@status", @searchInfo as "@urlInfo"
				,CAST(@x AS NVARCHAR(MAX)) as "@policyResp"
				For XML PATH('searchInfoList'))--, ROOT('LogMonitoring_SearchListResp'))
			insert into @searchinfoTbl
			select CAST(@searchListResponse AS NVARCHAR(MAX))
				FETCH NEXT FROM MPListForAlert
				INTO  @searchid,
				 @searchName,
				 @status,
				 @searchInfo,
				 @creatoeUserId
				END
			CLOSE MPListForAlert
			DEALLOCATE MPListForAlert
--Updating with currentTime because if alerts are not processed and next time this sp is called , we would fetch correct value.
UPDATE ntNotif
SET ntNotif.lastRunTime = GETUTCDATE()
FROM NTNotificationQueryMapping ntNotif
INNER JOIN @newAlerts newAlerts
ON ntNotif.NtNotificationId = newAlerts.alertId
DECLARE @sinfo nvarchar(MAX)
select @sinfo=COALESCE(@sinfo+'','')+ searchinfo from   @searchinfoTbl
SET @searchListResponse = (select '<LogMonitoring_SearchListResp>' + @sinfo + '</LogMonitoring_SearchListResp>' )
EXEC GetLMCloudClientList '',@GetCloudClientInfoListResp OUTPUT
SET @nv_searchListResponse = CAST(@searchListResponse AS NVARCHAR(MAX))
SET @nv_GetCloudClientInfoListResp = CAST(@GetCloudClientInfoListResp AS NVARCHAR(MAX))
SET @o_xml = (
SELECT @nv_searchListResponse AS "searchListRespString",
@nv_GetCloudClientInfoListResp AS "getCloudClientInfoListRespString"
FOR XML RAW('LogMonitoring_LMSearchAlertResp'),ELEMENTS)
ENDPROC:
select @o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetSearchAlertAndInfo')
	delete from GxQscripts where name = 'LMGetSearchAlertAndInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetSearchAlertAndInfo')
	delete from GXDBVersions where aliasname = 'LMGetSearchAlertAndInfo'
GO

insert into GXDBVersions values(2, 'LMGetSearchAlertAndInfo',  '00010003004800060000', 'LMGetSearchAlertAndInfo', '00010003004800060000')
GO

