

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetReIndexJobList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetReIndexJobList.sp,v $ $Id: LMGetReIndexJobList.sp,v 1.1.2.6 2018/03/27 09:10:06 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LMGetReIndexJobList()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.0	Logesh G LMGetReIndexJobList to gives list of reIndexing job List to webconsole
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetReIndexJobList <<<'

IF EXISTS (select * from sysobjects where name='LMGetReIndexJobList')
	drop procedure LMGetReIndexJobList
IF EXISTS (select * from GxQscripts where name='LMGetReIndexJobList')
	delete from GxQscripts where name = 'LMGetReIndexJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetReIndexJobList')
	delete from GXDBVersions where aliasname = 'LMGetReIndexJobList'
GO
print '... Creating Procedure: LMGetReIndexJobList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetReIndexJobList
  @userId INTEGER,
  @inputXml XML,
  @outputXml XML OUTPUT
AS
	DECLARE @reIndexJobs TABLE(jobId INT , mpId INT)
	DECLARE @jobTypeTbl TABLE(lmJobType INT)
	DECLARE @curJobId INT
	DECLARE @mpIdTbl TABLE (mpId INT)
	DECLARE @appType INT
	SELECT @appType = ISNULL( ref.value('@appType','INT') , 1)
	FROM @inputXml.nodes('LogMonitoring_GetLMReIndexJobInfoListReq') AS R(ref)
	DECLARE @mpXml XML = '<LogMonitoring_GetMonitoringPoliciesListReq appType="' + CONVERT(NVARCHAR(MAX),@appType )+ '" />'
	EXEC LMGetMonitoringPolicy @userId, @mpXml , @mpXml OUTPUT
	DECLARE @monitoringPolicyTbl TABLE (mpId INT )
	INSERT INTO @monitoringPolicyTbl
    SELECT ref.value('@monitoringPolicyid','INT')
    FROM @mpXml.nodes('LogMonitoring_GetMonitoringPoliciesListResp/monitoringPolicies') AS R(ref)
	DECLARE @jobIds CURSOR
	IF ( CURSOR_STATUS('variable', '@jobIds') > 0) /* cursor is open */
        CLOSE @jobIds
    SET @jobIds = CURSOR
    FOR SELECT DISTINCT jobID FROM RunningAdminJobs WHERE opType = 86 -- LogMonitoring jobs
        OPEN @jobIds
            FETCH NEXT FROM @jobIds INTO @curJobId
            WHILE @@FETCH_STATUS = 0
			BEGIN
				INSERT INTO @jobTypeTbl
				EXEC TM_GetJobOption @curJobId , 1286767843 -- If returned is 2 , then it is a reIndexJob
				IF( (SELECT TOP 1 lmJobType FROM @jobTypeTbl) = 2)
				BEGIN
					INSERT INTO @mpIdTbl
					exec JMGetMonitoringPolicyIdForLMJob  @curJobId
					INSERT INTO @reIndexJobs(jobId , mpId)
					SELECT @curJobId , curMpTbl.mpId
					FROM @monitoringPolicyTbl mpTbl
					INNER JOIN @mpIdTbl curMpTbl
					ON mpTbl.mpId = curMpTbl.mpId
				END
				DELETE FROM @jobTypeTbl
				DELETE FROM @mpIdTbl
				FETCH NEXT FROM @jobIds INTO @curJobId
            END
        DEALLOCATE @jobIds
		SET @outputXml = ISNULL (
			 (
			SELECT reIndexJobs.jobId AS '@jobid' ,
				reIndexJobs.mpId AS '@monitoringPolicyId',
				policyTbl.MonitorPolicyName AS '@monitoringPolicyName',
				adminJobs.percentcomplete AS '@jobCompletePercent',
				(SELECT stateName FROM JMJobStateNames WHERE stateType = adminJobs.state) AS '@updateMessage'
			FROM @reIndexJobs reIndexJobs
			INNER JOIN RunningAdminJobs adminJobs WITH(NOLOCK)
			ON adminJobs.jobID = reIndexJobs.jobId
			INNER JOIN APP_MonitoringPolicy policyTbl WITH(NOLOCK)
			ON reIndexJobs.mpId = policyTbl.monitorPolicyId
			FOR XML PATH('lmJobInfoList')  , ROOT('LogMonitoring_LogMonitoringJobInfoList')
			)
			,
			'<LogMonitoring_LogMonitoringJobInfoList> </LogMonitoring_LogMonitoringJobInfoList>'
			)
SELECT @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetReIndexJobList')
	delete from GxQscripts where name = 'LMGetReIndexJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetReIndexJobList')
	delete from GXDBVersions where aliasname = 'LMGetReIndexJobList'
GO

insert into GXDBVersions values(2, 'LMGetReIndexJobList',  '00010001000200060000', 'LMGetReIndexJobList', '00010001000200060000')
GO

