

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetPoliciesToProcess.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetPoliciesToProcess.sp,v $ $Id: LMGetPoliciesToProcess.sp,v 1.13.40.9 2019/04/30 02:56:56 kvinayak Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMGetPoliciesToProcess')
BEGIN
	print '>>> Drop Stored Procedure: LMGetPoliciesToProcess <<<'
	drop procedure LMGetPoliciesToProcess
END
IF EXISTS (select * from GxQscripts where name='LMGetPoliciesToProcess')
	delete from GxQscripts where name = 'LMGetPoliciesToProcess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetPoliciesToProcess')
	delete from GXDBVersions where aliasname = 'LMGetPoliciesToProcess'
GO
print '... Creating Procedure: LMGetPoliciesToProcess'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetPoliciesToProcess
  @i_xml XML 
AS
  DECLARE @xmlStr xml
SET NOCOUNT ON
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
DECLARE @requestType INTEGER =  ISNULL(( SELECT ref.value('@type','INTEGER') AS data  FROM @i_xml.nodes('LogMonitoring_GetMonitoringPolicyPropsRequest') R(ref)),4)
DECLARE @fileCountForOnDemand INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'nFileToProcessInOnDemandMP'),3)
DECLARE @isSyslogEnabled NVARCHAR(32) = ISNULL((SELECT value FROM GXGlobalParam WHERE name LIKE 'benableSyslog'), N'false')
DECLARE @syslogHostNameAndPort NVARCHAR(1024) = ISNULL((SELECT value FROM GXGlobalParam WHERE name LIKE 'SyslogHostNameAndPort'), '')
BEGIN TRY
DECLARE @MonirotinPolicyData TABLE (
	monitoringPolicyId INTEGER,
	monitoringPolicyname NVARCHAR(1024),
	monitoringPolicyType INTEGER,
	defaultContent NVARCHAR(4000),
	cloudId INTEGER,
	cloudName NVARCHAR(1024),
	isSyslogEnabled NVARCHAR(32),
	syslogHostnameAndPort NVARCHAR(1024),
	lastDatarRowIndx INTEGER,
	nodesForCloud XML,
	templateId INTEGER,
	templateName NVARCHAR(1024),
	associations XML,
	TemplateXML XML,
	lmODPFileUploadInfo XML,
	uploadClientId INTEGER,
	indexStartTime INTEGER DEFAULT 0,
	uploadId INTEGER,
	lastUpdateTime INTEGER DEFAULT 0,--Used for DB policies
	subClientId INTEGER,
	dumpLocation NVARCHAR(MAX),
	factor INTEGER,
	requestedTimeInfo XML
)
DECLARE @nodesForCloudTbl TABLE(
	cloudId INTEGER,
	clientId INTEGER,
	clientName NVARCHAR(1024),
	freeSpace BIGINT,
	indexSize BIGINT,
	type INTEGER,
	hostName NVARCHAR(1024),
	basePort NVARCHAR(64),
	isAvailable INTEGER,
	mangledHostName NVARCHAR(1024),
	nodeURL NVARCHAR(1024)
)
DECLARE @cloudId TABLE(ids INTEGER)
DECLARE @mpAssoc TABLE(monitoringPoilicyId INTEGER, clientId INTEGER, packages INTEGER)
DECLARE @retryIntervalForPolicy INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'nLMRetryIntervalForDBPolicy'),10)
DECLARE @retryIntervalForUploadFiles INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'nLMRetryIntervalForUploadedFiles'),30)
DECLARE @maxAttemptForUploadFile INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'nLMRetryIntervalForDBPolicy'),10)
DECLARE @maxRetentionOfUploadHistryInHours INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'nLMRetainUploadHistryForHours'),4)
DECLARE @maxWaitForFileTransferCompleteInMinutes INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'nLMMaxWaitTimeForUploadFileTransfer'),15)
IF @requestType = 1-- initialization request
BEGIN
	 IF EXISTS ( SELECT 1 FROM GXGlobalParam WHERE name = 'bPopulatLMtemplate' AND value = 'true')
	 BEGIN
		DECLARE @alertTemplate INTEGER = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'populatealerttemplate'),1)
		IF @alertTemplate = 0
		BEGIN
			exec LMPopulateTemplate ''
			DELETE FROM GXGlobalParam WHERE name = 'bPopulatLMtemplate'
		END
	 END
	 --clear the mp table and get only the mos that are being process status 2
	 DELETE FROM @MonirotinPolicyData
	 INSERT INTO @MonirotinPolicyData (monitoringPolicyId,monitoringPolicyname,templateId,templateName,TemplateXML,monitoringPolicyType)
	 SELECT mp.monitorPolicyId,mp.MonitorPolicyName,template.templateId,template.templateName ,CONVERT(XML,CONVERT(varchar(MAX),template.templateXML)),template.templateForMonitoringType
			FROM APP_MonitoringPolicy mp
				 INNER JOIN APP_MonitorTemplateAssoc mpassoc
					ON mp.monitorPolicyId = mpassoc.monitorPolicyId
						INNER JOIN APP_Template template
							ON mpassoc.templateId = template.templateId
							WHERE mp.status IN (2)
	UPDATE policyData
	SET monitoringPolicyType = ISNULL(mpprop.attrVal,0)
	FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
			ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
				WHERE mpprop.attrName = 'Monitoring Type'
	DELETE FROM @MonirotinPolicyData WHERE monitoringPolicyType NOT IN (5)
	UPDATE policyData
	SET indexStartTime = ISNULL(mpprop.attrVal,0)
	FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
			WHERE mpprop.attrName = 'index start time'
	UPDATE policyData
	SET lastUpdateTime = ISNULL(mpprop.attrVal,0) -- If property is not set
	FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
			WHERE mpprop.attrName = 'Last Update Time For DB Policy'
    UPDATE APP_MonitoringPolicy
	SET status = 0
	WHERE monitorPolicyId IN (SELECT monitoringPolicyId FROM @MonirotinPolicyData WHERE (@now - indexStartTime) > (60 * @retryIntervalForPolicy)
									AND (@now - lastUpdateTime) > (60 * @retryIntervalForPolicy))
						AND status = 2 --Reset the status only for policies for which processing has started.
	UPDATE LMUploadInfo
	SET flag = 1
	WHERE flag = 2 AND (@now - modified) > (60 * @retryIntervalForUploadFiles)
	DELETE FROM LMUploadInfo WHERE (flag IN (0, 3, 4, 6, 7) OR attempt > @maxAttemptForUploadFile ) AND (@now-created) > (@maxRetentionOfUploadHistryInHours * 60 * 60)
	DELETE FROM @MonirotinPolicyData
	DECLARE @dbPolicies TABLE(mpid INTEGER,policyName NVARCHAR(1024),lastIndexId INTEGER, lastIndexTime INTEGER)
	INSERT INTO @dbPolicies(mpid,policyName)
	SELECT mpprop.monitorPolicyId,mp.MonitorPolicyName FROM APP_MonitoringPolicyProp mpprop
	INNER JOIN APP_MonitoringPolicy mp on mp.monitorPolicyId = mpprop.monitorPolicyId
	WHERE mpprop.attrName = 'Monitoring Type' AND mpprop.attrVal = '5'
	UPDATE policyData
	SET lastIndexId = ISNULL(mpprop.attrVal,0)
	FROM @dbPolicies policyData INNER JOIN APP_MonitoringPolicyProp mpprop
			ON policyData.mpid = mpprop.monitorPolicyId
				WHERE mpprop.attrName = 'last DataSet Index'
	--Update time for alert
	UPDATE dbpolicies
	SET dbpolicies.lastIndexTime = ISNULL((SELECT created FROM NTNotificationsForCI WITH (NOLOCK) WHERE ALertId = dbpolicies.lastIndexId),0)
	FROM
	@dbPolicies dbpolicies INNER JOIN APP_MonitorTemplateAssoc tempAssoc
		ON dbpolicies.mpid = tempAssoc.monitorPolicyId
		INNER JOIN APP_Template template ON template.templateId = tempAssoc.templateId AND template.templateName = 'Alert'
	--Update time for events
	UPDATE dbpolicies
	SET dbpolicies.lastIndexTime = ISNULL((SELECT timeServer FROM evMsg WITH (NOLOCK) WHERE id = dbpolicies.lastIndexId),0)
	FROM
	@dbPolicies dbpolicies INNER JOIN APP_MonitorTemplateAssoc tempAssoc
		ON dbpolicies.mpid = tempAssoc.monitorPolicyId
		INNER JOIN APP_Template template ON template.templateId = tempAssoc.templateId AND template.templateName = 'Event Viewer'
	--update time for audits
	UPDATE dbpolicies
	SET dbpolicies.lastIndexTime = ISNULL((SELECT TOP 1 timeServer FROM EvGuiAuditMessage WITH (NOLOCK) WHERE opId = dbpolicies.lastIndexId),0)
	FROM
	@dbPolicies dbpolicies INNER JOIN APP_MonitorTemplateAssoc tempAssoc
		ON dbpolicies.mpid = tempAssoc.monitorPolicyId
		INNER JOIN APP_Template template ON template.templateId = tempAssoc.templateId AND template.templateName = 'Audit Trail'
	MERGE APP_MonitoringPolicyProp as mpprop
	USING (SELECT mpid,lastIndexTIme FROM @dbPolicies) as dbpolicy
	ON mpprop.monitorPolicyId = dbpolicy.mpid AND mpprop.attrName = 'Last Index Id Time'
	WHEN MATCHED THEN UPDATE SET mpprop.attrVal = dbpolicy.lastIndexTime,mpprop.modified = dbo.getUnixTime(GetUTCDate())
	WHEN NOT MATCHED THEN INSERT(monitorPolicyId,commcellId,attrName,attrType,attrVal,created,modified)
	VALUES(dbpolicy.mpid,2,'Last Index Id Time',7,dbpolicy.lastIndexTime,dbo.getUnixTime(GetUTCDate()),dbo.getUnixTime(GetUTCDate()));
	SET @xmlStr = (SELECT  0 AS '@errorCode', '' AS '@errorMessage' FOR XML PATH ('CVGui_GenericResp'))
	SELECT @xmlStr
END
ELSE
BEGIN
--Get the required policies
INSERT INTO @MonirotinPolicyData (monitoringPolicyId,monitoringPolicyname,templateId,templateName,TemplateXML,monitoringPolicyType)
SELECT mp.monitorPolicyId,mp.MonitorPolicyName,template.templateId,template.templateName ,CONVERT(XML,CONVERT(varchar(MAX),template.templateXML)),template.templateForMonitoringType
			FROM APP_MonitoringPolicy mp
				 INNER JOIN APP_MonitorTemplateAssoc mpassoc
					ON mp.monitorPolicyId = mpassoc.monitorPolicyId
						INNER JOIN APP_Template template
							ON mpassoc.templateId = template.templateId
								WHERE mp.status NOT IN (1,2,3)
UPDATE policyData
SET monitoringPolicyType = ISNULL(mpprop.attrVal,0)
FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
			WHERE mpprop.attrName = 'Monitoring Type'
--SELECT * FROM @MonirotinPolicyData
DELETE FROM @MonirotinPolicyData WHERE
	((@requestType = 4 AND monitoringPolicyType NOT IN (4,5))
		OR (@requestType = 3 AND monitoringPolicyType NOT IN (5))
			OR (@requestType = 2 AND monitoringPolicyType NOT IN (4)))
--SELECT * FROM @MonirotinPolicyData
UPDATE policyData
SET cloudId = mpprop.attrVal
FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
			WHERE mpprop.attrName = 'Cloud Id'
UPDATE policyData
SET cloudName = mpprop.attrVal
FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
			WHERE mpprop.attrName = 'Cloud Name'
-- set isSyslogEnabled and syslogHostnameAndPort only for system created syslog specific policies.
-- syslog specific policies will have 'Send to Syslog' property set
UPDATE policyData
SET policyData.isSyslogEnabled = @isSyslogEnabled, policyData.syslogHostnameAndPort = @syslogHostNameAndPort
FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop ON  policyData.monitoringPolicyId = mpprop.monitorPolicyId
WHERE MPProp.attrName = 'Send to Syslog'
UPDATE policyData
SET lastDatarRowIndx = ISNULL(mpprop.attrVal,0)
FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
			WHERE mpprop.attrName = 'last DataSet Index'
-- get the nodes of the cloud
INSERT INTO @cloudId
SELECT CP.id
    FROM APP_ComponentProp CP with(nolock)
    WHERE CP.componentType = 1 AND CP.componentId = 2 AND CP.propertyTypeId = 1 AND CP.modified = 0
INSERT INTO @nodesForCloudTbl(cloudId,clientId,clientName,freeSpace,indexSize,type,hostName,basePort,isAvailable,nodeURL,mangledHostName)
SELECT C.cloudid,SC.ClientId,dbo.GetClientName(SC.ClientId),SC.FreeSpace,0,0,CL.net_hostname,SC.Portno,SC.Enabled,
		'http://'+ CL.net_hostname + ':' + CAST (SC.Portno AS nvarchar(20)),dbo.GetClientMangledHostName(SC.ClientId,NULL)
      FROM DM2SearchServerCoreInfo SC with(nolock) Join DM2CloudCoreRole CR with(nolock)
		ON SC.CloudId = CR.CloudId Join Dm2cloud C with(nolock) ON SC.CloudId = C.cloudid
      inner join App_Client CL with(nolock)
		on SC.ClientId = CL.id
      WHERE roleid = 3 --LM Role
--Get the Assiciations
DECLARE @mpClientAssoc TABLE(id INTEGER PRIMARY KEY IDENTITY(1,1),mpid INTEGER,clientId INTEGER,uploadId INTEGER DEFAULT 0,templateid INTEGER DEFAULT 0)
INSERT INTO @mpClientAssoc
SELECT DISTINCT monitorPolicyId,2,0,templateId FROM APP_MonitorTemplateAssoc
WHERE templateId IN (SELECT template.templateId FROM APP_Template template WHERE template.templateForMonitoringType = 5)
DECLARE @mpsAssoc TABLE(mpAssocId INTEGER, mpId INTEGER, assoc XML)
--UPDATE ASSOCIATION
MERGE @mpsAssoc as mptable
USING
(SELECT assoc.id,assoc.mpid,
	(
		SELECT 3 as '@_type_',assoc.clientId as '@clientId',
		(SELECT name FROM APP_Client with (nolock) WHERE id = assoc.clientId) as '@clientName'
		FOR XML PATH('associations')
	)as NodesXML
 FROM @mpClientAssoc assoc
) as nodesTable
ON mptable.mpId = nodesTable.mpid AND mptable.mpAssocId = nodesTable.id
WHEN MATCHED THEN UPDATE SET mptable.assoc = nodesTable.NodesXML
WHEN NOT MATCHED THEN
INSERT (mpAssocId,mpId,assoc)
VALUES(nodesTable.id,nodesTable.mpId,nodesTable.NodesXML);
UPDATE mpData
SET mpData.associations = ass.assoc
FROM @mpsAssoc ass INNER JOIN @MonirotinPolicyData mpData
	ON ass.mpId = mpData.monitoringPolicyId
--select * from @nodesForCloudTbl
--Remove all the policy of type 4 since we have already calculated association and proceeed with type 5
DELETE FROM @mpClientAssoc
	WHERE mpid NOT IN (SELECT monitoringPolicyId FROM @MonirotinPolicyData WHERE monitoringPolicyType = 4)
DECLARE @uploadEntries TABLE(ids INTEGER)
INSERT INTO @uploadEntries
SELECT DISTINCT upload.id
FROM LMUploadInfo upload INNER JOIN @MonirotinPolicyData mpData ON mpData.monitoringPolicyId = upload.MonitoringPolicyId AND mpData.monitoringPolicyType = 4
WHERE upload.flag = 1
INSERT INTO @mpClientAssoc
SELECT DISTINCT monitoringPolicyId,clientid,id,templateId
FROM LMUploadInfo WHERE id IN (SELECT ids FROM @uploadEntries)
UPDATE mpData
SET mpData.uploadClientId = mpassoc.clientId
FROM @mpClientAssoc mpassoc INNER JOIN @MonirotinPolicyData mpData
		ON  mpassoc.mpid = mpData.monitoringPolicyId
MERGE @MonirotinPolicyData mpData
USING (SELECT DISTINCT assc.uploadId,mpid,data.monitoringPolicyname,data.monitoringPolicyType,data.cloudId,data.cloudName,data.lastDatarRowIndx,lmupload.templateId,
	data.templateName,assc.clientId
	FROM @mpClientAssoc assc INNER JOIN LMUploadInfo lmupload ON assc.mpid = lmupload.monitoringPolicyId AND assc.templateId = lmupload.templateId
	INNER JOIN @MonirotinPolicyData data ON assc.mpid = data.monitoringPolicyId ) as assoc
ON mpData.monitoringPolicyId = assoc.mpid AND mpData.uploadClientId = assoc.clientId AND mpData.templateId = assoc.templateId
WHEN NOT MATCHED THEN
INSERT (monitoringPolicyId,monitoringPolicyname,monitoringPolicyType,cloudId,cloudName,lastDatarRowIndx,templateId,templateName,uploadClientId,uploadId)
VALUES (assoc.mpid,assoc.monitoringPolicyname,assoc.monitoringPolicyType,
	assoc.cloudId,assoc.cloudName,assoc.lastDatarRowIndx,assoc.templateId,assoc.templateName,assoc.clientId,assoc.uploadId) ;
DECLARE @OemBramdId int
SET @OemBramdId = 1
IF EXISTS (SELECT value FROM GXGlobalParam WHERE name = 'MiniBrandId')
BEGIN
        SET @OemBramdId = (SELECT TOP 1 CONVERT(INT, CONVERT(NVARCHAR, value)) FROM GXGlobalParam WHERE name = 'MiniBrandId')
END
UPDATE mp
SET mp.associations = (SELECT 3 as '@_type_',assoc.clientId as '@clientId',
		(SELECT name FROM APP_Client with (nolock) WHERE id = assoc.clientId) as '@clientName'
		FOR XML PATH('associations'))
FROM @MonirotinPolicyData mp INNER JOIN @mpClientAssoc assoc
ON mp.monitoringPolicyId = assoc.mpid AND mp.uploadClientId = assoc.clientId
UPDATE mp
SET mp.templateId = upload.templateId
FROM @MonirotinPolicyData mp INNER JOIN LMUploadInfo upload WITH(NOLOCK)
ON mp.uploadId = upload.id AND mp.monitoringPolicyType = 4
UPDATE mp
SET mp.templateName = (case when mp.templateId = 1 then
						 (select top 1 OEMName from simOEM where OEMId in (select OEMId from SimMiniBrand where MiniBrandId = @OemBramdId)) + ' Logs'
								else
								 template.templateName END)
FROM @MonirotinPolicyData mp INNER JOIN APP_Template template WITH(NOLOCK)
ON mp.templateId = template.templateId AND mp.monitoringPolicyType = 4
UPDATE mp
SET mp.TemplateXML = CONVERT(XML,CONVERT(varchar(MAX),template.templateXML))
FROM @MonirotinPolicyData mp INNER JOIN APP_Template template WITH(NOLOCK)
ON mp.templateId = template.templateId AND mp.monitoringPolicyType = 4
UPDATE mp
SET lmODPFileUploadInfo = (SELECT TOP (@fileCountForOnDemand) id as '@id', monitoringPolicyId as '@monitoringPolicyId',
		requestId as '@requestId',
		destpath as '@destPath',
		fileSize as '@fileSize',
		flag as '@flag',
		uploadTag as '@uploadTag',
		0 as '@offSet',
		attempt as '@attempt',
		clientid as 'client/@clientId',
		userid as 'user/@userId' FROM LMUPloadInfo lmupload WITH(NOLOCK) WHERE lmupload.monitoringPolicyid = mp.monitoringPolicyId
		AND lmupload.clientid = mp.uploadClientId AND lmupload.templateId = mp.templateId
		AND lmupload.id IN (SELECT ids FROM @uploadEntries) FOR XML PATH('lmODPFileUploadInfo'))
FROM @MonirotinPolicyData mp INNER JOIN LMUploadInfo upload WITH(NOLOCK)
ON mp.monitoringPolicyId = upload.monitoringpolicyId AND mp.uploadClientId = upload.clientId
DELETE FROM @uploadEntries
DECLARE @uploadXML XML
SET @uploadXML = (SELECT lmODPFileUploadInfo as uploads FROM @MonirotinPolicyData FOR XML PATH(''))
INSERT INTO @uploadEntries
SELECT  ISNULL(R.col.value('@id','INTEGER'),0)
FROM @uploadXML.nodes('uploads/lmODPFileUploadInfo') as R(col)
--Set the ids as indexing
UPDATE LMUploadInfo
SET flag = 2,modified = @now,attempt = attempt + 1
WHERE id in (SELECT ids FROM @uploadEntries)
--Set fail for files which are in upload incomplete state for more than 15 minutes by default
UPDATE LMUploadInfo
SET flag = 4,failureReason =7
Where flag = 0 AND ((@now - created)> @maxWaitForFileTransferCompleteInMinutes*60)
UPDATE mp
SET mp.nodesForCloud = (SELECT nodes.mangledHostName as '@managedHostName',
								nodes.nodeURL as '@nodeURL',
								nodes.clientId as '@clientId',
								nodes.clientName as '@clientName',
								nodes.type as '@type',
								nodes.basePort as '@baseport',
								nodes.hostName as '@hostname'
								FOR XML PATH ('cloudNodes') )
FROM @MonirotinPolicyData mp INNER JOIN @nodesForCloudTbl nodes
ON mp.cloudId = nodes.cloudId
--Once all the required data is collected now mark the MPs as processing
UPDATE APP_MonitoringPolicy
SET status = 2
WHERE monitorPolicyId IN (SELECT monitoringPolicyId FROM @MonirotinPolicyData WHERE monitoringPolicyType = 5)
MERGE APP_MonitoringPolicyProp as mpProp
USING (SELECT DISTINCT monitoringPolicyId FROM @MonirotinPolicyData ) as mpdata
ON mpprop.monitorPolicyId = mpdata.monitoringPolicyId AND mpprop.attrName = 'index start time'
WHEN MATCHED THEN UPDATE SET mpProp.attrVal = @now,mpprop.modified = @now
WHEN NOT MATCHED THEN
INSERT (monitorPolicyId,commcellId,attrName,attrType,attrVal,created,modified)
VALUES(mpdata.monitoringPolicyId,2,'index start time',7,@now,@now,@now);
/*Setting last update time is same as start time, This is to initialize the values.
If DB policy indexing is taking more than 15 min, client will update this property, this will help us to decide if we should retry the policy or not.*/
MERGE APP_MonitoringPolicyProp as mpProp
USING (SELECT DISTINCT monitoringPolicyId FROM @MonirotinPolicyData ) as mpdata
ON mpprop.monitorPolicyId = mpdata.monitoringPolicyId AND mpprop.attrName = 'Last Update Time For DB Policy'
WHEN MATCHED THEN UPDATE SET mpProp.attrVal = @now,mpprop.modified = @now
WHEN NOT MATCHED THEN
INSERT (monitorPolicyId,commcellId,attrName,attrType,attrVal,created,modified)
VALUES(mpdata.monitoringPolicyId,2,'Last Update Time For DB Policy',7,@now,@now,@now);
DECLARE @dontNotSleep INTEGER
SET @dontNotSleep = (CASE WHEN (SELECT COUNT(*)
FROM LMUploadInfo upload INNER JOIN @MonirotinPolicyData mpData ON mpData.monitoringPolicyId = upload.MonitoringPolicyId AND mpData.monitoringPolicyType = 4
	 WHERE upload.flag = 1) > 0 THEN 1 ELSE 0 END)
DECLARE @mpListXML XML
--SELECT * FROM @MonirotinPolicyData
DELETE FROM @MonirotinPolicyData WHERE lmODPFileUploadInfo IS NULL AND monitoringPolicyType = 4
--SETTING LMSCALE PROPERTIES START
	UPDATE policyData
	SET policyData.subClientId = ISNULL(CONVERT(INTEGER,mpprop.attrVal),0)
	FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
	WHERE mpprop.attrName = 'SubClient Id'
	update policyData
	set policyData.dumpLocation = subClientTbl.fileName
	from @MonirotinPolicyData policyData inner join APP_ScFilterFile subClientTbl
		ON policyData.subClientId = subClientTbl.componentNameId
	WHERE policyData.subClientId <> 0
	UPDATE policyData
	SET policyData.factor = ISNULL(mpprop.attrVal ,1) --default is day factor.
	FROM @MonirotinPolicyData policyData INNER JOIN APP_MonitoringPolicyProp mpprop
		ON policyData.monitoringPolicyId = mpprop.monitorPolicyId
	WHERE mpprop.attrName = 'Factor'
	UPDATE policyData
	SET policyData.requestedTimeInfo = ISNULL((
											SELECT reqTbl.StartTime AS '@startPeriod',
													reqTbl.EndTime AS '@endPeriod'
											FROM APP_LMCoreReqInfo reqTbl
											WHERE reqTbl.PolicyId = policyData.monitoringPolicyId
											FOR XML PATH('requestedTimeRange')
										),'')
	FROM @MonirotinPolicyData policyData
-- SETTING LMSCALE PROPERTIES END
SET @mpListXML = (SELECT
	monitoringPolicyId as 'monitoringPolicy/@monitoringPolicyid',
	monitoringPolicyName as 'monitoringPolicy/@monitoringPolicyName',
	factor as 'monitoringPolicy/@factor',
	subClientId as 'monitoringPolicy/@subClientId',
	dumpLocation as 'monitoringPolicy/@dumpLocation',
	requestedTimeInfo as 'monitoringPolicy/node()',
	monitoringPolicyType as 'monitoringPolicy/monitoringTypes/@val',
	CONVERT(NVARCHAR(max),TemplateXML) as 'monitoringPolicy/LMTemplatesXml/@LMTemplateXML',
	(SELECT templateForMonitoringType FROM APP_Template WHERE templateId = data.templateId) as 'monitoringPolicy/LMTemplatesXml/@templateForMonitoringType',
	templateId as 'monitoringPolicy/LMTemplatesXml/LMTemplateEntity/@templateId',
	templateName as 'monitoringPolicy/LMTemplatesXml/LMTemplateEntity/@templateName',
	associations as 'monitoringPolicy/node()',
	ISNULL(lastDatarRowIndx,0) as 'dataSetInfo/@lastDataRowIndex',
	cloudId as 'cloudInfo/@cloudId',
	cloudName as 'cloudInfo/@cloudName',
	isSyslogEnabled as 'cloudInfo/@isSyslogEnabled',
	syslogHostnameAndPort as 'cloudInfo/@syslogHostnameAndPort',
	nodesForCloud as 'cloudInfo/node()',
	lmODPFileUploadInfo as 'node()'
 FROM @MonirotinPolicyData data
 FOR XML PATH('MonitoringPolicyPropsList'))
 SET @xmlStr = (SELECT @dontNotSleep as '@dontSleepTheThread',
						@mpListXML as 'node()' FOR XML PATH('LogMonitoring_GetMonitoringPolicyPropsResponse'))
 SELECT @xmlStr
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @xmlStr = '<LogMonitoring_GetMonitoringPolicyPropsResponse/>'
SELECT @xmlStr
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetPoliciesToProcess')
	delete from GxQscripts where name = 'LMGetPoliciesToProcess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetPoliciesToProcess')
	delete from GXDBVersions where aliasname = 'LMGetPoliciesToProcess'
GO

insert into GXDBVersions values(2, 'LMGetPoliciesToProcess',  '00010013004000090000', 'LMGetPoliciesToProcess', '00010013004000090000')
GO

