

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetNASClientsForPolicy.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetNASClientsForPolicy <<<'

IF EXISTS (select * from sysobjects where name='LMGetNASClientsForPolicy')
	drop procedure LMGetNASClientsForPolicy
IF EXISTS (select * from GxQscripts where name='LMGetNASClientsForPolicy')
	delete from GxQscripts where name = 'LMGetNASClientsForPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetNASClientsForPolicy')
	delete from GXDBVersions where aliasname = 'LMGetNASClientsForPolicy'
GO
print '... Creating Procedure: LMGetNASClientsForPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure LMGetNASClientsForPolicy
  @monitoringPolicyId int,
  @commcellId int
AS
declare @NasClients table (NASClientId integer,NASClientName nvarchar(MAX))
declare @AllNASClients table (clientId integer,clientName nvarchar(MAX))
declare @ExcludedClients table (clientId integer)
insert into @AllNASClients(clientId, clientName)
	select client.id, client.name from App_Client client with (NOLOCK)
where client.status & 0x0080 = 0x0080
and client.status & 0x00002  = 0
insert into @ExcludedClients
select clientId from APP_MonitorAssocEntity where monitorPolicyId=@monitoringPolicyId and commcellId=@commcellId  and exclude=1 and flags=3
--if all clients are selected, get non excluded nas clients
if exists(select 1 from APP_MonitorAssocEntity with (NOLOCK) where flags=2 and monitorpolicyid=@monitoringpolicyid and commcellId=@commcellId)
	begin
		insert into @NasClients(NASClientId,NASClientName)
			select allNAS.clientId,allNAS.clientName
			from @AllNASClients allNAS left join @ExcludedClients excluded on allNAS.clientId=excluded.clientId
			where excluded.clientId is NULL
	end
else
	begin
	--get list of selected NAS clients
	insert into @NasClients(NASClientId,NASClientName)
		select allNAS.clientId,allNAS.clientName from @AllNASClients allNAS
		inner join APP_MonitorAssocEntity assocEntity with (NOLOCK) on allNAS.clientId=assocEntity.clientId
		where assocEntity.flags=3 and assocEntity.exclude=0 and
		assocEntity.monitorPolicyId=@monitoringpolicyid and assocEntity.commcellId=@commcellId
   --get list of NASclients selected through clientGroup
   insert into @NasClients(NASClientId,NASClientName)
        select allNAS.clientId,allNAS.clientName from @AllNASClients allNAS
		inner join APP_ClientGroupAssoc cgAssoc with (NOLOCK) on cgAssoc.clientId=allNAS.clientId
		inner join APP_MonitorAssocEntity assocEntity with (NOLOCK) on assocEntity.clientGroupId=cgAssoc.clientGroupId
		where assocEntity.flags=28 and assocEntity.exclude=0 and
		assocEntity.monitorPolicyId=@monitoringpolicyid and assocEntity.commcellId=@commcellId
	end
--fill it in xml
select 1 as TAG,
       NULL as Parent,
	   NULL as [SysMonNasContent!1!],
	   NULL as [nasClients!2!clientId],
	   NULL as [nasClients!2!clientName],
	   NULL as [nasClients!2!_type_]
UNION ALL
select distinct 2, 1, NULL, NASClientId, NASClientName, 3
from @NasClients
for xml explicit
/*
  Sample output
<SysMonNasContent>
  <nasClients clientId="11" clientName="avocado" _type_="3" />
  <nasClients clientId="12" clientName="172.19.123.36" _type_="3" />
</SysMonNasContent>
*/

IF EXISTS (select * from GxQscripts where name = 'LMGetNASClientsForPolicy')
	delete from GxQscripts where name = 'LMGetNASClientsForPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetNASClientsForPolicy')
	delete from GXDBVersions where aliasname = 'LMGetNASClientsForPolicy'
GO

insert into GXDBVersions values(2, 'LMGetNASClientsForPolicy',  '00000000000000000000', 'LMGetNASClientsForPolicy', '00000000000000000000')
GO

