

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Divakar
--	Date:   09/01/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetMonitoringPolicy.sp,v $ $Id: LMGetMonitoringPolicy.sp,v 1.8.12.11 2018/10/31 07:03:06 syadav Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMGetMonitoringPolicy')
BEGIN
	print '>>> Drop Stored Procedure: LMGetMonitoringPolicy <<<'
	drop procedure LMGetMonitoringPolicy
END
IF EXISTS (select * from GxQscripts where name='LMGetMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetMonitoringPolicy'
GO
print '... Creating Procedure: LMGetMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetMonitoringPolicy
  @userid INTEGER,
  @inputxml_req XML,
  @o_xmlMsg XML OUTPUT
AS
BEGIN
SET NOCOUNT ON
DECLARE @returnOnlyDeleteMP INTEGER = ISNULL(( SELECT ref.value('@returnOnlyDeleteMP','INTEGER') AS data FROM @inputxml_req.nodes('LogMonitoring_GetMonitoringPoliciesListReq') R(ref)),0)
DECLARE @flag INTEGER = ISNULL(( SELECT ref.value('@flag','INTEGER') AS data  FROM @inputxml_req.nodes('LogMonitoring_GetMonitoringPoliciesListReq') R(ref)),0)
DECLARE @lmAppType INTEGER = ISNULL(( SELECT ref.value('@appType','INTEGER') AS data  FROM @inputxml_req.nodes('LogMonitoring_GetMonitoringPoliciesListReq') R(ref)),0)
DECLARE @monType INTEGER = ISNULL(( SELECT ref.value('@monType','INTEGER') AS data  FROM @inputxml_req.nodes('LogMonitoring_GetMonitoringPoliciesListReq') R(ref)),0)
DECLARE @reportId INTEGER = ISNULL(( SELECT ref.value('@reportId','INTEGER') AS data  FROM @inputxml_req.nodes('LogMonitoring_GetMonitoringPoliciesListReq') R(ref)),0)
IF object_id('tempdb.dbo.#mpClientAssoc') IS NOT NULL
BEGIN
	DROP TABLE #mpClientAssoc
END
CREATE TABLE #mpClientAssoc (id INTEGER,mpid INTEGER,clientId INTEGER)
DECLARE @permissionId INTEGER = 110
IF (@returnOnlyDeleteMP = 1)
BEGIN
SET @permissionId = 111
END
declare @MonitoringTypesForAppType table
(
	monitoringType int
)
IF @monType IS NOT NULL AND  @monType > 0
BEGIN
Insert into @MonitoringTypesForAppType
SELECT @monType
END
ELSE
BEGIN
	Insert into @MonitoringTypesForAppType
	select * from dbo.LMGetMonitoringTypesForAppType(@lmAppType)
END
DECLARE @MonirotinPolicyData TABLE (
	monitoringPolicyId INTEGER,
	monitoringPolicyType INTEGER,
	monitoringPolicyname NVARCHAR(1024),
	status INTEGER,
	associations XML
)
--can see all
if object_id('tempdb.dbo.#LMMonitoringPolicyObject') is not null
begin
       drop table #LMMonitoringPolicyObject
end
CREATE TABLE #LMMonitoringPolicyObject (logMonitoringPolicyId int)
-- this will return CS where user has execute/delete permission.
EXEC sec_getNonIdaObjectsForThisUser @userId, 1, @permissionId, '#LMMonitoringPolicyObject',1
DECLARE @canSeeAll INTEGER = ISNULL((select 1 from #LMMonitoringPolicyObject where logMonitoringPolicyId = 2),0)
--now that we found out weather user can see/operate all, we will use same table to get monitoring policy ids
DELETE FROM #LMMonitoringPolicyObject
 IF (@canSeeAll=1)
  BEGIN
	insert into #LMMonitoringPolicyObject(logMonitoringPolicyId)
	select APP_MonitoringPolicy.monitorPolicyId
	from APP_MonitoringPolicy
	where APP_MonitoringPolicy.status <> 3
  END
  ELSE
  BEGIN
	--now get list of monitoring policy entityes where user has execute/delete permission.
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, @permissionId, '#LMMonitoringPolicyObject'
  END
 -- Also delete from visible policies all policies of incorrect appType
 delete LMMonitoringPolicyObject
 from #LMMonitoringPolicyObject LMMonitoringPolicyObject
 inner join APP_MonitoringPolicyProp mpProp
 ON LMMonitoringPolicyObject.logMonitoringPolicyId = mpProp.monitorPolicyId AND
 mpProp.attrName = 'Monitoring Type'
 left join @MonitoringTypesForAppType MonitoringTypesForAppType
 on mpProp.attrVal=MonitoringTypesForAppType.monitoringType
 where MonitoringTypesForAppType.monitoringType is null
 DECLARE @outPut XML
 IF @flag = 3 AND @reportId > 0   -- This is for user to be able to execute report without having policy permission.
 BEGIN
	Declare @hasRights int
EXEC sec_checkPermissionOnEntity @userId, 132, @hasRights OUTPUT, 131, @reportId
	-- During report execution we do policy name(data set source) to id conversion.
	IF @hasRights > 0
	BEGIN
		INSERT INTO @MonirotinPolicyData(monitoringPolicyId,monitoringPolicyname,status,monitoringPolicyType)
		SELECT DISTINCT MonPolicy.monitorPolicyId ,MonPolicy.MonitorPolicyName ,MonPolicy.status,mpProp.attrVal
			FROM APP_MonitoringPolicy MonPolicy
				INNER JOIN APP_MonitoringPolicyProp mpProp
						ON MonPolicy.monitorPolicyId = mpProp.monitorPolicyId AND
							mpProp.attrName = 'Monitoring Type'
		WHERE	MonPolicy.status <> 3
	END
 END
 ELSE
 BEGIN
	INSERT INTO @MonirotinPolicyData(monitoringPolicyId,monitoringPolicyname,status,monitoringPolicyType)
	SELECT DISTINCT MonPolicy.monitorPolicyId ,MonPolicy.MonitorPolicyName ,MonPolicy.status,mpProp.attrVal
		FROM APP_MonitoringPolicy MonPolicy INNER JOIN #LMMonitoringPolicyObject MonPolicyObject
					ON MonPolicy.monitorPolicyId = MonPolicyObject.logMonitoringPolicyId INNER JOIN APP_MonitoringPolicyProp mpProp
												ON MonPolicyObject.logMonitoringPolicyId = mpProp.monitorPolicyId AND
													mpProp.attrName = 'Monitoring Type'
 END
 IF @flag = 2
 BEGIN
	 	-- '<LogMonitoring_GetMonitoringPoliciesListReq appType="1" flag="2" />' , If appType is sent , associations should not be deleted.
		 -- THis procedure is called from lmgetcloudandmonitoringpolicyLIst with above xml . so this proc should send monitoring policy and associaton of ODP
		IF(@lmAppType = 0)
		BEGIN
			DELETE FROM @MonirotinPolicyData WHERE monitoringPolicyType <> 4
			UPDATE @MonirotinPolicyData
			SET monitoringPolicyType = 4
		END
	--take cleint level associations
	INSERT INTO #mpClientAssoc
	select mpassoc.monitorAssocId,mp.monitorPolicyId,mpassoc.clientId
	from APP_MonitoringPolicy mp INNER JOIN APP_MonitorAssocEntity mpassoc
		ON mp.monitorPolicyId = mpassoc.monitorPolicyId
		WHERE mpassoc.flags = 3 and mpassoc.exclude=0
	-- take all cleint association
	INSERT INTO #mpClientAssoc
	select mpassoc.monitorAssocId,mp.monitorPolicyId,cl.id
	from APP_MonitoringPolicy mp INNER JOIN APP_MonitorAssocEntity mpassoc
		ON mp.monitorPolicyId = mpassoc.monitorPolicyId	AND mpassoc.flags = 2
		 INNER JOIN APp_Client cl ON cl.id > 1 AND cl.releaseId >= 15 AND (cl.specialClientFlags&2) <> 2 AND (cl.status&2) <>2
	--take group level association
	INSERT INTO #mpClientAssoc
	select mpassoc.monitorAssocId,mp.monitorPolicyId,cgassoc.clientId
	from APP_MonitoringPolicy mp INNER JOIN APP_MonitorAssocEntity mpassoc
		ON mp.monitorPolicyId = mpassoc.monitorPolicyId	AND mpassoc.flags = 28
		 INNER JOIN APP_ClientGroupAssoc cgassoc
			ON cgassoc.clientGroupId = mpassoc.clientGroupId
	MERGE #mpClientAssoc as mpcs
	USING (select DISTINCT mp.monitorPolicyId,mpassoc.clientId
	from APP_MonitoringPolicy mp INNER JOIN APP_MonitorAssocEntity mpassoc
		ON mp.monitorPolicyId = mpassoc.monitorPolicyId
		WHERE mpassoc.flags = 3 and mpassoc.exclude=1) as mpt
	ON mpt.monitorPolicyId = mpcs.mpid AND mpt.clientId = mpcs.clientId
	WHEN MATCHED THEN DELETE;
	--remove the duplicates
	DELETE  FROM #mpClientAssoc
	WHERE id NOT IN(    SELECT MAX(id)  FROM #mpClientAssoc GROUP BY mpid,clientId)
	DECLARE @mpsAssoc TABLE(mpAssocId INTEGER, mpId INTEGER, assoc XML)
	--UPDATE ASSOCIATION
	MERGE @mpsAssoc as mptable
	USING
	(SELECT assoc.id,assoc.mpid,
		(
			SELECT 3 as '@_type_',assoc.clientId as '@clientId',
			(SELECT name FROM APP_Client with (nolock) WHERE id = assoc.clientId) as '@clientName'
			FOR XML PATH('associations')
		)as NodesXML
	 FROM #mpClientAssoc assoc
	) as nodesTable
	ON mptable.mpId = nodesTable.mpid AND mptable.mpAssocId = nodesTable.id
	WHEN MATCHED THEN UPDATE SET mptable.assoc = nodesTable.NodesXML
	WHEN NOT MATCHED THEN
	INSERT (mpAssocId,mpId,assoc)
	VALUES(nodesTable.id,nodesTable.mpId,nodesTable.NodesXML);
	UPDATE mpData
	SET mpData.associations = ass.assoc
	FROM @mpsAssoc ass INNER JOIN @MonirotinPolicyData mpData
		ON ass.mpId = mpData.monitoringPolicyId
	SET @outPut = (SELECT MonPolicy.monitoringPolicyId as '@monitoringPolicyid',
									MonPolicy.monitoringPolicyname as '@monitoringPolicyName',
									(CASE MonPolicy.status WHEN 1 THEN 1 ELSE 0 END) as '@disabled',
									MonPolicy.monitoringPolicyType as 'monitoringTypes/@val',
									MonPolicy.associations as 'node()'
		FROM @MonirotinPolicyData MonPolicy INNER JOIN #LMMonitoringPolicyObject MonPolicyObject
					ON MonPolicy.monitoringPolicyId = MonPolicyObject.logMonitoringPolicyId
		ORDER BY MonPolicy.monitoringPolicyname
					FOR XML PATH('monitoringPolicies'))
 END
 ELSE IF @flag = 3    -- We will not send upload policy with this flag
 BEGIN
	DELETE M
	FROM @MonirotinPolicyData M, APP_MonitoringPolicyProp AP WITH(NOLOCK)
	WHERE M.monitoringPolicyId = AP.monitorPolicyId
		AND AP.attrName = N'Monitoring Type'
		AND CONVERT(INT,AP.attrVal) = 4
	SET @outPut = (SELECT MonPolicy.monitoringPolicyId as '@monitoringPolicyid',
								MonPolicy.monitoringPolicyname as '@monitoringPolicyName',
								(CASE MonPolicy.status WHEN 1 THEN 1 ELSE 0 END) as '@disabled',
								MonPolicy.monitoringPolicyType as 'monitoringTypes/@val'
	FROM @MonirotinPolicyData MonPolicy
	ORDER BY MonPolicy.monitoringPolicyname
					FOR XML PATH('monitoringPolicies'))
 END
 ELSE IF @flag = 10    --This is used for GxTail purpose, in this we will send the first commvault logs template policy id
 BEGIN
  --Delete all policies which is not of type Text logs
	DELETE M
	FROM @MonirotinPolicyData M, APP_MonitoringPolicyProp AP WITH(NOLOCK)
	WHERE M.monitoringPolicyId = AP.monitorPolicyId
		AND AP.attrName = N'Monitoring Type'
		AND CONVERT(INT,AP.attrVal) <> 0
	DELETE M
	FROM @MonirotinPolicyData M , APP_MonitorTemplateAssoc AMT WITH(NOLOCK)
	WHERE M.monitoringPolicyId = AMT.monitorPolicyId
		AND AMT.templateId <> 1
	DELETE M
	FROM @MonirotinPolicyData M
	WHERE M.monitoringPolicyId <> ( SELECT TOP(1) monitoringPolicyId FROM @MonirotinPolicyData ORDER BY monitoringPolicyId )
	SET @outPut = (SELECT MonPolicy.monitoringPolicyId as '@monitoringPolicyid',
								MonPolicy.monitoringPolicyname as '@monitoringPolicyName',
								(CASE MonPolicy.status WHEN 1 THEN 1 ELSE 0 END) as '@disabled',
								MonPolicy.monitoringPolicyType as 'monitoringTypes/@val'
	FROM @MonirotinPolicyData MonPolicy INNER JOIN #LMMonitoringPolicyObject MonPolicyObject
				ON MonPolicy.monitoringPolicyId = MonPolicyObject.logMonitoringPolicyId
	ORDER BY MonPolicy.monitoringPolicyname
					FOR XML PATH('monitoringPolicies'))
 END
 ELSE
 BEGIN
	SET @outPut = (SELECT MonPolicy.monitoringPolicyId as '@monitoringPolicyid',
								MonPolicy.monitoringPolicyname as '@monitoringPolicyName',
								(CASE MonPolicy.status WHEN 1 THEN 1 ELSE 0 END) as '@disabled',
								MonPolicy.monitoringPolicyType as 'monitoringTypes/@val'
		FROM @MonirotinPolicyData MonPolicy INNER JOIN #LMMonitoringPolicyObject MonPolicyObject
				ON MonPolicy.monitoringPolicyId = MonPolicyObject.logMonitoringPolicyId
		ORDER BY MonPolicy.monitoringPolicyname
					FOR XML PATH('monitoringPolicies'))
 END
 SET @o_xmlMsg = (SELECT @canSeeAll as '@canSeeAllPolicy', @outPut as 'node()' FOR XML PATH('LogMonitoring_GetMonitoringPoliciesListResp') )
SET NOCOUNT OFF
 END

IF EXISTS (select * from GxQscripts where name = 'LMGetMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'LMGetMonitoringPolicy',  '00010008001200110000', 'LMGetMonitoringPolicy', '00010008001200110000')
GO

