

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetGlobalMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetGlobalMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='LMGetGlobalMonitoringPolicy')
	drop procedure LMGetGlobalMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='LMGetGlobalMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetGlobalMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetGlobalMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetGlobalMonitoringPolicy'
GO
print '... Creating Procedure: LMGetGlobalMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetGlobalMonitoringPolicy
  @userId INT, 
  @o_xmlMsg XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @monitoringPolicyIdList TABLE (monitoringPolicyId INT, name NVARCHAR(MAX))
DECLARE @errorCode  INT
DECLARE @errorString NVARCHAR(MAX)
DECLARE @errorXML XML
DECLARE @xmlQuery  XML
INSERT @monitoringPolicyIdList
SELECT M.MonitorPolicyId, M.MonitorPolicyName
FROM APP_MonitoringPolicy M WITH (NOLOCK) , APP_MonitoringPolicyProp P WITH (NOLOCK)
WHERE M.MonitorPolicyId = P.MonitorPolicyId
	AND P.attrName ='Monitoring Type'
	AND P.attrVal = '7'
	AND M.status = 0
--First let us see if we have got the permissions on commcell level.
IF OBJECT_ID('tempdb.dbo.#commcellLevelAssociations') IS NOT NULL DROP TABLE #commcellLevelAssociations
CREATE TABLE #commcellLevelAssociations (permissionId INT)
EXEC sec_getPermissionsOnEntity '#commcellLevelAssociations', @userId, 1, 2
IF EXISTS (SELECT 1
			FROM #commcellLevelAssociations
WHERE permissionId IN (31, 110))
	GOTO SECURITYCHECKDONE
IF OBJECT_ID('tempdb.dbo.#MonitoringPolicyList') IS NOT NULL DROP TABLE #MonitoringPolicyList
CREATE TABLE #MonitoringPolicyList (monitoringPolicyId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 90, 110, '#MonitoringPolicyList'
DELETE monitoringPolicyTBL
FROM @monitoringPolicyIdList monitoringPolicyTBL
WHERE monitoringPolicyId NOT IN (SELECT  monitoringPolicyId
									FROM #MonitoringPolicyList)
SECURITYCHECKDONE:
  SET @xmlQuery =(  SELECT DISTINCT monitoringPolicyId as '@monitoringPolicyid',
                      name as '@monitoringPolicyName'
					  FROM @monitoringPolicyIdList
						FOR XML PATH ('monitoringPolicies'),TYPE)
  SET @errorXML=(SELECT '' as '@errorString',  0 as '@errorCode'FOR XML PATH('error'))
  SET @o_xmlMsg =(SELECT @xmlQuery ,
                         @errorXML FOR XML PATH ('')
                        ,ROOT('LogMonitoring_GetMonitoringPolicyResponse'))
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetGlobalMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetGlobalMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetGlobalMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetGlobalMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'LMGetGlobalMonitoringPolicy',  '00000000000000000000', 'LMGetGlobalMonitoringPolicy', '00000000000000000000')
GO

