

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetEventViewerDataSetForCI.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetEventViewerDataSetForCI.sp,v $ $Id: LMGetEventViewerDataSetForCI.sp,v 1.7.2.4 2019/05/22 12:01:15 kvinayak Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMGetEventViewerDataSetForCI')
BEGIN
	print '>>> Drop Stored Procedure: LMGetEventViewerDataSetForCI <<<'
	drop procedure LMGetEventViewerDataSetForCI
END
IF EXISTS (select * from GxQscripts where name='LMGetEventViewerDataSetForCI')
	delete from GxQscripts where name = 'LMGetEventViewerDataSetForCI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetEventViewerDataSetForCI')
	delete from GXDBVersions where aliasname = 'LMGetEventViewerDataSetForCI'
GO
print '... Creating Procedure: LMGetEventViewerDataSetForCI'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetEventViewerDataSetForCI
  @i_xml XML 
AS
  DECLARE @xmlStr xml
SET NOCOUNT ON
DECLARE @startIndex INTEGER = ISNULL((SELECT ref.value('@startIndex','INTEGER') AS data FROM @i_xml.nodes('LogMonitoring_GenerateDataSetForCI') R ( ref )),0)
DECLARE @endIndex INTEGER = ISNULL((SELECT ref.value('@endIndex','INTEGER') AS data FROM @i_xml.nodes('LogMonitoring_GenerateDataSetForCI') R ( ref )),1000)
DECLARE @monitoringPolicyId INTEGER = ISNULL((SELECT ref.value('@monitoringPolicyId','INTEGER') AS data FROM @i_xml.nodes('LogMonitoring_GenerateDataSetForCI') R ( ref )),0)
DECLARE @requestType INTEGER = ISNULL((SELECT ref.value('@type','INTEGER') AS data FROM @i_xml.nodes('LogMonitoring_GenerateDataSetForCI') R ( ref )),0)
DECLARE @templateId INTEGER
SET @templateId = ISNULL((SELECT templateId FROM APP_MonitorTemplateAssoc WHERE monitorPolicyId = @monitoringPolicyId),0)
DECLARE @count INTEGER
SET @count = ISNULL((SELECT TOP 1 value FROM GxGlobalParam WHERE name like 'LMEventViewerIndexBucket' AND modified = 0),1000)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
DECLARE @startFromTime INTEGER = 0
DECLARE @now INTEGER = dbo.GEtUnixTime(GetUTCdate())
SET @startFromTime = ISNULL((SELECT modified FROM APP_MonitoringPolicyProp WHERE attrName = 'Do not monitor old data' AND attrVal = 1 AND monitorPolicyId = @monitoringPolicyId ),0)
DECLARE @minId INTEGER
DECLARE @maxId INTEGER
SET @minId = (SELECT MIN(id) FROM evMsg WHERE timeServer > @startFromTime AND id > @startIndex AND type <> 2)
SET @maxId = ISNULL((SELECT MAX(TopCount.id) FROM
							 (SELECT DISTINCT TOP (@count) id FROM evMsg WHERE id >= @minId AND type <> 2) as TopCount
									),0)
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID('tempdb.dbo.#testEventTable'))         DROP TABLE tempdb.dbo.#testEventTable
IF EXISTS(SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID('tempdb.dbo.#ColumnRowFinal'))         DROP TABLE tempdb.dbo.#ColumnRowFinal
DECLARE @ColumnRow TABLE
(columnid INTEGER,
	rowId INTEGER,
columnName NVARCHAR(128),
columnXML XML)
CREATE TABLE #ColumnRowFinal
(columnid INTEGER,
	rowId INTEGER,
columnName NVARCHAR(128),
columnXML XML,
columnData NVARCHAR(max),
ColAndData XML)
CREATE CLUSTERED INDEX ColumnRowFinal_rowId_idx ON #ColumnRowFinal (rowid)
DECLARE @templ XML = CONVERT(XML,(SELECT templateXML FROM APP_Template WHERE templateId = @templateId))
DECLARE @minColId INTEGER = (SELECT MIN(columnId) FROM APP_TemplateColumn WHERE templateId = @templateId)
INSERT INTO @ColumnRow(columnid,columnXML)
SELECT R.col.value('@index','INTEGER') as colIndex,
		R.col.query('.')
FROM
@templ.nodes('LogMonitoring_TemplateXML/columns') as R(col)
UPDATE ColumnDataTemp
SET ColumnDataTemp.columnName = tempCol.columnName
FROM @ColumnRow ColumnDataTemp INNER JOIN APP_TemplateColumn tempCol
	ON ColumnDataTemp.columnid = (tempCol.columnId - @minColId) AND templateId = @templateId
DECLARE @templateColumns TABLE (colindex INTEGER,columnid INTEGER,ColumnName NVARCHAR(MAX), DataType INTEGER) DECLARE @templateXML XML DECLARE @colindex INTEGER DECLARE @userColName INTEGER DECLARE @columnid INTEGER DECLARE @ColumnName NVARCHAR(MAX) DECLARE @DataType INTEGER DECLARE @tableName NVARCHAR(1024) DECLARE @cursorName NVARCHAR(1024) DECLARE @colName NVARCHAR(1024)DECLARE @query NVARCHAR(MAX)
SET @templateXML = CONVERT(XML,(SELECT templateXML FROM APP_Template WHERE templateId = @templateId)) INSERT INTO @templateColumns SELECT ref.value('@index','INTEGER'), 0, ref.value('@columnName','NVARCHAR(1024)'), ref.value('@primaryDataType','INTEGER') FROM @templateXML.nodes('LogMonitoring_TemplateXML/columns') R(ref) SET @userColName = 0 SET @tableName  = '#testEventTable' SET @cursorName = 'testEventTableCur' IF object_id('tempdb.dbo.'+@tableName) IS NOT NULL DROP TABLE #testEventTable CREATE TABLE #testEventTable (column0 INTEGER) IF ( CURSOR_STATUS('global', @cursorName) >= 0 OR CURSOR_STATUS('local', @cursorName) >= 0 ) CLOSE testEventTableCur IF ( CURSOR_STATUS('global',@cursorName) = -1 OR CURSOR_STATUS('local',@cursorName) = -1 ) DEALLOCATE testEventTableCur DECLARE testEventTableCur CURSOR FOR SELECT colindex,columnid,ColumnName,DataType FROM @templateColumns WHERE colindex > 0 ORDER BY colindex OPEN testEventTableCur FETCH NEXT FROM testEventTableCur INTO @colindex,@columnid,@ColumnName,@DataType WHILE @@FETCH_STATUS = 0 BEGIN SET @colName = (CASE @userColName WHEN 1 THEN @ColumnName WHEN 0 THEN 'column'+ CONVERT(NVARCHAR(20),@colindex) END) SET @query  =  'ALTER TABLE '+@tableName+' ADD '+@colName+ ' ' + (CASE @DataType WHEN 0 THEN 'INTEGER' WHEN 1 THEN 'NVARCHAR(MAX)' ELSE 'NVARCHAR(MAX)' END) EXECUTE sp_executesql @query FETCH NEXT FROM testEventTableCur INTO @colindex,@columnid,@ColumnName,@DataType END IF ( CURSOR_STATUS('global', @cursorName) >= 0 OR CURSOR_STATUS('local', @cursorName) >= 0 ) CLOSE testEventTableCur IF ( CURSOR_STATUS('global',@cursorName) = -1 OR CURSOR_STATUS('local',@cursorName) = -1 )    DEALLOCATE testEventTableCur
CREATE UNIQUE CLUSTERED INDEX testEventTable_column0_idx ON #testEventTable (column0)
DECLARE @eventIDs TABLE(events INTEGER)
INSERT INTO @eventIDs
SELECT id FROM evMsg with (nolock)
WHERE (type <> 2) AND commcellid = 2 AND id >= @minId AND id <= @maxId
IF @requestType = 0
BEGIN
	INSERT INTO #testEventTable
	SELECT
	 id ,
	 timeSource,
	 timeSource,
	 severity ,
	 jobId_l ,
	 commCellID,
	 CommCell  ,
	 clientID  ,
	 Client  ,
	 CONVERT(NVARCHAR(128),(CASE WHEN (messageId & POWER(2,17)) <> 0 THEN	(messageId / (POWER(2,18)) & 0xFFFF)
									ELSE (messageId / (POWER(2,24)) & 0xFF) END)) + ':' + CONVERT(NVARCHAR(MAX),(messageId & 0x7FFF)) AS eventCode,
	 userID,
	 UserName ,
	 libraryId ,
	 libraryName,
	 maClientId ,
	 mediaAgentName ,
	 mediaId ,
	 mediaBarCode ,
	 driveId ,
	 driveName ,
	 subsystem ,
	 msgEnglish
	  FROM
			(SELECT TOP (@count) id,messageId as messageId ,timeSource as timeSource,
				 dbo.GetEventSeverityString(severity,0) as severity,
				 (CASE jobId_l WHEN 0 THEN '' ELSE CONVERT(nvarchar(32),jobId_l) END) as jobId_l,
				 commCellID,
				 (CASE commCellId WHEN 0 THEN '' ELSE ISNULL(dbo.GetCommCellNameFromId(commCellID),'Not Available') END) as CommCell,
				 clientID,
				 (CASE clientID WHEN 0 THEN '' ELSE ISNULL(dbo.GetClientName(clientid),'Not Available') END )  as Client,
				 userID,
				 (CASE UserID WHEN 0 THEN '' ELSE ISNULL(dbo.GetUserName(userid),'Not Available')END) as UserName,
				 libraryId,
				 (CASE libraryId WHEN 0 THEN '' ELSE ISNULL(dbo.GetLibraryAliasName(libraryId),'Not Available') END) as libraryName,
				 maClientId,
				 (CASE  maClientId WHEN 0 THEN  '' ELSE ISNULL(dbo.GetClientName(maClientId),'Not Available') END) as mediaAgentName,
				 mediaId,
				 (CASE mediaId WHEN 0 THEN '' ELSE ISNULL(dbo.GetMediaBarCode(mediaId),'Not Available') END)as mediaBarCode,
				 driveId ,
				 (CASE driveId WHEN 0 THEN '' ELSE ISNULL(dbo.GetDriveAliasName(driveId),'Not Available') END) as driveName,
				  subsystem,
				 dbo.EncodeInvalidXMLChar(DBO.fn_EvFormatEventMsgText(id,0,messageId,1,2)) as msgEnglish
			FROM evMsg with (nolock)
			WHERE (type <> 2 AND commcellid = 2
			--and (dbo.isVisible(1, jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0)
			and id >= @minId AND id <= @maxId) ) A
		ORDER BY id ASC
	INSERT INTO #ColumnRowFinal
	SELECT ColRow.columnid,ids.column0,ColRow.columnName,ColRow.columnXML,'',NULL
	FROM @ColumnRow ColRow,#testEventTable ids
	DECLARE @columnCount INTEGER =  (SELECT COUNT(*) FROM APP_TemplateColumn WHERE templateId = @templateId)
	DECLARE @i INTEGER = 0
	WHILE @i < @columnCount
	BEGIN
	DECLARE @queryUpdate NVARCHAR(MAX) =  'UPDATE colFinal
										SET colFinal.columnData = rowLm.column'+ CONVERT(NVARCHAR(128),@i)+
									'  FROM #ColumnRowFinal colFinal INNER JOIN #testEventTable rowLm
									ON colFinal.rowId = rowLm.column0 AND colFinal.columnid = '+CONVERT(NVARCHAR(20),@i)
	--print @queryUpdate
	EXECUTE sp_executesql @queryUpdate
	SET @i = @i + 1
	END
	UPDATE #ColumnRowFinal
	SET ColAndData = ( SELECT columnData as '@dataAsWString', columnXML as 'node()' FOR XML PATH('rowColumn'))
	DECLARE @rowColumnWiseFinal TABLE(id INTEGER,ColumnList XML)
	INSERT INTO @rowColumnWiseFinal
	SELECT
	  rowId,(SELECT columnData as '@dataAsWString',columnXML as 'node()'
		FROM #ColumnRowFinal
		WHERE rowId = Result.rowId
		FOR XML PATH ('rowColumn'))
	FROM #ColumnRowFinal Result
	GROUP BY rowId
	SET @xmlStr = ISNULL((SELECT ColumnList as 'node()'
	FROM @rowColumnWiseFinal
	ORDER BY id
	FOR XML PATH('rows'),ROOT('LogMonitoring_DataSetRowsWithRowAsColumnList')),'<LogMonitoring_DataSetRowsWithRowAsColumnList/>')
END
ELSE IF @requestType = 1
BEGIN
	IF (SELECT COUNT(*) FROM @eventIDs) >= 1
		SET @xmlStr = (SELECT 0 as '@errorCode' FOR XML PATH('App_GenericResp'))
	ELSE
		SET @xmlStr = (SELECT 1 as '@errorCode' FOR XML PATH('App_GenericResp'))
END
SELECT @xmlStr
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetEventViewerDataSetForCI')
	delete from GxQscripts where name = 'LMGetEventViewerDataSetForCI'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetEventViewerDataSetForCI')
	delete from GXDBVersions where aliasname = 'LMGetEventViewerDataSetForCI'
GO

insert into GXDBVersions values(2, 'LMGetEventViewerDataSetForCI',  '00010007000200040000', 'LMGetEventViewerDataSetForCI', '00010007000200040000')
GO

