

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetEnableMonitoringPolicyForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Seema Aggarwal
--	Date:   10/11/2012
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetEnableMonitoringPolicyForClient <<<'

IF EXISTS (select * from sysobjects where name='LMGetEnableMonitoringPolicyForClient')
	drop procedure LMGetEnableMonitoringPolicyForClient
IF EXISTS (select * from GxQscripts where name='LMGetEnableMonitoringPolicyForClient')
	delete from GxQscripts where name = 'LMGetEnableMonitoringPolicyForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetEnableMonitoringPolicyForClient')
	delete from GXDBVersions where aliasname = 'LMGetEnableMonitoringPolicyForClient'
GO
print '... Creating Procedure: LMGetEnableMonitoringPolicyForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetEnableMonitoringPolicyForClient
  @iClientId INT, 
  @isLogMonitoringType INT,
  @filterConitnous INT=1,
  @o_MonitoringPolicy INT=0 OUTPUT ,
  @outputTableName VARCHAR(256) ='',
  @isReturn INT =0
AS
  DECLARE @monitorPolicyId integer
  DECLARE @status integer
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 IF OBJECT_ID('tempdb.dbo.#monitoringPolicy') IS NOT NULL
        DROP TABLE #monitoringPolicy
CREATE TABLE #monitoringPolicy( mpid int,status int)
IF(@isLogMonitoringType=9)
BEGIN
INSERT INTO #monitoringPolicy
SELECT DISTINCT  M.monitorPolicyID,status from APP_MonitoringPolicy M JOIN APP_MonitoringPolicyProp Prop ON Prop.monitorPolicyId=M.monitorPolicyId and attrName='Monitoring Type' and attrVal='9' --HyperV Monitoring
	JOIN
	(SELECT monitorPolicyId from APP_MonitorAssocEntity where clientID=@iClientId and exclude=0
	UNION
	SELECT monitorPolicyId from APP_MonitorAssocEntity MP JOIN APP_ClientGroupAssoc CG ON  CG.clientGroupId=MP.clientGroupId AND CG.clientId=@iClientId  and flags=28
	UNION
	SELECT monitorPolicyId from APP_MonitorAssocEntity where flags=2
	EXCEPT
	SELECT monitorPolicyId FROM APP_MonitorAssocEntity where clientId=@iClientId and exclude=1)TBl ON TBL.monitorPolicyId=M.monitorPolicyId AND status<>3 and status <>1
	ORDER BY M.monitorPolicyId
END
ELSE
BEGIN
DECLARE @isWindowsClient INT =0
DECLARE @isUnixClient INT =0
DECLARE @isHyperVClient INT =0
DECLARE @OSType NVARCHAR(64)=(SELECT Type from simOperatingSystem OS WITH(NOLOCK) JOIN APP_CLient C on C.id=@iClientId and OS.id=simOperatingSystemId)
IF(@OSType='UNIX')
	SET @isUnixClient=1
ELSE  IF(@OSType='Windows')
	SET @isWindowsClient=1
SET @isHyperVClient=ISNULL((SELECT 1 FROM simInstalledPackages WITH(NOLOCK) where simPackageID=713 and clientId=@iClientId),0)
--Get list of monitoring polcies associated.
IF(@isLogMonitoringType=1)
BEGIN
	INSERT INTO #monitoringPolicy
	SELECT DISTINCT  M.monitorPolicyID,status from APP_MonitoringPolicy M JOIN
	(SELECT monitorPolicyId from APP_MonitorAssocEntity where clientID=@iClientId and exclude=0
	UNION
	SELECT monitorPolicyId from APP_MonitorAssocEntity MP JOIN APP_ClientGroupAssoc CG ON  CG.clientGroupId=MP.clientGroupId AND CG.clientId=@iClientId  and flags=28
	UNION
	SELECT monitorPolicyId from APP_MonitorAssocEntity where flags=2
	EXCEPT
	SELECT monitorPolicyId FROM APP_MonitorAssocEntity where clientId=@iClientId and exclude=1)TBl ON TBL.monitorPolicyId=M.monitorPolicyId AND status<>3 and status <>1
JOIN APP_MonitoringPolicyProp MPRopType ON MpropType.monitorPolicyId=M.monitorPolicyId and MPRopType.attrNAme='Monitoring Type' and  (attrVal=0 OR attrVal = 1 OR attrVal = 2 OR attrVal = 3 OR attrVal = 9 OR attrVal = 11 )
	LEFT OUTER JOIN  APP_MonitoringPolicyProp MProp ON Mprop.monitorPolicyId=M.monitorPolicyId and Mprop.attrName='Continuous monitoring'
	JOIN
	(SELECT monitorPolicyId   fROM APP_MonitorTemplateAssoc Assoc JOIN APP_Template T ON T.templateId =Assoc.templateId  WHERE  (@isWindowsClient=1 AND T.templateId=2) OR (@isUnixClient =2 AND T.templateId=5) OR templateForMonitoringType=0
	  UNION
	  SELECT monitorPolicyId FROM APP_MonitoringPolicyProp WHERE @isHyperVClient=1 AND attrName='Monitoring Type' and attrVal='9' --HyperV Monitoring
	) Pol ON Pol.monitorPolicyId= M.monitorPolicyID and (@filterConitnous=0 OR ( Mprop.attrVal=1 ))
END
IF(@isLogMonitoringType=0)   --System monitoring
BEGIN
	 -- get NAS clients
	DECLARE @clientTable TABLE (iClientId INT)
	--Other policies
	--Get Activity monitoring templateId
	DECLARE @ActivityMonitoringTemplateId INTEGER = (SELECT TOP 1 templateId from APP_Template where templateName ='Activity Monitoring')
	INSERT INTO #monitoringPolicy
	SELECT M.monitorPolicyID,status from APP_MonitoringPolicy M JOIN
	(SELECT DISTINCT monitorPolicyId from APP_MonitorAssocEntity  WHERE @iClientId=clientId and exclude=0
	UNION
	SELECT DISTINCT monitorPolicyId from APP_MonitorAssocEntity MP JOIN APP_ClientGroupAssoc CG ON  CG.clientGroupId=MP.clientGroupId  and flags=28 WHERE  @iClientId=CG.clientId
	UNION
	SELECT  monitorPolicyId from APP_MonitorAssocEntity where flags=2
	EXCEPT
	SELECT DISTINCT  monitorPolicyId FROM APP_MonitorAssocEntity WHERE  @iClientId=clientId and exclude=1)TBl
	ON TBL.monitorPolicyId=M.monitorPolicyId AND status<>3 and status <>1
	JOIN APP_MonitoringPolicyProp MProp ON Mprop.monitorPolicyId=M.monitorPolicyId and Mprop.attrNAme='Monitoring Type' and attrVal= '6'
	DELETE TBL
	FROM  #monitoringPolicy TBL  JOIN APP_MonitorTemplateAssoc on monitorPolicyId=mpid and templateId=@ActivityMonitoringTemplateId
	JOIN APP_MonitoringPolicyPRop MProp on MPRop.monitorPolicyId=mpid and attrNAme='osType' AND ( (attrVal=1 and @isWindowsClient=0 ) OR (attrVal=2 and @isUnixClient=0) OR attrVal=3)
	--NAS policy
			INSERT INTO @clientTable
			VALUES(@iClientId)
			INSERT INTO @clientTable
			EXEC AppGetNASClientsForGivenProxy @iClientId
			INSERT INTO #monitoringPolicy
			SELECT M.monitorPolicyID,status from APP_MonitoringPolicy M
			JOIN   APP_MonitorTemplateAssoc T ON M.monitorPolicyId= T.monitorPolicyId and templateId=@ActivityMonitoringTemplateId
			JOIN APP_MonitoringPolicyPRop MProp on MPRop.monitorPolicyId=M.monitorPolicyId and MPRop.attrNAme='osType' AND attrVal=3
			JOIN
			(SELECT DISTINCT monitorPolicyId from APP_MonitorAssocEntity  JOIN @clientTable  NAS ON  iClientId=clientId and exclude=0
			UNION
			SELECT DISTINCT monitorPolicyId from APP_MonitorAssocEntity MP JOIN APP_ClientGroupAssoc CG ON  CG.clientGroupId=MP.clientGroupId  and flags=28 JOIN @clientTable  NAS ON  iClientId=CG.clientId
			UNION
			SELECT  monitorPolicyId from APP_MonitorAssocEntity where flags=2
			EXCEPT
			SELECT DISTINCT  monitorPolicyId FROM APP_MonitorAssocEntity JOIN @clientTable  NAS ON  iClientId=clientId and exclude=1)TBl
			ON TBL.monitorPolicyId=M.monitorPolicyId AND status<>3 and status <>1
			JOIN APP_MonitoringPolicyProp MPropType ON MPropType.monitorPolicyId=M.monitorPolicyId and MPropType.attrNAme='Monitoring Type' and MPropType.attrVal= '6'      --LogMonitoring::MonitoringType_SYSTEM_MONITORING
	END
END
SET @o_MonitoringPolicy = ISNULL((SELECT top 1 mpId from #monitoringPolicy),0)
IF (@outputTableName<>'')
BEGIN
		DECLARE @dynamicSQLStr VARCHAR(MAX) = ''
		   SET @dynamicSQLStr = 'INSERT INTO '+ @outputTableName + ' SELECT * from #monitoringPolicy'
		EXEC(@dynamicSQLStr)
END
IF(@isReturn=1)
	SELECT * from  #monitoringPolicy
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LMGetEnableMonitoringPolicyForClient')
	delete from GxQscripts where name = 'LMGetEnableMonitoringPolicyForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetEnableMonitoringPolicyForClient')
	delete from GXDBVersions where aliasname = 'LMGetEnableMonitoringPolicyForClient'
GO

insert into GXDBVersions values(2, 'LMGetEnableMonitoringPolicyForClient',  '00000000000000000000', 'LMGetEnableMonitoringPolicyForClient', '00000000000000000000')
GO

