

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetDashBoardList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetDashBoardList.sp,v $ $Id: LMGetDashBoardList.sp,v 1.4.12.8 2018/03/22 01:32:22 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetDashBoardList <<<'

IF EXISTS (select * from sysobjects where name='LMGetDashBoardList')
	drop procedure LMGetDashBoardList
IF EXISTS (select * from GxQscripts where name='LMGetDashBoardList')
	delete from GxQscripts where name = 'LMGetDashBoardList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetDashBoardList')
	delete from GXDBVersions where aliasname = 'LMGetDashBoardList'
GO
print '... Creating Procedure: LMGetDashBoardList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetDashBoardList
  @userId INTEGER,
  @inputxml_req xml,
  @o_xmlMsg xml		OUTPUT
AS
DECLARE @infoLevel INTEGER = 0
DECLARE @dashBoardIds TABLE (dashBoardId INTEGER,rowPos INTEGER);
DECLARE @groupIds  TABLE (groupId INTEGER);
DECLARE @input XML = @inputxml_req
DECLARE @startId INTEGER
DECLARE @count	INTEGER
DECLARE @dashId INTEGER
DECLARE @appType INTEGER
DECLARE @includeMydashBoardList INTEGER
SET @infoLevel = ISNULL((SELECT ref.value('@infoLevel','INTEGER') AS data
					FROM @input.nodes('LogMonitoring_GetDashBoardListReq') R ( ref )),0)
SET @startId = ISNULL((SELECT ref.value('@start','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetDashBoardListReq/pageInfo') R ( ref )),0)
SET @count = ISNULL((SELECT ref.value('@count','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetDashBoardListReq/pageInfo') R ( ref )),0)
SET @appType = ISNULL((SELECT ref.value('@appType','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetDashBoardListReq') R ( ref )),1)
SET @includeMydashBoardList = ISNULL((SELECT ref.value('@includeMyDashboardListOnly','INTEGER') AS data
				FROM @input.nodes('LogMonitoring_GetDashBoardListReq') R ( ref )),1)
-- Secutity check for the users having rights on cs to see the SystemCreated Dashboard.
DECLARE @userHasViewRightOnCS INT
SET @userHasViewRightOnCS = 0
IF OBJECT_ID('tempdb.dbo.#dashboardListTmp') IS NOT NULL
	DROP TABLE #dashboardListTmp
create table  #dashboardListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC dbo.sec_getuserObjects @userID, 2018, 2, '#dashboardListTmp'
IF EXISTS(SELECT 1 FROM #dashboardListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) )
BEGIN
	set @userHasViewRightOnCS = 1
END
--staus = 4 is for System Created Dashboard
--So user having cs rights can see this
INSERT INTO @dashBoardIds(dashBoardId)
SELECT DISTINCT dashBoardId
FROM LMDashBoard WITH(NOLOCK)
WHERE  monitoringAppType = @appType AND(  ((creatorUserId = @userId  OR (@userHasViewRightOnCS = 1 AND @includeMydashBoardList =0) )AND isPrivate = 1 /*AND dashBoardId > @startId */) OR (@userHasViewRightOnCS = 1 AND status & 4 <> 0) OR (status & 8 <> 0))
--If @infoLevel = 1, then sharedEntityInfo should be sent in the response
DECLARE @userAndGroupInfo TABLE(userId INT , groupId INT , providerId INT , objectId INT)
IF @infoLevel = 1
BEGIN
	DECLARE @xml XML
    DECLARE @shareId INT
	DECLARE cur_dashBoardIds CURSOR
    STATIC FOR
		SELECT DISTINCT appShared.SharedEntityId
		FROM App_SharedEntityInfo appShared
			INNER JOIN @dashBoardIds dashIds
				ON  appShared.OriginalEntityId = dashIds.dashBoardId
			INNER JOIN LMDashBoard lmDashBoard
				ON lmDashBoard.dashBoardId = dashIds.dashBoardId
		WHERE appShared.SharedEntityType = 137 AND lmDashBoard.monitoringAppType = @appType --shared dashboard
	OPEN cur_dashBoardIds
		IF @@CURSOR_ROWS > 0
		BEGIN
			FETCH NEXT FROM cur_dashBoardIds INTO @shareId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				EXEC sec_getSecurityForEntity @userId, @xml output, 9674, @shareId  -- LM_SHARED_ENTITY_INFO = 9674
				INSERT INTO @userAndGroupInfo(userId , groupId , providerId , objectId)
                SELECT DISTINCT ISNULL( ref.value('@userId','INTEGER'),0)  ,CASE WHEN ref.value('@_type_','INTEGER') <> 62 THEN ISNULL(ref.value('@userGroupId','INTEGER'),0) ELSE ISNULL(ref.value('@groupId','INTEGER'),0) END, CASE WHEN ref.value('@_type_','INTEGER') = 62 THEN 1 ELSE 0 END , @shareId
                FROM @xml.nodes('associations/userOrGroup') R ( ref )
			    FETCH NEXT FROM cur_dashBoardIds INTO @shareId
			END
		END
	CLOSE cur_dashBoardIds
	DEALLOCATE cur_dashBoardIds
END
/*
SET @o_xmlMsg = ISNULL((SELECT dashBoardId as '@dashBoardId',
		DashBoardName as '@dashBoardName',
		isPrivate as '@isPrivate',
		status as '@status',
		creatorUserId as 'creator/@userId'
		FROM LMDashBoard WITH(NOLOCK)
		WHERE dashBoardId IN (SELECT dashBoardId FROM @dashBoardIds) AND monitoringAppType = @appType
		FOR XML PATH('dashBoardInfoList'),ROOT('LogMonitoring_DashBoardListResp')),'<LogMonitoring_DashBoardListResp/>')
*/
--calculating total number of dashboardIds
DECLARE @nTotalDashboardCount INTEGER
set @nTotalDashboardCount = ISNULL((SELECT count(DISTINCT dashIds.dashBoardId)
									FROM @dashBoardIds dashIds INNER JOIN LMDashBoard lmDashTbl
										ON dashIds.dashBoardId = lmDashTbl.dashBoardId
									WHERE lmDashTbl.monitoringAppType = @appType
									),0)
IF @count <> 0
BEGIN
-- updating rowNo in @dashboarIds table
UPDATE dashboardIds
	SET rowPos = T.rowNo
	FROM @dashBoardIds dashboardIds,
			(
					SELECT dashBoardId,ROW_NUMBER() OVER (ORDER BY dashboardId DESC) AS rowNo
					FROM @dashBoardIds
			) T
	WHERE T.dashBoardId=dashboardIds.dashBoardId
	--Now deleting unwanted dashboardIds
	DELETE FROM @dashBoardIds
	WHERE rowPos < @startId Or rowPos>@startId+@count-1
END
SET @o_xmlMsg = ISNULL((SELECT LMDashBoard.dashBoardId as '@dashBoardId',
		LMDashBoard.dashBoardName as '@dashBoardName',
		CONVERT(NVARCHAR(MAX),dashBoardProp) as '@dashBoardProp',
		LMDashBoard.isPrivate as '@isPrivate',
		LMDashBoard.status as '@status',
		creatorUserId as 'creator/@userId',
		UMUsers.login as 'creator/@userName',
		appShared.SharedEntityType as 'sharedEntityInfo/@sharetype' ,
		appShared.OriginalEntityId as 'sharedEntityInfo/@originalEntityId',
		case when appShared.OriginalEntityId <> NULL then  LMDashBoard.dashBoardName end as 'sharedEntityInfo/@originalEntityName' ,
		appShared.SharedEntityId as 'sharedEntityInfo/sharedEntityId/@sharedEntityId',
		(
			select CASE WHEN userAssoc.providerId = 0 AND userAssoc.groupId = 0 THEN 1 -- USERID
						WHEN userAssoc.providerId = 0 AND userAssoc.userId = 0 THEN 3 -- COMMCELL GROUP
						WHEN userAssoc.providerId <> 0 AND userAssoc.groupId <> 0 THEN 4 -- EXTERNAL GROUP
						END as '@userType' ,
					UMUsers.name + '(' + UMUsers.login + ')' as 'user/@userName' ,
					UMGroups.name + '(' + UMGroups.name + ')' as 'group/@userGroupName' ,
					UMDSgroups.name + '(' + UMDSProviders.domainName + '\' + UMDSgroups.name + ')' as 'externalGroup/@externalGroupName'
			FROM @userAndGroupInfo userAssoc
				LEFT JOIN UMUsers ON userAssoc.userId = UMUsers.id
				LEFT JOIN UMGroups ON userAssoc.groupId = UMGroups.id AND userAssoc.providerId = 0
				LEFT JOIN UMDSgroups ON userAssoc.groupId = UMDSgroups.id AND userAssoc.providerId > 0
				LEFT JOIN UMDSProviders ON UMDSgroups.umdsProviderId = UMDSProviders.id
			WHERE userAssoc.objectId = appShared.SharedEntityId
			FOR XML PATH('sharedTo') , type
		) as 'sharedEntityInfo'
		FROM LMDashBoard WITH(NOLOCK)
			INNER JOIN @dashBoardIds dashIds
				ON LMDashBoard.dashBoardId = dashIds.dashBoardId
			LEFT JOIN App_SharedEntityInfo appShared
				ON LMDashBoard.dashBoardId = appShared.OriginalEntityId  AND appShared.SharedEntityType = 137
			LEFT JOIN UMUsers ON creatorUserId = UMUsers.id
		WHERE LMDashBoard.monitoringAppType = @appType
		FOR XML PATH('dashBoardInfoList'),ROOT('LogMonitoring_DashBoardListResp')),'<LogMonitoring_DashBoardListResp/>')
SET @o_xmlMsg.modify('insert attribute totalDashBoards {sql:variable("@nTotalDashboardCount")} into (/LogMonitoring_DashBoardListResp)[1]')
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetDashBoardList')
	delete from GxQscripts where name = 'LMGetDashBoardList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetDashBoardList')
	delete from GXDBVersions where aliasname = 'LMGetDashBoardList'
GO

insert into GXDBVersions values(2, 'LMGetDashBoardList',  '00010004001200080000', 'LMGetDashBoardList', '00010004001200080000')
GO

