

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetContinuousLMStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Seema Aggarwal
--	Date:   10/11/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetContinuousLMStatus.sp,v $ $Id: LMGetContinuousLMStatus.sp,v 1.8.56.11 2019/04/23 15:47:09 manojg Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMGetContinuousLMStatus')
BEGIN
	print '>>> Drop Stored Procedure: LMGetContinuousLMStatus <<<'
	drop procedure LMGetContinuousLMStatus
END
IF EXISTS (select * from GxQscripts where name='LMGetContinuousLMStatus')
	delete from GxQscripts where name = 'LMGetContinuousLMStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetContinuousLMStatus')
	delete from GXDBVersions where aliasname = 'LMGetContinuousLMStatus'
GO
print '... Creating Procedure: LMGetContinuousLMStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetContinuousLMStatus
  @inputxml_req XML
AS
  DECLARE @o_xmlMsg XML;
begin
SET NOCOUNT ON
DECLARE @LMCurrentStatusTemp TABLE
(
            Id            int identity(1,1),
            commcellId        integer,
            jobId         integer,
            type          integer,
            monitorPolicyId   integer,
			policyName		NVARCHAR(1024),
            criteriaId        integer,
            clientId      integer,
            clientName nvarchar(1024),
            clientGroupId      integer,
            clientGroupName nvarchar(1024),
            clientFileId      integer,
            JobStatus         integer,
            Reason        integer,
            NoOfLineMatched   integer,
            quitFlag      integer,
            created       integer,
            modified      integer,
            xmlString         xml,
			LastIndexDataTime integer DEFAULT NULL
 );;
DECLARE @nowTime INTEGER = dbo.GetUnixTime(GETUTCDATE())
DECLARE @idleTimeInMin INTEGER = ISNULL((SELECT value FROM GXGlobalParam WHERE name LIKE 'nCLMIdleTimeStatus'), 120)
DECLARE @idleTimeInDay INTEGER = ISNULL((SELECT value FROM GXGlobalParam WHERE name LIKE 'nCLMIdleTimeClient'), 7)
UPDATE LMCurrentStatus
SET JobStatus = 2
WHERE (@nowTime - modified) > @idleTimeInMin * 60 AND JobStatus = 3
DECLARE @clientWithCLMandGroup TABLE (clientId integer) --May have duplicate IDs
DECLARE @mpWithCLM TABLE (mpId INTEGER)
DECLARE @i_userId INTEGER
SET @i_userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                       FROM    @inputxml_req.nodes('LogMonitoring_CLMStateRequest/processinginstructioninfo/user') R ( ref )),0)
INSERT INTO @mpWithCLM
SELECT DISTINCT mon.monitorPolicyId FROM APP_MonitoringPolicy mon INNER JOIN APP_MonitoringPolicyProp monPop
	ON mon.monitorPolicyId = monPop.monitorPolicyId
WHERE RTRIM(LTRIM(attrName)) like 'Continuous monitoring' AND attrVal = '1' and mon.status <> 3 and mon.status <> 1
--Step 1 -> Get all the clients from APP_Client
INSERT @clientWithCLMandGroup
SELECT id FROM APP_Client with (nolock) WHERE (status & 2) = 0 AND ((specialClientFlags & 2) = 0 OR (status & 0x0080 = 0x0080))
--Step 2 -> Check if there is a MP with all clients
IF NOT EXISTS(SELECT 1 FROM
			APP_MonitorAssocEntity WHERE flags = 2 and monitorPolicyId IN (SELECT mpId FROM @mpWithCLM))
BEGIN
--Step 2.1 -> Remove the client for which CLM is not enabled
	DELETE FROM @clientWithCLMandGroup WHERE clientId NOT IN (
		SELECT DISTINCT clientId
		FROM APP_MonitorAssocEntity  with (nolock)
		WHERE monitorPolicyId IN (SELECT mpId FROM @mpWithCLM) and flags = 3)
--Step 2.2 > Add the client for which CLM is enabled through client group
	INSERT INTO  @clientWithCLMandGroup
	SELECT distinct gAss.clientId
	FROM APP_MonitorAssocEntity mpAscEnt with (nolock)
				INNER JOIN APP_ClientGroupAssoc gAss with (nolock)
					ON mpAscEnt.clientGroupId = gAss.clientGroupId
				INNER JOIN APP_Client client with (nolock)
					ON gAss.clientId = client.id
WHERE mpAscEnt.flags = 28 and mpAscEnt.exclude = 0 and mpAscEnt.monitorPolicyId IN (SELECT mpId FROM @mpWithCLM) and (client.status & 2) = 0 AND ( (client.specialClientFlags & 2) = 0 OR (status & 0x0080 = 0x0080))
END
--DELETE CLIENTS ON which dont have Admin/Agent Management Cap
DECLARE @canSeeClient Table (clientId integer, clientName nvarchar(255), isDeleted integer,rights integer, cvdPort integer, evmgrcPort integer, clientGuid varchar(40), clientHostName nvarchar(255), clusterType int, clientDisplayName nvarchar(255))
INSERT INTO @canSeeClient
exec getClientNameList @i_userId,2,0,7,0,0,0
DELETE CliWithCLM
FROM @clientWithCLMandGroup CliWithCLM LEFT JOIN @canSeeClient canSeeClnt
ON CliWithCLM.clientId=canSeeClnt.clientId
WHERE canSeeClnt.clientId is null
--GET LIST OF CLIENT GROUP on which user has admin/agent cap
IF object_id('tempdb.dbo.#LMGetClientGroups_UserObjects') is not null DROP TABLE #LMGetClientGroups_UserObjects
create table  #LMGetClientGroups_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 2572, 0, '#LMGetClientGroups_UserObjects'
DECLARE @two bigint =2
DECLARE @CapNeeded bigint=POWER(@two,1 -1)|POWER(@two,2  -1)
DELETE FROM #LMGetClientGroups_UserObjects
where capabilities&@CapNeeded=0
DECLARE @hasNasPolicy bit = 0
DECLARE @NASPolicies TABLE(PolicyId INT)
INSERT INTO @NASPolicies
 SELECT monitorPolicyId from APP_MonitoringPolicyProp WITH (NOLOCK)
                         where attrName='OSType'
                         and attrVal='3' --NAS
IF EXISTS(select 1 from @NASPolicies NASP
          inner join app_monitoringpolicy  MP WITH (NOLOCK)
          on NASP.PolicyId = MP.monitorPolicyId
		  where status <> 3)
		 SET @hasNasPolicy=1
--replace nas clients with their proxy
 IF(@hasNasPolicy=1)
 BEGIN
		declare @NASClients TABLE(NASClientId INTEGER,ProxyClientId INTEGER)
	    --get list of NAS Clients
        insert into @NASClients(NASCLientid)
select id from app_client with(nolock) where status & 0x0080 = 0x0080 and status & 0x00002  = 0
        update NAS
        set NAS.ProxyClientId = cast (Idaprop.attrVal as INT)   from @NASClients NAS
inner join App_IdaName Ida with(nolock) on NAS.NASClientId = Ida.ClientId and Ida.apptypeId = 33
        inner join App_IdaProp Idaprop with (nolock) on  Ida.id = Idaprop.componentNameId and Idaprop.attrName = N'FPOLICY PRIMARY CLIENT'
        where Idaprop.modified=0
        delete from @NASClients where ProxyClientId=0 or ProxyClientId is Null
		INSERT INTO @clientWithCLMandGroup
		SELECT  NAS.ProxyClientId
		from  @NASClients NAS JOIN @clientWithCLMandGroup
		on NAS.NASClientId=clientId
		update clientSeen
		set clientSeen.clientId = NAS.ProxyClientId
		from @canSeeClient clientSeen inner join @NASClients NAS
		on NAS.NASClientId=clientSeen.clientId
 END
 DECLARE @canSeeClientDist Table(clientId int)
 INSERT into @canSeeClientDist
 SELECT distinct clientId from @canSeeClient
--Step 3 -> Remove the client which are excluded
--DELETE
--FROM @LMCurrentStatusTemp
--WHERE clientId IN (SELECT DISTINCT clientId FROM APP_MonitorAssocEntity WITH (nolock) WHERE flags = 3 and exclude = 1)
--Step 4 -> Now get the client that has suspend/resume feature and satisfying above steps
INSERT INTO @LMCurrentStatusTemp
SELECT commcellId,jobId,type,monitorPolicyId,NULL,criteriaId,LMCS.clientId ,
	 '' ,0,'',
	clientFileId ,
	jobStatus ,
	reason ,
	NoOfLineMatched ,
	quitFlag ,
	created ,
	modified,
	xmlString,NULL
FROM LMCurrentStatus LMCS  JOIN @canSeeClientDist c1 on c1.clientId=LMCS.clientId
where jobId = 0 and LMCS.clientId in (SELECT CWCG.clientId FROm @clientWithCLMandGroup CWCG)
--Remove clients for which CLM status is not updated for '@idleTimeInDay' time
DELETE FROM @LMCurrentStatusTemp
WHERE ((@nowTime - modified) > @idleTimeInDay * 24 * 3600) AND JobStatus = 2
INSERT INTO @LMCurrentStatusTemp(commcellId,clientGroupId,clientGroupName,jobId,JobStatus,clientId)
SELECT DISTINCT 2,id,name,0,0,0 FROM APP_ClientGroup  with (nolock) join #LMGetClientGroups_UserObjects  sec on (id =clientGroupId OR ( sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0 ))  WHERE id IN
(SELECT clientGroupId FROM APP_MonitorAssocEntity with (nolock) WHERE flags = 28 and monitorPolicyId in (SELECT mpId FROM @mpWithCLM))
--SELECT * FROM @LMCurrentStatusTemp
DECLARE @dbPolicies TABLE(mpid INTEGER,policyName NVARCHAR(1024),lastIndexId INTEGER, lastIndexTime INTEGER)
INSERT INTO @dbPolicies(mpid,policyName)
SELECT mpprop.monitorPolicyId,mp.MonitorPolicyName FROM APP_MonitoringPolicyProp mpprop
INNER JOIN APP_MonitoringPolicy mp on mp.monitorPolicyId = mpprop.monitorPolicyId AND mp.status NOT IN (3)
WHERE mpprop.attrName = 'Monitoring Type' AND mpprop.attrVal = '5'
UPDATE policyData
SET lastIndexId = ISNULL(mpprop.attrVal,0)
FROM @dbPolicies policyData INNER JOIN APP_MonitoringPolicyProp mpprop
        ON policyData.mpid = mpprop.monitorPolicyId
            WHERE mpprop.attrName = 'last DataSet Index'
UPDATE policyData
SET lastIndexTime = ISNULL(mpprop.attrVal,0)
FROM @dbPolicies policyData INNER JOIN APP_MonitoringPolicyProp mpprop
        ON policyData.mpid = mpprop.monitorPolicyId
            WHERE mpprop.attrName = 'Last Index Id Time'
INSERT INTO @LMCurrentStatusTemp(commcellId,jobId,type,monitorPolicyId,policyName,JobStatus,clientId,clientName,LastIndexDataTime)
SELECT 2,0,5,mpid,policyName,0,2,(SELECT name FROM APP_Client WHERE id = 2),lastIndexTime
FROM @dbPolicies WHERE 2 IN (SELECT clientid FROM @canSeeClientDist)
update @LMCurrentStatusTemp set type = 6 where type = 2 --SYSTEM_MONITORING
SET @o_xmlMsg = ISNULL((SELECT commcellId as '@commCellId',
	 jobId as '@jobId',
    type as '@type',
	monitorPolicyId as '@monitoringPolicyId',
	policyName as '@monitoringPolicyName',
	criteriaId as '@criteriaId',
	clientFileId as '@clientFileId',
	jobStatus as '@jobStatus',
	reason as '@reason',
	NoOfLineMatched  as '@noOfLinesMatched',
	quitFlag as '@quitFlag',
	created as '@created',
	modified as '@modified',
	LastIndexDataTime as '@LastIndexDataTime',
	CONVERT(nvarchar(max),xmlString)  as '@xmlData',
	CASE WHEN clientid > 0 THEN 3 ELSE 28 END as 'entity/@_type_',
	CASE WHEN clientid > 0 THEN clientId   ELSE NULL END as 'entity/@clientId' ,
	CASE WHEN clientid = 0 AND clientGroupId <> 0 THEN clientGroupId   ELSE NULL END as 'entity/@clientGroupId' ,
	CASE WHEN clientid > 0 THEN (select c1.name from APP_Client c1
          where c1.id = clientId) ELSE NULL END as 'entity/@clientName',
    CASE WHEN clientid = 0 AND clientGroupId <> 0 THEN (select c1.name from APP_ClientGroup c1
          where c1.id = clientGroupId) ELSE NULL END as 'entity/@clientGroupName'
 FROM @LMCurrentStatusTemp  where jobId = 0
 FOR XML PATH('clmStatusList'),
ROOT('LogMonitoring_LMCurrentStatusListResponse')),'<LogMonitoring_LMCurrentStatusListResponse/>')
--SELECT id,name FROM APP_ClientGroup WHERE id IN
--(SELECT clientGroupId FROM APP_MonitorAssocEntity WHERE flags = 28)
SELECT @o_xmlMsg
SET NOCOUNT OFF
 END

IF EXISTS (select * from GxQscripts where name = 'LMGetContinuousLMStatus')
	delete from GxQscripts where name = 'LMGetContinuousLMStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetContinuousLMStatus')
	delete from GXDBVersions where aliasname = 'LMGetContinuousLMStatus'
GO

insert into GXDBVersions values(2, 'LMGetContinuousLMStatus',  '00010008005600110000', 'LMGetContinuousLMStatus', '00010008005600110000')
GO

