

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetCloudInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetCloudInfo.sp,v $ $Id: LMGetCloudInfo.sp,v 1.2.60.4 2018/03/22 01:31:39 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
/*****Sp Ouput :donotuse o_flags,it is not populated**************************/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetCloudInfo <<<'

IF EXISTS (select * from sysobjects where name='LMGetCloudInfo')
	drop procedure LMGetCloudInfo
IF EXISTS (select * from GxQscripts where name='LMGetCloudInfo')
	delete from GxQscripts where name = 'LMGetCloudInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetCloudInfo')
	delete from GXDBVersions where aliasname = 'LMGetCloudInfo'
GO
print '... Creating Procedure: LMGetCloudInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetCloudInfo
  @i_cloudId INT,
  @i_userId INT
AS
  DECLARE @o_cloudId INTEGER;
  DECLARE @o_enabled INTEGER;
  DECLARE @o_attributes INTEGER;
  DECLARE @o_coreRoles INTEGER;
  DECLARE @o_flags INTEGER;   
  DECLARE @o_cloudClientId INTEGER;
  DECLARE @o_baseport NVARCHAR(6);
  DECLARE @o_url NVARCHAR(2000);
  DECLARE @o_serviceLink NVARCHAR(2000);
  DECLARE @o_cloudName NVARCHAR(512);
BEGIN
SET NOCOUNT ON
 IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
        CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
EXEC DM2GetIndexServers 'Log Monitoring'
	SELECT
		GIS.cloudid,
		SC.Enabled,
		SC.Attributes,
		SC.CoreRoles,
		0,   --flags is not used anywhere
		SC.ClientId,
		SC.Portno,
		GIS.hostName,
		GIS.serverURL,
		GIS.internalCloudName
	FROM DM2SearchServerCoreInfo SC with(nolock) Join #getIndexServers GIS ON  SC.clientID=GIS.clientId and SC.CloudId=GIS.cloudId
	and SC.CloudId=@i_cloudId
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'LMGetCloudInfo')
	delete from GxQscripts where name = 'LMGetCloudInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetCloudInfo')
	delete from GXDBVersions where aliasname = 'LMGetCloudInfo'
GO

insert into GXDBVersions values(2, 'LMGetCloudInfo',  '00010002006000040000', 'LMGetCloudInfo', '00010002006000040000')
GO

