

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetCloudAndMonitoringPolicyList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Logesh G
--	Date:   02/12/2015
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetCloudAndMonitoringPolicyList.sp,v $ $Id: LMGetCloudAndMonitoringPolicyList.sp,v 1.1.2.13 2018/10/31 07:03:09 syadav Exp $";
--
--  +========================================================================+
--  | Stored Precedure: LMGetCloudAndMonitoringPolicyList()
--  |
--  |   Revisions   Author          Description
--  |   ---------   ----------      ----------------------------------------
--  |   1.1			logesh G	LMGetCloudAndMonitoringPolicyList is to get lm cloud and its monitoring policy and core info
--	|							If Input is appType --> list of cloud and its policy Info is output
--	|							If list of monitoring policyId is given as input , only its INfo wil be returned
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMGetCloudAndMonitoringPolicyList')
BEGIN
	print '>>> Drop Stored Procedure: LMGetCloudAndMonitoringPolicyList <<<'
	drop procedure LMGetCloudAndMonitoringPolicyList
END
IF EXISTS (select * from GxQscripts where name='LMGetCloudAndMonitoringPolicyList')
	delete from GxQscripts where name = 'LMGetCloudAndMonitoringPolicyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetCloudAndMonitoringPolicyList')
	delete from GXDBVersions where aliasname = 'LMGetCloudAndMonitoringPolicyList'
GO
print '... Creating Procedure: LMGetCloudAndMonitoringPolicyList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetCloudAndMonitoringPolicyList
  @userId INTEGER,
  @inputXml XML,
  @outputXml XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @appType INT , @flag INT
DECLARE @inputMpTbl TABLE(mpId INT PRIMARY KEY)
DECLARE @monitoringPolicyTbl TABLE (mpId INT PRIMARY KEY, disabled INT , monitoringType INT )
DECLARE @associatedCloudTbl TABLE(cloudId INT)
DECLARE @assocTbl TABLE(mpId INT , type INT , clientId INT,clientName NVARCHAR(MAX))
DECLARE @canSeeAllPolicy INT
DECLARE @mpXml XML
DECLARE @context INT = 0
INSERT INTO @inputMpTbl
SELECT DISTINCT ref.value('@val','INT')
FROM @inputXml.nodes('LogMonitoring_GetCloudAndMonitoringPolicyListReq/cloudAndMpReq/monitoringPolicyId') AS R(ref)
SELECT @appType = ISNULL( ref.value('@appType','INT') , 0) , @flag = ISNULL( ref.value('@flag','INT') , 0)
FROM @inputXml.nodes('LogMonitoring_GetCloudAndMonitoringPolicyListReq/monitoringPolicyReq') AS R(ref)
SET @context = ISNULL (( SELECT ref.value('@context','INT')
FROM @inputXml.nodes('LogMonitoring_GetCloudAndMonitoringPolicyListReq') AS R(ref)), 0)
--if input has policyId , need not to get policies associated with userid.
--Because for shared searches ,we  need to give core info of policies which is not associated to that user also.
IF (@appType <> 0) AND (NOT EXISTS(SELECT 1 FROM @inputMpTbl))
BEGIN
	-- Ex xml for below statement '<LogMonitoring_GetMonitoringPoliciesListReq appType="1" flag="2" />'
	SET @mpXml= '<LogMonitoring_GetMonitoringPoliciesListReq appType="' + CONVERT(NVARCHAR(MAX),@appType )+ '" flag="'+ CONVERT(NVARCHAR(MAX), @flag )+'" />'
	EXEC LMGetMonitoringPolicy @userId, @mpXml , @mpXml OUTPUT
	SET @canSeeAllPolicy = ISNULL((SELECT ref.value('@canSeeAllPolicy','INT') FROM @mpXml.nodes('LogMonitoring_GetMonitoringPoliciesListResp') AS R(ref)) , 0)
	INSERT INTO @monitoringPolicyTbl
	SELECT DISTINCT ref.value('@monitoringPolicyid','INT') , ref.value('@disabled','INT') , ref.value('(monitoringTypes/@val)[1]' , 'INT')
	FROM @mpXml.nodes('LogMonitoring_GetMonitoringPoliciesListResp/monitoringPolicies') AS R(ref)
	INSERT INTO @assocTbl
	SELECT ref.value('@monitoringPolicyid','INT') , ref.value('(associations/@_type_)[1]','INT') , ref.value('(associations/@clientId)[1]' , 'INT') ,  ref.value('(associations/@clientName)[1]' , 'nvarchar(max)')
	FROM @mpXml.nodes('LogMonitoring_GetMonitoringPoliciesListResp/monitoringPolicies') AS R(ref)
END
-- If input has policyId , populate into generic policyTable.
IF exists ( SELECT 1 FROM @inputMpTbl )
BEGIN
	INSERT INTO @monitoringPolicyTbl(mpId)
	SELECT mpId FROM @inputMpTbl
	IF @context > 0   -- called from CRE end
	      AND EXISTS ( SELECT *
		            			FROM @monitoringPolicyTbl A
                                     INNER JOIN APP_EdgeDriveAssociation B
					                            ON A.mpId = B.entityId  AND B.entityType = 90 -- MONITORING POLICY
                    )
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#secClientList') IS NOT NULL  DROP TABLE #secClientList
			CREATE TABLE #secClientList (pseudoClientId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 3, 13, '#secClientList'
			--Delete only edge drive policy for which user do not have browse permissions.
			-- we may have mix of edge and non-edge drive policis, we should not delete non-edge drive polices.
			DELETE MT
			FROM @monitoringPolicyTbl MT  INNER JOIN APP_MonitoringPolicyProp AMP
			ON MT.mpId = AMP.monitorPolicyId AND AMP.attrName = N'Monitoring Type' AND AMP.attrval = '13'
			WHERE mpId IN ( SELECT A.mpId
							FROM @monitoringPolicyTbl A
										INNER JOIN APP_EdgeDriveAssociation B
											ON A.mpId = B.entityId
										AND B.entityType = 90 -- MONITORING POLICY
							WHERE mpId NOT IN ( SELECT DISTINCT entityId
												FROM #secClientList L INNER JOIN APP_EdgeDriveAssociation E
												ON L.pseudoClientId = E.clientId
												WHERE E.entitytype = 90))
		END
END
--Insert only monitoring policy associated clouds. Thereby poclicy assocated to clouds of other appType are ommited.
IF EXISTS (SELECT 1 FROM @monitoringPolicyTbl)
BEGIN
	INSERT INTO @associatedCloudTbl
	SELECT DISTINCT policyProp.attrval
	FROM @monitoringPolicyTbl mpTbl
		INNER JOIN APP_MonitoringPolicyProp policyProp
		ON policyProp.monitorPolicyId = mpTbl.mpId
		INNER JOIN DM2Cloud C ON C.cloudId = policyProp.attrVal
	WHERE policyProp.attrName = 'Cloud Id'
END
IF NOT EXISTS(select 1 from @associatedCloudTbl )
BEGIN
	DECLARE @userhasSharedSearch int=0
	exec LM_isUserHasSharedEntity @userId, @appType , @userhasSharedSearch output
	if @userhasSharedSearch = 1
	BEGIN
		-- This will happen only for shared search .for user with no policy, we will load default cores(old behaviour only for shared search)
		-- Hence user will get no cloud error  when loading app initially
		INSERT INTO @associatedCloudTbl
		SELECT cloudid FROM DM2Cloud
	END
END
-- MidNight Epoch Date is needed to compare with the created time in App_lmcoreReq . So calculating it below
DECLARE @midNightDate DATETIME
SET @midNightDate = ( SELECT Convert(DATETIME, DATEDIFF(DAY, 0,GETUTCDATE())))
DECLARE @midNightEpochDate BIGINT
SET @midNightEpochDate = DBO.GetUnixTime(@midNightDate)
DECLARE @oneDayInSec BIGINT
SET @oneDayInSec = (24 * 60 * 60)
DECLARE @coreReqTbl TABLE(policyId INT , startTime BIGINT , endTime BIGINT)
-- userId filter is done here because , while deleting policy , we need all requested cores to be unloaded.
-- from lmcihelper, CleanciData function userId as 0 will be input.
IF @userId <> 0
BEGIN
	INSERT INTO @coreReqTbl
	SELECT policyId , startTime , endTime--,reqTbl.userId
	FROM App_LmCoreReqInfo reqTbl  WITH(NOLOCK)
	INNER JOIN @monitoringPolicyTbl mpTbl
	ON mpTbl.mpId = reqTbl.policyId AND reqTbl.userId = @userId
	--Now we will pass isLoaded  = 1 cores .
	--So to filter out reqested dates, policy's retention dates also sent.(filtering is done in cpp end.)
	INSERT INTO @coreReqTbl
	SELECT propTbl.monitorPolicyId,dbo.GetUnixTime( dateadd(day, - CONVERT(INT,propTbl.attrVal),getutcdate())),dbo.GetUnixTime(GETUTCDATE())--,@userId
	FROM APP_MonitoringPolicyProp propTbl WITH(NOLOCK)
	INNER JOIN APP_MonitoringPolicyProp enableAgeingTbl WITH(NOLOCK)
	ON enableAgeingTbl.monitorPolicyId = propTbl.monitorPolicyId
	WHERE propTbl.attrName LIKE 'age ci data after days' AND enableAgeingTbl.attrName = 'enable ci data ageing' AND enableAgeingTbl.attrVal = 1
	DECLARE @ONE_DAY_IN_SECONDS_FORMAT INTEGER = (24 * 60 * 60)
	INSERT INTO @coreReqTbl
	SELECT propTbl.monitorPolicyId,(policyTbl.created  - (propTbl.attrVal * @ONE_DAY_IN_SECONDS_FORMAT)   ),dbo.GetUnixTime(GETUTCDATE())--,@userId
	FROM APP_MonitoringPolicy policyTbl
	INNER JOIN APP_MonitoringPolicyProp propTbl WITH(NOLOCK)
	ON policyTbl.monitorPolicyId = propTbl.monitorPolicyId
	INNER JOIN APP_MonitoringPolicyProp enableAgeingTbl WITH(NOLOCK)
	ON enableAgeingTbl.monitorPolicyId = propTbl.monitorPolicyId
	WHERE propTbl.attrName LIKE 'age ci data after days' and enableAgeingTbl.attrName = 'enable ci data ageing' and enableAgeingTbl.attrVal = 0
END
DECLARE @lmScalePropTbl TABLE(policyId INT , factor INT , subClientId INT , dumpLocation NVARCHAR(MAX))
INSERT INTO @lmScalePropTbl(policyId , factor,subClientId)
SELECT policyTempTbl.mpId ,
ISNULL((SELECT propTbl.attrVal FROM APP_MonitoringPolicyProp propTbl WITH(NOLOCK) WHERE propTbl.monitorPolicyId = policyTempTbl.mpId AND propTbl.attrName='Factor'),1), -- day as default
ISNULL((SELECT propTbl.attrVal FROM APP_MonitoringPolicyProp propTbl WITH(NOLOCK) WHERE propTbl.monitorPolicyId = policyTempTbl.mpId AND propTbl.attrName='SubClient Id'),0)
FROM @monitoringPolicyTbl policyTempTbl
--update dumpLocation info(needed to clear the data after deleting monitoring policy)
UPDATE @lmScalePropTbl
SET dumpLocation = ISNULL((SELECT TOP 1 fileName FROM APP_ScFilterFile WITH(NOLOCK) WHERE componentNameId = lmScalePropTbl.subClientId and modified = 0),'')
FROM @lmScalePropTbl lmScalePropTbl
WHERE lmScalePropTbl.subClientId <> 0
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
exec DM2GetIndexServers 'Log Monitoring'
SET @outputXml =
ISNULL(
	(
	SELECT	dm2Tbl.ClientId as '@clientId' ,
		appClientTbl.net_hostname AS '@hostname',
		dm2Tbl.basePort AS '@baseport' ,
		@canSeeAllPolicy as 'monitoringPolicyResp/@canSeeAllPolicy',
		(
			SELECT	mp.monitorPolicyId  AS '@monitoringPolicyid',
					mp.MonitorPolicyName AS '@monitoringPolicyName' ,
					mpTbl.disabled AS '@disabled' ,
					--ISNULL((SELECT factorTbl.attrVal FROM APP_MonitoringPolicyProp factorTbl WITH(NOLOCK) WHERE factorTbl.monitorpolicyId = mpp.monitorpolicyId and factorTbl.attrname = 'Factor') , 1) AS '@factor', --default 1(day factor)
					--ISNULL((SELECT subClientAssocTbl.attrVal FROM APP_MonitoringPolicyProp subClientAssocTbl WITH(NOLOCK) WHERE subClientAssocTbl.monitorpolicyId = mpp.monitorpolicyId and subClientAssocTbl.attrname = 'SubClient Id') , 0) AS 'subClientEntity/@subclientId',
					scalePropTbl.factor AS '@factor',
					scalePropTbl.dumpLocation AS '@dumpLocation',
					scalePropTbl.subClientId  AS 'subClientEntity/@subclientId',
					mpTbl.monitoringType AS 'monitoringTypes/@val' ,
					assoc.type AS 'associations/@_type',
					assoc.clientId AS 'associations/@clientId' ,
					assoc.clientName AS 'associations/@clientName' ,
					(
						SELECT	coreInfo.coreName AS '@coreName',
								coreInfo.isLoaded as '@isLoaded'
						FROM App_LMCoreInfo coreInfo WITH(NOLOCK)
						WHERE coreInfo.policyId = mp.monitorPolicyId  AND coreInfo.isLoaded = 1
						FOR XML PATH ('coreInfo') , TYPE
					) -- as 'CoreInfo'
					,
					(
						select coreReqTbl.startTime as '@startPeriod' , coreReqTbl.endTime as '@endPeriod'
						from @coreReqTbl coreReqTbl
						where coreReqTbl.policyId = mp.monitorPolicyId
						for xml path ('reIndexedTimeRange') , type
					)
			FROM APP_MonitoringPolicyProp mpp WITH(NOLOCK) INNER JOIN APP_MonitoringPolicy mp WITH(NOLOCK) ON mp.monitorPolicyId = mpp.monitorPolicyId
			INNER JOIN @monitoringPolicyTbl mpTbl ON mpTbl.mpId = mp.monitorPolicyId
			INNER JOIN @lmScalePropTbl scalePropTbl ON mpTbl.mpId = scalePropTbl.policyId
			LEFT JOIN @assocTbl assoc ON assoc.mpId = mpTbl.mpId
			WHERE mpp.attrName = 'Cloud Id' AND mpp.attrVal = dm2Tbl.CloudId-- and mp.status <> 3
			FOR XML PATH ('monitoringPolicies') ,type
		) as 'monitoringPolicyResp'
		FROM #getIndexServers dm2Tbl
		INNER JOIN @associatedCloudTbl cloudAssoc ON cloudAssoc.cloudId = dm2Tbl.cloudId
			INNER JOIN APP_Client appClientTbl WITH(NOLOCK) ON appClientTbl.id = dm2Tbl.ClientId
		AND appClientTbl.status & 2 <> 2 -- these are active clients. status of 2 are deconfigured ones.
		FOR XML PATH('cloudClientList') , ROOT('LogMonitoring_GetCloudClientInfoListResp')
)
 , '<LogMonitoring_GetCloudClientInfoListResp />')
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
SELECT @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'LMGetCloudAndMonitoringPolicyList')
	delete from GxQscripts where name = 'LMGetCloudAndMonitoringPolicyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetCloudAndMonitoringPolicyList')
	delete from GXDBVersions where aliasname = 'LMGetCloudAndMonitoringPolicyList'
GO

insert into GXDBVersions values(2, 'LMGetCloudAndMonitoringPolicyList',  '00010001000200130000', 'LMGetCloudAndMonitoringPolicyList', '00010001000200130000')
GO

