

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetApplicableAssocForMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Seema Aggarwal
--	Date:   10/11/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGetApplicableAssocForMonitoringPolicy.sp,v $ $Id: LMGetApplicableAssocForMonitoringPolicy.sp,v 1.4.66.11 2020/12/04 01:29:06 logeshg Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='LMGetApplicableAssocForMonitoringPolicy')
BEGIN
	print '>>> Drop Stored Procedure: LMGetApplicableAssocForMonitoringPolicy <<<'
	drop procedure LMGetApplicableAssocForMonitoringPolicy
END
IF EXISTS (select * from GxQscripts where name='LMGetApplicableAssocForMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetApplicableAssocForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetApplicableAssocForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetApplicableAssocForMonitoringPolicy'
GO
print '... Creating Procedure: LMGetApplicableAssocForMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure LMGetApplicableAssocForMonitoringPolicy
  @inputmonitoringPolicy integer,
  @iClientId INT =0,
  @isReturnPackageNotInstallClient INT =0,
  @lmOperationType INT= 1  
AS
  DECLARE @clientId integer;
  DECLARE @isPackageInstalled integer;
  DECLARE @clientMangledHostName NVARCHAR(1024);
  DECLARE @randomGUID NVARCHAR(1024);
BEGIN
	SET NOCOUNT ON
	DECLARE	 @exClientList TABLE (exclientId int PRIMARY KEY)
	IF OBJECT_ID ('tempdb.dbo.#MonitoringPolicy_ClientList') is not null DROP TABLE #MonitoringPolicy_ClientList
	CREATE TABLE #MonitoringPolicy_ClientList (clientId int)
	CREATE clustered index MonitoringPolicy_ClientListIndex on #MonitoringPolicy_ClientList(clientId)
	DECLARE @templateId integer
	DECLARE @NASClients TABLE(NASClientId INTEGER,ProxyClientId INTEGER)
	-- check if monitoringpolicy belongs to NAS client
	declare @isNas bit
	set @isNas=ISNULL((select 1 from APP_MonitoringPolicyProp WITH (NOLOCK)
	                     where attrName='OSType'
						 and attrVal='3' --NAS
						 and monitorPolicyId=@inputmonitoringPolicy),0)
	DECLARE @isWindows INT=0
	DECLARE @isUnix INT =0
	DECLARE @isHyperV INT =0
	--templateId=2 is for window event logs
	IF EXISTS (SELECT  1 from APP_MonitorTemplateAssoc WITH (NOLOCK) where monitorPolicyId=@inputMonitoringPolicy and templateId=2)
	OR EXISTS  (select 1 from APP_MonitoringPolicyProp WITH (NOLOCK)
	                     where ((attrName='OSType' and attrVal='1' ) --Windows OSType_WINDOWS
								 OR (attrName = 'Monitoring Type' and attrVal=4 ))    --UPLOADED_FILES
						 and monitorPolicyId=@inputmonitoringPolicy
				)
				SET @isWindows=1
				--template Id 5 is Sys Log tempalte.
	IF EXISTS (SELECT  1 from APP_MonitorTemplateAssoc WITH (NOLOCK) where monitorPolicyId=@inputMonitoringPolicy and templateId=5)
	OR EXISTS  (select 1 from APP_MonitoringPolicyProp WITH (NOLOCK)
	                     where attrName='OSType'
						 and attrVal='2' --Unix OSType_UNIX
						 and monitorPolicyId=@inputmonitoringPolicy
				)
				SET @isUnix=1
	IF EXISTS (SELECT 1 FROM APP_MonitoringPolicyProp WITH (NOLOCK)
				WHERE attrName='Monitoring Type' and attrVal='9' --HyperV Monitoring
				 and monitorPolicyId=@inputmonitoringPolicy
				 )
		SET @isHyperV=1
    IF(@isNas=1)
	BEGIN
	--get list of NAS Clients
		insert into @NASClients(NASCLientid)
select id from app_client with(nolock) where status & 0x0080 = 0x0080 and status & 0x00002  = 0
		update NAS
		set NAS.ProxyClientId = cast (Idaprop.attrVal as INT) 	from @NASClients NAS
inner join App_IdaName Ida with(nolock)	on NAS.NASClientId = Ida.ClientId and Ida.apptypeId = 33
		inner join App_IdaProp Idaprop with (nolock) on  Ida.id = Idaprop.componentNameId and Idaprop.attrName = N'FPOLICY PRIMARY CLIENT'
		where Idaprop.modified=0
		delete from @NASClients where ProxyClientId=0 or ProxyClientId is Null
	END
	select @templateId=templateId from APP_MonitorTemplateAssoc WITH (NOLOCK) where monitorPolicyId=@inputMonitoringPolicy
	--Case 1. Include All Clients and exclude some clients
	--If include all no need to consider clients for checking assoications, for saving associations client group assoications is also saved
	IF @lmOperationType = 2
	BEGIN
		-- @lmOperationType = 2 --> ReIndex LM Job. So initiate LM.EXE job in MA . So return only MA CLIENT ID INFO
		DECLARE @cloudId INT = (SELECT TOP 1 attrVal FROM APP_MonitoringPolicyProp WITH(NOLOCK) WHERE monitorPolicyId = @inputmonitoringPolicy and attrName = 'Cloud Id')
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
		CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
		exec DM2GetIndexServers 'Log Monitoring',0,@cloudId
		INSERT INTO #MonitoringPolicy_ClientList
		SELECT TOP 1 clientId
		FROM #getIndexServers
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	END
	ELSE if Exists(SELECT monitorAssocId FROM APP_MonitorAssocEntity WITH (NOLOCK)  WHERE monitorPolicyId=@inputMonitoringPolicy and flags=2)
	BEGIN
		INSERT INTO @exClientList
		select DISTINCT clientId from APP_MonitorAssocEntity WITH (NOLOCK) where monitorPolicyId=@inputMonitoringPolicy and flags=3  and exclude=1
		IF(@isNas=0)
		BEGIN
			IF(@isHyperV<>1)
			BEGIN
					INSERT INTO #MonitoringPolicy_ClientList
					select distinct C.id
					from APP_Client C WITH (NOLOCK) LEFT OUTER JOIN simOperatingSystem OS WITH (NOLOCK) ON simOperatingSystemId=OS.id
					where C.id not in ( select exclientId from @exClientList)
						and releaseId>=15
						and specialClientFlags&2<>2
						and ( (@isWindows=0  AND @isUnix=0 AND @isHyperV=0)
							OR(@isWindows=1 AND  TYPE='Windows' AND Os.id is NOT NULL)
							OR (@isUnix=1 AND  TYPE='Unix' AND OS.id is NOT NULL))
			END
			IF(@isHyperV=1)
			BEGIN
					INSERT INTO #MonitoringPolicy_ClientList
					select distinct C.id
from APP_Client C WITH (NOLOCK) JOIN simInstalledPackages IP WITH (NOLOCK) ON IP.ClientId=C.id and simPackageID=713
					where C.id not in ( select exclientId from @exClientList)
						and releaseId>=15
						and specialClientFlags&2<>2
			END
		END
		ELSE
		BEGIN
				  insert into #MonitoringPolicy_ClientList
                select distinct ProxyClientId from @NASClients where
                NASClientId not in(select exclientId from @exClientList)
		END
	END
	ELSE
	BEGIN
	IF(@isNas=0)
	  BEGIN
			IF(@isHyperV<>1)
			BEGIN
					INSERT INTO #MonitoringPolicy_ClientList
					select distinct C.id
					from APP_Client C WITH (NOLOCK)
					 JOIN  (select clientId
							 from  APP_ClientGroupAssoc WITH (NOLOCK)
							 where clientGroupId IN (select clientGroupId
										 from APP_MonitorAssocEntity WITH (NOLOCK)
										  where monitorPolicyId=@inputMonitoringPolicy
											and flags=28
											and exclude=0)
							UNION
	   						select clientId
		  					from APP_MonitorAssocEntity WITH (NOLOCK)
 								where monitorPolicyId=@inputMonitoringPolicy
 								and flags=3
										and exclude=0
						  )as  Tbl
						  ON clientId=C.id
						   LEFT OUTER JOIN simOperatingSystem OS WITH (NOLOCK) ON simOperatingSystemId=OS.id
					and releaseId>=15
					and specialClientFlags&2<>2
						and ( (@isWindows=0  AND @isUnix=0 AND @isHyperV=0)
								OR(@isWindows=1 AND  TYPE='Windows' AND Os.id is NOT NULL)
								OR (@isUnix=1 AND  TYPE='Unix' AND OS.id is NOT NULL))
			END
			IF(@isHyperV=1)
			BEGIN
					INSERT INTO #MonitoringPolicy_ClientList
					select distinct C.id
					from APP_Client C WITH (NOLOCK)
					 JOIN  (select clientId
							 from  APP_ClientGroupAssoc WITH (NOLOCK)
							 where clientGroupId IN (select clientGroupId
										 from APP_MonitorAssocEntity WITH (NOLOCK)
										  where monitorPolicyId=@inputMonitoringPolicy
											and flags=28
											and exclude=0)
							UNION
	   						select clientId
		  					from APP_MonitorAssocEntity WITH (NOLOCK)
 								where monitorPolicyId=@inputMonitoringPolicy
 								and flags=3
										and exclude=0
						  )as  Tbl
						  ON clientId=C.id
JOIN simInstalledPackages IP WITH (NOLOCK) ON IP.ClientId=C.id and simPackageID=713
					and releaseId>=15
					and specialClientFlags&2<>2
			END
		END
		ELSE --nas clients
		 BEGIN
				INSERT INTO #MonitoringPolicy_ClientList
				select distinct ProxyClientId from @NASClients inner join
				(
					select CGA.clientId from APP_ClientGroupAssoc  CGA with (NOLOCK)
					inner join App_MonitorAssocEntity MAE with (NOLOCK)  on CGA.clientGroupId=MAE.clientGroupId
					where MAE.monitorPolicyId=@inputMonitoringPolicy and MAE.flags=28 and MAE.exclude=0
				UNION
					select clientId
		  			from APP_MonitorAssocEntity WITH (NOLOCK)
 					where monitorPolicyId=@inputMonitoringPolicy
 					and flags=3
					and exclude=0
				) Selected
				on NASClientId=Selected.clientId
		 END
	END  -- all client selected else case.
	IF(@isNas=1)
	BEGIN
		--might have been added while adding proxies of NAS client
		delete from #MonitoringPolicy_ClientList where clientId  in (select id from app_client  WITH (NOLOCK) where releaseId<15 or specialClientFlags&2=2)
	END
	/*In case of cluster cs, check whether in active node and passive node packages for LM is installed.*/
	DECLARE @isCluserCSwithPackageInstalled INT = 0
	SET @isCluserCSwithPackageInstalled =ISNULL((
		SELECT TOP 1 packageTbl.id
		FROM APP_Client clientTbl
		INNER JOIN APP_VMToPMMap clusterTbl ON clientTbl.id = 2 /*CS clientId*/ AND clientTbl.id = clusterTbl.VMClientId
		INNER JOIN simInstalledPackages packageTbl ON clusterTbl.PMClientId = packageTbl.ClientId and (packageTbl.simPackageID=702 or packageTbl.simPackageID=1101)
		),0)
	if(@isReturnPackageNotInstallClient<>0)
	BEGIN
		select DISTINCT C.clientId ,
				ISNULL(simInstalledPackages.id,
				CASE WHEN (C.clientId=2 AND @isCluserCSwithPackageInstalled<>0) THEN @isCluserCSwithPackageInstalled
     			ELSE 0 END ),
				dbo.GetClientMangledHostName(C.clientId,NULL),
				NEWID()
		from  simInstalledPackages
		right outer join #MonitoringPolicy_ClientList C
			on C.clientId=simInstalledPackages.ClientId
			and (simPackageID=702 or simPackageID=1101)
		where
		(@iClientId=0 OR(C.clientId=@iClientId))
		order by NEWID()
	END
	ELSE
    BEGIN
		select DISTINCT C.clientId ,
				ISNULL(simInstalledPackages.id,
				CASE WHEN (C.clientId=2 AND @isCluserCSwithPackageInstalled<>0) THEN @isCluserCSwithPackageInstalled
     			ELSE 0 END ),
				dbo.GetClientMangledHostName(C.clientId,NULL),
				NEWID()
		from  simInstalledPackages
		join #MonitoringPolicy_ClientList C
			on C.clientId=simInstalledPackages.ClientId
			and (simPackageID=702 or simPackageID=1101)
		where
		(@iClientId=0 OR(C.clientId=@iClientId))
		order by NEWID()
	END
	SET NOCOUNT OFF
END

IF EXISTS (select * from GxQscripts where name = 'LMGetApplicableAssocForMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetApplicableAssocForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetApplicableAssocForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetApplicableAssocForMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'LMGetApplicableAssocForMonitoringPolicy',  '00010004006600110000', 'LMGetApplicableAssocForMonitoringPolicy', '00010004006600110000')
GO

