

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGetApplicableAssocCountForMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Saurabh Yadav
--	Date:   21/01/2016
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMGetApplicableAssocCountForMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='LMGetApplicableAssocCountForMonitoringPolicy')
	drop procedure LMGetApplicableAssocCountForMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='LMGetApplicableAssocCountForMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetApplicableAssocCountForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetApplicableAssocCountForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetApplicableAssocCountForMonitoringPolicy'
GO
print '... Creating Procedure: LMGetApplicableAssocCountForMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGetApplicableAssocCountForMonitoringPolicy
  @iMonitoringPolicyId INT
AS
  DECLARE @o_errorCode INT;
  DECLARE @o_noOfAssociations INT;
BEGIN
	SET NOCOUNT ON
	DECLARE @l_type INT = 0
	DECLARE @l_count INT = 0
	DECLARE @l_errorCode INT = 0
	SELECT @l_type = attrVal
	FROM APP_MonitoringPolicyProp WITH (NOLOCK)
	WHERE monitorPolicyId = @iMonitoringPolicyId AND attrName = 'Monitoring Type'
	SELECT @l_errorCode = @@ERROR
	IF @l_errorCode <> 0
		GOTO ERR_EXIT
	IF (@l_type <> 5)
	BEGIN
		DECLARE @ApplicableAssocForMonitoringPolicy TABLE (clientId INT, isPackageInstalled INT, clientMangledHostName NVARCHAR(1024), randomGUID NVARCHAR(1024))
		INSERT @ApplicableAssocForMonitoringPolicy
		EXEC LMGetApplicableAssocForMonitoringPolicy @iMonitoringPolicyId, 0, 1
		SELECT @l_errorCode = @@ERROR
		IF @l_errorCode <> 0
			GOTO ERR_EXIT
		DELETE P
		FROM @ApplicableAssocForMonitoringPolicy P, APP_Client AC WITH (NOLOCK)
		WHERE P.clientId = AC.Id
AND (AC.status & 0x00002) = 0x00002
		SELECT @l_errorCode = @@ERROR
		IF @l_errorCode <> 0
			GOTO ERR_EXIT
		DELETE 	@ApplicableAssocForMonitoringPolicy
		WHERE isPackageInstalled = 0
		SELECT @l_errorCode = @@ERROR
		IF @l_errorCode <> 0
			GOTO ERR_EXIT
		SELECT @l_count = ISNULL(COUNT(clientId),0)
		FROM @ApplicableAssocForMonitoringPolicy
		SELECT @l_errorCode = @@ERROR
		IF @l_errorCode <> 0
			GOTO ERR_EXIT
	END
	ELSE
	BEGIN
		SET @l_count = 1
	END
ERR_EXIT:
	SELECT @l_errorCode, @l_count
	SET NOCOUNT OFF
END

IF EXISTS (select * from GxQscripts where name = 'LMGetApplicableAssocCountForMonitoringPolicy')
	delete from GxQscripts where name = 'LMGetApplicableAssocCountForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGetApplicableAssocCountForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'LMGetApplicableAssocCountForMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'LMGetApplicableAssocCountForMonitoringPolicy',  '00000000000000000000', 'LMGetApplicableAssocCountForMonitoringPolicy', '00000000000000000000')
GO

