

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMGenerateGUIAuditData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMGenerateGUIAuditData.sp,v $ $Id: LMGenerateGUIAuditData.sp,v 1.1.2.5 2018/12/05 23:39:23 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='LMGenerateGUIAuditData')
BEGIN
	print '>>> Drop Stored Procedure: LMGenerateGUIAuditData <<<'
	drop procedure LMGenerateGUIAuditData
END
IF EXISTS (select * from GxQscripts where name='LMGenerateGUIAuditData')
	delete from GxQscripts where name = 'LMGenerateGUIAuditData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGenerateGUIAuditData')
	delete from GXDBVersions where aliasname = 'LMGenerateGUIAuditData'
GO
print '... Creating Procedure: LMGenerateGUIAuditData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMGenerateGUIAuditData
  @i_xml XML 
AS
  DECLARE @errorCode INTEGER
SET NOCOUNT ON
DECLARE @count INTEGER = 0
SET @count = ISNULL((SELECT TOP 1 value FROM GxGlobalParam WHERE name like 'LMGUIAuditIndexBucket' AND modified = 0),350)
--Logic to generate GUI audit
DECLARE @locId          integer = 0
DECLARE @startTime      integer = 0
DECLARE @endTime        integer = 0
DECLARE @lastOpId       integer = 0
DECLARE @lastOpIdOperation integer = 0
DECLARE @err            integer = 0
IF object_id('tempdb.dbo.#tempOpCount') IS NOT NULL DROP TABLE #tempOpCount
IF object_id('tempdb.dbo.#tempOpAuditLevel') IS NOT NULL DROP TABLE #tempOpAuditLevel
IF OBJECT_ID('tempdb.dbo.#TEGAM') IS NOT NULL DROP TABLE #TEGAM
IF OBJECT_ID('tempdb.dbo.#EvGuiAuditMessageTemp') IS NOT NULL DROP TABLE #EvGuiAuditMessageTemp
create table #tempOpCount ( opId int, msgSpanNum int)
create table #tempOpAuditLevel ( opId int, auditLevel int)
CREATE TABLE #TEGAM ( opId INT )
CREATE TABLE #EvGuiAuditMessageTemp
(
            evMsgId     integer,
            locId       integer,
            commcellId  integer,
            userId      integer,
            timeServer  integer,
            messageId   integer,
            opId        integer,
            paramId     integer,
            auditLevel  integer,
            entityType  integer,
            entityId    integer,
            oldMsgId    integer,
            newMsgId    integer,
            msgSpanNum  integer,
            messageText nvarchar(max),
            oldValue    nvarchar(max),
            newValue    nvarchar(max),
            isList      int default 0,
            listOpType  int default 0,
            hierarchyLevel	INT default 0,
            primary key (evMsgId, locId, commcellId),
);;
BEGIN TRY
	BEGIN TRAN
		SELECT  @lastOpId = ISNULL(MAX(opId), 0) FROM EvGuiAuditMessage WHERE locId = @locId
		DECLARE @maxOPID INTEGER = ISNULL((SELECT MAX(TopCount.id) FROM
											(SELECT DISTINCT TOP (@count) id FROM EvGuiAuditOperation WITH (NOLOCK) WHERE id > @lastOpId) as TopCount
									),0)
		IF @maxOPID <> 0 --If we got new data then expand
		BEGIN
			-- Retrieve GUI Audit events, default all event to AUDIT_TRAIL_LEVEL_HIGH = 0
			INSERT INTO #EvGuiAuditMessageTemp
			SELECT  a.id, @locId, a.commcellId, a.userId, a.timeServer, a.messageId, b.id, 0, 2, b.EntityType, b.EntityId, 0, 0, 0, N'', N'', N'',0,0,0
			FROM    EvMsg a WITH (NOLOCK) inner join EvGuiAuditOperation b on a.id = b.evMsgId and a.type = 2 and b.id > @lastOpId AND b.id <= @maxOPID
			SELECT  @lastOpIdOperation = ISNULL(MAX(opId), 0) FROM #EvGuiAuditMessageTemp WHERE locId = @locId
			INSERT INTO #EvGuiAuditMessageTemp
			SELECT  a.id, @locId, a.commcellId, a.userId, a.timeServer, a.messageId, b.opId, b.id, 2, 0, 0, 0, isnull(b.OldMsgId, 0), isnull(b.NewMsgId, 0), N'', isnull(b.OldValue, N''),isnull(b.NewValue, N''),b.IsList, b.listOpType,b.hierarchyLevel
			FROM    EvMsg a WITH (NOLOCK) inner join EvGuiAuditParameter b on a.id = b.evMsgId and a.type = 2 and b.opId > @lastOpId and b.opId <= @lastOpIdOperation
			INSERT INTO #tempOpCount
			SELECT  opId, COUNT(*)
			FROM    #EvGuiAuditMessageTemp
			WHERE   locId = @locId AND opId > @lastOpId AND msgSpanNum = 0
			GROUP BY opId
			UPDATE  #EvGuiAuditMessageTemp
			SET     msgSpanNum = b.msgSpanNum
			FROM    #EvGuiAuditMessageTemp a, #tempOpCount b
			WHERE   a.locId = @locId AND a.opId = b.opId
			INSERT INTO #tempOpAuditLevel
			SELECT  a.opId, Max(b.auditLevel)
			FROM    #EvGuiAuditMessageTemp a, EvGuiAuditLevel b
			WHERE   a.locId = @locId AND a.opId > @lastOpId AND a.messageId = b.opMsgId AND a.messageId > 0
			GROUP BY a.opId
			UPDATE  #EvGuiAuditMessageTemp
			SET     auditLevel = b.auditLevel
			FROM    #EvGuiAuditMessageTemp a, #tempOpAuditLevel b
			WHERE   a.locId = @locId AND a.opId = b.opId AND b.auditLevel > 0
			UPDATE  #EvGuiAuditMessageTemp
			SET     messageText = ISNULL(DBO.fn_EvFormatEventMsgText(evMsgId, @locId, messageId, 1, 2), '')
			WHERE   locId = @locId AND opId > @lastOpId
			--evMsgId, locId, commcellId
			MERGE EvGuiAuditMessage as EvGUIAudit
			USING (SELECT * FROM #EvGuiAuditMessageTemp) as EvGUITemp
			ON EvGUIAudit.evMsgid = EvGUITemp.evMsgid AND EvGUIAudit.locId = EvGUITemp.locId AND EvGUIAudit.commcellId = EvGUITemp.commcellId
			WHEN NOT MATCHED THEN INSERT(evMsgId, locId, commcellId, userId, timeServer, messageId, opId, paramId,
											auditLevel, entityType, entityId, oldMsgId, newMsgId, msgSpanNum,
												messageText, oldValue, newValue, isList, listOpType,hierarchyLevel)
								VALUES(EvGUITemp.evMsgId, EvGUITemp.locId, EvGUITemp.commcellId, EvGUITemp.userId, EvGUITemp.timeServer, EvGUITemp.messageId, EvGUITemp.opId, EvGUITemp.paramId,
											EvGUITemp.auditLevel, EvGUITemp.entityType, EvGUITemp.entityId, EvGUITemp.oldMsgId, EvGUITemp.newMsgId, EvGUITemp.msgSpanNum,
												EvGUITemp.messageText, EvGUITemp.oldValue, EvGUITemp.newValue, EvGUITemp.isList, EvGUITemp.listOpType, EvGUITemp.hierarchyLevel);;
		END
    COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @err = @@ERROR
	ROLLBACK TRAN
END CATCH
SELECT @err
GO

IF EXISTS (select * from GxQscripts where name = 'LMGenerateGUIAuditData')
	delete from GxQscripts where name = 'LMGenerateGUIAuditData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMGenerateGUIAuditData')
	delete from GXDBVersions where aliasname = 'LMGenerateGUIAuditData'
GO

insert into GXDBVersions values(2, 'LMGenerateGUIAuditData',  '00010001000200050000', 'LMGenerateGUIAuditData', '00010001000200050000')
GO

