

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/LMDashBoardOperations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/LMDashBoardOperations.sp,v $ $Id: LMDashBoardOperations.sp,v 1.8.12.8 2018/03/22 01:43:05 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: LMDashBoardOperations <<<'

IF EXISTS (select * from sysobjects where name='LMDashBoardOperations')
	drop procedure LMDashBoardOperations
IF EXISTS (select * from GxQscripts where name='LMDashBoardOperations')
	delete from GxQscripts where name = 'LMDashBoardOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMDashBoardOperations')
	delete from GXDBVersions where aliasname = 'LMDashBoardOperations'
GO
print '... Creating Procedure: LMDashBoardOperations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure LMDashBoardOperations
  @userId INTEGER,
  @inputxml_req xml,
  @o_xmlMsg xml		OUTPUT
AS
	DECLARE		@errorCode INTEGER = 0
	DECLARE		@errStr	NVARCHAR(MAX) = ''
	DECLARE 	@input XML = @inputxml_req
	DECLARE		@opertaionsType INTEGER = 0
	DECLARE		@creatorUserId	INTEGER = 1
	DECLARE		@dashBoardId INTEGER = 0
	DECLARE @entityType     int     = 9648
	DECLARE		@nowTime INTEGER = dbo.GetUnixTime(GetUTCDate());
	SET @opertaionsType = ISNULL((SELECT R.ref.value('@operationType','INTEGER') AS data FROM @input.nodes('LogMonitoring_DashBoardOperationReq') R ( ref )),0)
	BEGIN TRY
	BEGIN TRANSACTION LMDashBoardOperationsTran
	DECLARE @LMDashBoardTemp TABLE
		(
			dashboardID			integer,
			dashBoasrdName			nvarchar(1024),
			isPrivate			tinyint,
			creatorUserId		INTEGER,
			status 				INTEGER,
			appType				INTEGER,
			dashBoardProp		XML
		);
	DECLARE @LMDashBoard TABLE
		(
			searchId INTEGER,
			type INTEGER,
			userid INTEGER,
			userGroupId INTEGER,
			externalUserGroupId INTEGER,
			providerId INTEGER,
			capabilities BIGINT
		);
	INSERT INTO @LMDashBoardTemp
	SELECT
			ISNULL(ref.value('@dashBoardId','INTEGER'),0) as searchId,
			ISNULL(ref.value('@dashBoardName','NVARCHAR(1024)'),''),
			ISNULL(ref.value('@isPrivate','TINYINT'),1),
			(SELECT ISNULL(ref1.value('@userId','INTEGER'),0) as userid FROM @input.nodes('LogMonitoring_DashBoardOperationReq/dashBoardInfo/creator') R(ref1)) as creator,
			ISNULL(ref.value('@status','INTEGER'),0),
			ISNULL(ref.value('@appType','INTEGER'),1),
			ISNULL(ref.value('@dashBoardProp[1]','NVARCHAR(MAX)'),CAST('<LogMonitoring_DashBoardProp/>'  AS NVARCHAR(MAX)))
			FROM @input.nodes('LogMonitoring_DashBoardOperationReq/dashBoardInfo') R ( ref )
	--Set Operation
	IF(@opertaionsType = 5)
	BEGIN
			IF EXISTS (SELECT 1 FROM @LMDashBoardTemp WHERE dashBoasrdName = '' AND status <> 2)
			BEGIN
				--dbo.fn_EvFormatEventMsgText(0,@localeID,0,0,2)
				SET @errorCode = 5
				RAISERROR ('DashBoard name cannot be empty', -- Message text.
							16, -- Severity.
								1 -- State.
               );
			END
			DECLARE @creator INTEGER = 0;
			INSERT INTO LMDashBoard(dashBoardName,isPrivate,creatorUserId,status,created,modified,monitoringAppType,dashBoardProp)
			SELECT dashBoasrdName,isPrivate,creatorUserId,status,@nowTime,0,appType,dashBoardProp
			FROM
			@LMDashBoardTemp WHERE dashBoasrdName IS NOT NULL
			SET @dashBoardId = @@IDENTITY
			IF @dashBoardId IS NULL
			BEGIN
				SET @errorCode = 4
				RAISERROR ('Unable to create dash board', -- Message text.
							16, -- Severity.
								1 -- State.
               );
			END
			SELECT @creator = creatorUserId
			FROM LMDashBoard
			WHERE dashBoardId = @dashBoardId
			DECLARE @creatorCap BIGINT = CAST(POWER(2.0, 31  - 1) AS bigint) --View
											| CAST(POWER(2.0, 33 - 1) AS bigint)  -- Execute
												| CAST(POWER(2.0, 34 - 1) AS bigint) -- edit
													| CAST(POWER(2.0, 35 - 1) AS bigint) -- delete
			-- TO DO: What cap to see for clone support?
			--Insert creator information in UMUserandGroupEntityAssociation
			--INSERT INTO UMUserandGroupEntityAssociation
			--VALUES(@creator,0,0,@creatorCap,@entityType,@dashBoardId,0)
	END
	-- MODIFY Operation
	IF(@opertaionsType = 2)
	BEGIN
		IF EXISTS (SELECT 1 FROM @LMDashBoardTemp WHERE dashboardID <> 0 )
		BEGIN
			--update name
			UPDATE lmdash
			SET lmdash.dashBoardName = lmtemp.dashBoasrdName,lmdash.modified = @nowTime
			FROM @LMDashBoardTemp lmtemp INNER JOIN LMDashBoard lmdash
			ON lmtemp.dashboardID = lmdash.dashBoardId  AND (lmtemp.dashBoasrdName IS NOT NULL OR lmtemp.dashBoasrdName like '')
			--update private
			UPDATE lmdash
			SET lmdash.isPrivate = lmtemp.isPrivate,lmdash.modified = @nowTime
			FROM @LMDashBoardTemp lmtemp INNER JOIN LMDashBoard lmdash
			ON lmtemp.dashboardID = lmdash.dashBoardId  AND (lmtemp.isPrivate IS NOT NULL)
			--update status
			UPDATE lmdash
			SET lmdash.status = lmtemp.status,lmdash.modified = @nowTime
			FROM @LMDashBoardTemp lmtemp INNER JOIN LMDashBoard lmdash
			ON lmtemp.dashboardID = lmdash.dashBoardId  AND (lmtemp.status IS NOT NULL)
			--update dashBoardProp
			UPDATE lmdash
			SET lmdash.dashBoardProp = lmtemp.dashBoardProp, lmdash.modified = @nowTime
			FROM @LMDashBoardTemp lmtemp INNER JOIN LMDashBoard lmdash
			ON lmtemp.dashboardID = lmdash.dashBoardId AND (lmtemp.status IS NOT NULL)
			--TODO:dashboard assoc change
		END
	END
	--DELETE Operation
	IF(@opertaionsType = 3)
	BEGIN
		SET @creatorUserId = ISNULL((SELECT R.ref1.value('@userId','INTEGER') AS data FROM @input.nodes('LogMonitoring_DashBoardOperationReq/dashBoardInfo/creator') R(ref1)),1)
		--Here creator User Id is taken from db , not from webconsole.
		DECLARE @dasboardCreatorId INTEGER = (SELECT TOP 1 lmDashboard.creatorUserId FROM @LMDashBoardTemp lmDashboardTemp INNER JOIN LMDashBoard lmDashboard ON lmDashboard.dashBoardId = lmDashboardTemp.dashboardID)
		IF @dasboardCreatorId <> @userId
        BEGIN
            IF object_id('tempdb.dbo.#searchListTmp') is not null
            DROP TABLE #searchListTmp
create table  #searchListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
            EXEC dbo.sec_getuserObjects @userId, 2018, 2, '#searchListTmp'
            DECLARE @capabiliesWant  INT
            DECLARE @userHasRight INT
            SET @userHasRight = 0
SET @capabiliesWant = POWER(2, (1-1))
            IF EXISTS(SELECT 1 FROM #searchListTmp sec WHERE (capabilities & @capabiliesWant) <> 0 and
(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) )
            BEGIN
                SET @userHasRight = 1
            END
            IF @userHasRight = 0
            BEGIN
                SET @errorCode = 6
                --SET @err_message = 'User have no permission to make share operation'
                RAISERROR ('User have no permission to do dashboard operation', -- Message text.
                                    16, -- Severity.
                                        1 -- State.
                            );
                --goto ERROR_EXIT
            END
        END
		-- First get implicit all searches associated to dashboard.
		declare @LMSearchdeleteData table
		(
			searchId int,
			isImplicitShldDelete int
		)
		-- implictit searches associated to dashboard will be inserted into thie table
		insert into @LMSearchdeleteData
		select LMDashSearchAssoc.searchId , 1
		from @LMDashBoardTemp lmDashTemp inner join LMDashSearchAssoc on lmDashTemp.dashboardID = LMDashSearchAssoc.dashBoardId
		inner join LMUserSearch on LMUserSearch.searchId = LMDashSearchAssoc.searchId
		where IsNull(convert(xml,LMUserSearch.searchInfo).value('(/LogMonitoring_SearchURLInfo/@isImplicitSearch)[1]','int'),0) = 1
		-- check whether search is associated to alert
		update lmDashTemp
		set lmDashTemp.isImplicitShldDelete = 0
		from @LMSearchdeleteData lmDashTemp
		inner join LMUserSearch on LMUserSearch.searchId = lmDashTemp.searchId
		INNER JOIN APP_LMAlertInfo alertTbl
		ON alertTbl.SearchId = LMUserSearch.searchId
		-- check whether search is associated to schedule
		Update LMSearchdeleteData
		set isImplicitShldDelete = 0
		from @LMSearchdeleteData LMSearchdeleteData inner join TM_subtaskOptions WITH(NOLOCK)
		on LMSearchdeleteData.isImplicitShldDelete = 1
		and TM_subtaskOptions.optionId = 951244723
		and TM_subtaskOptions.value = convert(nvarchar(max),LMSearchdeleteData.searchId)
		inner join TM_subtask with (nolock) on
		TM_subtask.subtaskid = TM_subtaskOptions.subtaskId
		where TM_subtask.operationType = 5015
		-- Set the status of the search in the DB as 2
		DELETE FROM LMDashBoard WHERE dashBoardId IN (SELECT dashboardId
														FROM
														@LMDashBoardTemp WHERE creatorUserId = @creatorUserId and dashBoardId <> 0)
		DELETE FROM LMDashSearchAssoc WHERE dashBoardId IN (SELECT dashboardId
													FROM
													@LMDashBoardTemp WHERE creatorUserId = @creatorUserId and dashBoardId <> 0)
		delete LMUserSearch from LMUserSearch
		inner join @LMSearchdeleteData LMSearchdeleteData
		on LMUserSearch.searchId = LMSearchdeleteData.searchid
		and LMSearchdeleteData.isImplicitShldDelete = 1
		UPDATE LMUserSearch
		SET status = 2
		WHERE searchId NOT IN (SELECT searchId FROM LMDashSearchAssoc) AND status <> 1
		-- If dashboard is deleted , then associated shared dashboard also should be deleted.
		DECLARE @shareId INT
		DECLARE @dashBoardIdToDelete INT
		DECLARE cur_dashBoardIds CURSOR
		STATIC FOR
		SELECT dashboardId FROM @LMDashBoardTemp WHERE dashBoardId <> 0
		OPEN cur_dashBoardIds
			IF @@CURSOR_ROWS > 0
			BEGIN
				FETCH NEXT FROM cur_dashBoardIds INTO @dashBoardIdToDelete
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @shareId = (SELECT SharedEntityId FROM App_SharedEntityInfo where OriginalEntityId = @dashBoardIdToDelete and SharedEntityType = 137 ) -- 137 will filter only shared dashboard.
					EXEC sec_deleteSecurityAssociationsForEntity 9674, @shareId
					FETCH NEXT FROM cur_dashBoardIds INTO @dashBoardIdToDelete
				END
			END
		CLOSE cur_dashBoardIds
		DEALLOCATE cur_dashBoardIds
		DELETE shared
		FROM App_SharedEntityInfo shared
			INNER JOIN @LMDashBoardTemp lm
				ON shared.OriginalEntityId = lm.dashboardId AND  shared.SharedEntityType = 137   -- 137 will filter only shared dashboard.
		--End of deleting shared search details ;
	END
	COMMIT TRANSACTION LMDashBoardOperationsTran
	IF(@opertaionsType = 5)
	BEGIN
		SET @o_xmlMsg = ISNULL((SELECT dashBoardId as '@dashBoardId',
							dashBoardName as '@dashBoardName',
							isPrivate as '@isPrivate',
							status as '@status',
							CONVERT(NVARCHAR(MAX),dashBoardProp) as '@dashBoardProp',
							creatorUserId as 'creator/@userId'
							FROM LMDashBoard with (nolock) WHERE dashBoardId = @dashBoardId
							FOR XML PATH('dashBoardInfoList'),ROOT('LogMonitoring_DashBoardListResp')),'<LogMonitoring_DashBoardListResp/>')
	END
	ELSE
	BEGIN
		SET @o_xmlMsg = (SELECT @errorCode AS '@errorCode' FOR XML PATH ( 'LogMonitoring_GenericEntityResponse' ))
	END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRANSACTION LMDashBoardOperationsTran
	IF @errorCode =0 SET @errorCode = 1
	DECLARE @errorMessage NVARCHAR(4000) = ERROR_MESSAGE()
	SET @o_xmlMsg = (SELECT  @errorCode AS '@errorCode', @errorMessage AS '@errorString' FOR XML PATH ( 'LogMonitoring_GenericEntityResponse' ))
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'LMDashBoardOperations')
	delete from GxQscripts where name = 'LMDashBoardOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='LMDashBoardOperations')
	delete from GXDBVersions where aliasname = 'LMDashBoardOperations'
GO

insert into GXDBVersions values(2, 'LMDashBoardOperations',  '00010008001200080000', 'LMDashBoardOperations', '00010008001200080000')
GO

