

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JmGetTopJobPendingOrFailureReason.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  JmGetTopJobPendingOrFailureReason()
--  |
--  | Description:  Returns list of anomalous entity.
--  |
--  |       Input:  fromTime,toTime,jobTypeFilter
--  |
--  |      Output:  Returns the pending or failure reason for jobs in the given time frame
--  |				if a job started before the endtime(toTime) and is in pending/waiting state,
-- 	|				or if the job failed in the given time frame.
--  |      Return:  Pending Reason
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JmGetTopJobPendingOrFailureReason')
BEGIN
	print '>>> Drop Stored Procedure: JmGetTopJobPendingOrFailureReason <<<'
	drop procedure JmGetTopJobPendingOrFailureReason
END
IF EXISTS (select * from GxQscripts where name='JmGetTopJobPendingOrFailureReason')
	delete from GxQscripts where name = 'JmGetTopJobPendingOrFailureReason'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JmGetTopJobPendingOrFailureReason')
	delete from GXDBVersions where aliasname = 'JmGetTopJobPendingOrFailureReason'
GO
print '... Creating Procedure: JmGetTopJobPendingOrFailureReason'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JmGetTopJobPendingOrFailureReason
  @fromTime INT,
  @toTime INT,
  @jobTypeFilter INT,
  @localeId INT
AS
  DECLARE @message NVARCHAR(MAX)
  DECLARE @count INT
  DECLARE @state INT
  DECLARE @totaljobs INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#PendingAndFailedJobs') IS NOT NULL
 DROP TABLE #PendingAndFailedJobs
CREATE TABLE #PendingAndFailedJobs
(
	jobId INT,
	delayReasonId NVARCHAR(MAX),
	message NVARCHAR(MAX),
	state INT
)
IF (@jobTypeFilter & 1 > 0) OR (@jobTypeFilter & 8 > 0)
BEGIN
	INSERT INTO #PendingAndFailedJobs(jobId,message,state)
		SELECT jobId,RB.delayReason,RB.state
		FROM RunningBackups RB
		INNER JOIN App_Client Client ON RB.clientId = Client.id
		WHERE jobStartTime < @toTime
		AND
			(
(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) > 0 AND (@jobTypeFilter & 8) <> 0)
				OR
(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) = 0 AND (@jobTypeFilter & 1) <> 0)
			)
		AND RB.state IN (2,3,15) --CVJobState_PENDING,CVJobState_WAITING,CVJobState_QUEUED
	INSERT INTO #PendingAndFailedJobs(jobId,delayReasonId,state)
		SELECT jobId,failureReason,0
		FROM JMBKPStats Bkp
		INNER JOIN App_Application Subclient ON Bkp.appId = SubClient.id
		INNER JOIN App_Client Client ON Client.id = Subclient.clientID
		WHERE servEndDate BETWEEN @fromTime AND @toTime
		AND
		     (
(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) > 0 AND (@jobTypeFilter & 8) <> 0)
				OR
(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) = 0 AND (@jobTypeFilter & 1) <> 0)
			 )
		AND Bkp.status IN (2,3,4,14,15) -- (_CVJobStatus::Fail,_CVJobStatus::PARTIALSUCCESS,_CVJobStatus::KILLED,_CVJobStatus::JMSUCCESSWITHWARNINGS,_CVJobStatus::SYSTEMFAILED)
END
IF (@jobTypeFilter & 2 > 0)
BEGIN
	INSERT INTO #PendingAndFailedJobs(jobId,message,state)
		SELECT jobId,delayReason,state
		FROM RunningRestores
		WHERE jobStartTime < @toTime
		AND state IN (2,3,15) --CVJobState_PENDING,CVJobState_WAITING
	INSERT INTO #PendingAndFailedJobs(jobId,delayReasonId,state)
		SELECT jobId,failureReason,0
		FROM JMRestoreStats
		WHERE servEndTime BETWEEN @fromTime AND @toTime
		AND status IN (2,3,4,14,15) -- (_CVJobStatus::Fail,_CVJobStatus::PARTIALSUCCESS,_CVJobStatus::KILLED,_CVJobStatus::JMSUCCESSWITHWARNINGS,_CVJobStatus::SYSTEMFAILED)
END
IF (@jobTypeFilter & 4 > 0)
BEGIN
	INSERT INTO #PendingAndFailedJobs(jobId,message,state)
		SELECT jobId,delayReason,state
		FROM RunningAdminJobs
		WHERE jobStartTime < @toTime
		AND state IN (2,3,15) --CVJobState_PENDING,CVJobState_WAITING,CVJobState_QUEUED
AND opType NOT IN (17,39,92,35,36,67,68,84,64,90)
	INSERT INTO #PendingAndFailedJobs(jobId,delayReasonId,state)
		SELECT jobId,failureReason,0
		FROM JMAdminJobStatsTable
		WHERE servEnd BETWEEN @fromTime AND @toTime
		AND status IN (2,3,4,14,15) -- (_CVJobStatus::Fail,_CVJobStatus::PARTIALSUCCESS,_CVJobStatus::KILLED,_CVJobStatus::JMSUCCESSWITHWARNINGS,_CVJobStatus::SYSTEMFAILED)
AND opType NOT IN (17,39,92,35,36,67,68,84,64,90)
END
UPDATE #PendingAndFailedJobs
SET message = dbo.JMGetLocalizedMessageMaxFunc(@localeId,delayReasonId)
WHERE delayReasonId IS NOT NULL
;WITH cte AS
(
	SELECT *,DENSE_RANK()  OVER(PARTITION BY A.state ORDER BY A.cnt DESC)R
	FROM (SELECT message,state,COUNT(1) AS cnt
		  FROM #PendingAndFailedJobs
		  WHERE LEN(message)>0
		  GROUP BY message,state) A
)
SELECT message, cnt, TotalJobs.state, totaljobs
		FROM cte
		RIGHT JOIN
		(SELECT state, COUNT(1) AS totaljobs
		  FROM #PendingAndFailedJobs
		  GROUP BY state)TotalJobs
		  ON TotalJobs.state = cte.state
		  WHERE R<=5 OR R is NULL
		  ORDER BY R
IF OBJECT_ID('tempdb.dbo.#PendingAndFailedJobs') IS NOT NULL
 DROP TABLE #PendingAndFailedJobs
GO

IF EXISTS (select * from GxQscripts where name = 'JmGetTopJobPendingOrFailureReason')
	delete from GxQscripts where name = 'JmGetTopJobPendingOrFailureReason'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JmGetTopJobPendingOrFailureReason')
	delete from GXDBVersions where aliasname = 'JmGetTopJobPendingOrFailureReason'
GO

insert into GXDBVersions values(2, 'JmGetTopJobPendingOrFailureReason',  '00000000000000000000', 'JmGetTopJobPendingOrFailureReason', '00000000000000000000')
GO

