

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateXMLJobInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdateXMLJobInfo()
--  |				 Description:  Update job xml
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateXMLJobInfo <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateXMLJobInfo')
	drop procedure JMUpdateXMLJobInfo
IF EXISTS (select * from GxQscripts where name='JMUpdateXMLJobInfo')
	delete from GxQscripts where name = 'JMUpdateXMLJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateXMLJobInfo')
	delete from GXDBVersions where aliasname = 'JMUpdateXMLJobInfo'
GO
print '... Creating Procedure: JMUpdateXMLJobInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateXMLJobInfo
  @i_jobId integer,
  @i_commcellId integer,
  @i_xml nvarchar(max)
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
SET @errorCode = 0
IF EXISTS (SELECT * FROM JMJobInfo WHERE commCellId = @i_commcellId AND jobId = @i_jobId)
BEGIN
	UPDATE JMJobInfo SET xmlJobInfo = @i_xml
	WHERE commCellId = @i_commcellId AND jobId = @i_jobId
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	GOTO PROC_EXIT
END
IF EXISTS (SELECT * FROM JMJobStats WHERE commCellId = @i_commcellId AND jobId = @i_jobId)
BEGIN
	UPDATE JMJobStats SET xmlJobInfo = @i_xml
	WHERE commCellId = @i_commcellId AND jobId = @i_jobId
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	GOTO PROC_EXIT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = -1
END CATCH;
PROC_EXIT:
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateXMLJobInfo')
	delete from GxQscripts where name = 'JMUpdateXMLJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateXMLJobInfo')
	delete from GXDBVersions where aliasname = 'JMUpdateXMLJobInfo'
GO

insert into GXDBVersions values(2, 'JMUpdateXMLJobInfo',  '00000000000000000000', 'JMUpdateXMLJobInfo', '00000000000000000000')
GO

