

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateVsaParentJobStats.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdateVsaParentJobStats()
--  |				 Description:  Update JobStats for VSA Parent Job when child VM job stats being updated
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateVsaParentJobStats.sp,v $ $Id: JMUpdateVsaParentJobStats.sp,v 1.1.2.6 2020/06/25 03:47:54 bzhu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMUpdateVsaParentJobStats')
BEGIN
	print '>>> Drop Stored Procedure: JMUpdateVsaParentJobStats <<<'
	drop procedure JMUpdateVsaParentJobStats
END
IF EXISTS (select * from GxQscripts where name='JMUpdateVsaParentJobStats')
	delete from GxQscripts where name = 'JMUpdateVsaParentJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateVsaParentJobStats')
	delete from GXDBVersions where aliasname = 'JMUpdateVsaParentJobStats'
GO
print '... Creating Procedure: JMUpdateVsaParentJobStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateVsaParentJobStats
  @i_jobId integer,
  @i_commCellId integer,
  @i_needStatsUpdate integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
	SET @errorCode = 0
	IF @i_jobId <= 0
	BEGIN
		SET @errorCode = @i_jobId
		GOTO ERROR_EXIT
	END
	DECLARE @parentJobId INT = 0
	DECLARE @lastUpdateFromClient INT = 0
SELECT @parentJobId = parentJobId FROM JMJobDataLink JDL WITH(NOLOCK) WHERE JDL.commCellId = @i_commCellId AND JDL.childJobId = @i_jobId AND linkType = 7
	IF @parentJobId > 0
	BEGIN
		IF @i_needStatsUpdate = 1
		BEGIN
			DECLARE @totalB BIGINT = 0,
				@totalUB  BIGINT = 0,
				@totNwTransTime BIGINT = 0,
				@nwTransBytes BIGINT = 0,
				@totalMediaUsageTime BIGINT = 0,
				@averageThroughput FLOAT = 0
			SELECT  @totalB = ISNULL(SUM(ISNULL(compBytes, 0)), 0),
				@totalUB = ISNULL(SUM(ISNULL(unCompBytes, 0)), 0),
				@nwTransBytes = ISNULL(SUM(ISNULL(nwTransBytes, 0)), 0),
				@totNwTransTime = ISNULL(SUM(ISNULL(totNwTransTime, 0)), 0)
			FROM JMBkpJobInfo JMB WITH(NOLOCK)
				INNER JOIN JMJobDataLink jLink WITH(NOLOCK)
ON JMB.jobID = jLink.childJobId AND JMB.commcellId = jLink.commCellId AND jLink.linkType = 7
				AND jLink.parentJobId = @parentJobId
				AND jLink.commCellId = @i_commCellId
			SELECT @totalB = @totalB  + ISNULL(SUM(ISNULL(totalCompBytes, 0)), 0),
				@totalUB = @totalUB  + ISNULL(SUM(ISNULL(totalUncompBytes, 0)), 0),
				@nwTransBytes = @nwTransBytes + ISNULL(SUM(ISNULL(nwTransBytes, 0)), 0)
			FROM JMBkpStats JMB WITH(NOLOCK)
				INNER JOIN JMJobDataLink jLink WITH(NOLOCK)
ON JMB.jobID = jLink.childJobId AND JMB.commcellId = jLink.commCellId AND jLink.linkType = 7
				AND jLink.parentJobId = @parentJobId AND jLink.commCellId = @i_commCellId
				AND JMB.status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
			-- totalMediaUsageTime will be used to calculate throughput
			-- for VSA parent job, will use accumulated elapsedTime from each backup attempt
			select @totalMediaUsageTime = ISNULL((dbo.GetUnixTime(GetUTCDate()) - attemptStartTime), 0) from JMJobInfo where jobId = @parentJobId and commCellId = @i_commCellId
			select @totalMediaUsageTime = @totalMediaUsageTime + ISNULL(sum (ISNULL(elapsedTime, 0)), 0) from JMBkpAttemptInfo where jobId = @parentJobId and commCellId = @i_commCellId and phaseNum = 4 /* BACKUP phase */
			SET @averageThroughput = 0
			IF @totalMediaUsageTime <> 0
				SET @averageThroughput = (((@totalUB*60.0*60)/(@totalMediaUsageTime))/(1024.0 * 1024* 1024))
			UPDATE JMBkpJobInfo
			SET compBytes = @totalB,
				unCompBytes = @totalUB,
				nwTransBytes = @nwTransBytes,
				totNwTransTime = @totNwTransTime,
				totalMediaUsageTime = @totalMediaUsageTime,
				averageThroughput = @averageThroughput
			WHERE jobId = @parentJobId AND commCellId = @i_commCellId
	END
		SET @lastUpdateFromClient = (SELECT lastUpdateFromClient FROM JMJobInfo WITH(NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId)
		UPDATE JMJobInfo
		SET lastUpdateFromClient = @lastUpdateFromClient
		WHERE jobId = @parentJobId AND commCellId = @i_commCellId AND @lastUpdateFromClient > lastUpdateFromClient
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
END CATCH;
ERROR_EXIT:
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateVsaParentJobStats')
	delete from GxQscripts where name = 'JMUpdateVsaParentJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateVsaParentJobStats')
	delete from GXDBVersions where aliasname = 'JMUpdateVsaParentJobStats'
GO

insert into GXDBVersions values(2, 'JMUpdateVsaParentJobStats',  '00010001000200060000', 'JMUpdateVsaParentJobStats', '00010001000200060000')
GO

