

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateSnapTapeWF.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdateSnapTapeWF()
--  |				 Description:  Update SnapToTape WF Info
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateSnapTapeWF.sp,v $ $Id: JMUpdateSnapTapeWF.sp,v 1.1.2.4.50.1 2021/01/21 23:17:06 bzhu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMUpdateSnapTapeWF')
BEGIN
	print '>>> Drop Stored Procedure: JMUpdateSnapTapeWF <<<'
	drop procedure JMUpdateSnapTapeWF
END
IF EXISTS (select * from GxQscripts where name='JMUpdateSnapTapeWF')
	delete from GxQscripts where name = 'JMUpdateSnapTapeWF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateSnapTapeWF')
	delete from GXDBVersions where aliasname = 'JMUpdateSnapTapeWF'
GO
print '... Creating Procedure: JMUpdateSnapTapeWF'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMUpdateSnapTapeWF
  @i_jobId integer,
  @i_commcellId integer,
  @i_jobIdToSnapTape integer,
  @i_newSubmitStatus integer,
  @i_newJobIdOfSnapTapeJob integer,
  @i_appId integer,
  @i_updateChildJobStatus integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
	DECLARE @tranCnt INT = @@TRANCOUNT
	IF (@tranCnt > 0)
	BEGIN
	   SAVE TRAN JMUpdateSnapTapeWF_Tran
	END
	ELSE
	BEGIN
	   BEGIN TRAN JMUpdateSnapTapeWF_Tran
	END
	SET @errorCode = 0
	IF @i_appId <> 0  -- Reference Copy Work Flow
	BEGIN
		UPDATE JMJobWF SET childJobId = case @i_newJobIdOfSnapTapeJob WHEN 0 THEN childJobId ELSE @i_newJobIdOfSnapTapeJob END, submitStatus = @i_newSubmitStatus
		WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND applicationId = @i_appId
	END
	ELSE
	BEGIN
		UPDATE JMJobWF SET childJobId = case @i_newJobIdOfSnapTapeJob WHEN 0 THEN childJobId ELSE @i_newJobIdOfSnapTapeJob END, submitStatus = @i_newSubmitStatus
		WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND processedJobId = @i_jobIdToSnapTape
	END
	IF @i_appId = 0 AND @i_jobIdToSnapTape <> 0 AND @i_updateChildJobStatus <> 0
	BEGIN
	   -- for VSA snap parent job, needs to update its child job entries as well
	   DECLARE @bkpAttributesEx BIGINT = 0
	   SELECT @bkpAttributesEx = bkpAttributesEx FROM JMBkpStats JMBS WITH(NOLOCK)
	   WHERE JMBS.jobId = @i_jobIdToSnapTape AND JMBS.commcellId = @i_commcellId
IF @bkpattributesEx & 0x40000000 = 0x40000000  -- Parent VM job for Indexing V2
	   BEGIN
	     UPDATE JMJobWF
	     SET submitStatus = @i_newSubmitStatus
	     FROM JMJobWF WF INNER JOIN JMJobDataLink LNK WITH(NOLOCK)
	     ON WF.processedJobId = LNK.childJobId AND WF.commcellId = LNK.commCellId
	     WHERE WF.jobId = @i_jobId
		     AND WF.commcellId = @i_commcellId
		     AND LNK.parentJobId = @i_jobIdToSnapTape
		     AND LNK.linkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD_DEF
	   END
	END
	IF (@tranCnt = 0)
	BEGIN
	   COMMIT TRAN JMUpdateSnapTapeWF_Tran
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRAN JMUpdateSnapTapeWF_Tran
END CATCH;
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateSnapTapeWF')
	delete from GxQscripts where name = 'JMUpdateSnapTapeWF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateSnapTapeWF')
	delete from GXDBVersions where aliasname = 'JMUpdateSnapTapeWF'
GO

insert into GXDBVersions values(2, 'JMUpdateSnapTapeWF',  'v1.1.2.4.50.1', 'JMUpdateSnapTapeWF', 'v1.1.2.4.50.1')
GO

