

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateSLA.sp] ---------- 

-- ----------------------------------------------------------------------
--	Description:
--		Update SLA status in RptSLA, RptSLASubclient and RptSLAClient
--		tables when the given backup, snap or backup copy job finished.
--
--		For VSA jobs, the input jobId should be the child jobId of a VM.
--
--		This is not applicable for synthetic full jobs.
-- ----------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateSLA.sp,v $ $Id: JMUpdateSLA.sp,v 1.1.2.5 2020/11/03 01:29:54 junlu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMUpdateSLA')
BEGIN
	print '>>> Drop Stored Procedure: JMUpdateSLA <<<'
	drop procedure JMUpdateSLA
END
IF EXISTS (select * from GxQscripts where name='JMUpdateSLA')
	delete from GxQscripts where name = 'JMUpdateSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateSLA')
	delete from GXDBVersions where aliasname = 'JMUpdateSLA'
GO
print '... Creating Procedure: JMUpdateSLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMUpdateSLA
  @i_jobId integer
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
SET DEADLOCK_PRIORITY LOW;
SET	@retVal = 0
DECLARE @i_appId		INT
DECLARE @i_appType		INT
DECLARE @i_opType		INT
DECLARE @i_startTime	INT
DECLARE @i_jobStatus	INT
DECLARE @i_vmStatus		INT
DECLARE @i_jobIdActedOn	INT
DECLARE @i_clientId		INT = 0
DECLARE @i_category		INT = 1
DECLARE	@i_fromHour		INT = 8
DECLARE @i_startDate	DATETIME
DECLARE @i_currDate		DATETIME
DECLARE @i_slaDate		DATETIME
DECLARE @i_slaDays		INT
DECLARE @i_slaDaysLevel	VARCHAR(32)
DECLARE @oldCategory	INT
DECLARE @clientCategory	INT
DECLARE @i_fullCycleNum INT
DECLARE @i_bkpLevel		INT
DECLARE @i_initFrom		INT
DECLARE @i_dataArchGrpId	INT = 0
DECLARE @SnapJobsQualifySLA INT = 0
DECLARE @SnapMetSLAIfBackupCopyDisabled INT = 0
DECLARE @TblEntitySLA TABLE (id INT, nSubclients INT, nMetSLA INT)
BEGIN TRY
IF EXISTS (SELECT 1 FROM GxGlobalParam WITH (NOLOCK) WHERE name = 'JMSkipUpdateSLA' AND value = 1 AND modified = 0)
BEGIN
	SELECT 0
	RETURN
END
SELECT	@i_appId = appId, @i_appType = appType, @i_dataArchGrpId = dataArchGrpId, @i_opType = opType,
		@i_startTime = servStartDate, @i_jobStatus = status, @i_jobIdActedOn = jobIdActedOn,
		@i_fullCycleNum = fullCycleNum, @i_bkpLevel = bkpLevel, @i_initFrom = initFrom
FROM	JMBkpStats
WHERE	jobId = @i_jobId AND commcellId = 2
IF @i_opType NOT IN (4, 14, 18, 30, 43, 59, 60, 65, 76, 87, 91, 94, 97, 98, 101)
	OR @i_opType = 60 AND @i_jobStatus NOT IN (1, 3, 14)
	OR NOT ((@i_fullCycleNum = 1 AND @i_bkpLevel = 1) OR @i_initFrom = 2) -- Only proceed when the job is IMMEDIATE OR it's the first backup job of the subclient
BEGIN
	SELECT 0
	RETURN
END
IF @i_opType = 60
BEGIN
	SELECT	@i_appId = appId, @i_appType = appType, @i_dataArchGrpId = dataArchGrpId, @i_startTime = servStartDate
	FROM	JMBkpStats
	WHERE	jobId = @i_jobIdActedOn AND commcellId = 2
END
DECLARE @csTimeZoneName NVARCHAR(255) = ''
SELECT	@csTimeZoneName = dbo.GetClientTimeZone(2)
IF ISNULL(@csTimeZoneName, '') = ''
BEGIN
	SELECT  @csTimeZoneName = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
	SELECT	@csTimeZoneName = TimeZoneStdName
	FROM	SchedTimeZone WITH (NOLOCK)
	WHERE   TimeZoneName = SUBSTRING(@csTimeZoneName, CHARINDEX(':', @csTimeZoneName, CHARINDEX(':', @csTimeZoneName, 0) + 1) + 1, 255)
END
SELECT	@i_fromHour = CAST(value AS INT)
FROM	GXGlobalParam WITH (NOLOCK)
WHERE	name = 'SLA time window hour'
SET @i_startDate = DATEADD(SS, @i_startTime, '1970-01-01')
SET @i_startDate = dbo.UTCToLocalDateTimeConversionManaged(@i_startDate, @csTimeZoneName)
SET @i_slaDate = CAST(@i_startDate AS DATE)
SET @i_slaDate = DATEADD(HH, @i_fromHour, @i_slaDate)
IF  @i_slaDate > @i_startDate
	SET @i_slaDate = DATEADD(DD, -1, @i_slaDate)
IF @i_opType IN (59, 65)
BEGIN
	SELECT	@SnapJobsQualifySLA = longVal
	FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3303 AND modified = 0
	IF @SnapJobsQualifySLA = 0
	BEGIN
		SELECT	@SnapMetSLAIfBackupCopyDisabled = longVal
		FROM	APP_ComponentProp WITH (NOLOCK)
WHERE	componentType = 1 AND componentId = 2 AND propertyTypeId = 3312 AND modified = 0
		IF @SnapMetSLAIfBackupCopyDisabled > 0
			AND NOT EXISTS (SELECT 1 FROM archMaterializeSnapshotProp WHERE archGroupId = @i_dataArchGrpId)
			AND NOT EXISTS (SELECT 1 FROM archGroup AG INNER JOIN archGroupCopy AGC ON AG.id = AGC.archGroupId AND AG.id = @i_dataArchGrpId
					WHERE AGC.isActive = 1 AND AGC.isSnapCopy = 1 AND AGC.isMirrorCopy = 0 AND AGC.id <> AG.defaultSnapCopy)
			SET @SnapJobsQualifySLA = 1
	END
END
IF @i_appType = 106
	SELECT	@i_clientId = VMClientId, @i_vmStatus = CAST(attrVal AS INT)
	FROM	APP_VMProp
	WHERE	ClientJobId = @i_jobId AND commCellId = 2 AND attrName = 'vmStatus'
ELSE
	SELECT	@i_clientId = clientId
	FROM	APP_Application WITH (NOLOCK)
	WHERE	id = @i_appId
SELECT	@i_currDate = date, @oldCategory = category, @i_slaDays = slaDays, @i_slaDaysLevel = slaDaysLevel
FROM	RptSLASubclient
WHERE	clientId = @i_clientId AND (appTypeId = 106 OR appId = @i_appId) AND fullJobsOnly = 0
IF @oldCategory IS NULL
	SELECT	@i_slaDays = slaDays, @i_slaDaysLevel = slaDaysLevel
	FROM	dbo.GetSLADays(@i_clientId, @i_appType, @i_appId)
SELECT	@clientCategory = category
FROM	RptSLAClient
WHERE	days = -1 AND clientId = @i_clientId AND fullJobsOnly = 0
IF @i_appType = 106
BEGIN
	IF @i_vmStatus NOT IN (0, 3)
		SET @i_category = 2
	ELSE
	IF @i_opType IN (59, 65)
		SET @i_category = 12
	IF @i_category IN (1, 2, 12)
	BEGIN
		IF EXISTS (SELECT 1 FROM RptSLA WHERE date = @i_slaDate AND clientId = @i_clientId AND appTypeId = 106 AND fullJobsOnly = 0)
			UPDATE RptSLA SET appId = @i_appId, status = @i_category, category = @i_category
			WHERE  date = @i_slaDate AND clientId = @i_clientId AND appTypeId = 106 AND fullJobsOnly = 0
				AND category NOT IN (1, 13, @i_category)
		ELSE
			INSERT INTO RptSLA VALUES (@i_slaDate, @i_clientId, @i_appId, 0, 106, @i_category, @i_category, 0)
	END
	IF @i_category = 12 AND @SnapJobsQualifySLA = 1
		SET @i_category = 1
	IF @oldCategory IS NULL
		INSERT INTO RptSLASubclient
		SELECT @i_slaDate, @i_clientId, @i_appId, 0, 106, CASE WHEN @i_category = 1 THEN 1 ELSE 2 END, @i_category, 0,  @i_slaDays, @i_slaDaysLevel
	ELSE
	IF (@oldCategory > 1 AND @i_category = 1 OR @oldCategory IN (2,3,4) AND @i_category = 12 OR @oldCategory IN (3,4) AND @i_category = 2)
	AND DATEADD(DAY, -@i_slaDays, @i_currDate) < @i_startDate
		UPDATE	RptSLASubclient SET status = @i_category, category = @i_category
		WHERE	clientId = @i_clientId AND appTypeId = 106 AND fullJobsOnly = 0
	IF @clientCategory IS NULL
		INSERT INTO RptSLAClient
		SELECT @i_slaDate, -1, 0, @i_clientId, CASE WHEN @i_category = 1 THEN 1 ELSE 2 END, @i_category
	ELSE
	IF (@clientCategory > 1 AND @i_category = 1 OR @clientCategory IN (2,3,4) AND @i_category = 12 OR @clientCategory IN (3,4) AND @i_category = 2)
	AND DATEADD(DAY, -@i_slaDays, @i_currDate) < @i_startDate
		UPDATE	RptSLAClient SET status = CASE WHEN @i_category = 1 THEN 1 ELSE 2 END, category = @i_category
		WHERE	days = -1 AND clientId = @i_clientId AND fullJobsOnly = 0
END
ELSE
BEGIN
	IF @i_jobStatus NOT IN (1, 3, 14)
	OR @i_jobStatus = 3 AND NOT EXISTS (SELECT 1 FROM APP_iDAType WHERE type = @i_appType AND isCWEjobValid = 1)
		SET @i_category = 2
	ELSE
	IF @i_opType IN (59, 65)
		SET @i_category = 12
	IF @i_category IN (1, 2, 12)
	BEGIN
		IF EXISTS (SELECT 1 FROM RptSLA WHERE date = @i_slaDate AND appId = @i_appId AND appTypeId <> 106 AND fullJobsOnly = 0)
			UPDATE RptSLA SET status = @i_category, category = @i_category
			WHERE  date = @i_slaDate AND appId = @i_appId AND appTypeId <> 106 AND fullJobsOnly = 0
				AND category NOT IN (1, 13, @i_category)
		ELSE
			INSERT INTO RptSLA VALUES (@i_slaDate, @i_clientId, @i_appId, 0, @i_appType, @i_category, @i_category, 0)
	END
	IF @i_category = 12 AND @SnapJobsQualifySLA = 1
		SET @i_category = 1
	IF @oldCategory IS NULL
		INSERT INTO RptSLASubclient
		SELECT @i_slaDate, @i_clientId, @i_appId, 0, @i_appType, CASE WHEN @i_category = 1 THEN 1 ELSE 2 END, @i_category, 0, @i_slaDays, @i_slaDaysLevel
	ELSE
	IF (@oldCategory > 1 AND @i_category = 1 OR @oldCategory IN (2,3,4) AND @i_category = 12 OR @oldCategory IN (3,4) AND @i_category = 2)
	AND DATEADD(DAY, -@i_slaDays, @i_currDate) < @i_startDate
		UPDATE	RptSLASubclient SET status = @i_category, category = @i_category
		WHERE	clientId = @i_clientId AND appId = @i_appId AND appTypeId <> 106 AND fullJobsOnly = 0
	IF @clientCategory IS NULL
		INSERT INTO RptSLAClient
		SELECT @i_slaDate, -1, 0, @i_clientId, CASE WHEN @i_category = 1 THEN 1 ELSE 2 END, @i_category
	ELSE
	IF @i_category = 1
	AND NOT EXISTS (SELECT 1 FROM RptSLASubclient WHERE fullJobsOnly = 0 AND clientId = @i_clientId AND category IN (2, 3, 4, 12))
		UPDATE	RptSLAClient SET status = CASE WHEN @i_category = 1 THEN 1 ELSE 2 END, category = @i_category
		WHERE	days = -1 AND clientId = @i_clientId AND fullJobsOnly = 0
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@retVal = 1
END CATCH
SELECT	@retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateSLA')
	delete from GxQscripts where name = 'JMUpdateSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateSLA')
	delete from GXDBVersions where aliasname = 'JMUpdateSLA'
GO

insert into GXDBVersions values(2, 'JMUpdateSLA',  '00010001000200050000', 'JMUpdateSLA', '00010001000200050000')
GO

