

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateReferenceCopyInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdateReferenceCopyInfo()
--  |				 Description:  Update reference copy job information
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateReferenceCopyInfo.sp,v $ $Id: JMUpdateReferenceCopyInfo.sp,v 1.6.34.2 2018/03/22 02:58:16 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateReferenceCopyInfo <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateReferenceCopyInfo')
	drop procedure JMUpdateReferenceCopyInfo
IF EXISTS (select * from GxQscripts where name='JMUpdateReferenceCopyInfo')
	delete from GxQscripts where name = 'JMUpdateReferenceCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateReferenceCopyInfo')
	delete from GXDBVersions where aliasname = 'JMUpdateReferenceCopyInfo'
GO
print '... Creating Procedure: JMUpdateReferenceCopyInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateReferenceCopyInfo
  @i_refJobId integer,
  @i_refAppId integer,
  @i_status integer
AS
  DECLARE @count integer;
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
	DECLARE @isArchiveIndexSuccessFul	integer
	DECLARE @phaseNum					integer
SET @errorCode = 0
	SET @phaseNum	= 0
	SET @isArchiveIndexSuccessFul = 0
	IF @i_status > 0
	BEGIN
	-- Update the reference time if the
		UPDATE JMReferenceCopy SET referenceTime = tempRefTime WHERE refJobId = @i_refJobId and commcellId =2 and refAppId = @i_refAppId and tempRefTime > 0 And flag IN (4,5,6,7)/*SUCCESS,SUCCESS_WARNINGS,SUCCESS_ERRORS,SUCCESS_NOTHING_MATCHED*/
	SET @count = @@ROWCOUNT
	END
	-- Clean the temp referenceTime
	UPDATE JMReferenceCopy SET tempRefTime = 0, flag =0 WHERE refJobId = @i_refJobId and commcellId =2
	IF (not exists(select *From APP_SubClientProp where componentNameId = @i_refAppId and modified = 0 and attrName = 'RefCopy First backup done')) and (@count > 0)
	BEGIN
		SET @phaseNum = (select
							case when appTypeId in(11/*WIN2KFS*/, 33/*WINXP32*/, 34/*WINXP64*/, 42/*MSDOTNET32*/, 63/*MSDOTNET64*/) then 8/*WINSFARCHIVEINDEX*/ --Windows AppTypes
									  else 7/*SFARCHIVEINDEX*/
								 end
							From APP_Application(NOLOCK)
							Where id = @i_refAppId)
		SET @isArchiveIndexSuccessFul = ISNULL( (select top 1 case when status in(1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/) then 1
												 else 0
												 end
												 From JMBkpAttemptInfo
												 where jobId = @i_refJobId
												 and phaseNum = @phaseNum
												 order by attemptNum desc
												 ), 0)
		IF @isArchiveIndexSuccessFul > 0
		BEGIN
			insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@i_refAppId,'sys:last full',8,dbo.getunixtime(getutcdate()), dbo.getunixtime(getutcdate()),0)
		insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@i_refAppId,'RefCopy First backup done',2,1, dbo.getunixtime(getutcdate()),0)
		END
	END
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	SELECT  @count, @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateReferenceCopyInfo')
	delete from GxQscripts where name = 'JMUpdateReferenceCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateReferenceCopyInfo')
	delete from GXDBVersions where aliasname = 'JMUpdateReferenceCopyInfo'
GO

insert into GXDBVersions values(2, 'JMUpdateReferenceCopyInfo',  '00010006003400020000', 'JMUpdateReferenceCopyInfo', '00010006003400020000')
GO

