

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdatePreparedJobInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdatePreparedJobInfo()
--  |				 Description:  Update job description
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdatePreparedJobInfo.sp,v $ $Id: JMUpdatePreparedJobInfo.sp,v 1.4.60.5 2019/03/22 10:04:56 chandru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMUpdatePreparedJobInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMUpdatePreparedJobInfo <<<'
	drop procedure JMUpdatePreparedJobInfo
END
IF EXISTS (select * from GxQscripts where name='JMUpdatePreparedJobInfo')
	delete from GxQscripts where name = 'JMUpdatePreparedJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdatePreparedJobInfo')
	delete from GXDBVersions where aliasname = 'JMUpdatePreparedJobInfo'
GO
print '... Creating Procedure: JMUpdatePreparedJobInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdatePreparedJobInfo
  @i_preparedJobId integer,
  @i_preparedCCId integer,
  @i_status integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
SET @errorCode = 0
	UPDATE JMPreparedJob SET Status = @i_status WHERE preparedJobId = @i_preparedJobId AND preparedJobCCId = @i_preparedCCId
		AND status <> 3 -- PREPARATION_COMPLETED
	IF @@ROWCOUNT = 1 and @i_status = 3
	BEGIN
		-- Insert entry in JmJobDatatStats table
		INSERT	INTO JMJobDataStats
		SELECT  DISTINCT
b.jobId, b.archGrpId, b.archGrpCopyId, 6 ,
			b.opType, b.auxCopyJobId, b.status, b.disabled, b.appId, b.commCellId,
			b.archCheckEndTime, b.archCheckStatus, b.retentionFlags, b.manualRetentionEndTime, b.copiedTime, b.agedTime,
			b.mediaDeletedTime, b.modifiedTime, b.sizeOnMedia, b.agedBy, b.flags, b.modifiedTime, b.auxCopyStatus, b.unCompSize
			FROM JMJobDataStats b
WHERE b.jobId = @i_preparedJobId and b.commCellId = @i_preparedCCId and dataType = 1
	END
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdatePreparedJobInfo')
	delete from GxQscripts where name = 'JMUpdatePreparedJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdatePreparedJobInfo')
	delete from GXDBVersions where aliasname = 'JMUpdatePreparedJobInfo'
GO

insert into GXDBVersions values(2, 'JMUpdatePreparedJobInfo',  '00010004006000050000', 'JMUpdatePreparedJobInfo', '00010004006000050000')
GO

