

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateLegalHoldPinTime.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdateLegalHoldPinTime()
--  |				 Description:  Update LegalHoldPin Time
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateLegalHoldPinTime.sp,v $ $Id: JMUpdateLegalHoldPinTime.sp,v 1.5.60.2 2018/03/22 02:59:53 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateLegalHoldPinTime <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateLegalHoldPinTime')
	drop procedure JMUpdateLegalHoldPinTime
IF EXISTS (select * from GxQscripts where name='JMUpdateLegalHoldPinTime')
	delete from GxQscripts where name = 'JMUpdateLegalHoldPinTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateLegalHoldPinTime')
	delete from GXDBVersions where aliasname = 'JMUpdateLegalHoldPinTime'
GO
print '... Creating Procedure: JMUpdateLegalHoldPinTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateLegalHoldPinTime
  @i_CompPolicyName nvarchar(256),
  @i_jobId integer,
  @i_commcellId integer
AS
SET NOCOUNT ON
BEGIN TRY
  DECLARE @errorCode integer;
DECLARE		@pinTime				integer
DECLARE		@RetainUntil			datetime
DECLARE		@backupSetId			integer
DECLARE		@archGroupId			integer
SET @errorCode = 0
SET @pinTime = 0
IF EXISTS (SELECT * FROM DM2CompliancePolicy WHERE CompPolicyName = @i_CompPolicyName)
BEGIN
	SELECT 	@RetainUntil=RetainUntil, @backupSetId = BackupsetId
	FROM 		DM2CompliancePolicy
	WHERE 	CompPolicyName = @i_CompPolicyName
	IF @RetainUntil IS NOT NULL
	BEGIN
		-- Infinite retention
		IF CONVERT(CHAR(10), @RetainUntil, 101) = '12/31/9999'
			SET	@pinTime = -1
		ELSE IF CONVERT(CHAR(10), @RetainUntil, 101) = '01/01/1900'
			SET	@pinTime = 0
		ELSE
			SET @pinTime = dbo.getUnixTime(@RetainUntil)
	END
	ELSE
		SET @pinTime = 0
	select @archGroupId = dataArchGrpID from App_Application where backupSet = @backupSetId
	EXEC archPinLHJobsOnPrimaryCopy 0, @i_jobId, @i_commcellId, @archGroupId, @pinTime
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
END CATCH;
	SELECT  @errorCode
GO


IF EXISTS (select * from GxQscripts where name = 'JMUpdateLegalHoldPinTime')
	delete from GxQscripts where name = 'JMUpdateLegalHoldPinTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateLegalHoldPinTime')
	delete from GXDBVersions where aliasname = 'JMUpdateLegalHoldPinTime'
GO

insert into GXDBVersions values(2, 'JMUpdateLegalHoldPinTime',  '00010005006000020000', 'JMUpdateLegalHoldPinTime', '00010005006000020000')
GO

