

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateJobDescription.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdateJobDescription()
--  |				 Description:  Update job description
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateJobDescription.sp,v $ $Id: JMUpdateJobDescription.sp,v 1.4.60.2 2018/03/22 03:01:21 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateJobDescription <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateJobDescription')
	drop procedure JMUpdateJobDescription
IF EXISTS (select * from GxQscripts where name='JMUpdateJobDescription')
	delete from GxQscripts where name = 'JMUpdateJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateJobDescription')
	delete from GXDBVersions where aliasname = 'JMUpdateJobDescription'
GO
print '... Creating Procedure: JMUpdateJobDescription'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateJobDescription
  @i_jobId integer,
  @i_commcellId integer,
  @i_updateTime bigint,
  @i_jobDesc ntext
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
SET @errorCode = 0
IF EXISTS (SELECT * FROM JMJobInfo WHERE commCellId = @i_commcellId AND jobId = @i_jobId)
BEGIN
	UPDATE JMJobInfo SET jobDescription = @i_jobDesc, lastStateChangeTime = @i_updateTime
	WHERE commCellId = @i_commcellId AND jobId = @i_jobId
END
IF EXISTS (SELECT * FROM JMJobStats WHERE commCellId = @i_commcellId AND jobId = @i_jobId)
BEGIN
	UPDATE JMJobStats SET jobDescription = @i_jobDesc
	WHERE commCellId = @i_commcellId AND jobId = @i_jobId
	-- Update the respective stats table with the lastStateChangeTime
	IF EXISTS (SELECT * FROM JMBkpStats WHERE commCellId = @i_commcellId AND jobId = @i_jobId)
	BEGIN
		UPDATE JMBkpStats SET modifiedTime = dbo.GetUnixTime(GETUTCDATE())
		WHERE commCellId = @i_commcellId AND jobId = @i_jobId
	END
	ELSE IF EXISTS (SELECT * FROM JMRestoreStats WHERE commCellId = @i_commcellId AND jobId = @i_jobId)
	BEGIN
		UPDATE JMRestoreStats SET modifiedTime = dbo.GetUnixTime(GETUTCDATE())
		WHERE commCellId = @i_commcellId AND jobId = @i_jobId
	END
END
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateJobDescription')
	delete from GxQscripts where name = 'JMUpdateJobDescription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateJobDescription')
	delete from GXDBVersions where aliasname = 'JMUpdateJobDescription'
GO

insert into GXDBVersions values(2, 'JMUpdateJobDescription',  '00010004006000020000', 'JMUpdateJobDescription', '00010004006000020000')
GO

