

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateDataCopiedStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateDataCopiedStats.sp,v $ $Id: JMUpdateDataCopiedStats.sp,v 1.2.42.3 2018/03/22 03:14:15 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMUpdateDataCopiedStats
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateDataCopiedStats <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateDataCopiedStats')
	drop procedure JMUpdateDataCopiedStats
IF EXISTS (select * from GxQscripts where name='JMUpdateDataCopiedStats')
	delete from GxQscripts where name = 'JMUpdateDataCopiedStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateDataCopiedStats')
	delete from GXDBVersions where aliasname = 'JMUpdateDataCopiedStats'
GO
print '... Creating Procedure: JMUpdateDataCopiedStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateDataCopiedStats
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inJobId INTEGER,
  @inputXml XML
AS
  DECLARE @errorCode INTEGER
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
	BEGIN TRAN
	SET @errorCode = 0
	DECLARE @dataCopied TABLE
	(
		jobId			integer,
		archGrpCopyID		integer,
		BytesXferred		bigint,
		mediaUsageTime		integer,
		commCellId		integer,
		copyName		text,
		srcCopyId		integer,
		dataToCopy		bigint,
		muxFactor		integer,
		destCombinedStreams integer,
		failureReason		text
	)
	INSERT INTO @dataCopied
	SELECT
	@inJobId,
	ISNULL(col.value('(destinationCopy/@copyId)[1]', 'int'), 0),
	ISNULL(col.value('@dataCopied', 'bigint'), 0),
	ISNULL(col.value('@mediaUsageTime', 'int'), 0),
	2/*CommcellId*/,
	ISNULL(col.value('(destinationCopy/@copyName)[1]', 'varchar(256)'), 0),
	ISNULL(col.value('(sourceCopy/@copyId)[1]', 'int'), 0),
	ISNULL(col.value('@dataToBeCopied','bigint'), 0),
	ISNULL(col.value('@muxFactor', 'int'), 0),
	ISNULL(col.value('@destinationNum', 'int'), 0),
	''
	FROM @inputXml.nodes('/JobManager_ArchDataInfo/copyInfo') T(col)
	DELETE FROM @dataCopied Where archGrpCopyID = 0 And srcCopyId = 0
	Merge JMDataCopiedStatsTable j
	Using @dataCopied i
	On j.jobId = i.jobId And j.archGrpCopyID = i.archGrpCopyID And j.srcCopyId = i.srcCopyId
	When MATCHED Then
	Update Set j.dataToCopy=i.dataToCopy, j.muxFactor = i.muxFactor, j.destCombinedStreams = i.destCombinedStreams
	When NOT MATCHED Then
	Insert Values(i.jobId, i.archGrpCopyID, i.BytesXferred, i.mediaUsageTime, i.commCellId, i.copyName, i.srcCopyId, i.dataToCopy, i.muxFactor, i.destCombinedStreams, i.failureReason);
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	select @errorCode
	RETURN @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO


IF EXISTS (select * from GxQscripts where name = 'JMUpdateDataCopiedStats')
	delete from GxQscripts where name = 'JMUpdateDataCopiedStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateDataCopiedStats')
	delete from GXDBVersions where aliasname = 'JMUpdateDataCopiedStats'
GO

insert into GXDBVersions values(2, 'JMUpdateDataCopiedStats',  '00010002004200030000', 'JMUpdateDataCopiedStats', '00010002004200030000')
GO

