

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateDRBackupStatus.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMUpdateDRBackupStatus()
--  |				 Description:  Update job xml
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateDRBackupStatus <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateDRBackupStatus')
	drop procedure JMUpdateDRBackupStatus
IF EXISTS (select * from GxQscripts where name='JMUpdateDRBackupStatus')
	delete from GxQscripts where name = 'JMUpdateDRBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateDRBackupStatus')
	delete from GXDBVersions where aliasname = 'JMUpdateDRBackupStatus'
GO
print '... Creating Procedure: JMUpdateDRBackupStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateDRBackupStatus
  @i_jobId integer,
  @i_commcellId integer,
  @i_status integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
SET @errorCode = 0
DECLARE @status INTEGER = @i_status
DECLARE @jobID INTEGER = @i_jobId
DECLARE @commCellID INTEGER = @i_commcellId
DECLARE @outTable TABLE (jobID INTEGER)
--If job is still running then update Attempts Info
BEGIN TRANSACTION
	INSERT INTO @outTable
	SELECT TempTable.JobID FROM
	(
		MERGE JMAdminJobAttemptInfoTable as T
		USING (SELECT jobid FROM JMJobInfo WHERE Jobid = @jobID AND commCellId = @commCellID AND opType = 11) as S
		ON S.jobid = T.Jobid AND T.phaseNum = 1 --CSDRBKPPHASE
		WHEN MATCHED THEN UPDATE SET T.status = @status
		OUTPUT $action,S.jobid
	) AS TempTable (MergeAction, JobID)
	--If job has completed then update Attempts stats
	IF NOT EXISTS (SELECT 1 FROM @outTable WHERE jobID = @jobID)
	BEGIN
		DECLARE @jobFinalStatus INTEGER
		--CSDRBKPARCHIVEINDEX
		DECLARE @archiveIndexStatus INTEGER = ISNULL((SELECT TOP 1 status FROM JMAdminJobAttemptStatsTable WHERE Jobid = @jobID AND commCellId = @commCellID and phaseNum = 10 ORDER BY attemptNum DESC),2)
		INSERT INTO @outTable
		SELECT TempTable.JobID FROM
		(
			MERGE JMAdminJobAttemptStatsTable as T
			USING (SELECT jobid FROM JMAdminJobStatsTable WHERE Jobid = @jobID AND commCellId = @commCellID AND opType = 11) as S
			ON S.jobid = T.Jobid AND T.phaseNum = 1
			WHEN MATCHED THEN UPDATE SET T.status = @status
			OUTPUT $action,S.jobid
		) AS TempTable (MergeAction, JobID)
		IF @status = 1 AND @archiveIndexStatus = 1
			SET @jobFinalStatus = 1
		ELSE IF @status = 1 AND @archiveIndexStatus = 2
			SET @jobFinalStatus = 3
		ELSE IF @status IN (3,14) AND @archiveIndexStatus = 2
			SET @jobFinalStatus = 2
		ELSE IF @status = 14 AND @archiveIndexStatus = 1
			SET @jobFinalStatus = 14
		ELSE IF @status = 3 AND @archiveIndexStatus = 1
			SET @jobFinalStatus = 3
		ELSE
			SET @jobFinalStatus = 2
		UPDATE JMAdminJobStatsTable
		SET status = @jobFinalStatus
		WHERE jobId = @jobID AND commCellId = @commCellID AND opType = 11
		DELETE FROM @outTable
		IF  @jobFinalStatus NOT IN (1,3,14) --If the Job was failed, mark the arch files invalid
		BEGIN
			INSERT INTO @outTable
			exec ArchFileSetInvalidByJob @jobID,@commCellID,0,0,'',''
		END
	END
DELETE FROM JMJobOptions WHERE jobId = @jobID AND commCellId = @commCellID AND attributeId = 72
COMMIT TRANSACTION
END TRY
BEGIN CATCH
ROLLBACK TRANSACTION
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
END CATCH;
PROC_EXIT:
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateDRBackupStatus')
	delete from GxQscripts where name = 'JMUpdateDRBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateDRBackupStatus')
	delete from GXDBVersions where aliasname = 'JMUpdateDRBackupStatus'
GO

insert into GXDBVersions values(2, 'JMUpdateDRBackupStatus',  '00000000000000000000', 'JMUpdateDRBackupStatus', '00000000000000000000')
GO

