

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateCycleAndSequenceNumber.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateCycleAndSequenceNumber.sp,v $ $Id: JMUpdateCycleAndSequenceNumber.sp,v 1.1.2.7 2018/09/29 19:08:19 sbonilla Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateCycleAndSequenceNumber <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateCycleAndSequenceNumber')
	drop procedure JMUpdateCycleAndSequenceNumber
IF EXISTS (select * from GxQscripts where name='JMUpdateCycleAndSequenceNumber')
	delete from GxQscripts where name = 'JMUpdateCycleAndSequenceNumber'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCycleAndSequenceNumber')
	delete from GXDBVersions where aliasname = 'JMUpdateCycleAndSequenceNumber'
GO
print '... Creating Procedure: JMUpdateCycleAndSequenceNumber'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateCycleAndSequenceNumber
  @i_jobID BIGINT,
  @i_jobStartTime INTEGER,
  @i_appID INTEGER,
  @i_CommCellId INTEGER,
  @i_CycleNumber INTEGER,
  @i_status INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @incrJobs XML;
SET NOCOUNT ON
BEGIN TRY
	SET @incrJobs = '<JobManager_JobIDs/>'
	DECLARE @isCloudLaptop INT = 0
	DECLARE @curTime INT = datediff(second, '01/01/1970', GETUTCDATE())
	IF object_id('tempdb.dbo.#tmpJobsTable1') IS NOT NULL DROP TABLE #tmpJobsTable1
	DECLARE @resultTbl TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(MAX) )
	CREATE TABLE #tmpJobsTable1
	(
		opType int,
		startTime	int,
		bkpLevel int,
		appid int,
		jobid1 int,
		commcellid1 int,
		cycle int,
		sequence int,
		isCloudLaptopJob int DEFAULT 0
	)
	IF object_id('tempdb.dbo.#tmpJobsToCallUpdateAuxCopy') IS NOT NULL DROP TABLE #tmpJobsToCallUpdateAuxCopy
	CREATE TABLE #tmpJobsToCallUpdateAuxCopy
	(
		opType int,
		startTime	int,
		bkpLevel int,
		appid int,
		jobid1 int,
		commcellid1 int,
		cycle int,
		sequence int,
		isCloudLaptopJob int DEFAULT 0
	)
	IF EXISTS
	(
		SELECT 1 FROM APP_Application (NOLOCK) APP
		JOIN CommCellCloudLaptopClients CC ON CC.ClientID = APP.clientId AND APP.id = @i_appID
	)
		SET @isCloudLaptop = 1
	;WITH bkpjobs1 AS
	(
		SELECT j.opType,j.servStartDate,j.bkpLevel, j.appId, j.jobId,j.commCellId, @i_CycleNumber AS cycle, ROW_NUMBER() over ( PARTITION by  appId,fullCycleNum order by jobId ) AS rownum
		FROM JMBkpStats j
		WHERE j.appid = @i_appID and j.servStartDate >= @i_jobStartTime and j.commCellId = @i_CommCellId AND j.status IN (1,3,14,16) AND j.bkpLevel = 2 AND j.fullCycleNum <> 0 --If Full Cycle number is 0 then Cycle number is not supported for the job. So no need to adjust
	)
	INSERT into #tmpJobsTable1
	(opType, startTime, bkpLevel, appid, jobid1, commcellid1, cycle, sequence)
	SELECT opType, servStartDate, bkpLevel, appId, jobId, commCellId, cycle, rownum FROM bkpjobs1
	IF @isCloudLaptop = 1
	BEGIN
		INSERT into #tmpJobsTable1
		(opType, startTime, bkpLevel, appid, jobid1, commcellid1, cycle, sequence, isCloudLaptopJob)
		SELECT j.opType,j.servStartDate,j.bkpLevel, j.appId, j.jobId,j.commCellId, @i_CycleNumber AS cycle, ROW_NUMBER() over ( PARTITION by  appId,fullCycleNum order by jobId ) AS rownum, 1
		FROM JMBkpStats j
		WHERE  j.appId = @i_appID AND j.servEndDate >= @i_jobStartTime AND j.servStartDate < @i_jobStartTime AND j.servEndDate < @curTime AND j.commCellId = @i_CommCellId AND j.status IN (1,3,14,16) AND j.bkpLevel = 2 AND j.fullCycleNum <> 0 --If Full Cycle number is 0 then Cycle number is not supported for the job. So no need to adjust
	END
	INSERT INTO #tmpJobsToCallUpdateAuxCopy
	(opType, startTime, bkpLevel, appid, jobid1, commcellid1, cycle, sequence, isCloudLaptopJob)
	SELECT opType, startTime, bkpLevel, appid, jobid1, commcellid1, cycle, sequence, isCloudLaptopJob FROM #tmpJobsTable1
	UNION
	SELECT j.opType,j.servStartDate,j.bkpLevel, j.appId, j.jobId,j.commCellId, 0, 0, 0
	FROM JMBkpStats j
	WHERE j.appid = @i_appID and j.servStartDate >= @i_jobStartTime and j.commCellId = @i_CommCellId AND j.status IN (1,3,14,16) AND j.bkpLevel = 2 AND j.fullCycleNum = 0  AND j.opType = 60--Pick only Backup Copy Jobs
	--Get the list of JobIDs for which updateAuxCopyTable needs to be called.
	SET @incrJobs = ISNULL((SELECT jobid1 as '@jobId',
									opType as '@opType',
									bkpLevel as '@backupLevel',
									startTime as '@jobStartTime',
									cycle as '@fullCycleNum'
							  FROM #tmpJobsToCallUpdateAuxCopy FOR XML PATH('job'),ROOT('JobManager_JobIDs')),'<JobManager_JobIDs/>')
	IF @i_status IN (1,3,14,16)
	BEGIN
		UPDATE JMBkpStats
		SET fullCycleNum = T1.cycle,cyclesequence = T1.sequence + 1 -- 1 is for SynthFull Job
		FROM #tmpJobsTable1 T1
		WHERE jobid = T1.jobid1 AND JMBkpStats.bkpLevel = 2 AND commCellId = @i_CommCellId
		--Update the sub client prop accordingly
		DECLARE @nonFUllSeq INTEGER = (SELECT MAX(cyclesequence) FROM JMBkpStats WHERE appid = @i_appID AND fullCycleNum = @i_CycleNumber)
		DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
		INSERT INTO @resultTbl EXEC AppInsertSubClientProp @i_appID,0,@now,N'sys:non full cycle num',10,@nonFUllSeq
		IF @isCloudLaptop = 1
		BEGIN
			UPDATE archFile SET cTime = @i_jobStartTime+1
			WHERE jobId IN
			(
				SELECT T1.jobId1
				FROM #tmpJobsTable1 T1
				WHERE T1.isCloudLaptopJob = 1
				UNION
				SELECT JB.jobId
				FROM JMBkpJobInfo JB (NOLOCK)
				JOIN JMJobInfo JI (NOLOCK) ON JI.jobId = JB.jobId AND JI.jobStartTime < @i_jobStartTime
				WHERE JB.applicationId = @i_appID
			)
		END
	END
	--We have adjusted the cycle and sequence number for completes jobs. Other running jobs should update AuxCopy tables hence resetting below job option
	-- if SynthFull Job is complete(sucess/failure), then reset the attribute to 0, as other Incr in this cycle should call UpdateAuxCopy
	UPDATE jobOption
	SET jobOption.attributeValueInt = 0
	FROM
	JMBkpJobInfo bkpJobInfo WITH(NOLOCK) INNER JOIN JMJobOptions jobOption
	ON bkpJobInfo.jobId = jobOption.jobId AND bkpJobInfo.commcellId = jobOption.commCellId AND jobOption.attributeName = 'SynthFull job running with this Incr' AND jobOption.attributeValueInt = @i_jobID
	SET @retVal = 0
END TRY
BEGIN CATCH
	SET @retVal = @@ERROR
END CATCH
IF object_id('tempdb.dbo.#tmpJobsTable1') IS NOT NULL DROP TABLE #tmpJobsTable1
SELECT @retVal,@incrJobs
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateCycleAndSequenceNumber')
	delete from GxQscripts where name = 'JMUpdateCycleAndSequenceNumber'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCycleAndSequenceNumber')
	delete from GXDBVersions where aliasname = 'JMUpdateCycleAndSequenceNumber'
GO

insert into GXDBVersions values(2, 'JMUpdateCycleAndSequenceNumber',  '00010001000200070000', 'JMUpdateCycleAndSequenceNumber', '00010001000200070000')
GO

