

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateCDRJobProgress.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Amey Karandikar
--	Date:   10/03/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateCDRJobProgress.sp,v $ $Id: JMUpdateCDRJobProgress.sp,v 1.10.208.2 2018/03/22 03:09:44 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMUpdateCDRJobProgress <<<'

IF EXISTS (select * from sysobjects where name='JMUpdateCDRJobProgress')
	drop procedure JMUpdateCDRJobProgress
IF EXISTS (select * from GxQscripts where name='JMUpdateCDRJobProgress')
	delete from GxQscripts where name = 'JMUpdateCDRJobProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCDRJobProgress')
	delete from GXDBVersions where aliasname = 'JMUpdateCDRJobProgress'
GO
print '... Creating Procedure: JMUpdateCDRJobProgress'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMUpdateCDRJobProgress
  @in_repSetId INTEGER
AS
  DECLARE @out_filesTransfered bigint
  DECLARE @out_filesToTransfered bigint
  DECLARE @out_bytesTransfered bigint
  DECLARE @out_bytesToTransfered bigint
  DECLARE @out_jobId bigint
  DECLARE @out_phase integer
  DECLARE @out_attempt integer
  DECLARE @out_writeTime bigint
DECLARE @prevAttemptsFilesTransfered bigint
DECLARE @prevAttemptsBytesTransfered bigint
SET @out_filesTransfered = 0
SET @out_filesToTransfered = 0
SET @out_bytesTransfered = 0
SET @out_bytesToTransfered = 0
SET @out_jobId = 0
SET @out_phase = 0
SET @out_attempt = 0
SET @out_writeTime = 0
SET @prevAttemptsFilesTransfered = 0
SET @prevAttemptsBytesTransfered = 0
	SET NOCOUNT ON
	IF @in_repSetId IS NOT null
	BEGIN
		SELECT @out_filesTransfered   = SUM(JMCdrJobs.filesTransfered),
		       @out_filesToTransfered = SUM(JMCdrJobs.filesToTransfer),
		       @out_bytesTransfered   = SUM(JMCdrJobs.bytesTransfered),
		       @out_bytesToTransfered = SUM(JMCdrJobs.bytesToTransfer)
		FROM JMCdrJobs INNER JOIN APP_Application ON JMCdrJobs.PairId = APP_Application.id
		WHERE APP_Application.backupSet = @in_repSetId and ((APP_Application.subclientStatus & 4)= 0 )
		SELECT @out_jobId = JMBkpJobInfo.jobId
		FROM JMBkpJobInfo INNER JOIN APP_Application ON JMBkpJobInfo.applicationId = APP_Application.id
		WHERE APP_Application.backupSet = @in_repSetId and ((APP_Application.subclientStatus & 4)= 0 )
		IF @out_jobId IS NOT null
			BEGIN
				SELECT @out_phase     = JMJobInfo.currentPhase,
						 @out_attempt   = JMJobInfo.runAttempts,
						 @out_writeTime = dbo.GetUnixTime(GetUTCDate()) - JMJobInfo.attemptStartTime
				FROM JMJobInfo
				WHERE JMJobInfo.jobId = @out_jobId
AND JMJobInfo.commCellId = 2
				-- Get the previous transferred files and uncompressed bytes of previous attempts. These has to be deducuted from the acutal
				-- files and uncompressed bytes transferred from jmcdrjobs as these are not valid for the current attempt
				SELECT @prevAttemptsFilesTransfered = ISNULL(SUM(numFiles),0),
					   @prevAttemptsBytesTransfered = ISNULL(SUM(unCompBytes),0)
				FROM JMBkpAttemptInfo
				WHERE jobId = @out_jobId
AND JMBkpAttemptInfo.commCellId = 2
				AND attemptNum < @out_attempt
			END
		ELSE
			BEGIN
				SET @out_jobId = 0;
			END
	END
SELECT @out_filesTransfered - @prevAttemptsFilesTransfered, @out_filesToTransfered, @out_bytesTransfered - @prevAttemptsBytesTransfered, @out_bytesToTransfered, @out_jobId, @out_phase, @out_attempt, @out_writeTime
GO


IF EXISTS (select * from GxQscripts where name = 'JMUpdateCDRJobProgress')
	delete from GxQscripts where name = 'JMUpdateCDRJobProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCDRJobProgress')
	delete from GXDBVersions where aliasname = 'JMUpdateCDRJobProgress'
GO

insert into GXDBVersions values(2, 'JMUpdateCDRJobProgress',  '00010010020800020000', 'JMUpdateCDRJobProgress', '00010010020800020000')
GO

