

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateCCRXml.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateCCRXml.sp,v $ $Id: JMUpdateCCRXml.sp,v 1.1.2.9 2020/09/03 10:57:15 samrutkar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMUpdateCCRXml"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMUpdateCCRXml')
BEGIN
	print '>>> Drop Stored Procedure: JMUpdateCCRXml <<<'
	drop procedure JMUpdateCCRXml
END
IF EXISTS (select * from GxQscripts where name='JMUpdateCCRXml')
	delete from GxQscripts where name = 'JMUpdateCCRXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCCRXml')
	delete from GXDBVersions where aliasname = 'JMUpdateCCRXml'
GO
print '... Creating Procedure: JMUpdateCCRXml'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMUpdateCCRXml
  @i_clientListInXml XML,
  @o_onlineClientIdListInXml XML OUTPUT,
  @o_offlineClientIdListInXml XML OUTPUT
AS
SET NOCOUNT ON
--**********************************************************************************--
--																			        --
--	Note : This stored procedure to be called by JM to notify client status change  --
--			unavailability to availability and availability to unavailability       --
--**********************************************************************************--
DECLARE @clientId INTEGER = 0
DECLARE @latestCCRID integer = 0
DECLARE @startTime integer = dbo.GetUnixTime(getutcdate())
DECLARE @markAllClientsOffline bit = 0
IF object_id('tempdb.dbo.#clientGuidList') IS NOT NULL DROP TABLE #clientGuidList
CREATE TABLE #clientGuidList (clientGuid UNIQUEIDENTIFIER, clientId INT, type INT, SubClientId INT)
CREATE CLUSTERED  INDEX idx_clientGuidListClientGuid ON #clientGuidList(clientGuid)
SET @markAllClientsOffline = ISNULL((Select ref.value('@markAllClientsOffline', 'bit') From @i_clientListInXml.nodes ('JobManager_NotifyClientStatusBulkReq') R(ref)), 0)
IF @markAllClientsOffline = 1
BEGIN
	UPDATE CCRClientToClient
SET errorCode = 111,
		LastUpdateTime = @startTime,
		flag = 0,
		lastOfflineTime = @startTime
	WHERE lastOfflineTime < lastOnlineTime AND flag = 1 AND ToClientId <> 2
END
ELSE
BEGIN
	INSERT INTO #clientGuidList
		SELECT ref.value('@val', 'uniqueidentifier'), 0, 1, 0   -- 1 - online
		FROM  @i_clientListInXml.nodes ('JobManager_NotifyClientStatusBulkReq/onlineClientGuids') R(ref)
		WHERE ref.value('@val', 'nvarchar(max)') != ''
		UNION ALL
		SELECT ref.value('@val', 'uniqueidentifier'), 0, 0, 0   -- 0 - offline
		FROM  @i_clientListInXml.nodes ('JobManager_NotifyClientStatusBulkReq/offlineClientGuids') R(ref)
		WHERE ref.value('@val', 'nvarchar(max)') != ''
	-- update client id and subClientId
	UPDATE L SET L.clientId = C.id, L.SubClientId = ISNULL((select MIN(id) from APP_Application where clientId = C.id and (subClientStatus & 6) = 0),0)
	FROM #clientGuidList L
	INNER JOIN APP_Client C ON L.clientGuid = C.GUID
	-- update CCR tables
	BEGIN
		DELETE C FROM CCRToSubclient C
			INNER JOIN #clientGuidList L
			ON L.clientId = C.ClientId AND C.SubClientId = L.SubClientId
			INNER JOIN CCRCommCellReadiness CCR ON CCR.ccrid = C.ccrid
			where CCR.CCREndTime > 0
			AND C.dataPathId = 0
		INSERT INTO CCRCommCellReadiness (CCRLevel,CCRStartTime,CCREndTime)
		VALUES(0, @startTime, @startTime)
		SET	@latestCCRID = SCOPE_IDENTITY()
		 --since this is a dummy entry, we will take the default subclient
		INSERT INTO CCRToSubClient  (CCRId,ClientId,SubClientId,DataPathId,CCRResultFlag,CCRNetworkReadinessFlag,lastUnCompBytes,lastCompBytes,capacityAvailable,appTypeId,dataWritten,CCRResourceReadinessFlag)
		SELECT	@latestCCRID,
			L.clientId,
			L.SubClientId,
			0,
CASE L.type WHEN 1 THEN 0 ELSE 1 END,
CASE L.type WHEN 1 THEN 0 ELSE 8 END,
			0, 0, 0, 0, 0, 0    -- 6-> 2 is uninstalled and 4 is deleted
		FROM #clientGuidList L
		declare @src varchar(510) = ''
		set @src = (select net_hostname from APP_Client WITH(NOLOCK) where id = 2)
		MERGE CCRClientToClient cToClient
		USING (SELECT L.clientId, L.type, C.net_hostname FROM #clientGuidList L INNER JOIN APP_Client C WITH(NOLOCK) ON L.clientId = C.id ) AS T
		ON cToClient.FromClientId = 2 AND cToClient.ToClientId = T.clientId
WHEN MATCHED THEN UPDATE SET errorCode = CASE T.type WHEN 1 THEN 0 ELSE 111 END,
			LastUpdateTime = @startTime,
			flag = CASE T.type WHEN 1 THEN 1 ELSE 0 END,
			lastOnlineTime = CASE T.type WHEN 1 THEN @startTime ELSE lastOnlineTime END,
			lastOfflineTime = CASE WHEN T.type = 0 AND cToClient.lastOfflineTime < cToClient.lastOnlineTime THEN @startTime ELSE lastOfflineTime END
		WHEN NOT MATCHED THEN INSERT (FromClientId,FromClientInterfaceName,ToClientId,ToClientInterfaceName
				,NumberOfNWHops,NWDelayInMilliSec,LastUpdateTime,IsEnabled,Flag,errorCode,lastOnlineTime,serviceType,IsDip,lastOfflineTime)
			VALUES(2,
				@src,
				T.clientId,
				T.net_hostname,
				0,
				0,
				@startTime,
				0,
				CASE T.type WHEN 1 THEN 1 ELSE 0 END,
CASE T.type WHEN 1 THEN 0 ELSE 111 END,
				CASE T.type WHEN 1 THEN @startTime ELSE 0 END,
				0,
				0,
				CASE T.type WHEN 0 THEN @startTime ELSE 0 END);
	END
	BEGIN --Mark MA Offline, if needed
		UPDATE	H
		SET		MmHostSoftState = 0, OfflineReason = 10 -- HOST_STATUS_CVFWD_DETECTED_OFFLINE
		FROM 	MMHost H
				INNER JOIN #clientGuidList C ON C.clientId = H.ClientId AND C.type = 0 --offline clients
		WHERE	H.MmHostEnabled = 1 AND H.MmHostSoftState = 1
AND H.ClientId > 1 AND H.Attribute & 32768 = 0
		IF @@ROWCOUNT > 0
		BEGIN
EXEC MMGetSetMMTask 0, 0, 2, ''
		END
	END
	-- mark IsPowerRequestPending off if on for the client
	UPDATE CP SET CP.attrVal = N'0' FROM App_clientProp CP
	INNER JOIN #clientGuidList L ON L.clientId = CP.componentNameId
WHERE CP.attrName = 'Cloud VM Managment Power On Pending'
		AND CP.attrVal <> N'0'
		AND CP.modified = 0
		AND type = 1  -- for online clients
	IF OBJECT_ID('tempdb.dbo.#RemoveJMDependencyTrigger_ClientTbl') IS NOT NULL
		DROP TABLE #RemoveJMDependencyTrigger_ClientTbl
	-- External Inputted Table does not exist
	CREATE TABLE #RemoveJMDependencyTrigger_ClientTbl (
		clientId	INT PRIMARY KEY
	)
	INSERT INTO #RemoveJMDependencyTrigger_ClientTbl
	SELECT clientId from #clientGuidList WHERE type = 1  -- for online clients
	-- remove JM dependency
	-- will process the above created table without passing in clientId & jobId
	EXEC RemoveJMDependencyTrigger 0, 32, 0, 0, 0, 0   -- JM_CLIENT_ONLINE_DEPENDENCY  (0x20)
	SET @o_onlineClientIdListInXml = ( SELECT	L.clientId '@clientId'
		FROM #clientGuidList L
		WHERE type = 1 -- online clients
		FOR XML PATH('ClientInfoList'),
		ROOT ('JobManager_ClientList'))
	SET @o_offlineClientIdListInXml = ( SELECT	L.clientId '@clientId'
		FROM #clientGuidList L
		WHERE type = 0 -- offline clients
		FOR XML PATH('ClientInfoList'),
		ROOT ('JobManager_ClientList'))
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateCCRXml')
	delete from GxQscripts where name = 'JMUpdateCCRXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCCRXml')
	delete from GXDBVersions where aliasname = 'JMUpdateCCRXml'
GO

insert into GXDBVersions values(2, 'JMUpdateCCRXml',  '00010001000200090000', 'JMUpdateCCRXml', '00010001000200090000')
GO

