

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMUpdateCCR.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMUpdateCCR.sp,v $ $Id: JMUpdateCCR.sp,v 1.16.54.8 2020/06/02 23:29:06 mnatarajan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "JMUpdateCCR"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMUpdateCCR')
BEGIN
	print '>>> Drop Stored Procedure: JMUpdateCCR <<<'
	drop procedure JMUpdateCCR
END
IF EXISTS (select * from GxQscripts where name='JMUpdateCCR')
	delete from GxQscripts where name = 'JMUpdateCCR'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCCR')
	delete from GXDBVersions where aliasname = 'JMUpdateCCR'
GO
print '... Creating Procedure: JMUpdateCCR'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMUpdateCCR
  @i_clientId integer,
  @i_errorCode integer
AS
--:DECLARE o_CCRId	integer;
SET NOCOUNT ON
DECLARE @latestCCRID integer = 0
DECLARE @startTime	integer = 0
DECLARE @flag integer = 0
DECLARE @lastOnlineTime INTEGER= 0
DECLARE @lastOfflineTime INTEGER= 0
DECLARE @CCRResultFlag INTEGER = 0
DECLARE @CCRNetworkReadinessFlag INTEGER = 0
--**********************************************************************************--
--																			        --
--	Note : This stored procedure to be called by JM to notify client status change  --
--			unavailability to availability and availability to unavailability       --
--**********************************************************************************--
IF NOT EXISTS(SELECT 1 FROM App_client (NOLOCK) WHERE id = @i_clientId)
BEGIN
	RETURN
END
SET @startTime	= dbo.GetUnixTime(getutcdate())
IF @i_errorCode = 0 --success
BEGIN
	SET @lastOnlineTime = @startTime
	SET @flag = 1
	SET @CCRResultFlag = 0
	SET @CCRNetworkReadinessFlag = 0
END
ELSE
BEGIN
	SET @lastOfflineTime = @startTime
SET @CCRResultFlag = 1
SET @CCRNetworkReadinessFlag = 8
END
-- update CCR tables
BEGIN
	DECLARE @subclientId INT
	SET @subclientId = ISNULL((select MIN(id)
		FROM APP_Application where clientId = @i_clientId and (subClientStatus & 6) = 0),0)
	DELETE T FROM CCRToSubclient T
	INNER JOIN CCRCommCellReadiness CCR ON CCR.ccrid = T.ccrid
	WHERE clientid = @i_clientId AND subclientId = @subclientId AND CCR.CCREndTime > 0
	INSERT INTO CCRCommCellReadiness (CCRLevel,CCRStartTime,CCREndTime)
	SELECT	0, @startTime, @startTime
	SET	@latestCCRID = SCOPE_IDENTITY()
	 --since this is a dummy entry, we will take the default subclient
	INSERT INTO CCRToSubClient  (CCRId,ClientId,SubClientId,DataPathId,CCRResultFlag,CCRNetworkReadinessFlag,lastUnCompBytes,lastCompBytes,capacityAvailable,appTypeId,dataWritten,CCRResourceReadinessFlag)
	SELECT	@latestCCRID, @i_clientId, @subclientId as SubClientId, 0, @CCRResultFlag,  @CCRNetworkReadinessFlag,0, 0, 0, 0, 0, 0-- 6-> 2 is uninstalled and 4 is deleted
	declare @src varchar(510) = ''
	declare @cHost varchar(510) = ''
	set @src = (select net_hostname from APP_Client WITH(NOLOCK) where id = 2)
	set @cHost = (select net_hostname from APP_Client WITH(NOLOCK) where id =  @i_clientId)
	MERGE CCRClientToClient cToClient
	USING (SELECT 2 as CsClientID, @i_clientId as ClientID ) as T
	ON cToClient.FromClientId = T.CsClientID AND cToClient.ToClientId = T.ClientID
	WHEN MATCHED THEN UPDATE SET errorCode = @i_errorCode,LastUpdateTime = @startTime, flag = @flag,
						lastOnlineTime = CASE WHEN @i_errorCode = 0 THEN @lastOnlineTime ELSE lastOnlineTime END,
						lastOfflineTime = CASE WHEN @i_errorCode != 0 AND cToClient.lastOfflineTime<cToClient.lastOnlineTime THEN @lastOfflineTime ELSE lastOfflineTime END
	WHEN NOT MATCHED THEN INSERT (FromClientId,FromClientInterfaceName,ToClientId,ToClientInterfaceName
							,NumberOfNWHops,NWDelayInMilliSec,LastUpdateTime,IsEnabled,Flag,errorCode,lastOnlineTime,serviceType,IsDip,lastOfflineTime)
							VALUES(2, @src, @i_clientId, @cHost,
							0, 0, @startTime, 0, @flag, @i_errorCode , @lastOnlineTime , 0, 0, @lastOfflineTime);
END
--update ccrtosubclient with proper error codes
--No need of below statement. We are taking care of it in this SP only.
--exec CCRUpdateFlagsByCCRId @latestCCRID,1
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMUpdateCCR')
	delete from GxQscripts where name = 'JMUpdateCCR'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMUpdateCCR')
	delete from GXDBVersions where aliasname = 'JMUpdateCCR'
GO

insert into GXDBVersions values(2, 'JMUpdateCCR',  '00010016005400080000', 'JMUpdateCCR', '00010016005400080000')
GO

