

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMShouldRunJobAsIndexCopyJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +=============================================================================+
--  |   Procedure:  JMShouldRunJobAsIndexCopyJob()
--  |
--  | Description:  Select 1 if this should be an index copy job for BLR subclient
--  |
--  |       Input:  commCellId, BLRSubclientId
--  |
--  |      Output:  1 or 0
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +============================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMShouldRunJobAsIndexCopyJob <<<'

IF EXISTS (select * from sysobjects where name='JMShouldRunJobAsIndexCopyJob')
	drop procedure JMShouldRunJobAsIndexCopyJob
IF EXISTS (select * from GxQscripts where name='JMShouldRunJobAsIndexCopyJob')
	delete from GxQscripts where name = 'JMShouldRunJobAsIndexCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMShouldRunJobAsIndexCopyJob')
	delete from GXDBVersions where aliasname = 'JMShouldRunJobAsIndexCopyJob'
GO
print '... Creating Procedure: JMShouldRunJobAsIndexCopyJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMShouldRunJobAsIndexCopyJob
  @i_commcellId INT,
  @i_BLRSubclientId INT
AS
  DECLARE @shouldRunAsIndexCopyJob INTEGER
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF EXISTS (SELECT 0 FROM JMBkpStats WHERE commCellId = @i_commCellId AND appId = @i_BLRSubclientId AND status IN (1,3,14))
	GOTO NOT_AN_INDEX_COPY
	DECLARE @sourceSubclientXML XML;
	SELECT @sourceSubclientXML = CAST(REPLACE(attrVal, 'encoding="UTF-8"', '') AS XML) FROM APP_SubClientProp WHERE componentNameId = @i_BLRSubclientId AND attrName = 'BLR Parent Subclient ID'
	IF OBJECT_ID('tempdb.dbo.#srcSubclients') IS NOT NULL DROP TABLE #srcSubclients
	CREATE TABLE #srcSubclients (scrSubclientId INT);
	INSERT INTO #srcSubclients
	SELECT ref.value('@srcSubclientId', 'int') FROM @sourceSubclientXML.nodes('App_FSBLRParentVolumeSubclientMap/volSubclientPair') R ( ref )
	IF EXISTS(SELECT 0 FROM JMBkpStats JBS INNER JOIN #srcSubclients SSC ON JBS.appId = SSC.scrSubclientId WHERE JBS.commCellId = @i_commCellId AND JBS.status IN (1,3,14))
		SELECT 1 --this job should as Index copy job
	ELSE
		SELECT 0
	DROP TABLE #srcSubclients
	GOTO DONE
	NOT_AN_INDEX_COPY:
		SELECT 0 --this job is not an index copy job
	DONE:
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMShouldRunJobAsIndexCopyJob')
	delete from GxQscripts where name = 'JMShouldRunJobAsIndexCopyJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMShouldRunJobAsIndexCopyJob')
	delete from GXDBVersions where aliasname = 'JMShouldRunJobAsIndexCopyJob'
GO

insert into GXDBVersions values(2, 'JMShouldRunJobAsIndexCopyJob',  '00000000000000000000', 'JMShouldRunJobAsIndexCopyJob', '00000000000000000000')
GO

