

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSetSqlDBInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSetSqlDBInfo.sp,v $ $Id: JMSetSqlDBInfo.sp,v 1.5.2.10 2020/04/21 16:59:13 ankumar Exp $"
--
--  +========================================================================+
--  | Stored Precedure: JMSetSqlDBInfo()
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMSetSqlDBInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMSetSqlDBInfo <<<'
	drop procedure JMSetSqlDBInfo
END
IF EXISTS (select * from GxQscripts where name='JMSetSqlDBInfo')
	delete from GxQscripts where name = 'JMSetSqlDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetSqlDBInfo')
	delete from GXDBVersions where aliasname = 'JMSetSqlDBInfo'
GO
print '... Creating Procedure: JMSetSqlDBInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSetSqlDBInfo
  @inXML XML
AS
  DECLARE @outXml XML
BEGIN
BEGIN TRY
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON
	DECLARE @tranCnt INT = @@TRANCOUNT
	IF (@tranCnt > 0)
	BEGIN
		SAVE TRAN JMSetSqlDBInfo_Tran
	END
	ELSE
	BEGIN
		BEGIN TRAN JMSetSqlDBInfo_Tran
	END
	DECLARE @jobId bigint
	DECLARE @commcellId int = 2
	DECLARE @dbXml XML
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg nvarchar(max) = ''
    DECLARE @lockResult		int = -1
	DECLARE @lockName		varchar(64) = ''
    DECLARE @oldRowFound    int = 1
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#sqlInfoFromDB') IS NOT NULL
	   DROP TABLE #sqlInfoFromDB
	DECLARE @sqlInfoTbl TABLE
	(
		ReplicaUsed			nvarchar(2048),
		DatabaseName		nvarchar(2048),
		Status				int,
		FailureReason		nvarchar(2048),
		ConversionReason	nvarchar(2048),
		StartTime			bigint,
		EndTime				bigint,
		ApplicationSize		bigint,
		firstLSN			nvarchar(256),
		lastLSN				nvarchar(256),
		InitiatedFrom		int,
		sharePointVersion	int,
		ConvertedJobPhase	int,
		CurrentPhase		int,
		state				int,
		BackupCount			int
	)
	SELECT *
	INTO #sqlInfoFromDB
	FROM @sqlInfoTbl
	SET @jobId = ISNULL((Select Tbl.Col.value('@jobId', 'bigint') From @inXML.nodes('JobManager_SQLJobInfo') Tbl(Col)), 0)
	SET @commcellId = ISNULL((Select Tbl.Col.value('@commcellId', 'int') From @inXML.nodes('JobManager_SQLJobInfo') Tbl(Col)), 2)
	INSERT INTO @sqlInfoTbl
	SELECT
	ISNULL(Tbl.Col.value('@ReplicaUsed', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@DatabaseName', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@Status', 'int'), ''),
	ISNULL(Tbl.Col.value('@FailureReason', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@ConversionReason', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@StartTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@EndTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@ApplicationSize', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@firstLSN', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@lastLSN', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@InitiatedFrom', 'int'), ''),
	ISNULL(Tbl.Col.value('@sharePointVersion', 'int'), ''),
    ISNULL(Tbl.Col.value('@ConvertedJobPhase', 'int'), ''),
	ISNULL(Tbl.Col.value('@CurrentPhase', 'int'), ''),
	ISNULL(Tbl.Col.value('@state', 'int'), ''),
	ISNULL(Tbl.Col.value('@BackupCount', 'int'), 0)
	FROM @inXML.nodes('/JobManager_SQLJobInfo/db') as Tbl(Col)
	-- obtain lock first before fetch data from DB so that we will not hold obsolete data
	SET @lockName = 'JMSetSQLDBInfoLock_' + cast(@jobId as varchar(16))
	EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
	IF @lockResult NOT IN (0, 1)
	BEGIN
		SET @errorCode = @lockResult
		SET @errorMsg = 'Procedure [JMSetSqlDBInfo] Failed to acquired lock on:'+@lockName
		GOTO FINISH
	END
	-- Fetch from the DB and merge.
SET @dbXml =  (SELECT data From JMMisc WITH (READUNCOMMITTED) Where jobid = @jobId and commcellId = @commcellId and itemType = 28)
    IF  @dbXml IS NULL
    BEGIN
        SET @dbXml = '<JobManager_SQLJobInfo/>'
        SET @oldRowFound = 0
    END
	INSERT INTO #sqlInfoFromDB
	SELECT
	ISNULL(Tbl.Col.value('@ReplicaUsed', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@DatabaseName', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@Status', 'int'), ''),
	ISNULL(Tbl.Col.value('@FailureReason', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@ConversionReason', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@StartTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@EndTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@ApplicationSize', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@firstLSN', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@lastLSN', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@InitiatedFrom', 'int'), ''),
	ISNULL(Tbl.Col.value('@sharePointVersion', 'int'), ''),
	ISNULL(Tbl.Col.value('@ConvertedJobPhase', 'int'), ''),
	ISNULL(Tbl.Col.value('@CurrentPhase', 'int'), ''),
	ISNULL(Tbl.Col.value('@state', 'int'), ''),
	ISNULL(Tbl.Col.value('@BackupCount', 'int'), 0)
	FROM @dbXml.nodes('/JobManager_SQLJobInfo/db') as Tbl(Col)
	Merge #sqlInfoFromDB db
	Using @sqlInfoTbl input
	On db.DatabaseName = input.DatabaseName
	When MATCHED Then
	Update Set db.ReplicaUsed = input.ReplicaUsed, db.Status = input.Status, db.FailureReason = input.FailureReason,
		db.ConversionReason = CASE WHEN input.ConversionReason = '' THEN db.ConversionReason ELSE input.ConversionReason END,
		db.BackupCount = CASE WHEN (input.Status = 1 AND db.CurrentPhase = input.CurrentPhase) THEN db.BackupCount+1 ELSE input.BackupCount END,
		db.StartTime = CASE WHEN ((input.Status = 1 AND db.CurrentPhase = input.CurrentPhase AND input.StartTime < db.StartTime) OR (input.Status <> 1) OR (db.CurrentPhase <> input.CurrentPhase) OR (db.BackupCount=0)) THEN input.StartTime ELSE db.StartTime END,
		db.EndTime = CASE WHEN ((input.Status = 1 AND db.CurrentPhase = input.CurrentPhase AND input.EndTime > db.EndTime) OR (input.Status <> 1) OR (db.CurrentPhase <> input.CurrentPhase) OR (db.BackupCount=0)) THEN input.EndTime ELSE db.EndTime END,
		db.ApplicationSize = CASE WHEN (input.Status = 1 AND db.CurrentPhase = input.CurrentPhase) THEN db.ApplicationSize+input.ApplicationSize ELSE input.ApplicationSize END,
		db.firstLSN = CASE WHEN ((input.Status = 1 AND db.CurrentPhase = input.CurrentPhase AND input.StartTime < db.StartTime) OR (input.Status <> 1) OR (db.CurrentPhase <> input.CurrentPhase) OR (db.BackupCount=0)) THEN input.firstLSN ELSE db.firstLSN END,
		db.lastLSN = CASE WHEN ((input.Status = 1 AND db.CurrentPhase = input.CurrentPhase AND input.EndTime > db.EndTime) OR (input.Status <> 1) OR (db.CurrentPhase <> input.CurrentPhase) OR (db.BackupCount=0)) THEN input.lastLSN ELSE db.lastLSN END,
		db.InitiatedFrom = input.InitiatedFrom,
		db.sharePointVersion = input.sharePointVersion,
		db.ConvertedJobPhase = CASE WHEN input.Status = 3 THEN 0 ELSE CASE WHEN input.ConvertedJobPhase = 0 THEN db.ConvertedJobPhase ELSE input.ConvertedJobPhase END END,
		db.CurrentPhase = CASE WHEN input.CurrentPhase = 0 THEN db.CurrentPhase ELSE input.CurrentPhase END,
		db.state = input.state
	WHEN NOT MATCHED Then
	Insert values(input.ReplicaUsed, input.DatabaseName, input.Status,
	input.FailureReason, input.ConversionReason, input.StartTime,input.EndTime, input.ApplicationSize,
	input.firstLSN,input.lastLSN, input.InitiatedFrom, input.sharePointVersion, input.ConvertedJobPhase, input.CurrentPhase, input.state, CASE WHEN input.Status = 1 AND input.BackupCount = 0 THEN 1 ELSE input.BackupCount END);
	SET @dbXml = (
					SELECT
					ReplicaUsed		'@ReplicaUsed',
					DatabaseName	'@DatabaseName',
					Status		'@Status',
					FailureReason	'@FailureReason',
					ConversionReason '@ConversionReason',
					StartTime		'@StartTime',
					EndTime			'@EndTime',
					ApplicationSize	'@ApplicationSize',
					firstLSN		'@firstLSN',
					lastLSN			'@lastLSN',
					InitiatedFrom '@InitiatedFrom',
					sharePointVersion '@sharePointVersion',
					ConvertedJobPhase '@ConvertedJobPhase',
					CurrentPhase '@CurrentPhase',
					state	'@state',
					BackupCount '@BackupCount'
					FROM #sqlInfoFromDB order by DatabaseName
					FOR XML PATH('db'), ROOT('JobManager_SQLJobInfo')
				  )
    IF @oldRowFound = 1
    BEGIN
        UPDATE JMMisc
        SET data = cast(@dbXml as nvarchar(max))
WHERE jobid = @jobId and commcellId = @commcellId and itemType = 28
    END
    ELSE
    BEGIN
	    Insert Into JMMisc
values(@jobId, 0, 28, 0, 0, cast(@dbXml as nvarchar(max)), @commcellId)
    END
    IF @lockResult IN (0, 1)
		EXEC @lockResult = sp_releaseapplock @Resource = @lockName
	DROP TABLE #sqlInfoFromDB
	IF (@tranCnt = 0)
	BEGIN
		COMMIT TRAN JMSetSqlDBInfo_Tran
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRAN JMSetSqlDBInfo_Tran
	SET @errorCode = ERROR_MESSAGE()
	SET @errorMsg = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
FINISH:
	SET @outXml = (
					SELECT
						@errorCode '@errorCode',
						@errorMsg '@message'
					FOR XML PATH('App_GenericResp')
				  )
	SELECT @outXml
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMSetSqlDBInfo')
	delete from GxQscripts where name = 'JMSetSqlDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetSqlDBInfo')
	delete from GXDBVersions where aliasname = 'JMSetSqlDBInfo'
GO

insert into GXDBVersions values(2, 'JMSetSqlDBInfo',  '00010005000200100000', 'JMSetSqlDBInfo', '00010005000200100000')
GO

