

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSetMobileJobControlSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSetMobileJobControlSettings.sp,v $ $Id: JMSetMobileJobControlSettings.sp,v 1.4.212.2 2018/03/22 02:58:22 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMSetMobileJobControlSettings()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan   				Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMSetMobileJobControlSettings <<<'

IF EXISTS (select * from sysobjects where name='JMSetMobileJobControlSettings')
	drop procedure JMSetMobileJobControlSettings
IF EXISTS (select * from GxQscripts where name='JMSetMobileJobControlSettings')
	delete from GxQscripts where name = 'JMSetMobileJobControlSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetMobileJobControlSettings')
	delete from GXDBVersions where aliasname = 'JMSetMobileJobControlSettings'
GO
print '... Creating Procedure: JMSetMobileJobControlSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSetMobileJobControlSettings
  @inXml XML,
  @outXml XML	OUTPUT
AS
SET NOCOUNT ON
BEGIN
DECLARE @i_userId INT
DECLARE @i_userGuid VARCHAR(36)
DECLARE @i_errorCode INT = 0
DECLARE @i_errorString NVARCHAR(MAX)
DECLARE @i_jobControlSetting NVARCHAR(MAX)
SET   @i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
							  FROM  @inXml.nodes ('JobManager_SetJobControlSettingReq/userInfo') R(ref)), '')
IF (LEN(@i_userGuid) = 0)
BEGIN
	SET @i_errorCode = 1
	SET @i_errorString = 'Invalid User Info'
	GOTO EXIT_ERROR
END
SET @i_userId = ISNULL((SELECT TOP 1 id FROM UMUSERS WHERE userGuid = @i_userGuid) ,0)
IF (@i_userId = 0)
BEGIN
	SET @i_errorCode = 2
	SET @i_errorString = 'User Not Found'
	GOTO EXIT_ERROR
END
DECLARE @userPrefXml xml
SET @userPrefXml = ISNULL((SELECT @inXml.query('/JobManager_SetJobControlSettingReq/userPreference')),'')
IF EXISTS (SELECT * FROM APP_ComponentProp WHERE componentType = 14 AND componentId = @i_userId AND propertyTypeId = 1801 AND modified = 0)
BEGIN
	UPDATE APP_ComponentProp
	SET stringVal = CAST (@userPrefXml AS nvarchar(max))
WHERE componentType = 14 AND componentId = @i_userId AND propertyTypeId = 1801 AND modified = 0
END
ELSE
BEGIN
INSERT INTO [CommServ].[dbo].[APP_ComponentProp]
		   ([componentType]
		   ,[componentId]
		   ,[propertyTypeId]
		   ,[dataType]
		   ,[longVal]
		   ,[longlongVal]
		   ,[stringVal]
		   ,[created]
		   ,[modified])
	 VALUES
(14
		   ,@i_userId
,1801
		   ,1
		   ,0
		   ,0
		   ,CAST(@userPrefXml AS nvarchar(max))
		   ,(SELECT DBO.GETUNIXTIME(GETDATE()))
		   ,0)
END
EXIT_ERROR:
	IF @i_errorCode <> 0
	BEGIN
		SET @outXml = (
						SELECT @i_errorCode AS 'error/errList/@errorCode', @i_errorString AS 'error/errList/@errLogMessage'
						FOR XML PATH('JobManager_SetJobControlSettingResp'), TYPE
					   )
	END
	ELSE
		SET @outXml = '<JobManager_SetJobControlSettingResp />'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMSetMobileJobControlSettings')
	delete from GxQscripts where name = 'JMSetMobileJobControlSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetMobileJobControlSettings')
	delete from GXDBVersions where aliasname = 'JMSetMobileJobControlSettings'
GO

insert into GXDBVersions values(2, 'JMSetMobileJobControlSettings',  '00010004021200020000', 'JMSetMobileJobControlSettings', '00010004021200020000')
GO

