

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSetJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSetJobOptions.sp,v $ $Id: JMSetJobOptions.sp,v 1.3.40.1 2017/02/10 21:48:12 sjohnson Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Description:	Set the job options
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMSetJobOptions <<<'

IF EXISTS (select * from sysobjects where name='JMSetJobOptions')
	drop procedure JMSetJobOptions
IF EXISTS (select * from GxQscripts where name='JMSetJobOptions')
	delete from GxQscripts where name = 'JMSetJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetJobOptions')
	delete from GXDBVersions where aliasname = 'JMSetJobOptions'
GO
print '... Creating Procedure: JMSetJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSetJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inputXml XML
AS
BEGIN
  DECLARE @outputXml XML 
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg nvarchar(max) = ''
	SET NOCOUNT ON
	DECLARE @jmjoboptions TABLE
	(
		jobId				int,
		commCellId			int,
		attributeId			int,
		attributeName  		varchar(1024),
		attributeValueInt	bigint,
		attributeValue		varchar(max)
	)
	INSERT INTO @jmjoboptions
	SELECT
	ISNULL(i.col.value('@jobId', 'int'), 0),
	ISNULL(i.col.value('@commCellId', 'int'), 2),
	ISNULL(i.col.value('@attributeId', 'int'), 0),
	ISNULL(i.col.value('@attributeName', 'varchar(1024)'), ''),
	ISNULL(i.col.value('@attributeValueInt', 'int'), 0),
	ISNULL(i.col.value('@attributeValue', 'varchar(max)'), '')
	FROM
	@inputXml.nodes('JobManager_SetJmJobOptionsReq/jobOptions') i(col)
	BEGIN TRY
		DELETE A
		FROM JmJobOptions A
		INNER JOIN  @jmjoboptions B
		ON A.jobId = B.joBId And A.commcellId = B.commCellId And A.attributeId = B.AttributeId And A.attributeName = B.attributeName
		INSERT INTO JmJobOptions
		SELECT *FROM @jmjoboptions
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorMsg = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
	END CATCH
	SET @outputXml =	(
							SELECT
							@errorCode '@errorCode',
							@errorMsg '@errorMessage'
							FOR XML PATH('JobManager_SetJmJobOptionsResp')
						)
	IF @outputXml IS NULL
		SET @outputXml = '<JobManager_SetJmJobOptionsResp/>'
	SELECT @outputXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMSetJobOptions')
	delete from GxQscripts where name = 'JMSetJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetJobOptions')
	delete from GXDBVersions where aliasname = 'JMSetJobOptions'
GO

insert into GXDBVersions values(2, 'JMSetJobOptions',  '00010003004000010000', 'JMSetJobOptions', '00010003004000010000')
GO

