

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSetExchMBInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSetExchMBInfo.sp,v $ $Id: JMSetExchMBInfo.sp,v 1.1.2.14 2020/10/27 15:15:07 calonzo Exp $"
--
--  +========================================================================+
--  | Stored Precedure: JMSetExchMBInfo()
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMSetExchMBInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMSetExchMBInfo <<<'
	drop procedure JMSetExchMBInfo
END
IF EXISTS (select * from GxQscripts where name='JMSetExchMBInfo')
	delete from GxQscripts where name = 'JMSetExchMBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetExchMBInfo')
	delete from GXDBVersions where aliasname = 'JMSetExchMBInfo'
GO
print '... Creating Procedure: JMSetExchMBInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSetExchMBInfo
  @inXML XML
AS
  DECLARE @outXml XML
BEGIN
BEGIN TRY
	BEGIN TRAN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON
	DECLARE @jobId bigint
	DECLARE @commcellId int = 2
	DECLARE @dbXml XML
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg nvarchar(max) = ''
	DECLARE @totalMBs						int = 0
	DECLARE @successfulMBs					int = 0
	DECLARE @skippedMBs						int = 0
	DECLARE @failedMBs						int = 0
	DECLARE @suspendedMBs					int = 0
	DECLARE @successfulWithWarningMBs		int = 0
	DECLARE @toBeProcessedMBs				int = 0
	DECLARE @lockResult						int = -1
	DECLARE @lockName						varchar(64) = ''
	DECLARE @includeAll					bit = 0
	-- None of these temp tables should ever exist when this procedure is called!
	-- Using temp table since there could be thousands of rows (especially in the case of PST Ingestion)
	IF object_id('tempdb.dbo.#exchMBInfoFromDB') IS NOT NULL
	   DROP TABLE #exchMBInfoFromDB
	-- Using table variable since we should only be getting a few rows at a time during JM Update
	DECLARE @exchMBInfoTbl TABLE
	(
		displayName			nvarchar(2048),
		guid				nvarchar(2048),
		pstPath				nvarchar(2048),
		ownerGuid				nvarchar(2048),
		smtp				nvarchar(2048),
		pstOwner			nvarchar(2048),
		ownerType			int,
		size				bigint,
		modifiedTime		bigint,
		referenceTime		bigint,
		successfulMessages	bigint,
		failedMessages		bigint,
		skippedMessages		bigint,
		totalMessages		bigint,
		status				int,
		failureReason		nvarchar(max),
		agentName			nvarchar(2048)
	)
	-- Create a temp table in the image of the table variable
	SELECT *
	INTO #exchMBInfoFromDB
	FROM @exchMBInfoTbl
	SET @jobId = ISNULL((Select Tbl.Col.value('@jobId', 'bigint') From @inXML.nodes('JobManager_ExchMbJobInfo') Tbl(Col)), 0)
	SET @commcellId = ISNULL((Select Tbl.Col.value('@commcellId', 'int') From @inXML.nodes('JobManager_ExchMbJobInfo') Tbl(Col)), 2)
	SET @includeAll = ISNULL((Select Tbl.Col.value('@includeAll', 'bit') From @inXML.nodes('JobManager_ExchMbJobInfo') Tbl(Col)), 0)
	INSERT INTO @exchMBInfoTbl
	SELECT
	ISNULL(Tbl.Col.value('@DisplayName', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@GUID', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@PSTPath', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@OwnerGUID', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@SMTP', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@PSTOwner', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@ownerType', 'int'), 0),
	ISNULL(Tbl.Col.value('@Size', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@ModifiedTime', 'bigint'),0),
	ISNULL(Tbl.Col.value('@ReferenceTime', 'bigint'),0),
	ISNULL(Tbl.Col.value('@SuccessfulMessages', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@FailedMessages', 'bigint'),0),
	ISNULL(Tbl.Col.value('@SkippedMessages', 'bigint'),0),
	ISNULL(Tbl.Col.value('@TotalMessages', 'bigint'),0),
	ISNULL(Tbl.Col.value('@status', 'int'), 0),
	ISNULL(Tbl.Col.value('@FailureReason', 'nvarchar(max)'), ''),
	ISNULL(Tbl.Col.value('@AgentName', 'nvarchar(2048)'), '')
	FROM @inXML.nodes('/JobManager_ExchMbJobInfo/SourceMailboxStats') as Tbl(Col)
	SET @lockName = 'JMSetExchMBInfoLock_' + cast(@jobId as varchar(16))
	EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
	IF @lockResult NOT IN (0, 1)
	BEGIN
		SET @errorCode = @lockResult
		SET @errorMsg = 'Procedure [JMSetExchMBInfo] Failed to acquired lock on:'+@lockName
		ROLLBACK TRAN
		GOTO FINISH
	END
	-- Fetch from the DB and merge.
SET @dbXml =  ISNULL((SELECT data From JMMisc WHERE jobid = @jobId AND commcellId = @commcellId AND itemType = 28), '<JobManager_ExchDbJobInfo/>')
	INSERT INTO #exchMBInfoFromDB
	SELECT
	ISNULL(Tbl.Col.value('@DisplayName', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@GUID', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@PSTPath', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@OwnerGUID', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@SMTP', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@PSTOwner', 'nvarchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@ownerType', 'int'), 0),
	ISNULL(Tbl.Col.value('@Size', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@ModifiedTime', 'bigint'),0),
	ISNULL(Tbl.Col.value('@ReferenceTime', 'bigint'),0),
	ISNULL(Tbl.Col.value('@SuccessfulMessages', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@FailedMessages', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@SkippedMessages', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@TotalMessages', 'bigint'), 0),
	ISNULL(Tbl.Col.value('@status', 'int'),0),
	ISNULL(Tbl.Col.value('@FailureReason', 'nvarchar(max)'), ''),
	ISNULL(Tbl.Col.value('@AgentName', 'nvarchar(2048)'), '')
	FROM @dbXml.nodes('/JobManager_ExchMbJobInfo/SourceMailboxStats') AS Tbl(Col)
	MERGE #exchMBInfoFromDB db
	USING @exchMBInfoTbl input
	-- For Mailbox Archive jobs, displayName is unique. But not for PST Ingestion.
	-- For PST Ingestion pstPath and Guid are unique.
	-- So, add the Guid check as well
	ON db.guid = input.guid AND db.displayName = input.displayName
	WHEN MATCHED THEN
	UPDATE SET
			db.displayName = input.displayName,
			db.guid = input.guid,
			db.pstPath = input.pstPath,
			db.ownerGuid = input.ownerGuid,
			db.smtp = input.smtp,
			db.pstOwner = input.pstOwner,
			db.ownerType = input.ownerType,
			db.size = input.size,
			db.modifiedTime = input.modifiedTime,
			db.referenceTime = input.referenceTime,
			db.successfulMessages = input.successfulMessages,
			db.failedMessages = input.failedMessages,
			db.skippedMessages = input.skippedMessages,
			db.totalMessages = input.totalMessages,
			db.status = input.status,
			db.failureReason = input.failureReason,
			db.agentName = input.agentName
	WHEN NOT MATCHED THEN
	INSERT VALUES(
			input.displayName,
			input.guid,
			input.pstPath,
			input.ownerGuid,
			input.smtp,
			input.pstOwner,
			input.ownerType,
			input.size,
			input.modifiedTime,
			input.referenceTime,
			input.successfulMessages,
			input.failedMessages,
			input.skippedMessages,
			input.totalMessages,
			input.status,
			input.failureReason,
			input.agentName);
	SET @totalMBs = ISNULL((Select Tbl.Col.value('@TotalMBs', 'int') From @inXML.nodes('JobManager_ExchMbJobInfo/SourceMailboxCounters') Tbl(Col)), 0)
	SET @successfulMBs = ISNULL((Select Tbl.Col.value('@SuccessfulMBs', 'int') From @inXML.nodes('JobManager_ExchMbJobInfo/SourceMailboxCounters') Tbl(Col)), 0)
	SET @skippedMBs = ISNULL((Select Tbl.Col.value('@SkippedMBs', 'int') From @inXML.nodes('JobManager_ExchMbJobInfo/SourceMailboxCounters') Tbl(Col)), 0)
	SET @failedMBs = ISNULL((Select Tbl.Col.value('@FailedMBs', 'int') From @inXML.nodes('JobManager_ExchMbJobInfo/SourceMailboxCounters') Tbl(Col)), 0)
	SET @suspendedMBs = ISNULL((Select Tbl.Col.value('@SuspendedMBs', 'int') From @inXML.nodes('JobManager_ExchMbJobInfo/SourceMailboxCounters') Tbl(Col)), 0)
	SET @successfulWithWarningMBs = ISNULL((Select Tbl.Col.value('@SuccessfulWithWarningMBs', 'int') From @inXML.nodes('JobManager_ExchMbJobInfo/SourceMailboxCounters') Tbl(Col)), 0)
	SET @toBeProcessedMBs = @totalMBs - @successfulMBs - @skippedMBs - @failedMBs - @suspendedMBs - @successfulWithWarningMBs
	IF @toBeProcessedMBs < 0
	BEGIN
		SET @toBeProcessedMBs = 0
	END
	SET @dbXml = (
					SELECT
					(
						SELECT
						displayName			'@DisplayName',
						guid				'@GUID',
						pstPath 			'@PSTPath',
						ownerGuid			'@OwnerGUID',
						smtp				'@SMTP',
						pstOwner			'@PSTOwner',
						ownerType			'@ownerType',
						size				'@Size',
						modifiedTime		'@ModifiedTime',
						referenceTime		'@ReferenceTime',
						successfulMessages	'@SuccessfulMessages',
						failedMessages		'@FailedMessages',
						skippedMessages		'@SkippedMessages',
						totalMessages		'@TotalMessages',
						status				'@status',
						failureReason		'@FailureReason',
						agentName			'@AgentName'
						FROM #exchMBInfoFromDB
							WHERE (@includeAll = 1)
							-- For PST Ingestion, include all statuses
							OR status IN (1,2,4,5)
							-- status IN ExchMailboxStatusFlags::FAILED, ExchMailboxStatusFlags::SKIPPED, ExchMailboxStatusFlags::SUSPENDED, ExchMailboxStatusFlags::SUCCESSWITHWARNING
							-- from "XmlMessage/JobManagerEnumBase.h"
						FOR XML PATH('SourceMailboxStats'), TYPE
					),
					(
						SELECT
						@totalMBs					'@TotalMBs',
						@successfulMBs				'@SuccessfulMBs',
						@skippedMBs					'@SkippedMBs',
						@failedMBs					'@FailedMBs',
						@suspendedMBs				'@SuspendedMBs',
						@successfulWithWarningMBs	'@SuccessfulWithWarningMBs',
						@toBeProcessedMBs			'@ToBeProcessedMBs'
						FOR XML PATH('SourceMailboxCounters'), TYPE
					)
					For XML PATH(''), ROOT('JobManager_ExchMbJobInfo')
				  )
	DELETE FROM JMMisc
WHERE jobid = @jobId and commcellId = @commcellId and itemType = 28
	INSERT INTO JMMisc
VALUES(@jobId, 0, 28, 0, 0, CAST(@dbXml AS nvarchar(max)), @commcellId)
	DROP TABLE #exchMBInfoFromDB
	IF @lockResult IN (0, 1)
		EXEC @lockResult = sp_releaseapplock @Resource = @lockName
	COMMIT TRAN
END TRY
BEGIN CATCH
	ROLLBACK TRAN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_MESSAGE()
	SET @errorMsg = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
FINISH:
	SET @outXml = (
					SELECT
						@errorCode '@errorCode',
						@errorMsg '@message'
					FOR XML PATH('App_GenericResp')
				  )
	SELECT @outXml
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMSetExchMBInfo')
	delete from GxQscripts where name = 'JMSetExchMBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetExchMBInfo')
	delete from GXDBVersions where aliasname = 'JMSetExchMBInfo'
GO

insert into GXDBVersions values(2, 'JMSetExchMBInfo',  '00010001000200140000', 'JMSetExchMBInfo', '00010001000200140000')
GO

