

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSetExchDBInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSetExchDBInfo.sp,v $ $Id: JMSetExchDBInfo.sp,v 1.4.2.4 2018/03/22 03:12:11 jiechen Exp $"
--
--  +========================================================================+
--  | Stored Precedure: JMSetExchDBInfo()
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMSetExchDBInfo <<<'

IF EXISTS (select * from sysobjects where name='JMSetExchDBInfo')
	drop procedure JMSetExchDBInfo
IF EXISTS (select * from GxQscripts where name='JMSetExchDBInfo')
	delete from GxQscripts where name = 'JMSetExchDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetExchDBInfo')
	delete from GXDBVersions where aliasname = 'JMSetExchDBInfo'
GO
print '... Creating Procedure: JMSetExchDBInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSetExchDBInfo
  @inXML XML
AS
  DECLARE @outXml XML
BEGIN
BEGIN TRY
	BEGIN TRAN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON
	DECLARE @jobId bigint
	DECLARE @commcellId int = 2
	DECLARE @dbXml XML
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg nvarchar(max) = ''
	DECLARE @totalDBs		int = 0
	DECLARE @pendingDBs		int = 0
	DECLARE @successfulDBs	int = 0
	DECLARE @skippedDBs		int = 0
	DECLARE @failedDBs		int = 0
	DECLARE @processingDBs	int = 0
	DECLARE @suspendedDBs	int = 0
	DECLARE @lockResult		int = -1
	DECLARE @lockName		varchar(64) = ''
	-- None of these temp tables should ever exist when this procedure is called!
	IF object_id('tempdb.dbo.#exchDBInfoFromDB') IS NOT NULL
	   DROP TABLE #exchDBInfoFromDB
	DECLARE @exchDBInfoTbl TABLE
	(
		serverName			varchar(2048),
		applicationSize		bigint,
		startTime			bigint,
		endTime				bigint,
		failureReason		varchar(max),
		status				int,
		DatabaseName		varchar(2048)
	)
	SELECT *
	INTO #exchDBInfoFromDB
	FROM @exchDBInfoTbl
	SET @jobId = ISNULL((Select Tbl.Col.value('@jobId', 'bigint') From @inXML.nodes('JobManager_ExchDbJobInfo') Tbl(Col)), 0)
	SET @commcellId = ISNULL((Select Tbl.Col.value('@commcellId', 'int') From @inXML.nodes('JobManager_ExchDbJobInfo') Tbl(Col)), 2)
	INSERT INTO @exchDBInfoTbl
	SELECT
	ISNULL(Tbl.Col.value('@ExchangeServerName', 'varchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@ApplicationSize', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@startTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@endTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@FailureReason', 'varchar(max)'), ''),
	ISNULL(Tbl.Col.value('@status', 'int'), ''),
	ISNULL(Tbl.Col.value('@dbName', 'varchar(2048)'), '')
	FROM @inXML.nodes('/JobManager_ExchDbJobInfo/SourceDatabaseStats') as Tbl(Col)
	SET @lockName = 'JMSetExchDBInfoLock_' + cast(@jobId as varchar(16))
	EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
	IF @lockResult NOT IN (0, 1)
	BEGIN
		SET @errorCode = @lockResult
		SET @errorMsg = 'Procedure [JMSetExchDBInfo] Failed to acquired lock on:'+@lockName
		ROLLBACK TRAN
		GOTO FINISH
	END
	-- Fetch from the DB and merge.
SET @dbXml =  ISNULL((SELECT data From JMMisc Where jobid = @jobId and commcellId = @commcellId and itemType = 28), '<JobManager_ExchDbJobInfo/>')
	INSERT INTO #exchDBInfoFromDB
	SELECT
	ISNULL(Tbl.Col.value('@ExchangeServerName', 'varchar(2048)'), ''),
	ISNULL(Tbl.Col.value('@ApplicationSize', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@startTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@endTime', 'bigint'), ''),
	ISNULL(Tbl.Col.value('@FailureReason', 'varchar(max)'), ''),
	ISNULL(Tbl.Col.value('@status', 'int'), ''),
	ISNULL(Tbl.Col.value('@dbName', 'varchar(2048)'), '')
	FROM @dbXml.nodes('/JobManager_ExchDbJobInfo/SourceDatabaseStats') as Tbl(Col)
	Merge #exchDBInfoFromDB db
	Using @exchDBInfoTbl input
	On db.DatabaseName = input.DatabaseName
	When MATCHED Then
	Update Set db.serverName = input.serverName, db.applicationSize = input.applicationSize, db.startTime = input.startTime, db.endTime = input.endTime, db.failureReason = input.failureReason, db.status = input.status, db.DatabaseName = input.DatabaseName
	WHEN NOT MATCHED Then
	Insert values(input.serverName, input.applicationSize, input.startTime,
	input.endTime, input.failureReason, input.status,input.DatabaseName);
	SET @totalDBs = ISNULL((Select count(*) from #exchDBInfoFromDB), 0)
	SET @pendingDBs = ISNULL((Select count(*) from #exchDBInfoFromDB where status = 1/*Pending*/), 0)
	SET @successfulDBs = ISNULL((Select count(*) from #exchDBInfoFromDB where status = 5/*Successful*/), 0)
	SET @skippedDBs = ISNULL((Select count(*) from #exchDBInfoFromDB where status = 4/*Skipped*/),0)
	SET @failedDBs = ISNULL((Select count(*) from #exchDBInfoFromDB where status = 3/*Failed*/),0)
	SET @processingDBs = ISNULL((Select count(*) from #exchDBInfoFromDB where status = 2/*Processing*/),0)
	SET @suspendedDBs = ISNULL((Select count(*) from #exchDBInfoFromDB where status = 6/*Suspended*/),0)
	SET @dbXml = (
					SELECT
					(
						SELECT
						serverName		'@ExchangeServerName',
						applicationSize	'@ApplicationSize',
						startTime		'@startTime',
						endTime			'@endTime',
						failureReason	'@FailureReason',
						status			'@status',
						DatabaseName	'@dbName'
						FROM #exchDBInfoFromDB
						FOR XML PATH('SourceDatabaseStats'), TYPE
					),
					(
						SELECT
						@totalDBs			'@TotalDBs',
						@pendingDBs			'@PendingDBs',
						@successfulDBs		'@SuccessfulDBs',
						@skippedDBs			'@SkippedDBs',
						@failedDBs			'@FailedDBs',
						@processingDBs		'@processingDBs',
						@suspendedDBs		'@suspendedDBs'
						FOR XML PATH('SourceDatabaseCounters'), TYPE
					)
					For XML PATH(''), ROOT('JobManager_ExchDbJobInfo')
				  )
Delete From JMMisc Where jobid = @jobId and commcellId = @commcellId and itemType = 28
	Insert Into JMMisc
values(@jobId, 0, 28, 0, 0, cast(@dbXml as nvarchar(max)), @commcellId)
	DROP TABLE #exchDBInfoFromDB
	IF @lockResult IN (0, 1)
		EXEC @lockResult = sp_releaseapplock @Resource = @lockName
	COMMIT TRAN
END TRY
BEGIN CATCH
	ROLLBACK TRAN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_MESSAGE()
	SET @errorMsg = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
FINISH:
	SET @outXml = (
					SELECT
						@errorCode '@errorCode',
						@errorMsg '@message'
					FOR XML PATH('App_GenericResp')
				  )
	SELECT @outXml
END
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMSetExchDBInfo')
	delete from GxQscripts where name = 'JMSetExchDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetExchDBInfo')
	delete from GXDBVersions where aliasname = 'JMSetExchDBInfo'
GO

insert into GXDBVersions values(2, 'JMSetExchDBInfo',  '00010004000200040000', 'JMSetExchDBInfo', '00010004000200040000')
GO

