

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSetDashMAs.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMSetDashMAs()
--  |				 Description:  Set the source MAs used for the Dash job as job option.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSetDashMAs.sp,v $ $Id: JMSetDashMAs.sp,v 1.4.14.2 2018/03/22 03:19:09 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMSetDashMAs <<<'

IF EXISTS (select * from sysobjects where name='JMSetDashMAs')
	drop procedure JMSetDashMAs
IF EXISTS (select * from GxQscripts where name='JMSetDashMAs')
	delete from GxQscripts where name = 'JMSetDashMAs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetDashMAs')
	delete from GXDBVersions where aliasname = 'JMSetDashMAs'
GO
print '... Creating Procedure: JMSetDashMAs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSetDashMAs
  @i_jobId integer,
  @i_commcellId integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
SET @errorCode = 0
DECLARE	@SourceMAs	TABLE(id int)
DECLARE	@srcMAs		NVARCHAR(max)
INSERT INTO @SourceMAs
SELECT DISTINCT srcMAId FROM ArchJobStreamStatusHistory(NOLOCK) WHERE jobid = @i_jobId and SrcMAId > 0
and status = 0x02 /* #define STREAM_READER_STATUS_INITED 0x02 macro*/
IF EXISTS (SELECT *FROM @SourceMAs)
BEGIN
	SELECT @srcMAs = COALESCE(@srcMAs + ',', '') + cast(id as varchar(32))FROM @SourceMAs
	Insert Into JMMisc
values(@i_jobId, 0, 31, 0, 0, @srcMAs, @i_commcellId)
END
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMSetDashMAs')
	delete from GxQscripts where name = 'JMSetDashMAs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSetDashMAs')
	delete from GXDBVersions where aliasname = 'JMSetDashMAs'
GO

insert into GXDBVersions values(2, 'JMSetDashMAs',  '00010004001400020000', 'JMSetDashMAs', '00010004001400020000')
GO

