

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSaveJobIdForInlineCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Baishen Zhu
--	Date:   10/05/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSaveJobIdForInlineCopy.sp,v $ $Id: JMSaveJobIdForInlineCopy.sp,v 1.1.4.2 2018/10/20 22:03:13 pkoti Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMSaveJobIdForInlineCopy')
BEGIN
	print '>>> Drop Stored Procedure: JMSaveJobIdForInlineCopy <<<'
	drop procedure JMSaveJobIdForInlineCopy
END
IF EXISTS (select * from GxQscripts where name='JMSaveJobIdForInlineCopy')
	delete from GxQscripts where name = 'JMSaveJobIdForInlineCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSaveJobIdForInlineCopy')
	delete from GXDBVersions where aliasname = 'JMSaveJobIdForInlineCopy'
GO
print '... Creating Procedure: JMSaveJobIdForInlineCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSaveJobIdForInlineCopy
  @jobid INTEGER,
  @commcellId INTEGER,
  @applicationId INTEGER,
  @processedJobId INTEGER,
  @bkpOptions INTEGER,
  @fullCycleNum INTEGER,
  @servEndDate INTEGER,
  @childJobId INTEGER,
  @submitStatus INTEGER,
  @childOpType INTEGER,
  @processedCommcellId INTEGER,
  @step INTEGER,
  @stepType INTEGER
AS
  DECLARE @errorCode INTEGER
	SET NOCOUNT ON
	INSERT INTO JMJobWF (jobId, commcellId, applicationId, processedJobId, bkpOptions, fullCycleNum, servEndDate, childJobId, submitStatus, childOpType, processedCommcellId, step, stepType)
	VALUES(@jobId, @commcellId, @applicationId, @processedJobId, @bkpOptions, @fullCycleNum, @servEndDate, @childJobId, @submitStatus, @childOpType, @processedCommcellId, @step, @stepType)
	-- insert entries for VM child job, by default, include all the VM being backed up
   DECLARE @iChildJobId INT
	DECLARE @iChildAppId INT
	DECLARE @iFullCycleNum INT
	DECLARE @iCommcellId INT
	DECLARE @iBkpOptions INT
	DECLARE @iServEndDate INT
	DECLARE childVmJobsCursor CURSOR FOR
   SELECT JMJobDataLink.childJobId, JMJobDataLink.childAppid, JMBkpStats.fullCycleNum, JMBkpStats.commcellId, JMBkpStats.bkpOptions, JMBkpStats.servEndDate FROM JMBkpStats, JMJobDataLink
	WHERE   JMJobDataLink.childJobId = JMBkpStats.jobId
   	AND JMJobDataLink.commCellId = JMBkpStats.commCellId
		AND JMJobDataLink.parentJobId = @processedJobId
		AND JMJobDataLink.commCellId = @processedCommcellId
		AND JMJobDataLink.linkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
	OPEN childVmJobsCursor
	FETCH childVmJobsCursor INTO @iChildJobId, @iChildAppId, @iFullCycleNum, @iCommcellId, @iBkpOptions, @iServEndDate
   WHILE   @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO JMJobWF (jobId, commcellId, applicationId, processedJobId, bkpOptions, fullCycleNum, servEndDate, childJobId, submitStatus, childOpType, processedCommcellId, step, stepType)
		VALUES(@jobId, @commcellId, @iChildAppId, @iChildJobId, @iBkpOptions, @iFullCycleNum, @iServEndDate, @childJobId, @submitStatus, @childOpType, @iCommcellId, @step, @stepType)
		FETCH childVmJobsCursor INTO @iChildJobId, @iChildAppId, @iFullCycleNum, @iCommcellId, @iBkpOptions, @iServEndDate
	END
   CLOSE childVmJobsCursor
	DEALLOCATE childVmJobsCursor
	SET @errorCode		= @@ERROR
	SELECT @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMSaveJobIdForInlineCopy')
	delete from GxQscripts where name = 'JMSaveJobIdForInlineCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSaveJobIdForInlineCopy')
	delete from GXDBVersions where aliasname = 'JMSaveJobIdForInlineCopy'
GO

insert into GXDBVersions values(2, 'JMSaveJobIdForInlineCopy',  '00010001000400020000', 'JMSaveJobIdForInlineCopy', '00010001000400020000')
GO

