

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMSapBrowse.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMSapBrowse.sp,v $ $Id: JMSapBrowse.sp,v 1.11.60.2 2018/03/22 03:13:03 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMSapBrowse
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMSapBrowse <<<'

IF EXISTS (select * from sysobjects where name='JMSapBrowse')
	drop procedure JMSapBrowse
IF EXISTS (select * from GxQscripts where name='JMSapBrowse')
	delete from GxQscripts where name = 'JMSapBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSapBrowse')
	delete from GXDBVersions where aliasname = 'JMSapBrowse'
GO
print '... Creating Procedure: JMSapBrowse'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMSapBrowse
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXMl XML
AS
  DECLARE @dummyXml XML
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
DECLARE @inClientId INT
DECLARE @inAppType INT
DECLARE @inInstanceId INT
DECLARE @inSubclientId INT
DECLARE @fromTime	INT
DECLARE @toTime	INT
DECLARE @commcellId	INT
DECLARE @userId INT
DECLARE @localeId INT
DECLARE @r_capabilityId INT
DECLARE @entityXml xml
DECLARE @r_errorCode int
DECLARE @r_errorString nvarchar(max)
SET @inClientId = ISNULL (( SELECT ref.value('@clientId', 'INTEGER')FROM @inXMl.nodes('JobManager_SapLogBrowseReq') R(ref)), 0)
SET @inAppType = ISNULL (( SELECT ref.value('@appTypeId', 'INTEGER')FROM @inXMl.nodes('JobManager_SapLogBrowseReq') R(ref)), 0)
SET @inInstanceId = ISNULL (( SELECT ref.value('@instanceId', 'INTEGER')FROM @inXMl.nodes('JobManager_SapLogBrowseReq') R(ref)), 0)
SET @inSubclientId = ISNULL (( SELECT ref.value('@subclientId', 'INTEGER')FROM @inXMl.nodes('JobManager_SapLogBrowseReq') R(ref)), 0)
SET @fromTime = ISNULL (( SELECT ref.value('@toTime', 'INTEGER')FROM @inXMl.nodes('JobManager_SapLogBrowseReq') R(ref)), 0)
SET @toTime = ISNULL (( SELECT ref.value('@fromTime', 'INTEGER')FROM @inXMl.nodes('JobManager_SapLogBrowseReq') R(ref)), 0)
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                         FROM    @inXMl.nodes('JobManager_SapLogBrowseReq/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
                         FROM    @inXMl.nodes('JobManager_SapLogBrowseReq/processinginstructioninfo/locale') R ( ref )),0)
SET @r_capabilityId = 13
	IF object_id('tempdb.dbo.#SubclientList') is not null DROP TABLE #SubclientList
	CREATE TABLE #SubclientList(id INTEGER)
	IF object_id('tempdb.dbo.#tempJobXML') is not null DROP TABLE #tempJobXML
	CREATE TABLE #tempJobXML(jobId INTEGER,xmljobinfo nvarchar(max),startDate	INT,bkpLevel INT, bkpAttributes	BIGINT, commcellId INT)
	IF(@inSubclientId <> 0)
	BEGIN
		INSERT INTO #SubclientList VALUES(@inSubclientId)
		SET @commcellId = (SELECT origCCId from APP_Application where id = @inSubclientId)
	END
	IF(@inClientId <> 0 AND @inAppType <> 0 AND @inInstanceId <> 0 )
	BEGIN
		INSERT INTO #SubclientList
		SELECT APP_Application.id FROM APP_Application WHERE clientId = @inClientId AND appTypeId = @inAppType
		AND instance = @inInstanceId
		SET @commcellId = (SELECT origCCId from APP_Client where id = @inClientId)
	END
	ELSE IF(@inClientId <> 0 AND @inAppType <> 0)
	BEGIN
		INSERT INTO #SubclientList
		SELECT APP_Application.id FROM APP_Application WHERE clientId = @inClientId AND appTypeId = @inAppType
		SET @commcellId = (SELECT origCCId from APP_Client where id = @inClientId)
	END
-- Perform security checks here. If not return GenericResponse here itself
set @entityXml = (select @inAppType as '@applicationId',
							 @inClientId as '@clientId',
							 @inInstanceId as '@instanceId',
							 6 as '@_type_'
							 for xml path('entity'))
exec [dbo].[Sec_DoesUserHaveRightsOnEntity] @entityXml,@userId,@r_capabilityId,1,@localeId,@r_errorString OUTPUT
if (len(@r_errorString)>0)
begin
	set @r_errorCode = 1
	SET @inXMl = (SELECT '<?xml version="1.0" encoding="utf-16" ?>' +
	(SELECT
	@r_errorCode			     as errorCode,
	@r_errorString	         as errorMessage
FOR XML PATH('CVGui_GenericResp')))
	SELECT @inXMl
	return
end
INSERT INTO #tempJobXML
SELECT JMJobStats.jobId ,
 JMJobStats.xmlJobInfo,JMBkpStats.servStartDate,JMBkpStats.bkpLevel,JMBkpStats.bkpattributes, JMJobStats.commCellId
FROM JMJobStats, JMBkpStats WHERE JMJObStats.jobId = JMBkpStats.jobId	AND JMBkpStats.logsBackedUp = 1 AND
(JMJobStats.commCellId = @commcellId OR JMJobStats.commCellId = 2) AND JMJobStats.commCellId = JMBkpStats.commCellId  AND
LEN(JMJobStats.xmljobinfo) > 0 AND
JMBkpStats.appId IN(SELECT id FROM #SubclientList) AND ((@fromTime = 0 AND @toTime = 0) or  ( @fromTime >= JMBkpStats.servStartDate AND @toTime <= JMBkpStats.servEndDate))
IF (@fromTime = 0 AND @toTime = 0)
BEGIN
DELETE	#tempJobXML
   	WHERE
   startDate < ISNULL((SELECT MAX(servStartDate) FROM JMBkpStats with (nolock) WHERE appId IN(SELECT id FROM #SubclientList) AND status IN (1, 3, 14) AND bkpLevel IN (1, 1024, 32768) AND (bkpAttributes & 0x1000) <> 0), 0)
END
SET @inXMl = ''
SET @inXMl = IsNull((
SELECT jobId "@jobId" ,
 xmljobinfo "@xmlJobInfo",
commcellId "@commcellId"
FROM #tempJobXML
FOR XML PATH('sapLogs'), ROOT('JobManager_SapLogBrowseResp')),'<JobManager_SapLogBrowseResp/>')
DROP TABLE #tempJobXML
DROP TABLE #SubclientList
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @inXMl = ''
END CATCH;
SELECT @inXMl
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'JMSapBrowse')
	delete from GxQscripts where name = 'JMSapBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMSapBrowse')
	delete from GXDBVersions where aliasname = 'JMSapBrowse'
GO

insert into GXDBVersions values(2, 'JMSapBrowse',  '00010011006000020000', 'JMSapBrowse', '00010011006000020000')
GO

