

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMRegisterCDRJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Author: Eugene Volohov
--      Date:   28/11/2006
--
--      | Input:                pairID  - pair id
--                                                          status      - initial status
--
--      | Output:               jobId   - job id
--                                                              existed - job existing flag
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMRegisterCDRJob.sp,v $ $Id: JMRegisterCDRJob.sp,v 1.15.50.1 2018/03/22 03:03:18 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMRegisterCDRJob <<<'

IF EXISTS (select * from sysobjects where name='JMRegisterCDRJob')
	drop procedure JMRegisterCDRJob
IF EXISTS (select * from GxQscripts where name='JMRegisterCDRJob')
	delete from GxQscripts where name = 'JMRegisterCDRJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMRegisterCDRJob')
	delete from GXDBVersions where aliasname = 'JMRegisterCDRJob'
GO
print '... Creating Procedure: JMRegisterCDRJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMRegisterCDRJob
  @jobRequest INTEGER,
  @pairOrJobId INTEGER,
  @oldStatus INTEGER,
  @newPhase INTEGER,
  @newStatus INTEGER
AS
  DECLARE @locJobId INTEGER
  DECLARE @existed INTEGER
    DECLARE @currentAtmptNo  INTEGER
    DECLARE @currentPhaseNo  INTEGER
    DECLARE @currentStatus   INTEGER
    DECLARE @defaultCCId INT = 2
	DECLARE @t_JobId        TABLE( jobId int )  --Temp table
    set transaction isolation level read uncommitted
    IF @jobRequest IS null OR @jobRequest = 0 BEGIN -- this is a state change request
        -- check if job exists and retrieve
		-- current phase (@currentPhaseNo), current attempt(@currentAtmptNo) and current status (@currentStatus)
        SELECT @locJobId = JMCdrJobs.jobId, @currentPhaseNo = JMCdrJobs.currentPhase, @currentAtmptNo = JMCdrJobs.currentAttempt, @currentStatus = ISNULL(JMCdrJobs.currentStatus, 0)
        FROM   JMCdrJobs
        WHERE  JMCdrJobs.jobId = @pairOrJobId
		-- now we have the following
		-- @locJobId
		-- @currentPhaseNo
		-- @currentAtmptNo
		-- @currentStatus
        IF @locJobId IS null BEGIN  -- job for the given pair does not exist
            SET @existed = 0        -- report that job does not exists
        END
        ELSE BEGIN                  -- job exist
            SET @existed = 1        -- report that job exists
			-- first of all we have to mark current (latest) attempt with the passed status.
			-- if passed status is 0 or is missing then we have to leave status of current (latest)
			-- attempt unchenged
			-- check if state for last attempt parameter was passed
            IF @oldStatus IS NOT null AND @oldStatus > 0 BEGIN
				-- it is passed
				-- we have to mark current attempt with passed status
				-- update 'main' record with a status
                UPDATE JMCdrJobs SET currentStatus = @oldStatus, unverifiable = 0
                WHERE JMCdrJobs.jobId = @pairOrJobId
                and commCellId = @defaultCCId
				-- update attempt record with a status
                UPDATE JMCdrAttempts
                SET    JMCdrAttempts.status		 = @oldStatus
                WHERE  JMCdrAttempts.jobId       = @pairOrJobId    AND
					   JMCdrAttempts.commCellId  = @defaultCCId and
                       JMCdrAttempts.phaseNum    = @currentPhaseNo AND
                       JMCdrAttempts.attemptNum  = @currentAtmptNo
            END
			-- after that we have to create a new attempts record if information for new attempt was sent
			-- check if newPhase parameter was sent. ie not NULL and more then 0
            IF @newPhase IS NOT null AND @newPhase > 0 BEGIN -- we have to create new attempt for a new phase
				-- yes, we have to create new attempt record
                -- set end time for the last attempt and duration
                UPDATE JMCdrAttempts
                SET    JMCdrAttempts.endTime	 = dbo.GetUnixTime( GETUTCDATE() ),
                       JMCdrAttempts.elapsedTime = dbo.GetUnixTime( GETUTCDATE() ) - JMCdrAttempts.startTime
                WHERE  JMCdrAttempts.jobId       = @pairOrJobId    AND
					   JMCdrAttempts.commCellId  = @defaultCCId and
                       JMCdrAttempts.phaseNum    = @currentPhaseNo AND
                       JMCdrAttempts.attemptNum  = @currentAtmptNo
                -- determine attempt number for the phase number
                SELECT @currentAtmptNo = ISNULL( MAX(JMCdrAttempts.attemptNum), 0 ) + 1
                FROM   JMCdrAttempts
                WHERE  (JMCdrAttempts.jobId = @locJobId) AND
					   (JMCdrAttempts.commCellId  = @defaultCCId ) and
					   (JMCdrAttempts.phaseNum  = @newPhase)
                -- update 'main' record
                UPDATE JMCdrJobs
                SET    JMCdrJobs.currentStatus               = @newStatus,
                       JMCdrJobs.lastStateChangeTime         = dbo.GetUnixTime( GETUTCDATE() ),
                       JMCdrJobs.lastUpdateTime              = dbo.GetUnixTime( GETUTCDATE() ),
                       JMCdrJobs.currentThroughput           = 0,
                       JMCdrJobs.currentPhase                = @newPhase,
                       JMCdrJobs.currentAttempt              = @currentAtmptNo,
                       JMCdrJobs.currentFileBeingTransfered  = N'',
                       JMCdrJobs.currentSourceLogNumber      = 0,
                       JMCdrJobs.currentDestinationLogNumber = 0,
                       JMCdrJobs.lastLoggedPlayedNumber      = 0,
                       JMCdrJobs.lastLogPlayedTime           = 0,
                       JMCdrJobs.abortReason                 = 0,
		               JMCdrJobs.failureReason		         = N'',
                       JMCdrJobs.clientStatusChangeTime      = dbo.GetUnixTime( GETUTCDATE() ),
                       JMCdrJobs.unverifiable                = 0
                WHERE  JMCdrJobs.jobId = @locJobId
				and	   JMCdrJobs.commCellId  = @defaultCCId
				-- check what we should do with the current values for
				-- number of files to transfer
				-- number of files transfered
				-- number of bytes to transfer
				-- number of bytes transfered
				-- number of bytes replicated
				-- no matter what we have to reset value for number of bytes replicated
				UPDATE JMCdrJobs SET JMCdrJobs.bytesReplicated = 0 WHERE JMCdrJobs.jobId = @locJobId
				IF (@newPhase < @currentPhaseNo) AND ((@newPhase = 1) OR (@newPhase = 3)) BEGIN
                    UPDATE  JMCdrJobs
                    SET     JMCdrJobs.bytesTransfered = 0,
                            JMCdrJobs.bytesToTransfer = 0,
                            JMCdrJobs.filesTransfered = 0,
                            JMCdrJobs.filesToTransfer = 0
                    WHERE  JMCdrJobs.jobId = @locJobId
                    and	   JMCdrJobs.commCellId  = @defaultCCId
				END
	                -- create new attempt
                INSERT INTO JMCdrAttempts
                (
                    jobId,
                    phaseNum,
                    attemptNum,
                    status,
                    startTime,
                    endTime,
                    elapsedTime,
                    dataTransfer,
                    numberOfFilesToTransfer,
                    noFilesTransfered,
                    averageThroughput,
                    bytesToTransfer,
                    abortReason,
                    failureReason,
                    commCellId
                )
                VALUES
                (
                    @locJobId,                    -- jobId
                    @newPhase,                    -- phaseNum
                    @currentAtmptNo,              -- attemptNum
                    @newStatus,                   -- status
                    dbo.GetUnixTime(GETUTCDATE()),-- startTime
                    0,                            -- endTime
                    0,                            -- elapsedTime
                    0,                            -- dataTransfer
                    0,                            -- numberOfFilesToTransfer
                    0,                            -- noFilesTransfered
                    0,                            -- averageThroughput
                    0,                            -- bytesToTransfer
                    0,                            -- abortReason,
                    N'',                         -- failureReason
                    @defaultCCId		  -- commCellId
                )
            END -- @newPhase IS NOT null AND @newPhase > 0
        END -- @locJobId IS NOT null
    END -- @jobRequest IS null OR @jobRequest = 0
    ELSE BEGIN -- @jobRequest IS NOT null AND @jobRequest > 0
        -- this is a job request
        -- check if job exists and retrieve
		-- current phase (@currentPhaseNo), current attempt(@currentAtmptNo) and current status (@currentStatus)
        SELECT @locJobId = JMCdrJobs.jobId, @currentPhaseNo = JMCdrJobs.currentPhase, @currentAtmptNo = JMCdrJobs.currentAttempt, @currentStatus = ISNULL(JMCdrJobs.currentStatus, 0)
        FROM   JMCdrJobs
        WHERE  JMCdrJobs.pairId = @pairOrJobId
		-- this is a brand new job
		-- just create a records for this job in tables
        IF @locJobId IS null BEGIN
            -- there is no such job. create one
            SET @existed = 0
            -- get next available job id
            -- get job id
			INSERT INTO @t_JobId
            EXEC @locJobId = [dbo].[JMGetNextJobId]
            -- create 'main' record
            INSERT INTO JMCdrJobs
            VALUES
            (
                @locJobId,                  -- jobId
                @pairOrJobId,               -- pairId
                @newStatus,                 -- currentStatus
                dbo.GETUNIXTIME(GETUTCDATE()), -- lastStateChangeTime
                dbo.GETUNIXTIME(GETUTCDATE()), -- lastUpdateTime
                0,                          -- currentThroughput
                @newPhase,                  -- currentPhase
                1,                          -- currentAttempt
                N'',                        -- currentFileBeingTransfered
                0,                          -- currentSourceLogNumber
                0,                          -- currentDestinationLogNumber
                0,                          -- lastLoggedPlayedNumber
                0,                          -- lastLogPlayedTime
                0,                          -- noOfGUIMonitors
                0,                          -- bytesToTransfer
                0,                          -- bytesTransfered
                0,                          -- abortReason
                0,                          -- filesToTransfer
                0,                          -- filesTransfered
                0,                          -- bytesReplicated
				N'',			            -- failureReason
				dbo.GETUNIXTIME(GETUTCDATE()), -- clientStatusChangeTime
				0,                            -- unverifiable
				@defaultCCId		-- commCellId
            )
            -- create attempt record
            INSERT INTO JMCdrAttempts
            (
                jobId,
                phaseNum,
                attemptNum,
                status,
                startTime,
                endTime,
                elapsedTime,
                dataTransfer,
                numberOfFilesToTransfer,
                noFilesTransfered,
                averageThroughput,
                bytesToTransfer,
                abortReason,
                failureReason,
                commCellId
            )
            VALUES
            (
                @locJobId,                    -- jobId
                @newPhase,                    -- phaseNum
                1,                            -- attemptNum
                @newStatus,                   -- status
                dbo.GetUnixTime(GETUTCDATE()),-- startTime
                0,                            -- endTime
                0,                            -- elapsedTime
                0,                            -- dataTransfer
                0,                            -- numberOfFilesToTransfer
                0,                            -- noFilesTransfered
                0,                            -- averageThroughput
                0,                            -- bytesToTransfer
                0,                            -- abortReason,
                N'',                          -- failureReason
                @defaultCCId		  -- commCellId
            )
        END -- @locJobId IS null BEGIN
        ELSE BEGIN
            -- job for given pair already exist then
			-- now we have the following
			-- @locJobId
			-- @currentPhaseNo
			-- @currentAtmptNo
			-- @currentStatus
            SET @existed = 1
            -- if we are already in this phase and state
            IF @currentStatus = @newStatus AND @currentPhaseNo = @newPhase BEGIN
                UPDATE JMCdrAttempts
                SET    status = 0
                WHERE  JMCdrAttempts.jobId      = @locJobId       AND
					   JMCdrAttempts.commCellId  = @defaultCCId and
                       JMCdrAttempts.phaseNum   = @currentPhaseNo AND
                       JMCdrAttempts.attemptNum = @currentAtmptNo
            END
            -- check current phase. if we are changing phase
            IF @newPhase <> @currentPhaseNo BEGIN
                -- check previous attempt status
                -- if previous phase in transient state
				-- then mark existing attempt as unknown\bad\whatever
                IF @currentStatus IN( 0, 1, 4, 5, 7, 11) BEGIN
                    UPDATE JMCdrAttempts
                    SET    JMCdrAttempts.status		= 0
                    WHERE  JMCdrAttempts.jobId		= @locJobId AND
						   JMCdrAttempts.commCellId  = @defaultCCId and
                           JMCdrAttempts.phaseNum   = @currentPhaseNo AND
                           JMCdrAttempts.attemptNum = @currentAtmptNo
                END
            END
            -- set end time for current attempt
            UPDATE JMCdrAttempts
            SET    endTime		= dbo.GetUnixTime( GETUTCDATE() ),
                   elapsedTime  = dbo.GetUnixTime( GETUTCDATE() ) - JMCdrAttempts.startTime
            WHERE  JMCdrAttempts.jobId      = @locJobId AND
				   JMCdrAttempts.commCellId  = @defaultCCId and
                   JMCdrAttempts.phaseNum   = @currentPhaseNo AND
                   JMCdrAttempts.attemptNum = @currentAtmptNo
			-- determine attempt number for the phase number
            SELECT @currentAtmptNo = ISNULL( MAX(JMCdrAttempts.attemptNum), 0 ) + 1
            FROM   JMCdrAttempts
            WHERE  (JMCdrAttempts.jobId = @locJobId) AND (JMCdrAttempts.phaseNum  = @newPhase)
            -- update 'main' record
            UPDATE JMCdrJobs
            SET    JMCdrJobs.currentStatus               = @newStatus,
                   JMCdrJobs.lastStateChangeTime         = dbo.GetUnixTime( GETUTCDATE() ),
                   JMCdrJobs.lastUpdateTime              = dbo.GetUnixTime( GETUTCDATE() ),
                   JMCdrJobs.currentThroughput           = 0,
                   JMCdrJobs.currentPhase                = @newPhase,
                   JMCdrJobs.currentAttempt              = @currentAtmptNo,
                   JMCdrJobs.currentFileBeingTransfered  = N'',
                   JMCdrJobs.currentSourceLogNumber      = 0,
                   JMCdrJobs.currentDestinationLogNumber = 0,
                   JMCdrJobs.lastLoggedPlayedNumber      = 0,
                   JMCdrJobs.lastLogPlayedTime           = 0,
                   JMCdrJobs.abortReason                 = 0,
                   JMCdrJobs.failureReason		 = N'',
                   JMCdrJobs.clientStatusChangeTime       = dbo.GetUnixTime( GETUTCDATE() ),
                   JMCdrJobs.unverifiable                 = 0
            WHERE  JMCdrJobs.jobId = @locJobId
             and   JMCdrJobs.commCellId  = @defaultCCId
			UPDATE JMCdrJobs SET JMCdrJobs.bytesReplicated = 0 WHERE JMCdrJobs.jobId = @locJobId
			IF (@newPhase < @currentPhaseNo) AND ((@newPhase = 1) OR (@newPhase = 3)) BEGIN
                UPDATE  JMCdrJobs
                SET     JMCdrJobs.bytesTransfered = 0,
                        JMCdrJobs.bytesToTransfer = 0,
                        JMCdrJobs.filesTransfered = 0,
                        JMCdrJobs.filesToTransfer = 0
                WHERE  JMCdrJobs.jobId = @locJobId
                and		JMCdrJobs.commCellId = @defaultCCId
			END
            -- create attempt record
            INSERT INTO JMCdrAttempts
            (
                jobId,
                phaseNum,
                attemptNum,
                status,
                startTime,
                endTime,
                elapsedTime,
                dataTransfer,
                numberOfFilesToTransfer,
                noFilesTransfered,
                averageThroughput,
                bytesToTransfer,
                abortReason,
                failureReason,
                commCellId
            )
            VALUES
            (
                @locJobId,                    -- jobId
                @newPhase,                    -- phaseNum
                @currentAtmptNo,              -- attemptNum
                @newStatus,                   -- status
                dbo.GetUnixTime( GETUTCDATE() ), -- startTime
                0,                            -- endTime
                0,                            -- elapsedTime
                0,                            -- dataTransfer
                0,                            -- numberOfFilesToTransfer
                0,                            -- noFilesTransfered
                0,                            -- averageThroughput
                0,                            -- bytesToTransfer
                0,                            -- abortReason,
                N'',                          -- failureReason
                @defaultCCId		  -- commCellId
            )
        END -- @locJobId IS NOT null BEGIN
    END -- @jobRequest IS NOT null AND @jobRequest > 0
    SELECT @locJobId, @existed
GO

IF EXISTS (select * from GxQscripts where name = 'JMRegisterCDRJob')
	delete from GxQscripts where name = 'JMRegisterCDRJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMRegisterCDRJob')
	delete from GXDBVersions where aliasname = 'JMRegisterCDRJob'
GO

insert into GXDBVersions values(2, 'JMRegisterCDRJob',  '00010015005000010000', 'JMRegisterCDRJob', '00010015005000010000')
GO

