

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMRefreshClientCache.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMRefreshClientCache.sp,v $ $Id: JMRefreshClientCache.sp,v 1.1.2.25.16.1 2021/04/07 22:19:11 dmitriy Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMRefreshClientCache')
BEGIN
	print '>>> Drop Stored Procedure: JMRefreshClientCache <<<'
	drop procedure JMRefreshClientCache
END
IF EXISTS (select * from GxQscripts where name='JMRefreshClientCache')
	delete from GxQscripts where name = 'JMRefreshClientCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMRefreshClientCache')
	delete from GXDBVersions where aliasname = 'JMRefreshClientCache'
GO
print '... Creating Procedure: JMRefreshClientCache'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMRefreshClientCache
  @i_XML XML
AS
  DECLARE @o_XML XML;
SET NOCOUNT ON
	DECLARE @now INTEGER= dbo.GetUnixTime(GetUTCDate())
	DECLARE @newJobId BIGINT
	DECLARE @runningJobID BIGINT
	DECLARE @runningBkpLevel INTEGER
	DECLARE @startTime INTEGER
	DECLARE @fullCycleNumber INTEGER
	DECLARE @prevFullCycleNumber INTEGER
	DECLARE @apptype INTEGER
	DECLARE @archGrpID INTEGER
	DECLARE @subClientID INTEGER
	DECLARE @bkpLevel INTEGER
	DECLARE @commCellID INTEGER
	DECLARE @userID INTEGER
	DECLARE @updateJobInfo INTEGER = 0
	DECLARE @lastClientActivityTime INTEGER
	DECLARE @nothingToBackup INTEGER
	DECLARE @jobControlOp INTEGER = 0
	DECLARE @errorCode	INTEGER = 0
	DECLARE @in_filesXfered BIGINT = 0
	DECLARE @in_unCompBytes BIGINT = 0
	DECLARE @in_enableTrueUp INT = 0
	DECLARE @in_bFailCurrentJob INT = 0
	DECLARE @jobStatus INT = 1 --JMSUCCESS
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @scPropTbl TABLE (errCode INT, hasChanged INT, propId INT, errString VARCHAR(MAX) )
	BEGIN TRY
		SET @subClientID = ISNULL(( SELECT ref.value('@subclientId', 'int')
	                                FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest/entity') R ( ref )
	                                ), 0)
		SET @commCellID  = ISNULL(( SELECT ref.value('@commCellId', 'int')
	                                    FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest/entity') R ( ref )
	                                ), 2)
	    SET @bkpLevel  = ISNULL(( SELECT ref.value('@bkpLevel', 'int')
	                                    FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest') R ( ref )
	                                ), 2)
		SET @userID  = ISNULL(( SELECT ref.value('@userId', 'int')
	                                    FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest/user') R ( ref )
	                                ), 1)    --TODO: Change this later
		SET @updateJobInfo  = ISNULL(( SELECT ref.value('@updateJobInfo', 'int')
	                                    FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest/jobInfo') R ( ref )
	                                ), 0)
		SET @jobControlOp  = ISNULL(( SELECT ref.value('@jobControl', 'int')
	                                    FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest/jobInfo') R ( ref )
	                                ), 0)
		SELECT @in_filesXfered = ISNULL(ref.value('@filesXfered', 'bigint'), 0), @in_unCompBytes  = ISNULL(ref.value('@unCompBytes', 'bigint'), 0),
				@in_enableTrueUp  = ISNULL(ref.value('@enableTrueUp', 'int'), 0), @in_bFailCurrentJob  = ISNULL(ref.value('@bFailCurrentJob', 'int'), 0)
				FROM @i_xml.nodes('JobManager_RefreshClientCacheRequest/jobInfo') R (ref)
		IF @in_bFailCurrentJob <> 0
			SET @jobStatus = 2 --FAIL
		BEGIN TRANSACTION
			DECLARE @ClientID INTEGER
			DECLARE @ConfigXML XML
			DECLARE @runningJobOpType INTEGER = 0
			SET @ClientID = (SELECT TOP 1 ClientID FROM APP_Application WITH (NOLOCK) WHERE id = @subClientID)
			SET @apptype = (SELECT TOP 1 appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = @subClientID)
			exec JMUpdateCCR @ClientID,0 --We got a update from client, Hence updating the Client online status.
			IF NOT EXISTS (SELECT 1 FROM CommCellCloudLaptopClients WHERE ClientID = @ClientID)
			BEGIN
				IF @jobControlOp <> 2 --StatelessJobControl_KILL
				BEGIN
					--Cloud laptop is not enabled for this client
					RAISERROR ('Cloud Laptop is not enabled for the client', 16,1);
				END
			END
			IF @jobControlOp = 2 --StatelessJobControl_KILL
			BEGIN
				SET @updateJobInfo = 0
			END
			IF @updateJobInfo = 0
			BEGIN
				IF @jobControlOp <> 2 --StatelessJobControl_KILL
				BEGIN
					-- Get all the required counters
					-- JobID
					INSERT INTO GxJobCounter
					DEFAULT VALUES
					SET @newJobId = SCOPE_IDENTITY()
					SELECT @archGrpID = dataArchGrpID FROM APP_Application WITH(NOLOCK) WHERE id = @subClientID and origCCId = 2
					IF @archGrpID IS NULL OR @archGrpID = 1
					BEGIN
						--Fail to start new Cloud laptop job because storage policy is not set, Raise Error.
						RAISERROR ('Fail to start new Cloud laptop job because storage policy is not set', 16,1);
					END
				END
				SELECT @runningJobID = B.jobId, @runningBkpLevel = B.bkpLevel
					FROM JMBkpJobInfo B
					JOIN JMJobInfo J ON J.jobId = B.jobId
					WHERE B.applicationId = @subClientID
					AND B.commCellId = @commCellID
					--IGNORE SF JOB SINCE IT CAN RUN AT SAME TIME
					AND J.opType <> 14	--SYNTHFULL
				IF @runningJobID IS NOT NULL --There is running job, let us create stats
				BEGIN
					SELECT @startTime = jobStartTime, @runningJobOpType = opType FROM JMJobInfo WHERE jobId = @runningJobID AND commCellId = @commCellID
					SET @prevFullCycleNumber = CONVERT(INTEGER,ISNULL((SELECT attrVal FROM APP_SubClientProp WHERE componentNameId = @subClientID AND modified = 0 and cs_attrName = CHECKSUM(N'sys:full cycle num')),1))
					IF @runningJobOpType <> 116 /*STATELESS_BACKUP*/
					BEGIN
						--A reglaur laptop job is still running, cannot create stats for it or start new Cloud laptop job, Raise Error.
						SET @errorString = 'Regular Laptop job ['+CAST(@runningJobID AS NVARCHAR(10))+'] is still running'
						RAISERROR (@errorString, 16,1);
					END
					ELSE
					BEGIN
						--Call stored proc to create stats
						exec JMCreateBkpStatsRecord @runningJobID, @commCellID, @jobStatus
						IF NOT EXISTS(SELECT 1 FROM JMBkpStats WHERE jobid = @runningJobID AND commCellId = @commCellID)
						BEGIN
						--Stats creation failed , Log  the message and go ahead
							print 'Failed to create stats for Job ' + @runningJobID
						END
						-- Clean up JMJobInfo table
						DELETE FROM JMJobInfo WHERE jobid = @runningJobID AND commCellId = @commCellID
					END
				END
				ELSE
				BEGIN
					IF NOT EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId = @ClientID AND attrName = 'cloud laptop enabled time')
					BEGIN
						INSERT INTO APP_ClientProp
						(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
						SELECT @ClientID, 'cloud laptop enabled time', 2, @now, @now, 0, 0
					END
				END
				SET @fullCycleNumber = CONVERT(INTEGER,ISNULL((SELECT attrVal FROM APP_SubClientProp WHERE componentNameId = @subClientID AND modified = 0 and cs_attrName = CHECKSUM(N'sys:full cycle num')),1))
				IF @jobControlOp <> 2 --StatelessJobControl_KILL
				BEGIN
					--Insert new record in the table
					DECLARE @lastBackupTime INTEGER
					SELECT @lastBackupTime = CONVERT(INTEGER,attrVal) FROM APP_SubClientProp WITH(NOLOCK)
					WHERE componentNameId =  4 AND attrName = 'Last Backup Start Time' AND modified = 0
					IF @lastBackupTime IS NULL
						SET @lastBackupTime = 0
					--SELECT @lastBackupTime
					INSERT INTO JMJobStats(jobid, status, opType, commCellId,jobCategory, jobDescription, xmlJobInfo, subOpType, foreignToken)
											VALUES(@newJobId,1 /*ACTIVE*/ , 116 /*STATELESS_BACKUP*/, @commCellID,1 ,'','',0,'')
					INSERT INTO JMJobInfo (jobId,initFrom,opType,userId,clientPriority,opPriority,appPriority,combPriority,currentPhase,
											jobStartTime,attemptStartTime,serverEndTime,jobElapsedTime,elapsedTime,lastStartOrRun,phaseParams,restartString,
											startAttempts,runAttempts,state,pendingCause,restartable,appArgs,numOfFailures,
											failureReason,preemptable,taskLinkID,percentcomplete,displayState,commCellId,resourcesAllocated,
											currentContext,libraryList,driveList,opUsername,phaseOnSuccess,interruptedPhase,errorType,licenseVerified,
											currentPhaseName,timeToComplete,lastUpdateFromClient,lastStateChangeTime,jobCategory,recoveredFromServiceRestart,
											noOfGUIMonitors,isScheduledAlert,jobBasedAlertId,alertName,shortMediaAgent,seqNumber,activeFile,guiAlertColorLevel,
											jobDescription,xmlJobInfo,subOpType,foreignToken,preparedJobId)
									VALUES(@newJobId, 3 /*Schedule*/, 116 /*STATELESS_BACKUP*/, @userID, 6, 1, 6, 166, 1 ,
											@now, @now , -1, 0, 0, -1, '', '',
											1, 1, 1, 5, 1, '', 0,
											'', 1, 0, 0, 1, 2, 0,
											0, N'', N'', N'',0, 0, 0, 0,
											'', 0, @lastBackupTime, 0, 1 /*jobCategory*/, 0,
											0, 0, 0, N' ', '', 0, N'', 0,
											N'',N'', 0, N'', 0)
					INSERT INTO JMBkpJobInfo (jobId,commcellId,applicationId,numStreams,currentPolicy,targetCopyList,bkpLevel,
												indexOverride,startNewMedia,compBytes,unCompBytes,filesToXfer,backupTaskId,scanFileFailures,
												scanFolderFailures,backupFileFailures,backupFolderFailures,shadowCopyId,bkpOptions,oraSubLevel,
												bkpattributes,dataPolicy,logPolicy,filesXfered,currentThroughput,averageThroughput,filesIndexed,
												filesFailedToIndex,filesSkippedForIndex,contentIndexDBSize,totalMediaUsageTime,mediaAgentName,scanType,
												scanTypeChangeReason,numStreamsAllocated,maxRestarts,restartInterval,cloudId,diffPolicy,targetClientId,
												unCompBytesToXfer,secondaryBkpLevel,jobIdActedOn,fromTime,toTime,nwTransBytes,totSkippedObjects,bkpAttributesEx,
												jobReferenceTime, totReadBytes, totReadTime, totPhysicalWriteBytes, totPhysicalWriteTime, totNwTransTime, totSidbLookups, totSidbLookupTime,
												readCurrentThroughput, readAverageThroughput, writeCurrentThroughput, writeAverageThroughput, networkCurrentThroughput,
    											networkAverageThroughput, sidbCurrentLookups, sidbAverageLookups)
									VALUES(@newJobId, @commCellID, @subClientID, 1, @archGrpID, '', @bkpLevel,
											0, 0, 0, 0, 0, 0, 0,
											0, 0, 0,'', 0, 0,
											0, 0, 0, 0, 0.000000,0.000000, 0,
											0, 0, 0, 0, N'', 0,
											'', 0, 144, 1200, 0, 0, 0,
											0, 0, 0, 0, 0, 0, 0, 0,
											0, 0, 0, 0, 0, 0, 0, 0,
											0, 0, 0, 0, 0, 0, 0, 0)
					INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'Last Backup Start Time',8,@now
					DECLARE @ClientConfigXML TABLE(config XML)
					INSERT INTO @ClientConfigXML
					EXEC JMGetStatelessJobControlInfo @ClientID
					SELECT @ConfigXML = config FROM @ClientConfigXML
					SET @ConfigXML = CONVERT(XML,REPLACE (CONVERT(NVARCHAR(MAX),@ConfigXML),'JobManager_StatelessJobControlInfo','jobControlInfo'))
					SET @o_XML = (SELECT @newJobId 		as '@jobID',
										 @runningJobID  as '@previousJobID',
										 @subClientID   as '@subClientID',
										 @runningBkpLevel as '@previousBkpLevel',
										 @archGrpID		as '@archGroupID',
										 @bkpLevel		as '@bkpLevel',
										 @startTime		as '@prevJobStartTime',
										 @fullCycleNumber as '@fullCycleNum',
										 @apptype			as '@appType',
										 @prevFullCycleNumber as '@previousFullCycleNum',
										 ISNULL((SELECT attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientID AND modified = 0 AND attrName = 'sys:last full'),0) 			as '@fullRefTime',
										 ISNULL((SELECT attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientID AND modified = 0 AND attrName = 'sys:last incr'),0) 	 		as '@incrRefTime',
										 @ConfigXML as 'node()'
									FOR XML PATH('JobManager_RefreshClientCacheResponse'))
				END
				ELSE
				BEGIN
						--Send success for Kill Operation
						SET @o_XML =    (SELECT 0 AS '@errorCode'
									FOR XML PATH ( 'App_GenericResp' ))
				END
			END
			ELSE
			BEGIN
				SET @lastClientActivityTime  = ISNULL(( SELECT ref.value('@lastClientActivityTime', 'int')
															FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest/jobInfo') R ( ref )
														), 0)
				SET @nothingToBackup  = ISNULL(( SELECT ref.value('@nothingToBackup', 'int')
															FROM   @i_xml . nodes('JobManager_RefreshClientCacheRequest/jobInfo') R ( ref )
														), 0)
				IF @lastClientActivityTime <> 0 OR @in_filesXfered <> 0 OR @in_unCompBytes <> 0
				BEGIN
					SELECT TOP 1 @runningJobID = JMJobInfo.jobId
					FROM JMJobInfo
					JOIN JMBkpJobInfo
					ON JMJobInfo.opType = 116 /*STATELESS_BACKUP*/
					AND JMBkpJobInfo.applicationId = @subClientID
					AND JMJobInfo.commCellId = @commCellID
					AND JMJobInfo.jobId = JMBkpJobInfo.jobId
					AND JMJobInfo.commCellId = JMBkpJobInfo.commcellId
				END
				IF @lastClientActivityTime <> 0
				BEGIN
					UPDATE JMJobInfo
					SET lastUpdateFromClient = @lastClientActivityTime
					FROM JMJobInfo INNER JOIN JMBkpJobInfo
							ON JMJobInfo.opType = 116 /*STATELESS_BACKUP*/ AND JMBkpJobInfo.applicationId = @subClientID AND JMJobInfo.commCellId = @commCellID
								AND JMJobInfo.jobId = JMBkpJobInfo.jobId AND JMJobInfo.commCellId = JMBkpJobInfo.commcellId
					INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID,0, @now, N'Last Data Protected Time',8,@lastClientActivityTime
				END
				ELSE
				BEGIN
					IF @nothingToBackup <> 0
					BEGIN
						INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID,0, @now, N'Nothing to backup',8,@nothingToBackup
						INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID,0, @now, N'Last Data Protected Time',8,@nothingToBackup
					END
				END
				IF @runningJobID <> 0 AND (@in_filesXfered <> 0  OR @in_unCompBytes <> 0 OR @in_enableTrueUp <> 0)
				BEGIN
					UPDATE JMBkpJobInfo
					SET filesXfered =
							CASE WHEN @in_filesXfered <> 0 THEN @in_filesXfered
							ELSE filesXfered END,
						unCompBytes =
							CASE WHEN @in_unCompBytes <> 0 THEN @in_unCompBytes
							ELSE unCompBytes END,
						bkpAttributesEx =
							CASE WHEN @in_enableTrueUp <> 0 THEN bkpAttributesEx | 0x8000000000 --JMBKP_EX_FS_TRUE_UP_JOB
							ELSE bkpAttributesEx END
					WHERE jobId = @runningJobID
					--UPDATE SUBCLIENT PROPERTY FOR ADMIN/WEB CONSOLE
					IF @in_unCompBytes <> 0
						INSERT INTO @scPropTbl exec AppInsertSubClientProp @subClientID, 0, @now, N'Last Backup Size', 15, @in_unCompBytes
				END
				SET @o_XML =    (SELECT 0 AS '@errorCode'
									FOR XML PATH ( 'App_GenericResp' ))
			END
		COMMIT TRANSACTION
	END TRY
BEGIN CATCH
	ROLLBACK TRANSACTION
	IF @errorCode = 0 SET @errorCode = 1
	SET @o_XML =    (SELECT @errorCode AS '@errorCode',
								ISNULL(ERROR_MESSAGE(), 'UNKNOWN ERROR') AS '@errorMessage'
							FOR XML PATH ( 'App_GenericResp' ))
END CATCH
SELECT @o_XML
GO

IF EXISTS (select * from GxQscripts where name = 'JMRefreshClientCache')
	delete from GxQscripts where name = 'JMRefreshClientCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMRefreshClientCache')
	delete from GXDBVersions where aliasname = 'JMRefreshClientCache'
GO

insert into GXDBVersions values(2, 'JMRefreshClientCache',  'v1.1.2.25.16.1', 'JMRefreshClientCache', 'v1.1.2.25.16.1')
GO

