

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMPushPackages.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppPushPackages							    |
--	|       Procedure for Pushing packages on Laptop Client				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMPushPackages')
BEGIN
	print '>>> Drop Stored Procedure: JMPushPackages <<<'
	drop procedure JMPushPackages
END
IF EXISTS (select * from GxQscripts where name='JMPushPackages')
	delete from GxQscripts where name = 'JMPushPackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPushPackages')
	delete from GXDBVersions where aliasname = 'JMPushPackages'
GO
print '... Creating Procedure: JMPushPackages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMPushPackages
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @ixml XML
-----------------------------------------------------------
AS
  DECLARE @oxml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  JMPushPackagesHelper							    |
--	|       Procedure for Pushing packages on Laptop Client				|
--	+===================================================================+
SET NOCOUNT ON
BEGIN
	DECLARE @featureDisabledAtGlobalLevel INT = 0
	IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'DisableAutomaticPushInstall' AND value = '1' and modified = 0)
		SET @featureDisabledAtGlobalLevel  = 1
	DECLARE @featureDisAllowedForLaptops INT = 0
	IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'DisableLaptopAutomaticPushInstall' AND value = '1' and modified = 0)
		SET @featureDisAllowedForLaptops  = 1
	if OBJECT_ID('tempdb.dbo.#clientPackageListInProcess') is not null drop table dbo.#clientPackageListInProcess
	if OBJECT_ID('tempdb.dbo.#apppropPackageList') is not null drop table dbo.#apppropPackageList
	if OBJECT_ID('tempdb.dbo.#sendOSCclientIds') is not null drop table dbo.#sendOSCclientIds
	if OBJECT_ID('tempdb.dbo.#clientPackagestatus') is not null drop table dbo.#clientPackagestatus
	if OBJECT_ID('tempdb.dbo.#completedclientPackages') is not null drop table dbo.#completedclientPackages
	if OBJECT_ID('tempdb.dbo.#AppPropCompletedPackagesList') is not null drop table dbo.#AppPropCompletedPackagesList
	if OBJECT_ID('tempdb.dbo.#ExistingCompletedPackagesList') is not null drop table dbo.#ExistingCompletedPackagesList
	if OBJECT_ID('tempdb.dbo.#MergedPackageList') is not null drop table dbo.#MergedPackageList
	if OBJECT_ID('tempdb.dbo.#apppropLicenseList') is not null drop table dbo.#apppropLicenseList
	create table #clientPackagestatus
	(
		clientId	INTEGER,
clientName  NVARCHAR(255),
		displayName NVARCHAR(255),
		packageId	INTEGER,
		consumeLic  INTEGER,
		status      INTEGER,
		jobID		INTEGER DEFAULT 0
	);
	create table #sendOSCclientIds
	(
		clientId integer,
	);
	create table #clientPackageListInProcess
	(
	clientid integer,
	data nvarchar(MAX),
	consumeLic integer
	);
	create table #apppropPackageList
	(
	clientid integer,
	data nvarchar(MAX)
	);
	create table #completedclientPackages
	(
		clientid integer,
		data nvarchar(MAX)
	);
	create table #AppPropCompletedPackagesList
	(
		clientid integer,
		data nvarchar(MAX)
	);
	create table #ExistingCompletedPackagesList
	(
		clientid integer,
		data nvarchar(MAX)
	);
	create table #MergedPackageList
	(
		clientid integer,
		data nvarchar(MAX)
	);
	create table #apppropLicenseList
	(
		clientId integer,
		dataLic nvarchar(MAX)
	);
	DECLARE @checkAndRemoveInstalledPackage	INT = 0
	DECLARE @triggerImmediateJob INT = 0
	DECLARE @forceKilledByUser INT = 0
	DECLARE @taskId	INT = 0
	DECLARE @flags	INT = 0
	DECLARE @errorCode	INT = 0
	DECLARE @curTime INTEGER = dbo.GetUnixTime(GetUTCDate())
	SELECT @checkAndRemoveInstalledPackage = ISNULL(ref.value('@checkAndRemoveInstalledPackage', 'INT'), 0) ,
		@triggerImmediateJob = ISNULL (ref.value('@triggerImmediateJob', 'INT'),0) ,
		@forceKilledByUser = ISNULL(ref.value('@forceKilledByUser', 'INT'),0)
		FROM  @ixml.nodes ('JobManager_ClientPackageReqList') R(ref)
	select @taskId = TM.taskId, @flags = TM.flags from TM_Task TM
	where ((TM.flags & CONVERT(INT,0x4000) >0))
	AND TM.deleted = 0
	AND TM.uninstalled = 0
	AND TM.disabled = 0
	-- We want to check system created schedule for push install for automatic jobs only and not for immediate jobs.
	IF @triggerImmediateJob = 0 AND @taskId = 0 AND @flags = 0
	BEGIN
		SET @errorCode = 1
	END
	IF @checkAndRemoveInstalledPackage = 0
	BEGIN
		INSERT INTO #clientPackagestatus
		(clientid, packageId, consumeLic, status)
		SELECT  cl.value('@clientId', 'int') AS client, pkg.value('@packageId', 'int') AS packageId, pkg.value('@consumeLic', 'int') AS consumeLic, 0 /*PACKAGE_REQUEST_SUBMITTED*/
		FROM    @ixml.nodes('JobManager_ClientPackageReqList/reqList') R ( prl )
		CROSS APPLY prl.nodes('./packageInfoList') P(pkg)
		CROSS APPLY prl.nodes('./client') C(cl)
		UPDATE CPS
			SET
				CPS.clientName = AC.name,
				CPS.displayName = AC.displayName
		FROM #clientPackagestatus CPS
		INNER JOIN APP_Client AC WITH(NOLOCK)
			ON AC.id=CPS.clientid
		-- CS/Webserver/WebConsole should not auto install packages. Fail the request in case that client id is present
		IF EXISTS (SELECT 1 FROM #clientPackagestatus clientPackagestatus INNER JOIN simInstalledPackages (NOLOCK) ON
			clientPackagestatus.clientID = simInstalledPackages.ClientId
AND simInstalledPackages.simPackageID IN (20,252,726)
		)
		BEGIN
			UPDATE #clientPackagestatus
			SET status = 4 /*CLIENT_NOT_SUPPORTED*/
			GOTO ERROR_EXIT
		END
		IF @featureDisabledAtGlobalLevel = 1
		BEGIN
			UPDATE CPS	SET CPS.status = 5 /*FEATURE_DISABLED*/
			FROM #clientPackagestatus CPS
			INNER JOIN APP_Client C WITH(NOLOCK)
			ON CPS.clientid = C.id
WHERE (C.status & 0x1000) = 0
			IF EXISTS(SELECT TOP 1 * FROM  #clientPackagestatus where status = 5 /*FEATURE_DISABLED*/)
			GOTO ERROR_EXIT
		END
		IF @featureDisAllowedForLaptops = 1
		BEGIN
			UPDATE CPS	SET CPS.status = 6 /*FEATURE_DISABLED_FOR_LAPTOP*/
			FROM #clientPackagestatus CPS
			INNER JOIN APP_Client C WITH(NOLOCK)
			ON CPS.clientid = C.id
WHERE (C.status & 0x1000) > 0
			IF EXISTS(SELECT TOP 1 * FROM  #clientPackagestatus where status = 6 /*FEATURE_DISABLED_FOR_LAPTOP*/)
			GOTO ERROR_EXIT
		END
		UPDATE clientPackagestatus
		SET status = 4 /*CLIENT_NOT_SUPPORTED*/
		FROM #clientPackagestatus clientPackagestatus LEFT JOIN
		(
			SELECT distinct AC.id ClientId FROM APP_Client AC INNER JOIN SimInstalledPackages PKG
ON PKG.ClientId = AC.id AND (AC.releaseId > 16 OR (AC.releaseId = 16 AND PKG.HighestSP >= 7))
		) SupportedClients
		ON SupportedClients.ClientId = clientPackagestatus.clientID
		WHERE SupportedClients.ClientId IS NULL
		IF NOT EXISTS(SELECT TOP 1 * FROM  #clientPackagestatus where status != 4 /*CLIENT_NOT_SUPPORTED*/)
			GOTO ERROR_EXIT
		UPDATE target
		SET status = 1 /*PACKAGE_INSTALLED*/
		FROM #clientPackagestatus target
		INNER JOIN siminstalledpackages ON
		target.clientID = siminstalledpackages.clientID AND target.packageId = SimInstalledPackages.SimPackageid
		INSERT INTO #clientPackageListInProcess
		(clientid, data, consumeLic)
		select t.componentNameId, C.Data, 0 from APP_ClientProp t CROSS APPLY dbo.SplitString(t.attrVal, ',') C where t.componentNameId in (select distinct clientid from  #clientPackagestatus) AND t.attrName = 'PackagesToInstall' AND t.modified = 0
		UPDATE cpl SET consumeLic = 1
		FROM #clientPackageListInProcess as cpl
		JOIN (select t.componentNameId AS clientId, C.Data AS data from APP_ClientProp t CROSS APPLY dbo.SplitString(t.attrVal, ',') C where t.componentNameId in (select distinct clientid from  #clientPackagestatus) AND t.attrName = 'LicensesToConsume' AND t.modified = 0) AS cplSrc
		ON cpl.clientid = cplSrc.clientId AND cpl.data = cplSrc.data
		IF (@triggerImmediateJob = 0)
		BEGIN
			INSERT INTO #sendOSCclientIds
			(clientid)
			SELECT DISTINCT clientPackagestatus.clientid FROM #clientPackagestatus clientPackagestatus
			LEFT JOIN #clientPackageListInProcess clientPackageListInProcess
			ON clientPackagestatus.clientID =  clientPackageListInProcess.clientId
			WHERE clientPackagestatus.status = 0 /*PACKAGE_REQUEST_SUBMITTED*/
			AND clientPackageListInProcess.clientId IS NULL
			IF @errorCode = 1
				GOTO ERROR_EXIT
			INSERT INTO TM_AssocEntity(
			assocType,
			taskId,
			flags,
			created,
			exclude,
			clientGroupId,
			clientId,
			apptypeId,
			instanceId,
			backupsetId,
			subclientId,
			policyId,
			copyId,
			srmReportSet,
			srmReportType,
			trackingPolicyId,
			MediaAgentId,
			agentlessPolicyId,
			workflowId,
			sidbStoreId,
			libraryId,
			logMonitoringPolicyId
			)
			SELECT 2, @taskId, @flags, @curTime, 0, 0, clientid, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
			FROM #sendOSCclientIds
		END
		ELSE
		BEGIN
			-- For clients which have running job for package installation, update their jobIds in #clientPackagestatus
			-- First check whether there is any job which is not yet picked by JM
			UPDATE clientPackagestatus
			SET jobId = TMJOBS.jobId,
			STATUS = 3 -- INSTALLATION_IN_PROGRESS
			FROM #clientPackagestatus clientPackagestatus
			INNER JOIN TM_JobOptions OPT WITH (NOLOCK) ON
			OPT.optionId = 140003 /*COM_CLIENT_ID*/ AND OPT.value = CAST(clientPackagestatus.clientId AS NVARCHAR(10) ) -- Same client
			AND OPT.modified = 0
			INNER JOIN TM_Jobs TMJOBS -- only committed rows
			ON TMJOBS.jobId = OPT.jobId
			-- Also verify job option for systemInitiatedInstall option
			INNER JOIN TM_JobOptions OPT1 WITH (NOLOCK) ON
			OPT1.optionId = 2025208984 /*UPDATEOPTION_SYSTEM_INITIATED_INSTALL*/ AND OPT1.value = '1' -- Same client
			AND OPT1.modified = 0
			AND TMJOBS.jobId = OPT1.jobId
			INNER JOIN TM_JobRequest TMJOBREQ WITH (NOLOCK) ON TMJOBS.jobRequestId = TMJOBREQ.jobRequestId
			INNER JOIN TM_Subtask WITH (NOLOCK) ON TM_Subtask.subtaskId = TMJOBREQ.subtaskId
			AND TM_Subtask.operationType = 4026
			WHERE (TMJOBS.status IN (0, 1, 4097))
			AND clientPackagestatus.status = 0 --Do this only where we need to submit package.
			UPDATE clientPackagestatus
			SET jobId = JINFO.jobId,
			STATUS = 3 -- INSTALLATION_IN_PROGRESS
			FROM #clientPackagestatus clientPackagestatus
			INNER JOIN JMQinetixUpdateStatus JUPDATE WITH (NOLOCK) ON JUPDATE.clientId = clientPackagestatus.clientId
			INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
			AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */
			AND clientPackagestatus.status = 0 --Do this only where we need to submit package.
			AND clientPackagestatus.jobId=0
			AND JINFO.Optype = 67 -- INSTALLCLIENT
			AND JUPDATE.Category!=1 --QCATEGORY_SUCCESS
			INNER JOIN TM_JobOptions OPT1 WITH (NOLOCK) ON
			OPT1.optionId = 2025208984 /*UPDATEOPTION_SYSTEM_INITIATED_INSTALL*/ AND OPT1.value = '1' -- Same client
			AND OPT1.modified = 0
			AND OPT1.jobID = JINFO.jobId
		END
		MERGE INTO #clientPackageListInProcess AS target
		USING (select clientid, packageId, consumeLic from #clientPackagestatus where status = 0 /*PACKAGE_REQUEST_SUBMITTED*/) as source
		ON (target.clientid = source.clientid AND target.data = source.packageId)
		WHEN NOT MATCHED THEN
	    INSERT (clientid, data, consumeLic)
		values (source.clientid, source.packageId, source.consumeLic)
		WHEN MATCHED AND target.consumeLic=0  THEN
		UPDATE SET consumeLic = source.consumeLic;
	END
	ELSE
	BEGIN
		INSERT INTO #clientPackageListInProcess
		(clientid, data, consumeLic)
		select t.componentNameId, C.Data, 0 from APP_ClientProp t CROSS APPLY dbo.SplitString(t.attrVal, ',') C where t.componentNameId in (SELECT  ref.value('@clientId', 'int') FROM @ixml.nodes('JobManager_ClientPackageReqList/reqList/client') R ( ref )) AND t.attrName = 'PackagesToInstall' AND t.modified = 0
		--update license information
		UPDATE cpl SET consumeLic = 1
		FROM #clientPackageListInProcess as cpl
		JOIN (select t.componentNameId AS clientid, C.Data AS packageId from APP_ClientProp t CROSS APPLY dbo.SplitString(t.attrVal, ',') C where t.componentNameId in (SELECT  ref.value('@clientId', 'int') FROM @ixml.nodes('JobManager_ClientPackageReqList/reqList/client') R ( ref )) AND t.attrName = 'LicensesToConsume' AND t.modified = 0) AS cplSrc
		ON cpl.clientid = cplSrc.clientid AND cpl.data = cplSrc.packageId
		INSERT INTO #clientPackagestatus
		(clientid, clientName, AC.displayName, packageId, consumeLic, status)
		SELECT CPL.clientid, AC.name, AC.displayName, CPL.data, CPL.consumeLic, 1 /*PACKAGE_INSTALLED*/ FROM #clientPackageListInProcess CPL
		INNER JOIN 	APP_Client AC WITH(NOLOCK)
			ON AC.id=CPL.clientid
		IF EXISTS(SELECT TOP 1 * FROM  #clientPackageListInProcess)
		BEGIN
			-- Logic here is given the list of completed packages for the requested clients, try to find if there are already some installed packages via this framework (can be found in client property "AutomaticPackagesInstalled")
			-- If yes then update "AutomaticPackagesInstalled" by appending newly installed package into the same property.
			-- From the clients that are requested, find the packages requested and how many got installed
			INSERT INTO #completedclientPackages
			SELECT CIP.clientId, CIP.data
				FROM #clientPackageListInProcess CIP
				INNER JOIN simInstalledPackages SIP ON SIP.clientId = CIP.clientId AND SIP.simPackageID = CIP.data
			-- Finding if there were already installed packages via this framework
			INSERT INTO #ExistingCompletedPackagesList
			SELECT CP.componentNameId,S._ID
				FROM  APP_ClientProp CP
				CROSS APPLY dbo.SplitStringByDelimiter(CP.attrVal, ',') S
				WHERE CP.componentnameId in (SELECT clientId FROM #completedclientPackages) AND CP.attrName = 'AutomaticPackagesInstalled' AND CP.modified = 0
			-- Merging new packages and old
			INSERT INTO #MergedPackageList
			SELECT clientId, data FROM #completedclientPackages
			UNION
			SELECT clientId, data FROM #ExistingCompletedPackagesList
			--Making a comma seperated string of all the packages
			INSERT INTO #AppPropCompletedPackagesList
			(clientid, data)
			SELECT clientid, data =
			STUFF((SELECT ', ' + data
			FROM #MergedPackageList b
			WHERE b.clientid = a.clientid
			FOR XML PATH('')), 1, 2, '')
			FROM #MergedPackageList a
			GROUP BY clientid
			--updating the client prop for the installed packages through this framework.
			MERGE INTO APP_ClientProp AS target
			USING (select clientid, data from #AppPropCompletedPackagesList) as source
			ON (target.componentnameid = source.clientid AND target.attrname = 'AutomaticPackagesInstalled' AND target.modified = 0)
			WHEN MATCHED THEN
			UPDATE SET attrVal = source.data, created = @curTime
			WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			values (source.clientid, 'AutomaticPackagesInstalled', 7, source.data, @curTime, 0, 0);
			DELETE clientPackageListInProcess
			FROM #clientPackageListInProcess clientPackageListInProcess
			INNER JOIN Siminstalledpackages ON clientPackageListInProcess.clientid = SimInstalledPackages.ClientID AND CAST(SimInstalledPackages.SimPackageId AS NVARCHAR(10)) = clientPackageListInProcess.Data
			UPDATE clientPackagestatus
			SET status = 3 /*INSTALLATION_IN_PROGRESS*/
			FROM #clientPackagestatus clientPackagestatus INNER JOIN #clientPackageListInProcess clientPackageListInProcess
			ON clientPackageListInProcess.ClientId = clientPackagestatus.ClientID AND
			CAST(clientPackagestatus.packageId AS NVARCHAR(10)) = clientPackageListInProcess.data
			INSERT INTO #sendOSCclientIds
			(clientid)
			SELECT DISTINCT clientPackagestatus.clientid FROM #clientPackagestatus clientPackagestatus LEFT JOIN #clientPackageListInProcess  clientPackageListInProcess ON
			clientPackageListInProcess.clientId = clientPackagestatus.ClientId
			WHERE clientPackageListInProcess.clientId IS NULL
			UNION
			SELECT DISTINCT clientPackagestatus.clientid FROM #clientPackagestatus clientPackagestatus INNER JOIN #clientPackageListInProcess  clientPackageListInProcess ON
			clientPackageListInProcess.clientId = clientPackagestatus.ClientId
			WHERE @forceKilledByUser = 1 AND clientPackagestatus.status = 3
			IF @errorCode = 1 AND EXISTS(SELECT TOP 1 * FROM  #sendOSCclientIds)
				GOTO ERROR_EXIT
			DELETE APP_ClientProp FROM APP_ClientProp
			INNER JOIN #sendOSCclientIds sendOSCclientIds
			ON APP_ClientProp.attrname = 'PackagesToInstall' AND APP_ClientProp.componentnameid = sendOSCclientIds.ClientId AND Modified = 0
			DELETE APP_ClientProp FROM APP_ClientProp
			INNER JOIN #sendOSCclientIds sendOSCclientIds
			ON APP_ClientProp.attrname = 'LicensesToConsume' AND APP_ClientProp.componentnameid=sendOSCclientIds.clientId AND Modified = 0
			-- For automatic push install scheduled job, remove frm tm_assocentity on job completion.
			DELETE TM_AssocEntity FROM TM_AssocEntity
			INNER JOIN #sendOSCclientIds sendOSCclientIds
			ON TM_AssocEntity.taskId = @taskId AND flags = @flags AND TM_AssocEntity.clientId = sendOSCclientIds.clientId
			AND sendOSCclientIds.clientId>0
			AND @triggerImmediateJob = 0
		END
		ELSE
			GOTO ERROR_EXIT
	END
	INSERT INTO #apppropPackageList
	(clientid, data)
	SELECT clientid, data =
	STUFF((SELECT ', ' + data
	FROM #clientPackageListInProcess b
	WHERE b.clientid = a.clientid
	FOR XML PATH('')), 1, 2, '')
	FROM #clientPackageListInProcess a
	GROUP BY clientid
	MERGE INTO APP_ClientProp AS target
	USING (select clientid, data from #apppropPackageList) as source
	ON (target.componentnameid = source.clientid AND target.attrname = 'PackagesToInstall' AND target.modified = 0)
	WHEN MATCHED THEN
	UPDATE SET attrVal = source.data, created = @curTime
	WHEN NOT MATCHED AND @forceKilledByUser = 0 THEN
	INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
	values (source.clientid, 'PackagesToInstall', 7, source.data, @curTime, 0, 0);
	--insert License information
	INSERT INTO #apppropLicenseList
	(clientid, dataLic)
	SELECT clientid, data =
	STUFF((SELECT ', ' + CASE consumeLic
							WHEN 1 THEN data
					     END
	FROM #clientPackageListInProcess b
	WHERE b.clientid = a.clientid
	FOR XML PATH('')), 1, 2, '')
	FROM #clientPackageListInProcess a
	GROUP BY clientid
	IF EXISTS(SELECT TOP 1 * FROM  #apppropLicenseList)
	BEGIN
		MERGE INTO APP_ClientProp AS target
		USING (select clientid, dataLic from #apppropLicenseList) as source
		ON (target.componentnameid = source.clientid AND target.attrname = 'LicensesToConsume' AND target.modified = 0)
		WHEN MATCHED AND source.dataLic IS NULL THEN
		DELETE
		WHEN MATCHED THEN
		UPDATE SET attrVal =  source.dataLic, created = @curTime
		WHEN NOT MATCHED AND source.dataLic IS NOT NULL THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		values (source.clientid, 'LicensesToConsume', 7, source.dataLic, @curTime, 0, 0);
	END
	SET @errorCode = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @oscClientId INT = 0
	IF @triggerImmediateJob = 0 AND EXISTS(SELECT TOP 1 * FROM  #sendOSCclientIds)
	BEGIN
		--Pushing Subclient Content changed WorkToken when FS addon Package installation is successful
		INSERT INTO APP_WorkQueueRequest
		(	clientId,
			workToken,
			workTokenParams,
			createTime,
			lastUpdateTime,
			retryCount,
			flag,
			remoteClient
		)
		SELECT DISTINCT
			OSC.clientId,
			7/*WORK_TOKEN_SUBCLIENT_CONTENT*/,
			workTokenParams =  CONVERT ( NVARCHAR(MAX), ( SELECT SC.id AS '@subclientID'
							FROM APP_Application SC
							WHERE SC.clientId = OSC.clientId
AND SC.subclientStatus & 0x00008 = 0x00008
AND SC.subclientStatus & 0x00010 != 0x00010 FOR XML PATH('TMMsg_SubclientChangeReq'), TYPE) ) ,
			@curTime, 0, 0, 0, -1
		FROM #sendOSCclientIds OSC
		INNER JOIN simInstalledPackages CP WITH(NOLOCK)
		 ON CP.ClientId = OSC.ClientId
WHERE CP.simPackageID = 753
		-- Pushing Work Queue Token
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT DISTINCT clientId, 4/*WORK_TOKEN_OSC*/, 0, @curTime, 0, 0, 0, -1
		FROM #sendOSCclientIds
		ERROR:
		IF @errorCode <> 0
		BEGIN
			UPDATE #clientPackagestatus
			SET status = 2 /*PACKAGE_FAIL_TO_INSTALL*/
			where clientId = @oscClientId and status = 0 /*PACKAGE_REQUEST_SUBMITTED*/
		END
	END
	ERROR_EXIT:
	SET @oxml = (SELECT (
						SELECT status '@status', jobId '@jobId', clientId AS 'client/@clientId', clientName AS 'client/@clientName', displayName AS 'client/@displayName', packageId AS 'packageInfo/@packageId' FROM #clientPackagestatus order by clientId, packageId
						FOR XML PATH('clientPackageStatusList'), TYPE)
 					    FOR XML PATH('JobManager_ClientPackageStatusResp'), TYPE)
	if OBJECT_ID('tempdb.dbo.#clientPackageListInProcess') is not null drop table dbo.#clientPackageListInProcess
	if OBJECT_ID('tempdb.dbo.#apppropPackageList') is not null drop table dbo.#apppropPackageList
	if OBJECT_ID('tempdb.dbo.#sendOSCclientIds') is not null drop table dbo.#sendOSCclientIds
	if OBJECT_ID('tempdb.dbo.#clientPackagestatus') is not null drop table dbo.#clientPackagestatus
	if OBJECT_ID('tempdb.dbo.#completedclientPackages') is not null drop table dbo.#completedclientPackages
	if OBJECT_ID('tempdb.dbo.#AppPropCompletedPackagesList') is not null drop table dbo.#AppPropCompletedPackagesList
	if OBJECT_ID('tempdb.dbo.#ExistingCompletedPackagesList') is not null drop table dbo.#ExistingCompletedPackagesList
	if OBJECT_ID('tempdb.dbo.#MergedPackageList') is not null drop table dbo.#MergedPackageList
	if OBJECT_ID('tempdb.dbo.#apppropLicenseList') is not null drop table dbo.#apppropLicenseList
END
SET NOCOUNT OFF
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		DECLARE @o_ErrorCode INT = -1
DECLARE @o_ErrorString nvarchar(max) = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2722 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = 0)
		SET @oxml =
	(
            SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errLogMessage'
            FOR XML PATH ('error'), ROOT('JobManager_ClientPackageStatusResp')
		)
END CATCH
select @oxml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMPushPackages')
	delete from GxQscripts where name = 'JMPushPackages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPushPackages')
	delete from GXDBVersions where aliasname = 'JMPushPackages'
GO

insert into GXDBVersions values(2, 'JMPushPackages',  '00000000000000000000', 'JMPushPackages', '00000000000000000000')
GO

