

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMPruneCDRAttempts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Eugene Volohov
--	Date:   28/11/2006
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMPruneCDRAttempts.sp,v $ $Id: JMPruneCDRAttempts.sp,v 1.5.210.1 2018/03/22 03:00:14 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMPruneCDRAttempts <<<'

IF EXISTS (select * from sysobjects where name='JMPruneCDRAttempts')
	drop procedure JMPruneCDRAttempts
IF EXISTS (select * from GxQscripts where name='JMPruneCDRAttempts')
	delete from GxQscripts where name = 'JMPruneCDRAttempts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPruneCDRAttempts')
	delete from GXDBVersions where aliasname = 'JMPruneCDRAttempts'
GO
print '... Creating Procedure: JMPruneCDRAttempts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMPruneCDRAttempts
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	IF object_id('tempdb.dbo.#tmpJMCdrAttempts') is not null DROP TABLE #tmpJMCdrAttempts
	CREATE TABLE #tmpJMCdrAttempts(failureReason nText)
	IF object_id('tempdb.dbo.#tmpAttemptMessageID') is not null DROP TABLE #tmpAttemptMessageID
	CREATE TABLE #tmpAttemptMessageID(msgId INTEGER)
	DECLARE @olderthen	int
	DECLARE @endIndex			integer
	DECLARE @startIndex			integer
	DECLARE @msgId				varchar(40)
	DECLARE @tmpFailureReason	nvarchar(1024)
	SELECT @olderthen = CAST( CAST( [value] as varchar(32) ) AS INT) FROM GXGlobalParam WHERE [name] = N'JMCDRPrunePeriod'
	IF @olderthen IS NULL BEGIN
		SET @olderthen = 30
	END
	SET @olderthen = -@olderthen
	SET @olderthen = dbo.GETUNIXTIME( DATEADD(day, @olderthen, GETDATE() ) )
	INSERT INTO #tmpJMCdrAttempts  SELECT failureReason from JMCdrAttempts where  (endTime > 0) AND (endTime <= @olderthen)
	DECLARE tmpJMCdrAttemptsCur CURSOR FOR select *from #tmpJMCdrAttempts
	OPEN tmpJMCdrAttemptsCur
	FETCH NEXT FROM tmpJMCdrAttemptsCur	INTO @tmpFailureReason
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Do the processing of the @tmpFailureReason
		SET @startIndex = 1
		SET @endIndex	= 0
		SET @endIndex = CHARINDEX(',', @tmpFailureReason, @startIndex)
		WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
		BEGIN
			SET @msgId = SUBSTRING(@tmpFailureReason,@startIndex,@endIndex-@startIndex)
			INSERT INTO #tmpAttemptMessageID VALUES (@msgId)
			--DELETE FROM JMFailureReasonMsg where id = @msgId
			SET @startIndex = @endIndex + 1
			SET @endIndex = CHARINDEX(',', @tmpFailureReason, @startIndex)
		END
		-- For the last msgId
		SET @endIndex = LEN(@tmpFailureReason) + 1
		IF @endIndex - @startIndex > 0
		BEGIN
			SET @msgId = SUBSTRING(@tmpFailureReason,@startIndex,@endIndex-@startIndex)
			INSERT INTO #tmpAttemptMessageID VALUES (@msgId)
			--DELETE FROM JMFailureReasonMsg where id = @msgId
		END
		FETCH NEXT FROM tmpJMCdrAttemptsCur	INTO @tmpFailureReason
	END
	CLOSE tmpJMCdrAttemptsCur
	DELETE JMF FROM JMFailureReasonMsg JMF
	INNER JOIN  #tmpAttemptMessageID TM on JMF.id = TM.msgId
	DELETE FROM JMCdrAttempts WHERE (endTime > 0) AND (endTime <= @olderthen)
	IF object_id('tempdb.dbo.#tmpAttemptMessageID') is not null DROP TABLE #tmpAttemptMessageID
	IF object_id('tempdb.dbo.#tmpJMCdrAttempts') is not null DROP TABLE #tmpJMCdrAttempts
	SELECT 0
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMPruneCDRAttempts')
	delete from GxQscripts where name = 'JMPruneCDRAttempts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPruneCDRAttempts')
	delete from GXDBVersions where aliasname = 'JMPruneCDRAttempts'
GO

insert into GXDBVersions values(2, 'JMPruneCDRAttempts',  '00010005021000010000', 'JMPruneCDRAttempts', '00010005021000010000')
GO

