

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMPreviousSucessfullJobInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMPreviousSucessfullJobInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMPreviousSucessfullJobInfo <<<'
	drop procedure JMPreviousSucessfullJobInfo
END
IF EXISTS (select * from GxQscripts where name='JMPreviousSucessfullJobInfo')
	delete from GxQscripts where name = 'JMPreviousSucessfullJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPreviousSucessfullJobInfo')
	delete from GXDBVersions where aliasname = 'JMPreviousSucessfullJobInfo'
GO
print '... Creating Procedure: JMPreviousSucessfullJobInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMPreviousSucessfullJobInfo
  @subclientId INTEGER,
  @opType INTEGER,
  @inBkpLevel INTEGER
AS
  DECLARE @fullJobId INTEGER
  DECLARE @incrJobId INTEGER
  DECLARE @synthFullJobId INTEGER
	SET NOCOUNT ON
	SET @fullJobId = 0
	SET @incrJobId = 0
	SET @synthFullJobId = 0
	IF NOT EXISTS(SELECT *FROM APP_SubClientProp WITH (NOLOCK) Where componentNameId = @subclientId and attrName = 'sys:jobIds updated' and modified=0)
	BEGIN
		-- Update both the snap and traditional successful backup jobids from the jobStats
		--Insert Non-Snap Jobids
		select top 1 @fullJobId = ISNULL(JMBkpStats.jobId,0) from JMBkpStats(NOLOCK), JMJobStats(NOLOCK)
									where JMBkpStats.jobId=JMJobStats.jobId And JMBkpStats.commCellId = JMJobStats.commCellId
									And JMJobStats.opType = 59 And JMBkpStats.appId = @subclientId And bkpLevel = 1 and JMBkpStats.status in(1, 3)
									order by servEndDate desc
		select top 1 @incrJobId = ISNULL(JMBkpStats.jobId,0) from JMBkpStats(NOLOCK), JMJobStats(NOLOCK)
									where JMBkpStats.jobId=JMJobStats.jobId And JMBkpStats.commCellId = JMJobStats.commCellId
									And JMJobStats.opType = 59 And JMBkpStats.jobId > @fullJobId and JMBkpStats.appId = @subclientId And bkpLevel = 2 and JMBkpStats.status in(1, 3)
									order by servEndDate desc
		-- Insert the full jobId
		IF @fullJobId>0
		insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@subclientId,'sys:last snap full jobId',8,@fullJobId, dbo.getunixtime(getutcdate()),0)
		-- Insert the incr jobId
		IF @incrJobId>0
		insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@subclientId,'sys:last snap incr jobId',8, @incrJobId, dbo.getunixtime(getutcdate()),0)
		-- Insert SnapJobIds
		-- Update both the snap and traditional successful backup jobids from the jobStats
		select top 1 @fullJobId = ISNULL(JMBkpStats.jobId,0) from JMBkpStats(NOLOCK), JMJobStats(NOLOCK)
									where JMBkpStats.jobId=JMJobStats.jobId And JMBkpStats.commCellId = JMJobStats.commCellId
									And JMJobStats.opType <> 59 And JMBkpStats.appId = @subclientId And bkpLevel = 1 and JMBkpStats.status in(1, 3) AND (bkpAttributesEx & 0x10000000000/*JMBKP_EX_AS_HOC_BACKUP*/) = 0
									order by servEndDate desc
		select top 1 @incrJobId = ISNULL(JMBkpStats.jobId,0) from JMBkpStats(NOLOCK), JMJobStats(NOLOCK)
									where JMBkpStats.jobId=JMJobStats.jobId And JMBkpStats.commCellId = JMJobStats.commCellId
									And JMJobStats.opType <> 59 And JMBkpStats.appId = @subclientId And JMBkpStats.jobId > @fullJobId and bkpLevel = 2 and JMBkpStats.status in(1, 3) AND (bkpAttributesEx & 0x10000000000/*JMBKP_EX_AS_HOC_BACKUP*/) = 0
									order by servEndDate desc
		select top 1 @synthFullJobId = ISNULL(JMBkpStats.jobId,0) from JMBkpStats(NOLOCK), JMJobStats(NOLOCK)
									where JMBkpStats.jobId=JMJobStats.jobId And JMBkpStats.commCellId = JMJobStats.commCellId
									And JMJobStats.opType <> 59 And JMBkpStats.appId = @subclientId And JMBkpStats.jobId > @fullJobId and bkpLevel = 64 and JMBkpStats.status in(1, 3)
									order by servEndDate desc
		-- Insert the full jobId
		IF @fullJobId>0
		insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@subclientId,'sys:last full jobId',8,@fullJobId, dbo.getunixtime(getutcdate()),0)
		-- Insert the incr jobId
		IF @incrJobId>0
		insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@subclientId,'sys:last incr jobId',8, @incrJobId, dbo.getunixtime(getutcdate()),0)
		-- Insert the synth full jobId
		IF @synthFullJobId>0
		insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@subclientId,'sys:last synthFull jobId',8,@synthFullJobId,dbo.getunixtime(getutcdate()),0)
		-- Insert the flag on the subclient so that next lookup will fetch JobId directly
		insert into app_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) values (@subclientId,'sys:jobIds updated',8,'1',dbo.getunixtime(getutcdate()),0)
	END
	IF @opType = 59 OR  @opType = 60  --SnapBackup or Snaptotape
	BEGIN
		Select @fullJobId = cast(ISNULL(attrVal,0) as Int) From APP_SubClientProp WITH (NOLOCK) Where componentNameId = @subclientId and modified = 0 and attrName = 'sys:last snap full jobId'
		Select @incrJobId = cast(ISNULL(attrVal,0) as Int) From APP_SubClientProp WITH (NOLOCK) Where componentNameId = @subclientId and modified = 0 and attrName = 'sys:last snap incr jobId'
	END
	ELSE
	BEGIN
		Select @fullJobId = cast(ISNULL(attrVal,0) as Int) From APP_SubClientProp WITH (NOLOCK) Where componentNameId = @subclientId and modified = 0 and attrName = 'sys:last full jobId'
		Select @incrJobId = cast(ISNULL(attrVal,0) as Int) From APP_SubClientProp WITH (NOLOCK) Where componentNameId = @subclientId and modified = 0 and attrName = 'sys:last incr jobId'
	END
	Select @synthFullJobId = cast(ISNULL(attrVal,0) as Int) From APP_SubClientProp WITH (NOLOCK) Where componentNameId = @subclientId and modified = 0 and attrName = 'sys:last synthFull jobId'
	Select @fullJobId, @incrJobId, @synthFullJobId
GO

IF EXISTS (select * from GxQscripts where name = 'JMPreviousSucessfullJobInfo')
	delete from GxQscripts where name = 'JMPreviousSucessfullJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPreviousSucessfullJobInfo')
	delete from GXDBVersions where aliasname = 'JMPreviousSucessfullJobInfo'
GO

insert into GXDBVersions values(2, 'JMPreviousSucessfullJobInfo',  '00000000000000000000', 'JMPreviousSucessfullJobInfo', '00000000000000000000')
GO

