

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMPostStatsActivity.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMPostStatsActivity()
--  |				 Description:  Post JobStats activity like updation/cleanup of various properites
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMPostStatsActivity.sp,v $ $Id: JMPostStatsActivity.sp,v 1.4.48.62.4.4 2021/02/17 07:57:12 dgupta Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMPostStatsActivity')
BEGIN
	print '>>> Drop Stored Procedure: JMPostStatsActivity <<<'
	drop procedure JMPostStatsActivity
END
IF EXISTS (select * from GxQscripts where name='JMPostStatsActivity')
	delete from GxQscripts where name = 'JMPostStatsActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPostStatsActivity')
	delete from GXDBVersions where aliasname = 'JMPostStatsActivity'
GO
print '... Creating Procedure: JMPostStatsActivity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMPostStatsActivity
  @i_jobId integer,
  @i_appId integer,
  @i_status integer
AS
  DECLARE @errorCode integer;
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#vmClientList') IS NOT NULL
	DROP TABLE #vmClientList
create table #vmClientList
(
	clientid INT,
	status INT,
	backupStartTime NVARCHAR(32)
)
IF OBJECT_ID('tempdb.dbo.#vmLastJobclientList') IS NOT NULL
	DROP TABLE #vmLastJobclientList
create table #vmLastJobclientList
(
	clientid INT,
	lastBackupJobInfo XML
)
CREATE CLUSTERED  INDEX idx_clientIds_clientid ON #vmClientList(clientid)
BEGIN TRY
	DECLARE @rcnt INT
	SET @errorCode = 0
	Declare @appTypeId Integer = 0
	Declare @cloudAppsInstanceType Integer = 0
	Declare @jobIdActedOn Integer
	DECLARE @optype INT = 0
	DECLARE @subOpType INT = 0
	DECLARE @bkpAttributesEx BIGINT = 0
	DECLARE @targetClientID INT = 0
	DECLARE @bkpLevel INT = 0
	DECLARE @unixTimeNow BIGINT = 0
	DECLARE @commcellID INT = 2
	DECLARE @applicationSize BIGINT = 0
	DECLARE @sizeOnMedia BIGINT = 0
	DECLARE @encryptionType INTEGER
	DECLARE @subTaskId INT = 0
	DECLARE @isPlanDataSchedulePolicy INT = 0
	DECLARE @errorMsg    VARCHAR(MAX)
	DECLARE @clientId INT = 0
	DECLARE @isVsaV2Parent INT = 0
	DECLARE @jobEndTime INT = 0
	DECLARE @failureReason VARCHAR(512)
	DECLARE @agentIdaId INT = 0
	DECLARE @instanceId INT = 0
	DECLARE @backupSetId INT = 0
	DECLARE @displayStatus INT = @i_status
	DECLARE @parentStatus INT = 0
	DECLARE @cycleSequence	INTEGER = 1
	DECLARE @backupStartTime INT = 0
	DECLARE @backupEndTime INT = 0
	DECLARE @averageThroughput FLOAT = 0
	DECLARE @totalMediaUsageTime BIGINT = 0
	DECLARE @nwTransBytes BIGINT = 0
	DECLARE @lockName VARCHAR(64) = ''
	DECLARE @lockResult     int = -1
	DECLARE @isDDBOrIndexBackup INT = 0
	IF @i_jobId <= 0
	BEGIN
		SET @errorCode = @i_jobId
		GOTO ERROR_EXIT
	END
	SET @unixTimeNow = dbo.getUnixTime(GetUTCDate())
	BEGIN TRAN
	SELECT @jobIdActedOn = JBI.jobIdActedOn,
		@optype = JI.opType,
		@subOpType = JI.subOpType,
		@bkpAttributesEx = JBI.bkpAttributesEx,
		@targetClientID = JBI.targetClientId,
		@bkpLevel  = JBI.bkplevel,
		@applicationSize = unCompBytes,
		@subTaskId = JBI.backupTaskId,
		@failureReason = failureReason,
		@jobEndTime = serverEndTime,
		@agentIdaId = IDA.id,
		@instanceId = APP.instance,
		@backupSetId = APP.backupSet,
		@backupStartTime = JI.jobStartTime,
		@averageThroughput = JBI.averageThroughput,
		@totalMediaUsageTime = JBI.totalMediaUsageTime,
		@nwTransBytes = JBI.nwTransBytes
	FROM JMJobInfo(NOLOCK) JI
	JOIN JMBkpJobInfo(NOLOCK) JBI ON JI.jobId = JBI.jobId and JI.commCellId = JBI.commcellId
	JOIN APP_Application(NOLOCK) APP ON JBI.applicationId = APP.id
	JOIN APP_IDAName(NOLOCK) IDA ON IDA.clientId = APP.clientId AND IDA.appTypeId = APP.appTypeId
	WHERE
		JI.jobId = @i_jobId And JI.commCellId = @commcellID
	SELECT
	@displayStatus = JB.displayStatus
	FROM JMBkpStats JB (NOLOCK)
	WHERE JB.jobId = @i_jobId AND JB.commcellId = @commcellID
SET @isPlanDataSchedulePolicy = (SELECT CASE WHEN (ST.flags& 0x10000 ) > 0 THEN 1 ELSE 0 END
				FROM TM_SubTask ST WITH (NOLOCK)
				JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
				JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
JOIN TM_SubTaskOptions O (NOLOCK) ON O.subTaskId = ST.subTaskId AND O.optionId = 414240771	--_COMMONOPTION_USE_JOB_START_TIME_FOR_CONTINUOUS_SCHEDULE
				WHERE ST.subTaskId = @subTaskId
				AND O.Value = '1' -- Consider only schedules which have usejobStarttime set.
AND PT.freq_type = 4096
				AND PT.freq_interval != 0
AND ST.operationType = 2
			)
	 IF @bkpAttributesEx & 0x20000000000 = 0x20000000000 /*JMBKP_EX_VM_LEVEL_SYNTHFULL*/
		SELECT @appTypeId = appTypeId, @targetClientID = clientId FROM APP_Application (NOLOCK) WHERE id = @i_appId
	ELSE
		SELECT @appTypeId = appTypeId, @clientId = clientId FROM APP_Application (NOLOCK) WHERE id = @i_appId
IF @bkpattributesEx & 0x40000000 = 0x40000000
		SET @isVsaV2Parent = 1
	DECLARE @parentJobID INTEGER =  @i_jobId -- For convenience to use same variable for VM level job and parent level job or V1
	DECLARE @parentAppId INTEGER =  @i_appId -- For convenience to use same variable for VM level job and parent level job or V1
	DECLARE @isPseudoVMJob INTEGER = 0
IF @appTypeId = 106
	   AND
		 (@bkpAttributesEx & 0x4000000 = 0x4000000 /*JMBKP_EX_PSEUDO_CHILD_JOB*/)
	BEGIN
		SELECT @parentJobID = parentJobId, @parentAppID = parentAppId
		FROM JMJobDataLink WITH(NOLOCK)
WHERE childJobId = @i_jobId AND commCellId = @commcellID AND linkType = 7
		SET @isPseudoVMJob = 1
	END
	-- Initialize Instance type for Cloud App
IF @appTypeId = 134
	BEGIN
		SET @cloudAppsInstanceType = (SELECT CAST(attrVal AS INT)
									  FROM APP_InstanceProp IP WITH (NOLOCK)
									  WHERE IP.componentNameId = @instanceId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
									  )
	END
	-- Check if DDB or Index backup
	IF EXISTS(	SELECT 1
				FROM APP_SubClientProp p WITH(NOLOCK)
                WHERE p.componentNameId = @i_appId
                AND p.attrName IN (N'Index SubClient', N'DDB Backup')
                AND p.modified = 0
                AND p.attrVal = N'1'
                AND p.cs_attrName IN (CHECKSUM(N'Index SubClient'), CHECKSUM(N'DDB Backup'))
			 )
		SET @isDDBOrIndexBackup = 1
	If @appTypeId In(2/*ORACLE_7*/, 22/*ORACLE_8*/, 23/*ORACLE_8I*/, 80/*ORACLE_RAC*/, 37/*DB2*/, 62/*UNIXDB2*/, 103/*DB2DPF*/, 61/*SAP*/, 79/*SAP_FOR_SAPDB*/)
		Update archFile set isValid = -1 where isValid = 0 and jobId = @i_jobId and commCellId = 2
	-- All success cases should go here
	IF @i_status IN (1, 3, 14) /* JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/
	BEGIN
		-- Move the last seen MA from tape copy job to the SnapJob.
		IF @jobIdActedOn > 0 AND @optype = 60 /*SNAPTOTAPE*/
		BEGIN
Delete From JmJobOptions where jobId = @jobIdActedOn and commCellId = 2 and attributeId = 28
			Insert into JmJobOptions
			Select @jobIdActedOn, commCellId, attributeId, attributeName, attributeValueInt, attributeValue
From JmJobOptions Where jobId = @i_jobId and commCellId = 2 and attributeId = 28
		END
		-- VSA related changes
		IF (@appTypeId = 106  /* VIRTUAL_SERVER_IDA */ )
		BEGIN
			IF (@optype IN (4, 59) /*BACKUP, SNAP BACKUP*/ )
			BEGIN
				-- Populate Last Backup JobID
				-- Let us populate this for Indexing V2 as soon as VM job is complete.
				INSERT INTO #vmClientList
				(clientid, status, backupStartTime)
				SELECT vmClientId, ISNULL([vmStatus], 0) AS status, ISNULL([vmBackupStartTime], 0) AS backupStartTime
				FROM
				(
					SELECT VM.vmClientId, VM.attrName, VM.attrVal
					FROM APP_VMProp VM WITH(NOLOCK)
WHERE VM.jobid = @parentJobID and VM.commCellId = 2
					AND @isVsaV2Parent = 0 -- Not needed for V2 parent
					AND (@isPseudoVMJob = 0 OR VM.vmClientId = @clientId) -- Either not a V2 VM level job, get all clients for parent(V1). Or get only the VM client.
				) AS clients
				PIVOT
				(
					MAX(attrVal) -- Workaround for Pivot aggregate.
					FOR attrName IN
					(
						[vmStatus],
						[vmBackupStartTime]
					)
				) AS pvt
				MERGE INTO APP_ClientProp AS target
				USING (select clientid from #vmClientList  WHERE status IN (0,3) /* COMPLETED, PARTIAL_SUCCESS*/) as source
				ON (target.componentnameid = source.clientid AND target.attrname = 'Last Backup JobID' AND target.modified = 0)
				WHEN MATCHED THEN
					UPDATE SET attrVal = @parentJobID, created = @unixTimeNow
				WHEN NOT MATCHED THEN
					INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (source.clientid, 'Last Backup JobID', 7, @parentJobID, @unixTimeNow, 0, 0);
				MERGE INTO APP_ClientProp AS target
				USING (select clientid, backupStartTime from #vmClientList  WHERE status IN (0,3) /* COMPLETED, PARTIAL_SUCCESS*/) as source
				ON (target.componentnameid = source.clientid AND target.attrname = 'Last VM Backup Start Time' AND target.modified = 0)
				WHEN MATCHED THEN
					UPDATE SET attrVal = backupStartTime, created = @unixTimeNow
				WHEN NOT MATCHED THEN
					INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (source.clientid, 'Last VM Backup Start Time', 7, backupStartTime, @unixTimeNow, 0, 0);
				MERGE INTO APP_ClientProp AS target
				USING (select clientid from #vmClientList) as source
ON (target.componentnameid = source.clientid AND target.attrname = 'Last Backup Subclient' AND target.modified = 0)
				WHEN MATCHED THEN
					UPDATE SET attrVal = @parentAppID, created = @unixTimeNow
				WHEN NOT MATCHED THEN
					INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
values (source.clientid, 'Last Backup Subclient', 7, @parentAppID, @unixTimeNow, 0, 0);
				-- Job Finished
				-- Last backup subclient is updated
				-- Delete 'Next Backup Subclient' as that doesn't make sense anymore. We have our latest backup
				DELETE ACP
					FROM APP_ClientProp ACP
				INNER JOIN #vmClientList CL
ON CL.clientid=ACP.componentNameid AND ACP.attrname='Next Backup Subclient'
			END
			ELSE IF ( @optype = 14 ) -- SYNTHFULL
			BEGIN
				-- Populate Last Backup JobID
				INSERT INTO #vmClientList
				(clientid, status)
				SELECT VMP.vmClientId,  CAST(VMP.attrVal AS INT)
				FROM APP_VMProp VMP WITH(NOLOCK)
WHERE VMP.jobid = @i_jobId and VMP.commCellId = 2
				AND VMP.attrName = '' AND VMP.attrVal IN ('0', '3')/* COMPLETED, PARTIAL_SUCCESS*/
				MERGE INTO APP_ClientProp AS target
				USING (select clientid from #vmClientList WHERE status IN (0,3) /* COMPLETED, PARTIAL_SUCCESS*/) as source
				ON (target.componentnameid = source.clientid AND target.attrname = 'Last Backup JobID' AND target.modified = 0)
				WHEN MATCHED THEN
					UPDATE SET attrVal = @i_jobId, created = @unixTimeNow
				WHEN NOT MATCHED THEN
					INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					values (source.clientid, 'Last Backup JobID', 7, @i_jobId, @unixTimeNow, 0, 0);
				-- Synthetic full application size will be VM's backup size and guest size
				IF (@bkpAttributesEx & 0x20000000000 = 0x20000000000 /*JMBKP_EX_VM_LEVEL_SYNTHFULL*/)
				BEGIN
					INSERT INTO APP_VMPROP
					SELECT @i_jobId, @commcellID , @targetClientID, 'vmUsedSpace', 2, CAST(@applicationSize AS NVARCHAR(32)), @i_jobId
					IF NOT EXISTS(	SELECT 1 FROM APP_VMPROP
								WHERE jobid = @i_jobId AND commCellId = @commcellID
								AND VMclientId = @targetClientID
								AND attrName = 'vmGuestSize')
					BEGIN
						INSERT INTO APP_VMPROP
						SELECT @i_jobId, @commcellID , @targetClientID, 'vmGuestSize', 2, CAST(@applicationSize AS NVARCHAR(32)), @i_jobId
					END
				END
			END
		END
		SET @sizeOnMedia = ISNULL((select	SUM(sizeOnMedia) from JMJobDataStats J inner join archGroup AG on AG.id = J.archGrpId
									where j.jobId  = (case when  @optype = 60 then @jobIdActedOn else @i_jobId end)
									and j.commCellId =  @commcellID and j.archGrpCopyId = AG.defaultCopy),0)
		--Copied the logic from jmgetbkpstats.cur, if sum(sizeOnMedia) is 0 or null, get its totalBackupSize
		IF @sizeOnMedia = 0
		BEGIN
			SET @sizeOnMedia = ISNULL((SELECT totalBackupSize FROM JMBkpStats WHERE jobId = @i_jobId), 0)
		END
		--For VSA Indexing V2.1 Admin Parent Job, sizeOnMedia is sum of all the child job's sizeOnMedia
IF (@appTypeId = 106  /* VIRTUAL_SERVER_IDA */) AND @bkpattributesEx & 0x40000000 = 0x40000000
		BEGIN
			--Add size on media from child jobs
			SET @sizeOnMedia = @sizeOnMedia + ISNULL((SELECT SUM(sizeOnMedia)
				FROM JMJobDataStats J
				INNER JOIN archGroup AG ON AG.id = J.archGrpId
				INNER JOIN JMJobDataLink jobMapping WITH(NOLOCK)
				ON (J.jobId = jobMapping.childJobId AND jobMapping.parentJobId = (CASE WHEN  @optype = 60 THEN @jobIdActedOn ELSE @i_jobId end)
AND jobMapping.linkType = 7)
				WHERE J.commCellId = @commcellID AND J.archGrpCopyId = AG.defaultCopy),0)
		END
		INSERT INTO JMJobOptions
VALUES(@i_jobId, @commcellId, 73, 'Size on Media', @sizeOnMedia, '')
		--Snap backup job gets size on media only after backup copy job is run.
		IF @optype = 60
		BEGIN
IF EXISTS (SELECT 1 FROM JMJobOptions WHERE jobId = @jobIdActedOn AND commCellId = @commcellID AND attributeId = 73)
			BEGIN
UPDATE JMJobOptions SET attributeValueInt = @sizeOnMedia WHERE jobId = @jobIdActedOn AND commCellId = @commcellID AND attributeId = 73
			END
		END
		 SET @encryptionType =  (SELECT MAX(AFC.encKeyType)
					FROM archFile AF
					INNER JOIN archFileCopy AFC ON AF.jobId = @i_jobId AND AF.commCellId = @commcellId AND AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
					WHERE AF.isValid = 1)
		INSERT INTO JMMisc
VALUES(@i_jobId, 0, 71, 0, (CASE WHEN @encryptionType IS NULL THEN 2 WHEN @encryptionType > 0 THEN 1 ELSE 0 END), '', @commcellId)
INSERT INTO JMMisc VALUES(@i_jobId, 0, 74, 0, 0,
	        (SELECT ISNULL( STUFF((SELECT DISTINCT ',' + CAST(lib.LibraryId as nvarchar(12)) FROM MMLibrary lib WITH (NOLOCK), (SELECT MasterPoolId,LibraryId FROM MMMasterPool WITH (NOLOCK) ) AS mp
	                             WHERE lib.LibraryId > 0
	                             AND   lib.LibraryId = mp.LibraryId
	                             AND   mp.MasterPoolId IN (SELECT DISTINCT MasterPoolId
	                                                         FROM JMJObResourceHistory JM WITH (NOLOCK) WHERE JM.jobId = @i_jobId AND JM.commCellId = @commcellId
	                                                      )
	                                       FOR XML PATH('') ),1,1,''), '')
	        AS 'libraryList/@list'
	        FOR XML PATH ('jobStatsCache')), @commcellId)
		IF @subOpType = 114/*EXCHANGE_IMPORT*/
		BEGIN
			DECLARE @inXML XML
			SET @inXML =
			(
				SELECT
				@i_jobId '@jobId',
				@i_appId '@appId',
				ISNULL((select distinct userId From JMJobInfo(READUNCOMMITTED) where jobId = @i_jobId), 1/*Admin*/) '@userId'
				FOR XML PATH('App_MigratePSTMbxInfo'), TYPE
			)
			EXEC AppMigrateExchangeMBFromClassicAgent @inXML
		END
		IF @optype = 4
		BEGIN
			DELETE FROM APP_SubClientProp
			WHERE componentNameId = @i_appId AND attrName = 'Subclient Deconfigured Time' AND cs_attrName = checksum(N'Subclient Deconfigured Time')
		END
		-- Save the last backup size for all subclients if we have it.
		IF @optype IN (4, 18, 59, 65, 30, 43) -- JMShouldUpdateLastBackupTime AND @isDDBOrIndexBackup = 0
		BEGIN
			IF EXISTS(SELECT 1 FROM APP_SubClientProp WHERE componentNameId = @i_appId AND attrName = 'Last Backup Size' AND modified = 0 AND cs_attrName = CHECKSUM(N'Last Backup Size'))
			BEGIN
				UPDATE APP_SubClientProp
				SET attrVal = CAST(@applicationSize AS NVARCHAR(32)),
					created = @unixTimeNow
				WHERE componentNameId = @i_appId AND attrName = 'Last Backup Size' AND modified = 0 AND cs_attrName = CHECKSUM(N'Last Backup Size')
			END
			ELSE
			BEGIN
				INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES (@i_appId, 'Last Backup Size', 15, CAST(@applicationSize AS NVARCHAR(32)), @unixTimeNow, 0, 0)
			END
		END
		-- Upon successful completion of a synthetic full job, inactivate the property 'RunSFImmediately' if exists.
		-- This is needed for plan schedules to work correctly.
		-- Also synthetic full is if needed again to reclaim space, this row will be reinstated by a periodic thread that.
		IF @optype = 14 -- SYNTHFULL
		BEGIN
			UPDATE APP_SubClientProp
			SET modified = @unixTimeNow
			WHERE componentNameId = @i_appId AND attrName = 'RunSFImmediately' AND modified = 0 AND cs_attrName = CHECKSUM(N'RunSFImmediately')
		END
	END
	ELSE
	BEGIN
		-- For failed job in below category for VSA , save below property so that next time, we can use it for inheritance
		IF (@appTypeId = 106  /* VIRTUAL_SERVER_IDA */)  AND  (@optype IN (4, 59) /*BACKUP, SNAP BACKUP*/ )
		BEGIN
			INSERT INTO #vmClientList
			(clientid, status)
			SELECT clientid, status
			FROM jmqinetixupdatestatus
			WHERE jobid = @parentJobID AND commCellId = 2
			AND (@isPseudoVMJob = 0 OR clientId = @clientId) -- Either not a VM level job, get all clients. Or get only the VM client.
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT CT.clientid, 'Last Backup Subclient', 7, @parentAppID, @unixTimeNow, 0, 0 FROM #vmClientList CT
			LEFT OUTER JOIN APP_ClientProp ACP WITH(NOLOCK)
ON ACP.componentNameId=CT.clientid AND ACP.attrname = 'Last Backup Subclient' AND ACP.modified = 0
			WHERE ACP.componentNameId IS NULL
		END
		IF @isPlanDataSchedulePolicy = 1
		BEGIN
			DECLARE @xmlForResetScProp XML
            SET @xmlForResetScProp =
					(SELECT 1 AS '@jobFailed',
(SELECT @i_appId '@subclientId' , 7 '@_type_',
								(SELECT @subTaskId '@subtaskId' FOR XML PATH('subtask'), TYPE)
								FOR XML PATH('entity'), TYPE)
						FOR XML PATH('App_AssociationsForNextRunTimeRecompute')
					)
            EXEC dbo.TM_ResetNextStartTimeForContSched @xmlForResetScProp, @errorCode OUTPUT, @errorMsg OUTPUT
		END
	END
	-- end of @i_status IN (1, 3, 14) /* JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS*/
	-- Make sure the VM status is correct at the end of VSA pseudo VM job. MR :163951
IF @appTypeId = 106
	   AND
	   ( (@bkpAttributesEx & 0x20000000000 = 0x20000000000 /*JMBKP_EX_VM_LEVEL_SYNTHFULL*/)
								OR
		 (@i_status = 4/*KILLED*/ AND @isPseudoVMJob = 1)
	   )
	BEGIN
		DECLARE @vmStatus INT = 0
		SET @vmStatus =			(CASE @i_status
									WHEN 1 THEN 0 -- JMSUCCESS THEN VMClientBkupStatus_COMPLETED
									WHEN 2 THEN 1 -- FAIL THEN VMClientBkupStatus_FAILED
									WHEN 3 THEN 3 -- PARTIALSUCCESS THEN VMClientBkupStatus_PARTIAL_SUCCESS
									WHEN 4 THEN 6 -- KILLED THEN VMClientBkupStatus_KILLED
									WHEN 9 THEN 1 -- DROPPED (Failed to start) THEN VMClientBkupStatus_FAILED
									WHEN 14 THEN 3 -- JMSUCCESSWITHWARNINGS THEN VMClientBkupStatus_PARTIAL_SUCCESS
									ELSE 1 --  THEN VMClientBkupStatus_FAILED
								 END
								 )
		UPDATE JMQinetixUpdateStatus
		SET status = @vmStatus
		WHERE jobid = @parentJobID AND commCellId = 2
		AND clientId = @targetClientID
		UPDATE APP_VMProp
		SET attrVal = CAST(@vmStatus AS NVARCHAR(12))
		WHERE jobid = @parentJobID AND commCellId = 2
		AND VMclientId = @targetClientID
		AND attrName = 'vmStatus'
		-- set average throughput for synth full as well to be consistent
		IF NOT EXISTS(SELECT 1 FROM APP_VMProp WITH(NOLOCK) WHERE jobId = @parentJobID AND commCellId = @commcellID AND VMclientId = @targetClientID AND attrName = 'vmAverageThroughput')
		BEGIN
			INSERT INTO APP_VMProp VALUES(@parentJobID, @commcellID, @targetClientID, 'vmAverageThroughput', 2, @averageThroughput, @i_jobId)
		END
		ELSE
		BEGIN
			UPDATE APP_VMProp SET attrVal = @averageThroughput WHERE jobId = @parentJobID AND commCellId = @commcellID AND VMclientId = @targetClientID AND attrName = 'vmAverageThroughput'
		END
	END
	-- Consecutive failures
	DECLARE @failureCount INT = 0
	IF @i_status IN (2, 9)
	BEGIN
		SET @failureCount = 1
	END
	IF @i_status IN (1, 2, 3, 9, 14)
	BEGIN
		UPDATE APP_SubClientProp
		SET attrVal = CASE WHEN @i_status IN (1, 3, 14) THEN 0 ELSE attrVal + 1 END
		WHERE componentNameId = @i_appId AND attrName = 'Consecutive Backup Failures Count' AND modified = 0 AND cs_attrName = CHECKSUM(N'Consecutive Backup Failures Count')
		SET @rcnt = @@ROWCOUNT
		IF @rcnt = 0
		BEGIN
			INSERT INTO APP_SubClientProp
			VALUES (@i_appId, 'Consecutive Backup Failures Count', 7, @failureCount, @unixTimeNow, 0, 0)
		END
	END
	------ Populate cached values for Command center screens - BEGIN ------
	IF @optype IN (4, 18, 59, 65, 30, 43) -- JMShouldUpdateLastBackupTime AND @isDDBOrIndexBackup = 0
	BEGIN
		DECLARE @lastBackupJobInfo XML
		SET @lastBackupJobInfo = (
									SELECT	@i_jobId AS '@jobID',
										@commcellID AS '@commCellID',
										@displayStatus AS '@status', -- Use display status always so that committed jobs show correctly
										@failureReason AS '@failureReasonIds',
										dbo.JMGetLocalizedMessageFunc(0, @failureReason) AS '@failureReasonMessageEnglish',
										@jobEndTime AS 'endTime/@time',
										@backupStartTime AS 'startTime/@time'
									FOR XML PATH('lastBackupJobInfo'), TYPE
								 )
		-- Need to take locks to prevent duplicate inserts.
		SET @lockName = 'JMAppIdLastBackupLock_' + cast(@i_appId as varchar(16))
		EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
		IF @lockResult NOT IN (0, 1)
		BEGIN
			PRINT 'JMPostStatsActivity : Failed to acquire lock [' + @lockName + ']. Skipping last backup info.'
		END
		ELSE
		BEGIN
			-- Save the last backup job information agains the subclient and agent.
			UPDATE APP_SubClientProp WITH (ROWLOCK)
			SET attrVal = CAST(@lastBackupJobInfo AS NVARCHAR(MAX)),
				created = @jobEndTime -- use end time for created
			WHERE componentNameId = @i_appId AND attrName = 'Last Backup Job Info' AND modified = 0 AND cs_attrName = CHECKSUM(N'Last Backup Job Info')
			-- Insert if prop not exists
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES (@i_appId, 'Last Backup Job Info', 15, CAST(@lastBackupJobInfo AS NVARCHAR(MAX)), @jobEndTime, 0, 0)
			END
			-- Release lock
			IF @lockName <> ''
			BEGIN
				EXEC @lockResult = sp_releaseapplock @Resource = @lockName
				SET @lockName = ''
			END
		END
		-- Save at VM client level for VMs.
IF @appTypeId = 106
		BEGIN
			-- Get all info about VMs first
			INSERT INTO #vmLastJobclientList(clientId, lastBackupJobInfo)
			SELECT vmClientId,
					(
							SELECT	@i_jobId AS '@jobID', -- Using client jobId causes duplicates as somerows have 0 in them which gets updated later. Use @i_jobID which is same
									commCellId AS '@commCellID',
									CASE
										WHEN [vmStatus] = 0 THEN 1 -- VMClientBkupStatus::COMPLETED, CVJobStatus::JMSUCCESS
										WHEN [vmStatus] = 1 THEN 2 -- VMClientBkupStatus::FAILED, CVJobStatus::FAIL
										WHEN [vmStatus] = 3 THEN 3 -- VMClientBkupStatus::PARTIAL_SUCCESS, CVJobStatus::PARTIALSUCCESS
										WHEN [vmStatus] = 6 THEN 4 -- VMClientBkupStatus::KILLED, CVJobStatus::KILLED
										ELSE 9 -- VMClientBkupStatus::SKIPPED_BY_USER or VMClientBkupStatus::SKIPPED, CVJobStatus::DROPPED
									END AS '@status',
									CASE
										WHEN LEN([vmFailureReason]) > 512 -- Limiting to 512 in the failure reason to ensure it doesnt overflow attrVal column after xml encoding.
											THEN SUBSTRING([vmFailureReason], 1, 500) + '<Truncated>'
										ELSE [vmFailureReason]
									END AS '@failureReasonMessageEnglish',
									[vmBackupEndTime] AS 'endTime/@time',
									[vmBackupStartTime] AS 'startTime/@time'
							FOR XML PATH('lastBackupJobInfo'), TYPE
					)
			FROM
			(
				SELECT VM.vmClientId, VM.attrName, VM.attrVal, VM.commcellId
				FROM APP_VMProp VM WITH(NOLOCK)
WHERE VM.jobid = @parentJobID and VM.commCellId = 2
				AND @isVsaV2Parent = 0 -- Not needed for V2 parent
				AND (@isPseudoVMJob = 0 OR VM.vmClientId = @clientId) -- Either not a V2 VM level job, get all clients for parent(V1). Or get only the VM client.
			) AS clients
			PIVOT
			(
				MAX(attrVal) -- Workaround for Pivot aggregate.
				FOR attrName IN
				(
					[vmStatus],
					[vmBackupStartTime],
					[vmBackupEndTime],
					[vmFailureReason]
				)
			) AS pvt
			-- Need to take locks to prevent duplicate inserts.
			-- Not that as this is bulk update, lock is global. This should be fine as it is a quick update operation most of the times.
			SET @lockName = 'JMVMLastBackupLock'
			EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @lockResult NOT IN (0, 1)
			BEGIN
				PRINT 'JMPostStatsActivity : Failed to acquire lock [' + @lockName + ']. Skipping last backup info.'
			END
			ELSE
			BEGIN
				UPDATE SP
				SET SP.attrVal = CAST(VM.lastBackupJobInfo AS NVARCHAR(MAX)),
					SP.created = @jobEndTime
				FROM #vmLastJobclientList VM
				INNER JOIN APP_ClientProp SP ON SP.componentNameId = VM.clientId AND SP.attrName = 'Last VM Backup Job Info' AND SP.modified = 0
				INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				SELECT VM.clientId, 'Last VM Backup Job Info', 15, CAST(VM.lastBackupJobInfo AS NVARCHAR(MAX)), @jobEndTime, 0, 0
				FROM #vmLastJobclientList VM
				LEFT OUTER JOIN APP_ClientProp SP ON SP.componentNameId = VM.clientId AND SP.attrName = 'Last VM Backup Job Info' AND SP.modified = 0
				WHERE SP.id IS NULL -- Prop not already exists, so insert.
				-- Release lock
				IF @lockName <> ''
				BEGIN
					EXEC @lockResult = sp_releaseapplock @Resource = @lockName
					SET @lockName = ''
				END
			END
		END
		-- Save at instance level for DB agents in command center.
		ELSE IF @appTypeId IN (81, -- MSSQL
							   22, 80, 61, -- ORACLE_8, ORACLE_RAC, SAP
							   3, 5, -- INFORMIX, SYBASE
							   37, 62, 103, -- DB2, UNIXDB2, DB2DPF
							   104, 125, -- MYSQL, POSTGRESS
							   135 -- SAP_HANA
							   )
				OR
( (@appTypeId = 134)
				  AND
				  (@cloudAppsInstanceType IN (4, 22, 23, 26, 27) )
				  -- CloudAppsInstanceType_AMAZON_RDS , CloudAppsInstanceType_AMAZON_DYNAMODB, CloudAppsInstanceType_AZURE_COSMOS_DB_SQL_API, CloudAppsInstanceType_AMAZON_REDSHIFT, CloudAppsInstanceType_AMAZON_DOCUMENTDB
			 )
		BEGIN
			-- Need to take locks to prevent duplicate inserts.
			SET @lockName = 'JMInsLastBackupLock_' + cast(@instanceId as varchar(16))
			EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @lockResult NOT IN (0, 1)
			BEGIN
				PRINT 'JMPostStatsActivity : Failed to acquire lock [' + @lockName + ']. Skipping last backup info.'
			END
			ELSE
			BEGIN
				UPDATE APP_InstanceProp
				SET attrVal = CAST(@lastBackupJobInfo AS NVARCHAR(MAX)),
					created = @jobEndTime -- use end time for created
				WHERE componentNameId = @instanceId AND attrName = 'Last Backup Job Info' AND modified = 0
				-- Insert if prop not exists
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO APP_InstanceProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					VALUES (@instanceId, 'Last Backup Job Info', 15, CAST(@lastBackupJobInfo AS NVARCHAR(MAX)), @jobEndTime, 0, 0)
				END
				-- Release lock
				IF @lockName <> ''
				BEGIN
					EXEC @lockResult = sp_releaseapplock @Resource = @lockName
					SET @lockName = ''
				END
			END
		END
		-- Save at backupset level for Sharepoint agent in command center.
ELSE IF @appTypeId = 78
		BEGIN
			-- Need to take locks to prevent duplicate inserts.
			SET @lockName = 'JMBkpSetLastBackupLock_' + cast(@backupSetId as varchar(16))
			EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @lockResult NOT IN (0, 1)
			BEGIN
				PRINT 'JMPostStatsActivity : Failed to acquire lock [' + @lockName + ']. Skipping last backup info.'
			END
			ELSE
			BEGIN
				UPDATE APP_BackupSetProp
				SET attrVal = CAST(@lastBackupJobInfo AS NVARCHAR(MAX)),
					created = @jobEndTime -- use end time for created
				WHERE componentNameId = @backupSetId AND attrName = 'Last Backup Job Info' AND modified = 0
				-- Insert if prop not exists
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					VALUES (@backupSetId, 'Last Backup Job Info', 15, CAST(@lastBackupJobInfo AS NVARCHAR(MAX)), @jobEndTime, 0, 0)
				END
				-- Release lock
				IF @lockName <> ''
				BEGIN
					EXEC @lockResult = sp_releaseapplock @Resource = @lockName
					SET @lockName = ''
				END
			END
		END
		-- Save at agent level for other agents.
		ELSE
		BEGIN
			-- Need to take locks to prevent duplicate inserts.
			SET @lockName = 'JMIdaLastBackupLock_' + cast(@agentIdaId as varchar(16))
			EXEC @lockResult = sp_getapplock @Resource = @lockName, @LockMode = 'Exclusive', @LockTimeout = 60000
			IF @lockResult NOT IN (0, 1)
			BEGIN
				PRINT 'JMPostStatsActivity : Failed to acquire lock [' + @lockName + ']. Skipping last backup info.'
			END
			ELSE
			BEGIN
				UPDATE APP_IDAProp
				SET attrVal = CAST(@lastBackupJobInfo AS NVARCHAR(MAX)),
					created = @jobEndTime -- use end time for created
				WHERE componentNameId = @agentIdaId AND attrName = 'Last Backup Job Info' AND modified = 0
				-- Insert if prop not exists
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO APP_IDAProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					VALUES (@agentIdaId, 'Last Backup Job Info', 15, CAST(@lastBackupJobInfo AS NVARCHAR(MAX)), @jobEndTime, 0, 0)
				END
				-- Release lock
				IF @lockName <> ''
				BEGIN
					EXEC @lockResult = sp_releaseapplock @Resource = @lockName
					SET @lockName = ''
				END
			END
		END
	END
	------ Populate cached values for Command center screens - END------
	IF @optype = 14 /* SYNTHFULL */ AND @appTypeId = 106  /* VIRTUAL_SERVER_IDA */
	BEGIN
		IF dbo.IsIndexingV2Enabled(0, 0, @i_appId) = 1
		BEGIN
			DECLARE @parentSFJobID INT = 0
			DECLARE @parentSFAppID INT = 0
			IF EXISTS(
				SELECT 1 FROM APP_ClientProp (NOLOCK) P
				JOIN APP_Application A (NOLOCK) ON A.clientId = P.componentNameId AND A.id = @i_appId
				WHERE P.attrName='Virtual Server Discovered Clients'
				AND P.attrVal = '1' AND P.modified = 0
				)
			BEGIN
				SELECT @parentSFJobID = (
CASE WHEN optionId = 100007 THEN value ELSE @parentSFJobID END
						),
				@parentSFAppID = (
CASE WHEN optionId = 100006 THEN value ELSE @parentSFAppID END
						)
				FROM dbo.GetAllJobOptions(@i_jobId)
WHERE optionId IN (100006, 100007)
				IF @parentSFJobID > 0
				BEGIN
					IF NOT EXISTS(SELECT 1 FROM JMJobStats WHERE jobId = @parentSFJobID AND status <> 1)  -- 1 - ACTIVE, for skipped VM, status will be set to active
					BEGIN
						SET @cycleSequence = CONVERT(INTEGER,ISNULL((SELECT attrVal FROM APP_SubClientProp WHERE componentNameId = @i_appId AND modified = 0 and cs_attrName = CHECKSUM(N'sys:non full cycle num')), @cycleSequence))
						SELECT @backupStartTime = servStartDate, @backupEndTime = servEndDate
						FROM JMBkpStats WHERE jobId = @i_jobId AND commcellId = @commcellID
						IF NOT EXISTS(SELECT 1 FROM JMJobStats WHERE jobId = @parentSFJobID)
						BEGIN
							INSERT INTO JMJobStats(jobid, status, opType, commCellId, jobCategory, jobDescription, xmlJobInfo, subOpType, foreignToken)
												VALUES(@parentSFJobID, 2/*FINISHED*/, @optype, @commCellID, 1 , '', '', 147 /*SYNTH_FULL_ADMIN*/, '')
						END
						ELSE
						BEGIN
							SET @i_status = 3 --PARTIALSUCCESS
							UPDATE JMJobStats SET status = 2 /*FINISHED*/ WHERE jobid = @parentSFJobID AND commCellId = @commCellID
						END
						INSERT INTO JMBkpStats(jobId,commCellId,appId,appType,numAttempts,dataArchGrpId,copyID,bkpLevel,indexOverride,status,duration,numStreams,servStartDate,servEndDate,opType,fullCycleNum,initFrom,failureReason,bkpOptions,scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,oraSubLevel,username,totalWriteTime,priority,totalCompBytes,totalUncompBytes,totalNumOfFiles,bkpattributes,logArchGrpId,totalNumOfFolders,failureErrorCode,lastIncrJobTime,scanType,scanTypeChangeReason,numStreamsRequested,dataStatus,agedTime,mediaDeletedTime,modifiedTime,version,idaVersion,cIndexTime,cycleSequence,filesToXfer,cloudId,diffArchGrpId,totalBackupSize,percentageChange,targetClientId,totalUncompBytesToXfer,displayStatus,dataBackedUp,logsBackedUp,openChain,secondaryBkpLevel,jobIdPrepared,jobIdActedOn,fromTime,toTime,subTaskId,nwTransBytes,totSkippedObjects,bkpAttributesEx,jobReferenceTime)
						SELECT @parentSFJobID				as jobId,
								jobInfo.commcellId			as commCellId,
								@parentSFAppID				as appId,
								app.appTypeId				as appType,
								jobInfo.runAttempts			as numAttempts,
								dataArchGrpID				as dataArchGrpId,
								0							as copyID,
								bkpLevel					as bkpLevel,
								indexOverride				as indexOverride,
								@i_status/*status*/			as status,
								@unixTimeNow - @backupStartTime/*duration*/ as duration,
								bkpJobInfo.numStreams		as numStreams,
								@backupStartTime			as servStartDate,
								@unixTimeNow				as servEndDate,
								@optype						as opType,
								1							as fullCycleNum,
								jobInfo.initFrom			as initFrom,
								''							as failureReason,
								bkpJobInfo.bkpOptions		as bkpOptions,
								bkpJobInfo.scanFileFailures as scanFileFailures,
								0							as scanFolderFailures,
								bkpJobInfo.backupFileFailures as backupFileFailures,
								0							as backupFolderFailures,
								bkpJobInfo.oraSubLevel as oraSubLevel,
								jobInfo.opUsername			as username,
								bkpJobInfo.totalMediaUsageTime as totalWriteTime,
								jobInfo.combPriority		as priority,
								0							as totalCompBytes,
								0							as totalUncompBytes,
								bkpJobInfo.filesXfered		as totalNumOfFiles,
								bkpJobInfo.bkpattributes	as bkpattributes,
								bkpJobInfo.logPolicy		as logArchGrpId,
								0							as totalNumOfFolders,
								0							as failureErrorCode,
								0							as lastIncrJobTime,
								bkpJobInfo.scanType			as scanType,
								bkpJobInfo.scanTypeChangeReason			as scanTypeChangeReason,
								1							as numStreamsRequested,
								0							as dataStatus,
								0							as agedTime,
								0							as mediaDeletedTime,
								@unixTimeNow				as modifiedTime,
								16							as version,
								1							as idaVersion,
								0							as cIndexTime,
								@cycleSequence				as cycleSequence,
								bkpJobInfo.filesToXfer		as filesToXfer,
								bkpJobInfo.cloudId			as cloudId,
								bkpJobInfo.diffPolicy		as diffArchGrpId,
								0							as totalBackupSize,
								0							as percentageChange,
								0							as targetClientId,
								bkpJobInfo.unCompBytesToXfer			as totalUncompBytesToXfer,
								@i_status					as displayStatus,
								1							as dataBackedUp,
								0							as logsBackedUp,
								0							as openChain,
								0							as secondaryBkpLevel,
								0							as jobIdPrepared,
								0							as jobIdActedOn,
								bkpJobInfo.fromTime			as fromTime,
								bkpJobInfo.toTime			as toTime,
								bkpJobInfo.backupTaskId		as subTaskId,
								bkpJobInfo.nwTransBytes		as nwTransBytes,
								bkpJobInfo.totSkippedObjects			as totSkippedObjects,
								0x100000000000000			as bkpAttributesEx,	--JMBKP_EX_VSA_PARENT_SYNTHFULL
								bkpJobInfo.jobReferenceTime as jobReferenceTime
								FROM JMJobInfo jobInfo INNER
								JOIN JMBkpJobInfo bkpJobInfo
									ON jobInfo.jobId = @i_jobId
									AND bkpJobInfo.jobId = @i_jobId and jobInfo.commCellId = bkpJobInfo.commcellId
								INNER JOIN APP_Application app
									ON bkpJobInfo.applicationId = app.id
									AND bkpJobInfo.commcellId = app.origCCId
						SET @rcnt = @@ROWCOUNT
						IF @rcnt = 0
						BEGIN
							--Stats creation failed , Log  the message and go ahead
							print 'Failed to create stats for Parent Job ' + CAST(@parentSFJobID AS VARCHAR(10))
						END
						ELSE
						BEGIN
							UPDATE JMBkpStats
							SET username = (
								SELECT U.login
								FROM UMUsers U (NOLOCK)
								JOIN TM_JobRequest R (NOLOCK) ON R.userId = U.id
								JOIN TM_Jobs J (NOLOCK) ON J.jobRequestId = R.jobRequestId AND J.jobId = @i_jobId
							)
							WHERE jobId = @parentSFJobID AND commCellId = @commcellID
						END
					END
					ELSE
					BEGIN
						SELECT @parentStatus = status
						FROM JMBkpStats
						WHERE jobId = @parentSFJobID
						AND commCellId = @commcellID
						IF @parentStatus != @i_status
							SET @parentStatus = 3	--PARTIALSUCCESS
						UPDATE JMBkpStats
						SET displayStatus = @parentStatus,
						status = @parentStatus,
						--servStartDate = @backupStartTime,
						servEndDate = @unixTimeNow,
						modifiedTime = @unixTimeNow
						WHERE jobId = @parentSFJobID
						AND commCellId = @commcellID
					END
					-- insert linkage for vm synthetic full and unaged parent job for VSA subclient within current full cycle
					INSERT INTO JMJobDataLink(commCellId, parentJobId, childJobId, parentAppid, childAppid, linkType , childJobStatus)
SELECT @commcellId, @parentSFJobID, @i_jobId, @parentSFAppID, @i_appId, 7, @i_status  -- should be valid status from VM synthetic full
					-- Populate JMQinetixUpdateStatus now based on indexing V2 child/parent jobs
					INSERT INTO JMQinetixUpdateStatus ([jobId], [commCellId], [clientId], [clientName], [status], [category], [ostype], [discoverPhaseStatus], [foreignCommCellName], [clientRegistry], [installedUpdates], [statusMessage])
					SELECT	@parentSFJobID AS jobId, @commcellId AS commCellId, QVMP.clientId, QVMP.clientName,QVMP.status,
						QVMP.category, QVMP.ostype, QVMP.discoverPhaseStatus, QVMP.foreignCommCellName, QVMP.clientRegistry, QVMP.installedUpdates, QVMP.statusMessage
					FROM JMQinetixUpdateStatus QVMP WITH(NOLOCK) WHERE jobId = @i_jobId
					-- update synthetic full application size
					IF @parentSFJobID > 0
					BEGIN
						DECLARE @totalB BIGINT = 0, @totalUB  BIGINT = 0, @totalWriteTime BIGINT = 0
						SELECT @totalB = ISNULL(SUM(totalCompBytes), 0),
						@totalUB = ISNULL(SUM(totalUncompBytes), 0),
						@totalWriteTime = ISNULL(SUM(totalWriteTime), 0)
						FROM JMBkpStats JMB WITH(NOLOCK)
						INNER JOIN JMJobDataLink jLink WITH(NOLOCK)
ON JMB.jobID = jLink.childJobId AND JMB.commcellId = jLink.commCellId AND jLink.linkType = 7
						AND jLink.parentJobId = @parentSFJobID
						AND JMB.status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						UPDATE JMBkpStats
						SET totalCompBytes = @totalB, totalUncompBytes = @totalUB, totalWriteTime = @totalWriteTime
						WHERE jobId = @parentSFJobID AND commCellId = @commcellID
						-- calculate size on media from child jobs
						SET @sizeOnMedia = ISNULL((SELECT SUM(sizeOnMedia)
							FROM JMJobDataStats J WITH(NOLOCK)
							INNER JOIN archGroup AG WITH(NOLOCK) ON AG.id = J.archGrpId
							INNER JOIN JMJobDataLink jobMapping WITH(NOLOCK)
							ON (J.jobId = jobMapping.childJobId AND jobMapping.parentJobId = @parentSFJobID
AND jobMapping.linkType = 7)
							WHERE J.commCellId = @commcellID AND J.archGrpCopyId = AG.defaultCopy),0)
IF EXISTS (SELECT 1 FROM JMJobOptions WHERE jobId = @parentSFJobID AND commCellId = @commcellID AND attributeId = 73)
						BEGIN
UPDATE JMJobOptions SET attributeValueInt = @sizeOnMedia WHERE jobId = @parentSFJobID AND commCellId = @commcellID AND attributeId = 73
						END
						ELSE
						BEGIN
							INSERT INTO JMJobOptions
VALUES(@parentSFJobID, @commcellId, 73, 'Size on Media', @sizeOnMedia, '')
						END
					END
				END
			END
		END
	END
	-- fix ClientJobId in App_VMProp table
IF @appTypeId = 106 AND (@bkpAttributesEx & 0x40000000 = 0x40000000 /* JMBKP_EX_PSEUDO_PARENT_JOB  */ )
	BEGIN
		UPDATE VMP SET VMP.ClientJobId = DL.childJobId FROM APP_VMProp VMP
		INNER JOIN JMJobDataLink DL ON VMP.jobid = DL.parentJobId AND VMP.commCellId = DL.commCellId
		INNER JOIN APP_Application APP ON VMP.VMclientId = APP.clientId AND DL.childAppid = APP.id
		WHERE VMP.jobid = @i_jobId
AND DL.linkType = 7
			AND (VMP.ClientJobId = 0 OR VMP.ClientJobId IS NULL OR VMP.ClientJobId = VMP.jobid)  -- for some case, VM properties was created before vm pseudo job was created, thus set with parent jobid by default
		-- for parent job, persist the totalMediaUsageTime, nwTransBytes
		UPDATE JMBkpStats SET totalWriteTime = @totalMediaUsageTime, nwTransBytes = @nwTransBytes
		WHERE jobId = @i_jobId AND commCellId = @commcellID
		-- backup copy
		IF @optype = 60
		BEGIN
			DECLARE @totalUncompBytes  BIGINT = 0
			SELECT @totalUncompBytes = ISNULL(SUM(ISNULL(totalUncompBytes, 0)), 0)
			FROM JMBkpStats JMB WITH(NOLOCK)
				INNER JOIN JMJobDataLink jLink WITH(NOLOCK)
ON JMB.jobID = jLink.childJobId AND JMB.commcellId = jLink.commCellId AND jLink.linkType = 7
				AND jLink.parentJobId = @jobIdActedOn AND jLink.commCellId = @commCellId
				INNER JOIN JMJobSnapshotStats JSS WITH(NOLOCK) ON jLink.childJobId = JSS.jobId AND jLink.commcellId = JSS.commcellId
				WHERE JMB.status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JSS.materializationStatus = 100
			UPDATE JMBkpStats SET totalUncompBytes = @totalUncompBytes
			WHERE jobId =@jobIdActedOn AND commCellId = @commcellID
		END
	END
	-- set to itself if no child job
IF @appTypeId = 106
	BEGIN
		UPDATE VMP SET VMP.ClientJobId = VMP.jobid  FROM APP_VMProp VMP
		WHERE VMP.jobid = @i_jobId
			AND (VMP.ClientJobId = 0 OR VMP.ClientJobId IS NULL)
	END
	-- clear vmCurrentThroughput in APP_VMProp table when VM Pseudo job finish
	-- add vmAverageThroughput in APP_VMProp table when VM Pseudo job finish
IF @appTypeId = 106  AND @isPseudoVMJob = 1
	BEGIN
		DELETE FROM APP_VMProp
		WHERE jobId = @parentJobID
			AND commCellId = @commcellID
			AND VMclientId = @targetClientID
			AND attrName = 'vmCurrentThroughput'
		IF NOT EXISTS(SELECT 1 FROM APP_VMProp WITH(NOLOCK) WHERE jobId = @parentJobID AND commCellId = @commcellID AND VMclientId = @targetClientID AND attrName = 'vmAverageThroughput')
		BEGIN
			INSERT INTO APP_VMProp VALUES(@parentJobID, @commcellID, @targetClientID, 'vmAverageThroughput', 2, @averageThroughput, @i_jobId)
		END
		ELSE
		BEGIN
			UPDATE APP_VMProp SET attrVal = @averageThroughput WHERE jobId = @parentJobID AND commCellId = @commcellID AND VMclientId = @targetClientID AND attrName = 'vmAverageThroughput'
		END
	END
	IF OBJECT_ID('tempdb.dbo.#vmClientList') IS NOT NULL
		DROP TABLE #vmClientList
	IF OBJECT_ID('tempdb.dbo.#vmLastJobclientList') IS NOT NULL
		DROP TABLE #vmLastJobclientList
	COMMIT TRAN
END TRY
BEGIN CATCH
	-- Release lock if we still have a lock name.
	IF @lockName <> ''
	BEGIN
		EXEC @lockResult = sp_releaseapplock @Resource = @lockName
		SET @lockName = ''
	END
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	IF (XACT_STATE()) <> 0
    BEGIN
		ROLLBACK TRANSACTION;
    END
END CATCH;
ERROR_EXIT:
	SELECT  @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'JMPostStatsActivity')
	delete from GxQscripts where name = 'JMPostStatsActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPostStatsActivity')
	delete from GXDBVersions where aliasname = 'JMPostStatsActivity'
GO

insert into GXDBVersions values(2, 'JMPostStatsActivity',  'v1.4.48.62.4.4', 'JMPostStatsActivity', 'v1.4.48.62.4.4')
GO

