

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMPopulateReferenceCopyInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMPopulateReferenceCopyInfo.sp,v $ $Id: JMPopulateReferenceCopyInfo.sp,v 1.6.60.4 2018/03/22 03:13:15 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMPopulateReferenceCopyInfo
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMPopulateReferenceCopyInfo <<<'

IF EXISTS (select * from sysobjects where name='JMPopulateReferenceCopyInfo')
	drop procedure JMPopulateReferenceCopyInfo
IF EXISTS (select * from GxQscripts where name='JMPopulateReferenceCopyInfo')
	delete from GxQscripts where name = 'JMPopulateReferenceCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPopulateReferenceCopyInfo')
	delete from GXDBVersions where aliasname = 'JMPopulateReferenceCopyInfo'
GO
print '... Creating Procedure: JMPopulateReferenceCopyInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMPopulateReferenceCopyInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @refAppId INTEGER,
  @userId INTEGER,
  @jobId INTEGER	
AS
  DECLARE @errorCode INTEGER
DECLARE	@refAppType INT
DECLARE @assocXml XML
DECLARE @subOpType INT
DECLARE @requestType INT = 1
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
	SET @errorCode = 0
	IF object_id('tempdb.dbo.#SubclientInfo') is not null DROP TABLE #SubclientInfo
	CREATE TABLE #SubclientInfo(appId INTEGER, appTypeId INTEGER, clientId INTEGER, instanceId INTEGER, backupsetId INTEGER, status INTEGER, refTime INT, clientGrp Int, reviewSetId Int, componentType Int)
	SELECT @refAppType = appTypeId FROM APP_Application WHERE id = @refAppId
	SELECT @subOpType = subOpType FROM JMJobStats(READUNCOMMITTED) WHERE [jobId] = @jobId
	IF @subOpType = 114/*EXCHANGE_IMPORT*/
	BEGIN
		set @assocXml = ISNULL(dbo.GetXMLJobOptions(@jobId).query('/TMMsg_JobOption/backupOpts/exchOnePassOptions/importJobOptions/associations'), '<associations/>')
		SET @requestType = 3
	END
	ELSE
		SELECT @assocXml = attrVal FROM APP_SubClientProp WHERE componentNameId = @refAppId AND attrName = 'Reference Copy Association' AND modified = 0
	Insert into #SubclientInfo
Exec AppGetRefCopyAssocSubClients @refAppId, @refAppType, @userId, @requestType, 7, @assocXml
	IF @subOpType = 114/*EXCHANGE_IMPORT*/
	BEGIN
			DELETE FROM #SubclientInfo
			WHERE appId IN (SELECT DISTINCT jref.srcAppId FROM JMReferenceCopy jref INNER JOIN JMJobInfo jji ON jref.refJobId = jji.jobId AND jji.subOpType = 114)
	END
	Merge JMReferenceCopy j
	Using #SubclientInfo sc
	On j.refAppId = @refAppId And j.componentType = sc.componentType And ((sc.componentType =1/*ReviewSet*/ and j.srcAppId = sc.reviewSetId) OR (sc.componentType = 0 and j.srcAppId = sc.appId))
	When MATCHED Then
	Update Set j.refJobId = @jobId, j.tempRefTime =0, j.flag = 0
	When NOT MATCHED Then
	Insert Values(@refAppId, (case when sc.componentType = 1 then sc.reviewSetId else sc.appId end), 0, 0, @jobId, 2, 0, 0, 0, 0, sc.componentType, 0);
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	select @errorCode
	RETURN @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO


IF EXISTS (select * from GxQscripts where name = 'JMPopulateReferenceCopyInfo')
	delete from GxQscripts where name = 'JMPopulateReferenceCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPopulateReferenceCopyInfo')
	delete from GXDBVersions where aliasname = 'JMPopulateReferenceCopyInfo'
GO

insert into GXDBVersions values(2, 'JMPopulateReferenceCopyInfo',  '00010006006000040000', 'JMPopulateReferenceCopyInfo', '00010006006000040000')
GO

