

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMPopulatePickedJobsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012 CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMPopulatePickedJobsInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMPopulatePickedJobsInfo <<<'
	drop procedure JMPopulatePickedJobsInfo
END
IF EXISTS (select * from GxQscripts where name='JMPopulatePickedJobsInfo')
	delete from GxQscripts where name = 'JMPopulatePickedJobsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPopulatePickedJobsInfo')
	delete from GXDBVersions where aliasname = 'JMPopulatePickedJobsInfo'
GO
print '... Creating Procedure: JMPopulatePickedJobsInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMPopulatePickedJobsInfo
  @i_jobId INTEGER,
  @i_commCellId INTEGER
AS
	-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_outXML XML
	declare @jobid integer = @i_jobId
	declare @commcellId integer = @i_commCellId
	declare @appId integer = 0
	declare @bkpAttributesEx BIGINT= 0
	DECLARE @backupStartTime INT = 0
	DECLARE @backupEndTime INT = 0
	declare @optype integer = ISNULL((select optype from JMJobStats WITH(NOLOCK) where jobId=@jobid and commcellId = @commcellId), 0)
	DECLARE @isVSAParentSynthFull INT = 0
	DECLARE @fullJobId INT = 0
	--DECLARE @maxValidIncrJob INT = 0
	DECLARE @status INT = 0
	IF OBJECT_ID('tempdb.dbo.#vmInformation') IS NOT NULL
		DROP TABLE #vmInformation
	IF OBJECT_ID('tempdb.dbo.#pickedVMJobInfo') IS NOT NULL
		DROP TABLE #pickedVMJobInfo
	IF OBJECT_ID('tempdb.dbo.#vmJobInfo') IS NOT NULL
		DROP TABLE #vmJobInfo
	IF OBJECT_ID('tempdb.dbo.#maxValidIncrJob') IS NOT NULL
		DROP TABLE #maxValidIncrJob
	IF OBJECT_ID('tempdb.dbo.#pickedJobs') IS NOT NULL
			DROP TABLE #pickedJobs
	CREATE TABLE #vmInformation (vmclientID1 INT, jobID1 INT, isGuestSizeValid INT, computedGuestSize NVARCHAR(2048))
	CREATE TABLE #pickedVMJobInfo (vmClientId INT, parentJobID INT, vmJobId INT, vmJobLevel INT, vmAppId INT)
	CREATE TABLE #vmJobInfo (vmClientId INT, vmAppId INT, fullTime INT DEFAULT 0, incrTime INT DEFAULT 0, runSynthFull INT DEFAULT 0)
	CREATE TABLE #maxValidIncrJob (vmClientId INT, vmJobId INT)
	CREATE TABLE #pickedJobs (pJobid INT, isFailedVMJob INT, isValidVMJob INT DEFAULT 1)
	CREATE CLUSTERED INDEX vmInformation_vmclientID1_IDX on #vmInformation(vmclientID1);
	CREATE CLUSTERED INDEX pickedVMJobInfo_vmClientId_IDX on #pickedVMJobInfo(vmClientId);
	CREATE CLUSTERED INDEX vmJobInfo_vmClientId_IDX on #vmJobInfo(vmClientId);
	CREATE CLUSTERED INDEX maxValidIncrJob_vmClientId_Idx on #maxValidIncrJob(vmClientId)
	CREATE CLUSTERED INDEX pickedJobs_jobId_Idx on #pickedJobs(pJobId)
	if exists(select * from APP_VMProp WITH(NOLOCK) where jobId=@jobid and attrName not in ('vmUsedSpace', 'vmGuestSize','vmPercentComplete'))--Jobs have been merged previously so dont do it again
		GOTO PROC_EXIT
	if (@optype = 14) --SynthFull Job
	begin
		SELECT @appId = applicationid, @bkpAttributesEx = bkpAttributesEx, @status = 1  -- set to success by default
		FROM JMBkpJobInfo WITH(NOLOCK) where jobId = @jobid and commcellId = @commcellId
		if (@appId = 0 OR @appId IS NULL)
		begin
			SELECT @appId = appId, @bkpAttributesEx = bkpAttributesEx, @backupStartTime = servStartDate, @backupEndTime = servEndDate, @status = status
			FROM JMBkpStats WITH(NOLOCK) where jobId = @jobid and commcellId = @commcellId
		end
		ELSE	--JOB IS STILL RUNNING AND JMBkpStats ENTRY HAS NOT BEEN CREATED
		BEGIN
			IF @backupEndTime IS NULL OR @backupEndTime = 0
				SET @backupEndTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETUTCDATE()))
			IF @backupStartTime IS NULL OR @backupStartTime = 0
				SELECT @backupStartTime=jobStartTime FROM JMJobInfo (NOLOCK) WHERE jobId = @jobid
		END
		if (@appId = 0 OR @appId IS NULL)
			GOTO PROC_EXIT
IF @bkpAttributesEx & 0x40000000 = 0x40000000
			SET @isVSAParentSynthFull = 1
		declare @lastFullCycle integer = (select Top(1) fullcyclenum from JMBkpStats WITH(NOLOCK) where appId = @appId and commcellId = @commcellId AND servStartDate < @backupStartTime order by fullCycleNum desc)
		INSERT INTO #pickedJobs
		(pJobid, isFailedVMJob, isValidVMJob)
		SELECT jobid,
CASE WHEN bkpAttributesEx & 0x200000 = 0x200000 THEN 1 ELSE 0 END isFailedVMJob,
		ISNULL((SELECT TOP 1 1 FROM JMQinetixUpdateStatus Q (NOLOCK) WHERE Q.jobid = JMBkpStats.jobId AND Q.commCellId = @commcellId), 0) isValidVMJob
			FROM JMBkpStats WITH(NOLOCK)
			where commcellId = @commcellId and status in (1,3,14,16)
			and bkpLevel in (0x1, 0x2, 0x40, 0x80, 0x4000)
			and appId = @appid
			and fullCycleNum= @lastFullCycle
   		and servStartDate < @backupStartTime
		-- For indexing V2, do proper checks at VM level.
		IF @isVSAParentSynthFull = 1
		BEGIN
			-- Get correct job list based on indexing V2 child/parent jobs
			INSERT INTO #pickedVMJobInfo
			SELECT VMJ.targetClientId, jLink.parentJobId, VMJ.jobId, VMJ.bkpLevel, VMJ.appId
FROM  JMBkpStats VMJ WITH(NOLOCK) INNER JOIN JMJobDataLink jLink WITH(NOLOCK) ON VMJ.jobID = jLink.childJobId AND VMJ.commcellID = jLink.commCellID AND jLink.linkType = 7
			INNER JOIN #pickedJobs J ON jLink.parentJobId = J.pJobid
			WHERE VMJ.status IN (1, 3, 14)
			-- Decide if synthetic full can be allowed based on Full/Incr jobs in the VM
			INSERT INTO #vmJobInfo
			SELECT DISTINCT vmClientId,
							vmAppId,
							fullTime =
							CASE WHEN JBF.servEndDate IS NULL THEN NULL ELSE MAX(JBF.servEndDate) END,
							incrTime =
							CASE WHEN JBI.servEndDate IS NULL THEN NULL ELSE MAX(JBI.servEndDate) END,
							0
			FROM #pickedVMJobInfo PJ
			LEFT OUTER JOIN JMBkpStats (NOLOCK) JBF ON JBF.appId = PJ.vmAppId AND (JBF.bkpLevel = 1 OR JBF.opType = 14) AND JBF.status IN (1,3,14)
			LEFT OUTER JOIN JMBkpStats (NOLOCK) JBI ON JBI.appId = PJ.vmAppId AND JBI.bkpLevel IN (2, 4) AND JBI.status IN (1,3,14)
			GROUP BY PJ.vmClientId, PJ.vmAppId, JBI.bkpLevel, JBI.servEndDate, JBF.servEndDate
			UPDATE #vmJobInfo
			SET runSynthFull = 1
			WHERE incrTime > fullTime
			AND fullTime > 0 AND incrTime > 0
			-- Populate VM Prop
			INSERT INTO APP_VMProp
			SELECT @jobid, @commcellId, VMP.VMclientID, VMP.attrName , VMP.attrType, VMP.attrVal, 0 -- this doesnt apply anymore for V2
			FROM APP_VMProp VMP WITH(NOLOCK)
			INNER JOIN 	(SELECT MAX(parentJobID) AS parentJobID, vmClientId
					 FROM #pickedVMJobInfo GROUP BY vmClientId
					 ) PJ ON VMP.jobId = PJ.parentJobID AND VMP.VMclientId = PJ.vmClientId
			AND attrName NOT IN('vmUsedSpace', 'vmGuestSize', 'vmPseudoJobID', 'vmPercentComplete') AND commcellid = @commcellid
			update APP_VMProp set attrVal = ''	where jobId = @jobId AND attrname IN('vmTransportMode', 'vmAgent')
			update APP_VMProp set attrVal = '0'	where jobId = @jobId AND attrname IN ('vmBackupType', 'vmIsArchivedByCurrJob', 'vmIsPoweredOffByCurrJob')
			-- Guest size adjustment.
			INSERT INTO #vmInformation
			SELECT vmClientId, MAX(parentJobID), 0, ''
			FROM #pickedVMJobInfo
			GROUP BY vmClientId
			UPDATE vmInfo
			SET isGuestSizeValid= 1, computedGuestSize = VMP2.attrVal
			FROM #vmInformation vmInfo
			INNER JOIN APP_VMPROP VMP1 WITH(NOLOCK) ON vmInfo.jobID1 = VMP1.jobid AND vmInfo.vmclientID1 = VMP1.vmclientid AND VMP1.attrName = 'vmIsGuestSizeValid' AND VMP1.attrVal = '1'
			INNER JOIN APP_VMPROP VMP2 WITH(NOLOCK) ON vmInfo.jobID1 = VMP2.jobid AND vmInfo.vmclientID1 = VMP2.vmclientid AND VMP2. attrName = 'vmGuestSize'
			INSERT INTO APP_VMPROP
			SELECT DISTINCT @jobid, @commcellId, vmclientID1, 'vmGuestSize', 2, ISNULL(computedGuestSize, '0'), 0 -- this doesnt apply anymore for V2
			FROM #vmInformation
			WHERE isGuestSizeValid = 1
			-- Populate JMQinetixUpdateStatus now based on indexing V2 child/parent jobs
			INSERT INTO JMQinetixUpdateStatus ([jobId], [commCellId], [clientId], [clientName], [status], [category], [ostype], [discoverPhaseStatus], [foreignCommCellName], [clientRegistry], [installedUpdates], [statusMessage])
			SELECT	@jobid AS jobId, @commcellId AS commCellId, QVMP.clientId, QVMP.clientName,
				CASE WHEN runSynthFull = 0 THEN 1 -- VMClientBkupStatus_FAILED
					WHEN QVMP.status IN (0, 3) THEN 4 -- VMClientBkupStatus_WAITING
					ELSE QVMP.status
				END,
				QVMP.category, QVMP.ostype, QVMP.discoverPhaseStatus, QVMP.foreignCommCellName, QVMP.clientRegistry, QVMP.installedUpdates, QVMP.statusMessage
			FROM JMQinetixUpdateStatus QVMP WITH(NOLOCK)
			INNER JOIN (SELECT MAX(parentJobID) AS parentJobID, PVM.vmClientId, MAX(runSynthFull) AS runSynthFull
					FROM #pickedVMJobInfo PVM
					INNER JOIN #vmJobInfo VM ON PVM.vmClientId = VM.vmClientId
					GROUP BY PVM.vmClientId
					)PJ ON QVMP.jobId = PJ.parentJobID AND QVMP.clientId = PJ.vmClientId
			-- Set proper status in App_VMProp also
			UPDATE APP
			SET attrVal = CAST(JM.status AS NVARCHAR(32))
				FROM App_VMProp APP WITH(NOLOCK)
				INNER JOIN JMQinetixUpdateStatus JM ON APP.jobId = JM.jobId AND APP.commCellId = JM.commCellId AND APP.vmClientId = JM.clientId
				WHERE JM.jobId = @jobid AND JM.commCellId = @commcellId AND JM.status IN(1, 4)
				AND APP.attrName = 'vmStatus'
			-- Right now VM status is not localized. Only way is to set english string.
			UPDATE APP
			SET attrVal = 'Synthetic Full cannot run because no Incremental or Differential backup was run after the last Full backup for the Virtual Machine.'
				FROM App_VMProp APP WITH(NOLOCK)
				INNER JOIN #vmJobInfo VM ON APP.vmClientId = VM.vmClientId AND VM.runSynthFull = 0
				WHERE jobId = @jobid AND commCellId = @commcellId
				AND APP.attrName = 'vmFailureReason'
		END
		ELSE IF EXISTS(
			SELECT 1 FROM APP_ClientProp (NOLOCK) P
			JOIN APP_Application A (NOLOCK) ON A.clientId = P.componentNameId AND A.id = @appId
			WHERE P.attrName='Virtual Server Discovered Clients' AND P.attrVal = '1' AND P.modified = 0)
			AND (dbo.IsIndexingV2Enabled(0, 0, @appId) = 1)
		BEGIN
			SET @fullJobId = (select TOP(1) pJobId from #pickedJobs order by pJobid ASC)
			DECLARE @maxValidIncrJob INT = ISNULL((select TOP(1) pJobId from #pickedJobs where isFailedVMJob=0 order by pJobid DESC), @fullJobId)
			-- insert linkage for vm synthetic full and unaged parent job for VSA subclient within current full cycle
			INSERT INTO JMJobDataLink(commCellId, parentJobId, childJobId, parentAppid, childAppid, linkType , childJobStatus)
SELECT @commcellId, max(jLink.parentJobId), @jobid, jLink.parentAppid, @appId, 8, @status  -- should be valid status from VM synthetic full
			FROM JMJobDataLink jLink (NOLOCK)
			JOIN #pickedJobs PJ ON PJ.pJobid = jLink.childJobId
					AND jLink.commCellID = @commcellId
AND jLink.linkType = 7
			JOIN JMBkpStats (NOLOCK) JS ON JS.jobId = jLink.parentJobId
					AND JS.commCellId = jLink.commCellID
			JOIN APP_Application (NOLOCK) A ON A.id = jLink.parentAppid
			LEFT OUTER JOIN APP_ClientProp (NOLOCK) P ON P.componentNameId = A.clientId
					AND P.attrName='Using Pseudo client version V2.1'
					AND P.modified = 0
			LEFT OUTER JOIN JMJobDataStats (NOLOCK) JDS ON JDS.jobId = JS.jobId
					AND JDS.commCellId = JS.commCellId
					AND JDS.status = 100
					AND JDS.disabled & 256 = 0  -- CVA_AGED_DATA_FLAG
			WHERE
			--V2.1 jobs won't have entry in JMJobDataStats table so jobId will be NULL
			(
				P.attrVal = '1'
				AND
				JDS.jobId IS NULL
			)
			OR
			--Not a V2.1 job
			(
				P.attrVal = '0'
				AND
				JDS.jobId = JS.jobId
			)
			GROUP BY jLink.parentAppid
			INSERT INTO #pickedVMJobInfo
			SELECT VMJ.targetClientId, jLink.parentJobId, VMJ.jobId, VMJ.bkpLevel, VMJ.appId
			FROM  JMBkpStats VMJ WITH(NOLOCK)
			JOIN JMJobDataLink jLink WITH(NOLOCK) ON VMJ.jobID = jLink.childJobId
			AND VMJ.commcellID = jLink.commCellID
			AND VMJ.jobId = @maxValidIncrJob
AND jLink.linkType = 7
			WHERE VMJ.status IN (1, 3, 14)
			--POPULATE SO THAT XML OUTPUT GETS BUILT
			INSERT INTO #vmJobInfo
			(vmClientId, vmAppId)
			SELECT DISTINCT vmClientId, vmAppId
			FROM #pickedVMJobInfo
			-- Populate VM Prop
			INSERT INTO APP_VMProp
			(jobId, commCellId, VMclientId, attrName, attrType, attrVal, ClientJobId)
			SELECT @jobid, @commcellId, VMP.VMclientID, VMP.attrName , VMP.attrType, VMP.attrVal, @jobid
			FROM APP_VMProp VMP WITH(NOLOCK)
			INNER JOIN #pickedVMJobInfo PJ ON VMP.jobId = PJ.parentJobID AND VMP.VMclientId = PJ.vmClientId
				AND attrName NOT IN('vmGuestSize', 'vmPseudoJobID', 'vmBackupEndTime', 'vmUsedSpace', 'vmBackupStartTime', 'vmAverageThroughput') AND commcellid = @commcellid
			UPDATE APP_VMProp set attrVal = ''	WHERE jobId = @jobId AND attrname IN('vmTransportMode', 'vmAgent')
			UPDATE APP_VMProp set attrVal = '0'	WHERE jobId = @jobId AND attrname IN ('vmBackupType', 'vmIsArchivedByCurrJob', 'vmIsPoweredOffByCurrJob')
			-- Guest size adjustment.
			INSERT INTO #vmInformation
			SELECT vmClientId, MAX(parentJobID), 0, ''
			FROM #pickedVMJobInfo
			GROUP BY vmClientId
			UPDATE vmInfo
			SET isGuestSizeValid= 1, computedGuestSize = VMP2.attrVal
			FROM #vmInformation vmInfo
			INNER JOIN APP_VMPROP VMP1 WITH(NOLOCK) ON vmInfo.jobID1 = VMP1.jobid AND vmInfo.vmclientID1 = VMP1.vmclientid AND VMP1.attrName = 'vmIsGuestSizeValid' AND VMP1.attrVal = '1'
			INNER JOIN APP_VMPROP VMP2 WITH(NOLOCK) ON vmInfo.jobID1 = VMP2.jobid AND vmInfo.vmclientID1 = VMP2.vmclientid AND VMP2. attrName = 'vmGuestSize'
			INSERT INTO APP_VMPROP
			(jobId, commCellId, VMclientId, attrName, attrType, attrVal, clientJobId)
			SELECT DISTINCT @jobid, @commcellId, vmclientID1, 'vmGuestSize', 2, ISNULL(computedGuestSize, '0'), @jobid
			FROM #vmInformation
			WHERE isGuestSizeValid = 1
			UNION ALL
			SELECT DISTINCT @jobid, @commcellId, vmclientID1, 'vmBackupStartTime', 2, CAST(@backupStartTime AS NVARCHAR(32)), @jobid
			FROM #vmInformation
			UNION ALL
			SELECT DISTINCT @jobid, @commcellId, vmclientID1, 'vmBackupEndTime', 2, CAST(@backupEndTime AS NVARCHAR(32)), @jobid
			FROM #vmInformation
			UNION ALL
			SELECT DISTINCT @jobid, @commcellId, vmclientID1, 'vmPseudoJobID', 2, CAST(@jobid AS NVARCHAR(32)), @jobid
			FROM #vmInformation
			-- Populate JMQinetixUpdateStatus now based on indexing V2 child/parent jobs
			INSERT INTO JMQinetixUpdateStatus ([jobId], [commCellId], [clientId], [clientName], [status], [category], [ostype], [discoverPhaseStatus], [foreignCommCellName], [clientRegistry], [installedUpdates], [statusMessage])
			SELECT	@jobid AS jobId, @commcellId AS commCellId, QVMP.clientId, QVMP.clientName,QVMP.status,
				QVMP.category, QVMP.ostype, QVMP.discoverPhaseStatus, QVMP.foreignCommCellName, QVMP.clientRegistry, QVMP.installedUpdates, QVMP.statusMessage
			FROM JMQinetixUpdateStatus QVMP WITH(NOLOCK)
			INNER JOIN (SELECT MAX(parentJobID) AS parentJobID, PVM.vmClientId
					FROM #pickedVMJobInfo PVM
					GROUP BY PVM.vmClientId
					)PJ ON QVMP.jobId = PJ.parentJobID AND QVMP.clientId = PJ.vmClientId
			-- Set proper status in App_VMProp also
			UPDATE APP
			SET attrVal = CAST(JM.status AS NVARCHAR(32))
			FROM App_VMProp APP WITH(NOLOCK)
			INNER JOIN JMQinetixUpdateStatus JM ON APP.jobId = JM.jobId AND APP.commCellId = JM.commCellId AND APP.vmClientId = JM.clientId
			WHERE JM.jobId = @jobid AND JM.commCellId = @commcellId AND JM.status IN(1, 4)
			AND APP.attrName = 'vmStatus'
		END
		ELSE
		BEGIN -- For indexing V1
			--Take only the last incremental followed by  FailedVMBackupJobs
			SET @fullJobId = (select TOP(1) pJobId from #pickedJobs order by pJobid ASC)
			SET @maxValidIncrJob = ISNULL((select TOP(1) pJobId from #pickedJobs where isFailedVMJob=0 AND isValidVMJob=1 order by pJobid DESC), @fullJobId)
			insert into APP_VMProp
			select @jobid, @commcellId, VMP.VMclientID, VMP.attrName , VMP.attrType, VMP.attrVal, @jobid from
			(
				(
					select attrName, VMclientId, MAX(jobid) as MAXJOBID
					from app_vmprop P WITH(NOLOCK)
					WHERE
					jobid IN (select pJobid from #pickedJobs where pJobId >= @maxValidIncrJob)
					AND attrName NOT IN('vmUsedSpace', 'vmGuestSize', 'vmPercentComplete') and commcellid = @commcellid
		  			group by attrName, vmclientid
				) [temp]
				join APP_VMProp VMP WITH(NOLOCK) on [temp].attrName = VMP.attrName and temp.VMclientid = VMP.VMclientId and temp.MAXJOBID = VMP.jobId
			) order by VMP.VMclientId
			UPDATE APP_VMProp
			SET attrVal =
				CASE WHEN attrName IN ('vmTransportMode', 'vmAgent') THEN ''
				WHEN attrName IN ('vmBackupType', 'vmIsArchivedByCurrJob', 'vmIsPoweredOffByCurrJob') THEN '0'
				END
			WHERE jobId = @jobId AND attrname IN('vmTransportMode', 'vmAgent', 'vmBackupType', 'vmIsArchivedByCurrJob', 'vmIsPoweredOffByCurrJob')
			-- Guest size adjustment.
			INSERT INTO #vmInformation
			SELECT VMclientId, MAX(A.jobId), 0, 0 from APP_VMPROP A WITH (NOLOCK), JMBkpStats AS JBKP WITH (NOLOCK)
			WHERE  A.jobId>= @maxValidIncrJob AND A.jobId< @jobid AND A.jobId = JBKP.jobId AND JBKP.appId = @appId AND JBKP.status IN (1,3,14)  AND A.attrName='vmGuestSize'
			GROUP BY (A.VMclientId)
			UPDATE vmInfo set isGuestSizeValid= 1,
			computedGuestSize = (SELECT TOP 1 attrVal from APP_VMPROP WITH(NOLOCK) WHERE vmInfo.jobID1 = jobid AND vmInfo.vmclientID1 = vmclientid AND attrName='vmGuestSize')
			FROM APP_VMPROP WITH(NOLOCK), #vmInformation vmInfo
			WHERE vmInfo.jobID1 = jobid AND vmInfo.vmclientID1 = vmclientid AND attrName = 'vmIsGuestSizeValid' AND attrVal = '1'
			UPDATE vmInfo set computedGuestSize = (SELECT TOP 1 attrVal from APP_VMPROP WITH(NOLOCK) WHERE @jobid = jobid AND vmInfo.vmclientID1 = vmclientid AND attrName='vmUsedSpace')
			FROM APP_VMPROP WITH(NOLOCK), #vmInformation vmInfo
			WHERE vmInfo.jobID1 = jobid AND vmInfo.vmclientID1 = vmclientid AND vmInfo.isGuestSizeValid = 0
			--INSERT INTO APP_VMPROP
			--SELECT DISTINCT @jobid, @commcellId, vmInfo.vmclientID1, 'vmGuestSize', 2, ISNULL(vmInfo.computedGuestSize, 0)
			--FROM APP_VMPROP WITH(NOLOCK), #vmInformation vmInfo
			--WHERE jobid = vmInfo.jobID1 AND commcellid = @commcellid AND vmclientid = vmInfo.vmclientID1
			MERGE APP_VMPROP AS TARGET
			USING (SELECT DISTINCT @jobid, @commcellId, vmclientID1, 'vmGuestSize', 2, ISNULL(computedGuestSize, 0), @jobid from #vmInformation )AS SOURCE (jobId, commCellId, VMclientId, attrName, attrType, attrVal, ClientJobId)
				ON (TARGET.jobId = SOURCE.jobID AND TARGET.commcellid = @commcellid AND TARGET.vmclientid = SOURCE.vmclientID AND TARGET.attrName = 'vmGuestSize')
			WHEN MATCHED THEN
				UPDATE SET TARGET.attrType = 2, TARGET.attrVal = ISNULL(SOURCE.attrVal, 0)
			WHEN NOT MATCHED THEN
				INSERT ([jobId], [commCellId], [VMclientId], [attrName], [attrType], [attrVal], [ClientJobId])
				VALUES( @jobid, @commcellId, SOURCE.VMclientId, 'vmGuestSize', 2, ISNULL(SOURCE.attrVal, 0), @jobid);
			MERGE JMQinetixUpdateStatus AS TARGET
			USING(
				SELECT @jobid AS jobId, @commcellId AS commCellId, QVMP.clientId, QVMP.clientName,
						CASE WHEN @isVSAParentSynthFull = 1 AND QVMP.status IN (0, 3) THEN 4 ELSE QVMP.status END,
						QVMP.category, QVMP.ostype, QVMP.discoverPhaseStatus, QVMP.foreignCommCellName, QVMP.clientRegistry, QVMP.installedUpdates, QVMP.statusMessage
				FROM
				((SELECT clientId, MAX(jobid) AS QMAXJOBID FROM JMQinetixUpdateStatus WITH(NOLOCK)
					WHERE jobid IN (SELECT pJobid FROM #pickedJobs WHERE pJobId >= @maxValidIncrJob) AND commcellid = @commcellid
					GROUP BY clientId
					) [Qtemp]
				JOIN JMQinetixUpdateStatus QVMP ON [Qtemp].clientId = QVMP.clientId AND Qtemp.QMAXJOBID = QVMP.jobId)
			 	) AS SOURCE(jobId, commCellId, clientId, clientName, status, category, ostype, discoverPhaseStatus, foreignCommCellName, clientRegistry, installedUpdates, statusMessage)
			ON (TARGET.jobId = SOURCE.jobId AND TARGET.commCellId = SOURCE.commCellId AND TARGET.clientId = SOURCE.clientId)
			WHEN MATCHED THEN
			UPDATE SET TARGET.clientName = SOURCE.clientName, TARGET.status = SOURCE.status, TARGET.category = SOURCE.category, TARGET.ostype = SOURCE.ostype, TARGET.discoverPhaseStatus = SOURCE.discoverPhaseStatus,
						TARGET.foreignCommCellName = SOURCE.foreignCommCellName, TARGET.clientRegistry = SOURCE.clientRegistry, TARGET.installedUpdates = SOURCE.installedUpdates, TARGET.statusMessage = SOURCE.statusMessage
			WHEN NOT MATCHED THEN
			INSERT ([jobId], [commCellId], [clientId], [clientName], [status], [category], [ostype], [discoverPhaseStatus], [foreignCommCellName], [clientRegistry], [installedUpdates], [statusMessage])
			VALUES(SOURCE.jobId, SOURCE.commCellId, SOURCE.clientId, SOURCE.clientName, SOURCE.status, SOURCE.category, SOURCE.ostype, SOURCE.discoverPhaseStatus, SOURCE.foreignCommCellName, SOURCE.clientRegistry, SOURCE.installedUpdates, SOURCE.statusMessage);
		END
	END
	-- update bkpLevel to ensure it's being set to 64
	UPDATE APP_VMProp
	SET attrVal = '64' -- synthetic full
	WHERE jobId = @jobId AND commCellId = @commcellId AND attrname = 'vmBkpLevel' AND attrVal <> '64'
	--reusing the message as we only need to send the jobids
	PROC_EXIT:
		--MARK JOB AS CONTENT INDEXED WHEN CI PHASE IS SUCCESSFUL
		IF EXISTS(SELECT 1 FROM JMBkpAtmptStats (NOLOCK) WHERE jobId = @i_jobId AND phase = 13 /*SFCONTENTINDEXPHASE*/ AND status = 1 /*JMSUCCESS*/ AND commCellId = @i_commCellId)
		BEGIN
			UPDATE	JMBkpStats
SET		bkpAttributes = bkpAttributes | 0x4000000
			WHERE	JMBkpStats.commCellId = @i_commCellId
			AND		JMBkpStats.jobId = @i_jobId
		END
		SELECT				ISNULL((
							SELECT	DISTINCT JM.clientId AS '@clientId',
									VMP.vmAppId AS '@appID'
							FROM JMQinetixUpdateStatus JM WITH(NOLOCK)
							INNER JOIN #vmJobInfo VMP WITH(NOLOCK) ON JM.clientId = VMP.VMclientId
							WHERE JM.jobId = @jobid AND JM.commCellId = @commcellId
							AND JM.status = 4 -- WAITING IN (0, 3) -- COMPLETED, PARTIAL_SUCCESS
							FOR XML PATH('vmUpdateInfoList'), ROOT('JobManager_VMUpdateInfoResp')
							), '<JobManager_VMUpdateInfoResp/>')
	IF OBJECT_ID('tempdb.dbo.#pickedJobs') IS NOT NULL
			DROP TABLE #pickedJobs
	IF OBJECT_ID('tempdb.dbo.#vmInformation') IS NOT NULL
			DROP TABLE #vmInformation
	IF OBJECT_ID('tempdb.dbo.#maxValidIncrJob') IS NOT NULL
			DROP TABLE #maxValidIncrJob
	IF OBJECT_ID('tempdb.dbo.#pickedVMJobInfo') IS NOT NULL
			DROP TABLE #pickedVMJobInfo
		IF OBJECT_ID('tempdb.dbo.#vmJobInfo') IS NOT NULL
			DROP TABLE #vmJobInfo
	IF OBJECT_ID('tempdb.dbo.#maxValidIncrJob') IS NOT NULL
			DROP TABLE #maxValidIncrJob
GO

IF EXISTS (select * from GxQscripts where name = 'JMPopulatePickedJobsInfo')
	delete from GxQscripts where name = 'JMPopulatePickedJobsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMPopulatePickedJobsInfo')
	delete from GXDBVersions where aliasname = 'JMPopulatePickedJobsInfo'
GO

insert into GXDBVersions values(2, 'JMPopulatePickedJobsInfo',  '00000000000000000000', 'JMPopulatePickedJobsInfo', '00000000000000000000')
GO

